#!/bin/sh
##
##  recordwin.sh
##  $Id: recordwin.sh,v 1.1 2007/03/31 04:02:15 euske Exp $
##
##  Quick recording script for UNIX.
##
##  usage:
##     recordwin.sh [-display disp] [-name winname] [-id winid] output.swf
##

VNC2SWF="python vnc2swf.py"
X11VNC=x11vnc
XWININFO=xwininfo
AWK=awk

usage() {
    echo "usage: $0 [-display display] [-name windowname] [-id windowid] swfname"
    exit 2
}

xwopts=
swfopts=
display="$DISPLAY"
while [ $# -gt 1 ]; do
    case "$1" in
	-name) shift; xwopts="$xwopts -name $1";;
	-id) shift; xwopts="$xwopts -id $1";;
	-display|-d) shift; display="$1"; xwopts="$xwopts -display $1";;
	-*) usage;;
    esac
    shift
done

if [ $# -lt 1 ]; then usage; fi
case "$1" in
-*) usage;;
esac

swffile="$1"
geometry=`$XWININFO $xwopts |
      $AWK '/Absolute upper-left X:/{x=$4} 
            /Absolute upper-left Y:/{y=$4}
            /Width:/{w=$2}
            /Height:/{h=$2}
            END {printf "%dx%d+%d+%d",w,h,x,y}' `

# launch x11vnc
$X11VNC -quiet -display "$display" -viewonly -localhost -cursor -wait 10 -defer 10 >/dev/null 2>&1 &
# wait x11vnc
sleep 1
# launch vnc2swf
$VNC2SWF -n -o "$swffile" $swfopts -C $geometry
