/***************************************************************************
 *   Copyright (C) 2005 by Niklas Knutsson   *
 *   nq@altern.org   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef QALCULATEVARIABLESDIALOG_H
#define QALCULATEVARIABLESDIALOG_H

#include <kdialog.h>
#include <qmap.h>

class Variable;
class QalculateEditVariableDialog;
class QalculateEditMatrixVectorDialog;
class QalculateEditUnknownVariableDialog;
class QalculateExportCSVDialog;
class KListView;
class QListViewItem;
class QPushButton;

/**
@author Niklas Knutsson
*/
class QalculateVariablesDialog : public KDialog {

	Q_OBJECT

public:

	QalculateVariablesDialog(QWidget *parent = 0, const char *name = 0);
	virtual ~QalculateVariablesDialog();

	QalculateEditVariableDialog *variable_edit_dialog;
	QalculateEditMatrixVectorDialog *matrix_edit_dialog;
	QalculateEditUnknownVariableDialog *unknown_edit_dialog;
	QalculateExportCSVDialog *export_csv_dialog;
	QString selected_category;
	Variable *selected_variable;
	void addVariableTreeItem(Variable *v);
	QMap<QListViewItem*, Variable*> variableItems;
	QMap<QListViewItem*, QString> categoryItems;

	KListView *categoryView;
	KListView *variableView;
	QPushButton *newButton;
	QPushButton *editButton;
	QPushButton *deleteButton;
	QPushButton *deactivateButton;
	QPushButton *insertButton;
	QPushButton *exportButton;
	QPushButton *helpButton;
	QPushButton *buttonClose;

public slots:

	void updateVariableTree();
	void variableDoubleClicked(QListViewItem*);
	void variableSelected();
	void categorySelected();
	void exportVariable();
	void insertVariable();
	void deactivateVariable();
	void deleteVariable();
	void editVariable();
	void newVariable();
	
protected slots:
	
	void slotHelp();	

signals:

	void variablesChanged();
	void insertRequest(Variable*);

};

#endif
