/***************************************************************************
 $RCSfile$
                             -------------------
    cvs         : $Id$
    begin       : Mon Mar 01 2004
    copyright   : (C) 2004 by Martin Preuss
    email       : martin@libchipcard.de

 ***************************************************************************
 *          Please see toplevel file COPYING for license details           *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif

#include <aqbanking/country.h>

#include "selectcategory.h"
#include "category.h"
#include "transaction.h"
#include "kbanking.h"
#include "categorylist.h"
#include "editcategory.h"

#include <qwidget.h>
#include <qstring.h>
#include <qlabel.h>
#include <qlineedit.h>
#include <qpushbutton.h>
#include <qtextbrowser.h>
#include <qmessagebox.h>
#include <qcheckbox.h>
#include <qlistview.h>

#include <gwenhywfar/debug.h>




SelectCategory::SelectCategory(KBanking *kb,
                               Transaction *t,
                               QWidget* parent,
                               const char* name,
                               bool modal,
                               WFlags fl)
:SelectCategoryUi(parent, name, modal, fl)
,_app(kb)
,_category(0)
,_transaction(t)
,_aborted(false){
  std::list<std::string>::const_iterator it;

  if (t) {
    transBrowser->setText(QString::fromUtf8(t->toHtmlInfo().c_str()));
  }
  else {
    transBrowser->hide();
  }

  categoryList->setSelectionMode(QListView::Single);
  categoryList->setAllColumnsShowFocus(true);
  categoryList->setRootIsDecorated(true);

  QObject::connect(assignButton,
                   SIGNAL(clicked()),
                   this, SLOT(slotAssignSelected()));
  QObject::connect(createButton,
                   SIGNAL(clicked()),
                   this, SLOT(slotNew()));
  QObject::connect(editButton,
                   SIGNAL(clicked()),
                   this, SLOT(slotEdit()));
  QObject::connect(abortButton,
                   SIGNAL(clicked()),
                   this, SLOT(slotAbort()));

}



SelectCategory::~SelectCategory(){
}



void SelectCategory::init() {
  GWEN_DB_NODE *dbConfig=NULL;
  int rv;

  rv=_app->loadAppSubConfig("gui/dlgs/Selectcategory", &dbConfig);
  if (rv<0) {
    DBG_INFO(0, "here (%d)", rv);
  }
  else {
    int i, j;
    const char *p;
    int x, y;

    x=GWEN_DB_GetIntValue(dbConfig, "width", 0, -1);
    y=GWEN_DB_GetIntValue(dbConfig, "height", 0, -1);
    if (x!=-1 && y!=-1) {
      DBG_DEBUG(0, "Resizing to %d/%d", x, y);
      resize(x, y);
    }
    x=GWEN_DB_GetIntValue(dbConfig, "x", 0, -1);
    y=GWEN_DB_GetIntValue(dbConfig, "y", 0, -1);
    if (x!=-1 && y!=-1)
      move(x, y);

    p=GWEN_DB_GetCharValue(dbConfig, "sortOrder", 0, "ascending");
    if (p) {
      if (strcasecmp(p, "ascending")==0)
        categoryList->setSortOrder(Qt::Ascending);
      else
        if (strcasecmp(p, "descending")==0)
          categoryList->setSortOrder(Qt::Descending);
    }
    i=GWEN_DB_GetIntValue(dbConfig, "sortColumn", 0, -1);
    if (i!=-1)
      categoryList->setSortColumn(i);

    /* found settings */
    for (i=0; i<categoryList->columns(); i++) {
      categoryList->setColumnWidthMode(i, QListView::Manual);
      j=GWEN_DB_GetIntValue(dbConfig, "columns", i, -1);
      if (j!=-1)
        categoryList->setColumnWidth(i, j);
    } /* for */
    GWEN_DB_Group_free(dbConfig);
  } /* if settings */

  categoryList->beginModify();
  categoryList->addCategories(_app->getCategories());
  categoryList->expandAll();
  if (_transaction) {
    Category *cat;

    cat=_app->findCategoryByTransactionMatch(_transaction);
    if (cat) {
      categoryList->selectCategory(cat->getId().c_str(), true);
    }
  }
  categoryList->endModify();

}


void SelectCategory::fini() {
  GWEN_DB_NODE *dbConfig;
  int rv;
  int i, j;

  dbConfig=GWEN_DB_Group_new("config");
  assert(dbConfig);

  GWEN_DB_SetIntValue(dbConfig, GWEN_DB_FLAGS_OVERWRITE_VARS,
                      "x", x());
  GWEN_DB_SetIntValue(dbConfig, GWEN_DB_FLAGS_OVERWRITE_VARS,
                      "y", y());
  GWEN_DB_SetIntValue(dbConfig, GWEN_DB_FLAGS_OVERWRITE_VARS,
                      "width", width());
  GWEN_DB_SetIntValue(dbConfig, GWEN_DB_FLAGS_OVERWRITE_VARS,
                      "height", height());

  GWEN_DB_SetIntValue(dbConfig, GWEN_DB_FLAGS_DEFAULT,
                      "sortColumn", categoryList->sortColumn());
  switch(categoryList->sortOrder()) {
  case Qt::Ascending:
    GWEN_DB_SetCharValue(dbConfig, GWEN_DB_FLAGS_DEFAULT,
                         "sortOrder", "ascending");
    break;
  case Qt::Descending:
    GWEN_DB_SetCharValue(dbConfig, GWEN_DB_FLAGS_DEFAULT,
                         "sortOrder", "descending");
    break;
  default:
    break;
  }

  for (i=0; i<categoryList->columns(); i++) {
    j=categoryList->columnWidth(i);
    GWEN_DB_SetIntValue(dbConfig, GWEN_DB_FLAGS_DEFAULT,
                        "columns", j);
  } /* for */

  rv=_app->saveAppSubConfig("gui/dlgs/Selectcategory", dbConfig);
  GWEN_DB_Group_free(dbConfig);
  if (rv<0) {
    DBG_INFO(0, "here (%d)", rv);
  }

}



Category *SelectCategory::selectedCategory(){
  return _category;
}



void SelectCategory::slotAssignSelected(){
  std::list<Category*> pl;
  pl=categoryList->getSelectedCategories();
  if (pl.empty()) {
    QMessageBox::warning(this,
                         tr("Error"),
                         tr("<qt>"
                            "No category selected."
                            "</qt>"),
                         tr("Dismiss"), QString::null);
    return;
  }
  _category=pl.front();
  QDialog::accept();
}



void SelectCategory::slotNew(){
  Category *cat;
  std::string s;

  s=QBanking::QStringToUtf8String(tr("New Category"));
  cat=new Category("0", s.c_str(), "", 0);
  if (_transaction) {
    std::list<std::string>::const_iterator sit;
    GWEN_DB_NODE *dbRule;

    // preset category as far as possible
    s="";
    for (sit=_transaction->getRemoteName().begin();
         sit!=_transaction->getRemoteName().end();
         sit++) {
      if (!s.empty())
        s+=" ";
      s+=*sit;
    }
    cat->setName(s);
    dbRule=GWEN_DB_Group_new("rule");
    GWEN_DB_SetIntValue(dbRule, GWEN_DB_FLAGS_OVERWRITE_VARS,
                        "data/account/allAccounts", 1);
    GWEN_DB_SetIntValue(dbRule, GWEN_DB_FLAGS_OVERWRITE_VARS,
                        "data/payee/allPayees", 1);
    GWEN_DB_SetIntValue(dbRule, GWEN_DB_FLAGS_OVERWRITE_VARS,
                        "data/category/allCategories", 1);

    if (!s.empty()) {
      GWEN_DB_SetCharValue(dbRule, GWEN_DB_FLAGS_OVERWRITE_VARS,
                           "data/payee/compare/operation",
                           "contains");
      GWEN_DB_SetCharValue(dbRule, GWEN_DB_FLAGS_OVERWRITE_VARS,
                           "data/payee/compare/argument", s.c_str());
    }
    else {
      sit=_transaction->getPurpose().begin();
      if (sit!=_transaction->getPurpose().end()) {
        GWEN_DB_SetCharValue(dbRule, GWEN_DB_FLAGS_OVERWRITE_VARS,
                             "data/text/compare/operation",
                             "contains");
        GWEN_DB_SetCharValue(dbRule, GWEN_DB_FLAGS_OVERWRITE_VARS,
                             "data/text/compare/argument", (*sit).c_str());
      }
    }
    GWEN_DB_AddGroup(cat->getRules(), dbRule);

  }

  if (!EditCategory::editNewCategory(_app, cat, this)) {
    delete cat;
    return;
  }
  else {
    categoryList->beginModify();
    categoryList->clear();
    categoryList->addCategories(_app->getCategories());
    categoryList->expandAll();
    if (_transaction) {
      cat=_app->findCategoryByTransactionMatch(_transaction);
      if (cat) {
        categoryList->selectCategory(cat->getId().c_str(), true);
        categoryList->ensureSelectionVisible();
      }
    }
    categoryList->endModify();
  }
}



void SelectCategory::slotEdit(){
  std::list<Category*> pl;
  Category *cat;

  pl=categoryList->getSelectedCategories();
  if (pl.empty()) {
    QMessageBox::warning(this,
                         tr("Error"),
                         tr("<qt>"
                            "No category selected."
                            "</qt>"),
                         tr("Dismiss"), QString::null);
    return;
  }
  cat=pl.front();

  if (EditCategory::editCategory(_app, cat, this)) {
    categoryList->beginModify();
    categoryList->clear();
    categoryList->addCategories(_app->getCategories());
    categoryList->expandAll();
    if (_transaction) {
      cat=_app->findCategoryByTransactionMatch(_transaction);
      if (cat) {
        categoryList->selectCategory(cat->getId().c_str(), true);
        categoryList->ensureSelectionVisible();
      }
    }
    categoryList->endModify();
  }
}



void SelectCategory::slotAbort(){
  _aborted=true;
  reject();
}



Category *SelectCategory::selectCategory(KBanking *kb,
                                const QString &title,
                                const QString &text,
                                QWidget* parent) {
  SelectCategory sp(kb, 0, parent, "selectCategory", true);

  sp.againCheckBox->hide();
  sp.init();
  sp.categoryList->ensureSelectionVisible();
  if (!title.isEmpty())
    sp.setCaption(title);
  if (!text.isEmpty())
    sp.titleLabel->setText(text);
  else
    sp.titleLabel->hide();
  if (sp.exec()==QDialog::Accepted) {
    sp.fini();
    return sp.selectedCategory();
  }
  sp.fini();
  return 0;
}



Category *SelectCategory::assignCategory(KBanking *kb,
                                Transaction *t,
                                bool &aborted,
                                bool &askNoMore,
                                QWidget* parent) {
  SelectCategory sp(kb, t, parent, "selectCategory", true);

  aborted=false;
  sp.init();
  sp.assignButton->setText(tr("Assign"));
  sp.categoryList->ensureSelectionVisible();
  if (sp.exec()==QDialog::Accepted) {
    sp.fini();
    return sp.selectedCategory();
  }
  aborted=sp._aborted;
  askNoMore=sp.againCheckBox->isChecked();
  sp.fini();
  return 0;
}



Category *SelectCategory::assignSingleCategory(KBanking *kb,
                                               Transaction *t,
                                               bool &aborted,
                                               QWidget* parent) {
  SelectCategory sp(kb, t, parent, "selectCategory", true);

  sp.againCheckBox->hide();
  aborted=false;
  sp.init();
  sp.assignButton->setText(tr("Assign"));
  sp.categoryList->ensureSelectionVisible();
  if (sp.exec()==QDialog::Accepted) {
    sp.fini();
    return sp.selectedCategory();
  }
  aborted=sp._aborted;
  sp.fini();
  return 0;
}










