/***************************************************************************
  style.cpp
  -------------------
  AHA-like style class
  -------------------
  begin         September 26th, 1999
  author        David Johnson <david@usermode.org>
  -------------------
  Copyright 1999, 2001, David Johnson
  Please see the header file for copyright and license information
 ***************************************************************************/

#include "style.h"
#include <qstringlist.h>

//////////////////////////////////////////////////////////////////////////////
// Construction, Destruction                                                //
//////////////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////////////
// Style()
// -------
// Constructor

Style::Style(const double &oglow, const double &oghi,
            const double &ibulow, const double &ibuhi,
            const double &srmlow, const double &srmhi)
    : OGlow_(oglow), OGhi_(oghi), IBUlow_(ibulow),
    IBUhi_(ibuhi), SRMlow_(srmlow), SRMhi_(srmhi)
{ ; }

//////////////////////////////////////////////////////////////////////////////
// Style(const Style &)
// --------------------
// Copy onstructor

Style::Style(const Style &s)
    : OGlow_(s.OGlow_), OGhi_(s.OGhi_), IBUlow_(s.IBUlow_),
    IBUhi_(s.IBUhi_), SRMlow_(s.SRMlow_), SRMhi_(s.SRMhi_)
{ ; }

//////////////////////////////////////////////////////////////////////////////
// ~Style()
// --------
// Destrutor

Style::~Style() {}

//////////////////////////////////////////////////////////////////////////////
// Miscellaneous                                                            //
//////////////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////////////
// operator=
// ---------
// Assignment operator

Style Style::operator=(const Style &s)
{
    if (&s != this) {
        OGlow_ = s.OGlow_; OGhi_ = s.OGhi_;
        IBUlow_ = s.IBUlow_; IBUhi_ = s.IBUhi_;
        SRMlow_ = s.SRMlow_; SRMhi_ = s.SRMhi_;
    }
    return *this;
}

//////////////////////////////////////////////////////////////////////////////
// obsoleteSerializeIn()
// ---------------------
// Serialize the style in from a string, deprecated...

void Style::obsoleteSerializeIn(const QString &s)
{
    QString value = s;
    QStringList tokens;
    int pos;

    // get tokens
    while (value.length() > 0) {
        pos = value.find(',');
        if (pos > 0) {
            tokens += value.left(pos);
            value.remove(0, pos+1);
            value = value.stripWhiteSpace();
        } else {
            // get last token
            tokens += value;
            value = "";
        }
    }
    // create new style
    OGlow_    = tokens[0].toDouble() / 1000.0 + 1.000;
    OGhi_    = tokens[1].toDouble() / 1000.0 + 1.000;
    IBUlow_    = tokens[2].toDouble();
    IBUhi_    = tokens[3].toDouble();
    SRMlow_    = tokens[4].toDouble();
    SRMhi_    = tokens[5].toDouble();
}
