/***************************************************************************
  misc.cpp
  -------------------
  A generic ingredient class
  -------------------
  Copyright 1999-2006, David Johnson
  Please see the header file for copyright and license information
 ***************************************************************************/

#include "misc.h"

//////////////////////////////////////////////////////////////////////////////
// Misc()
// ------
// constructor

Misc::Misc()
    : name_("Generic"), quantity_(), notes_()
{ ; }

Misc::Misc(const QString &name, const Quantity &quantity, const QString &notes)
    : name_(name), quantity_(quantity), notes_(notes)
{ ; }

Misc::~Misc() { ; }

//////////////////////////////////////////////////////////////////////////////
// Misc()
// ------
// copy constructor

Misc::Misc(const Misc &m)
    : name_(m.name_), quantity_(m.quantity_), notes_(m.notes_)
{ ; }

//////////////////////////////////////////////////////////////////////////////
// operator=()
// -----------
// Assignment operator

Misc Misc::operator=(const Misc &m)
{
    if (this != &m) {
        name_ = m.name_;
        quantity_ = m.quantity_;
        notes_ = m.notes_;
    }
    return *this;
}

//////////////////////////////////////////////////////////////////////////////
// operator==()
// -----------
// Equivalence operator

bool Misc::operator==(const Misc &m) const
{
    return (name_ == m.name_)
        && (quantity_ == m.quantity_)
        && (notes_ == m.notes_);
}
