/***************************************************************************
                          rlayerdialog.h  -  description
                             -------------------
    begin                : Wed Feb 9 2000
    copyright            : (C) 2000 by Gerald Pichler
    email                : geripi@sbox.tu-graz.ac.at
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef RLAYERDIALOG_H
#define RLAYERDIALOG_H

#include <qwidget.h>
#include <qlineedit.h>
#include <qpushbutton.h>
#include <qlabel.h>
#include <qdialog.h>

#include "rlayer.h"
#include "rcombobox.h"


/**
  *@author Gerald Pichler
  */

class RLayerDialog : public QDialog  {
   Q_OBJECT
public: 
	RLayerDialog(QWidget *_parent=0, const char *_name=0, RLayer *_lay=0);
	~RLayerDialog();

  static int   colorToNumber(QColor _col);
  static QColor numberToColor(int _num);
  static int   styleToNumber(Qt::PenStyle _style);
  static Qt::PenStyle numberToStyle(int _num);

	QString getName();
	QColor getColor();
	int getWidth();
	Qt::PenStyle getStyle();

protected: 
	QLineEdit *QLineEdit_Name;
	RComboBox *cb_Color;
	RComboBox *cb_Width;
	RComboBox *cb_Style;
	QPushButton *QPushButton_Ok;
	QPushButton *QPushButton_Cancel;
	QLabel *QLabel_1;
	QLabel *QLabel_2;
	QLabel *QLabel_3;
	QLabel *QLabel_4;

private: 
};

#endif
