/***************************************************************************
                          rlibrarybrowser.h  -  description
                             -------------------
    begin                : Sun Jan 9 2000
    copyright            : (C) 2000 by Andrew Mustun
    email                : andrew@qcad.org
 ***************************************************************************/


#ifndef RLIBRARYBROWSER_H
#define RLIBRARYBROWSER_H

#include <qlabel.h>
#include <qlist.h>

#include "rwidget.h"

class QLabel;
class QListViewItem;
class QPushButton;
class QSplitter;

class RComboBox;
class RGraphic;
class RLibraryItem;
class RLineEdit;
class RListView;
class RListViewItem;
class RScrollView;



/**Library Browser Widget
  *@author Andrew Mustun
  */
class RLibraryBrowser : public RWidget  {
   Q_OBJECT
public: 
	RLibraryBrowser(QWidget *_parent=0, const char *_name=0);
	~RLibraryBrowser();
	
	void resizeChildren();
	
	RGraphic* getSelectedGraphic();
	double getHeight();
	double getLength();
	double getAngle();
	double getFactor();
	
protected slots:	
	void fillDirectoryList();
	
	void updateLibraryTree();
	void appendTree( RListViewItem* _item, QString _directory );
	void updatePreview(QListViewItem*);
	
	void slotItemActivated(RLibraryItem* _item);
	
	void insertPart();
	
protected:
  virtual void resizeEvent(QResizeEvent* _ev);	
	
private:
  QLabel*       lLabel;           // label for "library browser"
  QSplitter*    splitter;

  RListView*    lvLibrary;

  RScrollView*  scrollView;
  QList<RLibraryItem> itemList;
  RLibraryItem* selectedItem;

  QStringList   directoryList;

  QLabel*       lHeight;
  RLineEdit*    eHeight;
  QLabel*       lLength;
  RLineEdit*    eLength;

  QLabel*       lFactor;
  RLineEdit*    eFactor;
  QLabel*       lAngle;
  RLineEdit*    eAngle;

  QPushButton*  bInsert;
};

#endif
















