/***************************************************************************
                          rmath.h  -  description
                             -------------------
    begin                : Mon Sep 27 1999
    copyright            : (C) 1999 by Andreas Mustun
    email                : andrew@ribbonsoft.com
 ***************************************************************************/

/****************************************************************************
** rmath.h 1998/08/27 A. Mustun RibbonSoft
**
** Copyright (C) 1998 RibbonSoft.  All rights reserved.
**
*****************************************************************************/

#ifndef RMATH_H
#define RMATH_H

#include <math.h>
#include <qprinter.h>
#include <qfont.h>

#include "rmathdef.h"
#include "rgraphdef.h"
#include "rprgdef.h"

#define Absolute(a)  ((a) >= 0.0 ? (a) : -(a))

class QString;

bool        mtCompFloat(double _v1, double _v2, double _tol=DEF_MMTOL);
double      mtCorrAngle(double _ang);
void        mtCorrAngle(double* _ang);
double      mtGetAngle(double _x1, double _y1, double _x2, double _y2);
double      mtGetAngleDiff(double _a1, double _a2);
bool        mtAngleIsBetween(double _ang, double _startAngle, double _endAngle);
double      mtGetDistance(double _x1, double _y1, double _x2, double _y2);
void        mtRotatePoint(double _cx, double _cy, double* _px, double* _py, double _angle);
void        mtMirrorPoint(double _x1, double _y1, double _x2, double _y2, double* _px, double* _py);

double      mtSqr(double _v);
int         mtRound( double _v );

QString     mtFormatFloat( double _v,
                           double _exactness=0.01,
                           Unit _unit=Millimeter,
                           ValueFormat _format=Decimal,
                           bool _showUnit=false );
QString     mtFormatAngleFloat( double _v,
                                double _exactness=0.01,
                                AngleUnit _unit=Deg,
                                AngleFormat _format=DecimalDegrees );

QString     mtGetSignForUnit( Unit _unit );
bool        mtIsUnitMetric( Unit _unit );
Unit        mtStringToUnit( const QString &_unit, bool *ok=0 );
QString     mtUnitToString( Unit _unit );
ValueFormat mtStringToValueFormat( const QString &_format, bool *ok=0 );
QString     mtValueFormatToString( ValueFormat _format );

AngleUnit   mtStringToAngleUnit( const QString &_angleUnit, bool *ok=0 );
QString     mtAngleUnitToString( AngleUnit _angleUnit );
AngleFormat mtStringToAngleFormat( const QString &_format, bool *ok=0 );
QString     mtAngleFormatToString( AngleFormat _format );

ScaleType   mtStringToScaleType( const QString &_type, bool *ok=0 );
QString     mtScaleTypeToString( ScaleType _type );

QPrinter::Orientation mtStringToOrientation( const QString &_or, bool *ok=0 );
QString     mtOrientationToString( QPrinter::Orientation _or );

PageFormat  mtStringToPageFormat( const QString &_pf, bool *ok=0 );
QString     mtPageFormatToString( PageFormat _pf );

double      mtGetPageWidthMM( PageFormat _pf );
double      mtGetPageHeightMM( PageFormat _pf );

QFont::CharSet mtStringToCharset( const QString &_cs, bool *ok=0 );
QString     mtCharsetToString( QFont::CharSet _cs );

double      mtCalculate( const QString &_expression, double _default=0.0, bool *_ok=0 );
double      mtGetMM( double _v, Unit _unit );
QString     mtGetFractionString( double _v );

#endif


// EOF


