//
// C++ Implementation: CBodyEdit
//
// Description: 
//
//
// Author: Harald Krippel <harald@the-develop.net>, (C) 2007
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include <QtGui>

#include "CQcakeDlg.hpp"
#include "CBodyEdit.hpp"

CBodyEditDlg::CBodyEditDlg(QString strTitle, QWidget * parent, Qt::WFlags f)
: CQcakeDlg(parent, f)
{
   point = NULL;
   ui.setupUi(this);
    
   connect(ui.buttonBox, SIGNAL(accepted()), this, SLOT(slotEditData()));
   connect(ui.buttonBox, SIGNAL(rejected()), this, SLOT(slotGetData()));

   myParent = parent;
   setWindowTitle(strTitle);
}

CBodyEditDlg::~CBodyEditDlg() {
}

void CBodyEditDlg::slotGetData()
{
    if(point != NULL){
      slotGetData(point);
    }
}

void CBodyEditDlg::slotGetData(FolderListItem *i)
{
    point=i;
    ui.text->setText(i->text(0));
    ui.on->setChecked(i->GetValue("on",i).toInt());
    ui.online->setChecked(i->GetValue("online",i).toInt());
    ui.viewbox->setChecked(i->GetValue("viewbox",i).toInt());

    ui.box->setChecked(i->GetValue("box",i).toInt());
    ui.cylinder->setChecked(i->GetValue("cylinder",i).toInt());
    ui.sphere->setChecked(i->GetValue("sphere",i).toInt());

    ui.locx->setValue(i->GetValue("x",i).toDouble());
    ui.locy->setValue(i->GetValue("y",i).toDouble());
    ui.locz->setValue(i->GetValue("z",i).toDouble());

    ui.scax->setValue(i->GetValue("scax",i).toDouble());
    ui.scay->setValue(i->GetValue("scay",i).toDouble());
    ui.scaz->setValue(i->GetValue("scaz",i).toDouble());

    ui.rotx->setValue(i->GetValue("rotx",i).toDouble());
    ui.roty->setValue(i->GetValue("roty",i).toDouble());
    ui.rotz->setValue(i->GetValue("rotz",i).toDouble());

    ui.mass->setText(i->GetValue("mass",i));

    qWarning( "CBodyEditDlg::slotGetData(): Geht !" );
}

void CBodyEditDlg::slotEditData()
{
    if(point != NULL)
    {
        point->setText(0,ui.text->text());

        point->SetValue("on", ui.on->isChecked() ? "1" : "0");
        point->SetValue("online", ui.online->isChecked() ? "1" : "0");
        point->SetValue("viewbox", ui.viewbox->isChecked() ? "1" : "0");

        point->SetValue("box", ui.box->isChecked() ? "1" : "0");
        point->SetValue("cylinder", ui.cylinder->isChecked() ? "1" : "0");
        point->SetValue("sphere", ui.sphere->isChecked() ? "1" : "0");

        point->SetValue("x",ui.locx->text());
        point->SetValue("y",ui.locy->text());
        point->SetValue("z",ui.locz->text());

        point->SetValue("scax",ui.scax->text());
        point->SetValue("scay",ui.scay->text());
        point->SetValue("scaz",ui.scaz->text());

        point->SetValue("rotx",ui.rotx->text());
        point->SetValue("roty",ui.roty->text());
        point->SetValue("rotz",ui.rotz->text());

        point->SetValue("mass",ui.mass->text());

	point->updategl();
    }

qWarning( "CBodyEditDlg::slotEditData(): Geht !" );
}
