/***************************************************************************
    qgsdatadefinedsymboldialog.cpp
    ---------------------
    begin                : March 2013
    copyright            : (C) 2013 by Marco Hugentobler
    email                : marco dot hugentobler at sourcepole dot ch
 ***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include "qgsdatadefinedsymboldialog.h"
#include "qgsexpressionbuilderdialog.h"
#include "qgsfieldexpressionwidget.h"
#include "qgsvectorlayer.h"
#include "qgslogger.h"

#include <QCheckBox>
#include <QSettings>


QgsDataDefinedSymbolDialog::QgsDataDefinedSymbolDialog( const QList< DataDefinedSymbolEntry >& entries, const QgsVectorLayer* vl, QWidget * parent, const Qt::WindowFlags& f )
    : QDialog( parent, f )
    , mVectorLayer( vl )
{
  setupUi( this );

  QgsFields attributeFields;
  if ( mVectorLayer )
  {
    attributeFields = mVectorLayer->fields();
  }

  QList< DataDefinedSymbolEntry >::const_iterator entryIt = entries.constBegin();
  for ( ; entryIt != entries.constEnd(); ++entryIt )
  {
    QTreeWidgetItem* item = new QTreeWidgetItem( mTreeWidget );

    //check box
    QCheckBox* cb = new QCheckBox( entryIt->title, this );
    cb->setChecked( !entryIt->initialValue.isEmpty() );
    item->setData( 0, Qt::UserRole, entryIt->property );
    mTreeWidget->setItemWidget( item, 0, cb );

    // expression
    QgsFieldExpressionWidget* few = new QgsFieldExpressionWidget( this );
    few->setMaximumWidth( 350 );
    few->setSizePolicy( QSizePolicy::Expanding, QSizePolicy::Maximum );
    few->setLayer( const_cast<QgsVectorLayer*>( vl ) );
    few->setField( entryIt->initialValue );
    mTreeWidget->setItemWidget( item, 1, few );

    //help text
    item->setText( 2, entryIt->helpText );

    mTreeWidget->addTopLevelItem( item );
  }

  for ( int c = 0; c != mTreeWidget->columnCount() - 1; c++ )
    mTreeWidget->resizeColumnToContents( c );

  QSettings settings;
  restoreGeometry( settings.value( "/Windows/QgsDataDefinedSymbolDialog/geometry" ).toByteArray() );
}

QgsDataDefinedSymbolDialog::~QgsDataDefinedSymbolDialog()
{
  QSettings settings;
  settings.setValue( "/Windows/QgsDataDefinedSymbolDialog/geometry", saveGeometry() );
}

QMap< QString, QString > QgsDataDefinedSymbolDialog::dataDefinedProperties() const
{
  QMap< QString, QString > propertyMap;
  int rowCount = mTreeWidget->topLevelItemCount();
  for ( int i = 0; i < rowCount; ++i )
  {
    QTreeWidgetItem* item = mTreeWidget->topLevelItem( i );
    //property
    QString propertyKey = item->data( 0, Qt::UserRole ).toString();
    //checked?
    bool checked = false;
    QCheckBox* cb = qobject_cast<QCheckBox*>( mTreeWidget->itemWidget( item, 0 ) );
    if ( cb )
    {
      checked = cb->isChecked();
    }
    QString expressionString;
    if ( checked )
    {
      QgsFieldExpressionWidget* few = qobject_cast<QgsFieldExpressionWidget*>( mTreeWidget->itemWidget( item, 1 ) );
      expressionString = few->currentField();
    }
    propertyMap.insert( propertyKey, expressionString );
  }
  return propertyMap;
}

QString QgsDataDefinedSymbolDialog::doubleHelpText()
{
  return tr( "double" );
}

QString QgsDataDefinedSymbolDialog::colorHelpText()
{
  return tr( "'<red>,<green>,<blue>,<alpha>'" );
}

QString QgsDataDefinedSymbolDialog::offsetHelpText()
{
  return "'<x>,<y>'";
}

QString QgsDataDefinedSymbolDialog::fileNameHelpText()
{
  return tr( "'<filename>'" );
}

QString QgsDataDefinedSymbolDialog::horizontalAnchorHelpText()
{
  // Don't translate, localized keywords are not supported.
  return "'left'|'center'|'right'";
}

QString QgsDataDefinedSymbolDialog::verticalAnchorHelpText()
{
  // Don't translate, localized keywords are not supported.
  return "'top'|'center'|'bottom'";
}

QString QgsDataDefinedSymbolDialog::gradientTypeHelpText()
{
  return tr( "'linear'|'radial'|'conical'" );
}

QString QgsDataDefinedSymbolDialog::gradientCoordModeHelpText()
{
  return tr( "'feature'|'viewport'" );
}

QString QgsDataDefinedSymbolDialog::gradientSpreadHelpText()
{
  return tr( "'pad'|'repeat'|'reflect'" );
}

QString QgsDataDefinedSymbolDialog::boolHelpText()
{
  return tr( "0 (false)|1 (true)" );
}

QString QgsDataDefinedSymbolDialog::lineStyleHelpText()
{
  return "'no'|'solid'|'dash'|'dot'|'dash dot'|'dash dot dot'";
}

QString QgsDataDefinedSymbolDialog::joinStyleHelpText()
{
  return "'bevel'|'miter'|'round'";
}

QString QgsDataDefinedSymbolDialog::capStyleHelpText()
{
  return "'square'|'flat'|'round'";
}

QString QgsDataDefinedSymbolDialog::fillStyleHelpText()
{
  return "'solid'|'horizontal'|'vertical'|'cross'|'b_diagonal'|'f_diagonal'|"
         "'diagonal_x'|'dense1'|'dense2'|'dense3'|'dense4'|'dense5'|"
         "'dense6'|'dense7'|'no'";
}


