/*
 * Decompiled with CFR 0.152.
 */
package molikin;

import driftwood.moldb2.AtomState;
import driftwood.util.Strings;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.util.Collection;
import java.util.Set;
import molikin.AtomCrayon;
import molikin.AtomIDer;
import molikin.PrekinIDer;
import molikin.crayons.ConstCrayon;

public class BallPrinter {
    static final DecimalFormat df = Strings.usDecimalFormat("0.###");
    PrintWriter out;
    AtomCrayon crayon = ConstCrayon.NONE;
    AtomIDer ider = new PrekinIDer();

    public BallPrinter(PrintWriter printWriter) {
        this.out = printWriter;
    }

    public void printBalls(Collection collection, Set set, String string) {
        for (AtomState atomState : collection) {
            this.crayon.forAtom(atomState);
            if (!this.crayon.shouldPrint() || set != null && !set.contains(atomState.getResidue())) continue;
            this.out.println("{" + this.ider.identifyAtom(atomState) + string + "}" + this.crayon.getKinString() + " " + atomState.format(df));
        }
        this.out.flush();
    }

    public void printBalls(Collection collection) {
        this.printBalls(collection, null, null);
    }

    public AtomCrayon getCrayon() {
        return this.crayon;
    }

    public void setCrayon(AtomCrayon atomCrayon) {
        this.crayon = atomCrayon;
    }

    public AtomIDer getAtomIDer() {
        return this.ider;
    }

    public void setAtomIDer(AtomIDer atomIDer) {
        this.ider = atomIDer;
    }
}

