#ifndef PLOT_H
#define PLOT_H

#include <qwt_plot.h>
#include <qwt_plot_curve.h>
#include <qwt_plot_marker.h>

class Plot : public QwtPlot
{
    Q_OBJECT

public:
    Plot(QWidget *parent = 0);
    Plot(QwtText title, QWidget *parent = 0);
    ~Plot();
    void plot(const QList<double> x, QList<double>y);
    void clear(void);

    double getXmin() const;
    double getXmax() const;

    void showPeak(double x, double y);
    void show3dB(double x, double y);
protected:
    void initializeScales();
    void initializeCanvas();
    void initializeCurve();
    void initializeMarkers();

private:
    QwtPlotCurve *curve;
    double xmin;
    double xmax;
    QwtPlotMarker *markerP;
    QwtPlotMarker *marker3;
};

#endif // PLOT_H
