/***************************************************************************
                          dirdialog.cpp  -  description
                             -------------------
    begin                : Sat Apr 28 2001
    copyright            : (C) 2001 by 
    email                : 
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "dirdialog.h"



// ****************************************************************************************************

preview::preview( QWidget *parent ): QWidget(parent), QFilePreview()
{
	setMinimumSize(340,260);
	pixmap = new pixmapView( this );
	pixmap->setMinimumSize(340,260);
}

void preview::previewUrl( const QUrl &u)
{
	if ( u.isLocalFile() )
  	{
			QString path = u.path();
			QFileInfo fi( path );
			QPixmap pix( path );
			if (!pix.isNull() )
				{
		    	pixmap->setPixmap( pix );
				}
		}
}



// ****************************************************************************************************

dirDialog::dirDialog(QWidget * parent ,const char * name,bool modal) :  QFileDialog( parent, name, modal)
{
	setContentsPreviewEnabled( TRUE );
	preview *pw = new preview( this );
	setContentsPreview( pw, pw );
	setViewMode( QFileDialog::Detail);
}

dirDialog::~dirDialog()
{
}

QString dirDialog::openFileName(const QString &startWith, const QString &filter)
{
	QString start=startWith;
	setPreviewMode( QFileDialog::Contents );
	if ( !start )
  	{
			start = QDir::currentDirPath();
		}
	setMode(ExistingFile);	
	setFilter(filter);
	setSelection( start);
	show();
	return selectedFile();
}

QString dirDialog::openDirName(const QString &startWith, const QString &filter)
{
	QString start=startWith;
	setPreviewMode( QFileDialog::NoPreview );
	if ( !start )
  	{
			start = QDir::currentDirPath();
		}
	setMode(DirectoryOnly);	
	setFilter(filter);
	setSelection( start);
	show();
	return selectedFile();
}

QString dirDialog::saveFileName(const QString &startWith, const QString &filter)
{
	QString start=startWith;
	setPreviewMode( QFileDialog::NoPreview );
	if ( !start )
  	{
			start = QDir::currentDirPath();
		}
	setMode(AnyFile);	
	setFilter(filter);
	setSelection( start);
	show();
	return QString::null;
}
