#include "zoomwindow.h"
#include <qapplication.h>
#include <qpushbutton.h>
#include <qlayout.h>
#include <qwmatrix.h>
#include <qimage.h>
#include "qsstvglobal.h"
#include "pixmapview.h"
#include <qslider.h>
#include <qmessagebox.h>

zoomWindow::zoomWindow(QWidget* parent,	const char* name): zoomForm( parent, name, TRUE)
{
	
}


zoomWindow::~zoomWindow()
{
	originalPixmap.resize(1,1); //free storage
}

void zoomWindow::zoom(QPixmap *ipm)
{
	resize( zoomWidth,zoomHeight );
  originalPixmap=*ipm;
  zoomFrame->setPixmap(originalPixmap);
	zoomSlider->setValue(zoomScale);
}

void zoomWindow::slotSliderMoved(int v)
{
	int w,h;
	w=originalPixmap.width();
	h=originalPixmap.height();
	zoomScale=v;
	switch(v)
		{
			case 0: w/=4; h/=4; break;
			case 1: w/=3; h/=3; break;
			case 2: w/=2; h/=2; break;
			case 3:  break;
			case 4: w*=2; h*=2; break;
			case 5: w*=3; h*=3; break;
			case 6: w*=4; h*=4; break;
			default: break;
		}
	if(w==originalPixmap.width())
		{
			zoomFrame->setPixmap(originalPixmap);
		}
	else
		{
			if((w*h)>32000000)
				{
					zoomSlider->setValue(3);
					QMessageBox::information( this, "Zoom",
                              "Image would be more than 32Mb\n "
                              "Zoom factor reset to 1");
          zoomFrame->setPixmap(originalPixmap);
  			}
			else
				{
					scale(w,h);
				}
		}
}

void zoomWindow::scale(int width, int height)
{ 
  QImage temp,m;
  QPixmap pmScaled;
  m=originalPixmap;
	QApplication::setOverrideCursor( Qt::waitCursor );
	temp=m.smoothScale(width,height);
  QApplication::restoreOverrideCursor();
	pmScaled=temp;
	zoomFrame->setPixmap(pmScaled);	
}

void zoomWindow::slotClose()
{
	close();
}

void zoomWindow::closeEvent(QCloseEvent *e)
{
	zoomWidth=width();
	zoomHeight=height();
	e->accept();
}







