/* Copyright (C) 2004 Nikos Chantziaras.
 *
 * This file is part of the QTads program.  This program is free
 * software; you can redistribute it and/or modify it under the
 * terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, 59 Temple Place - Suite 330, Boston,
 * MA 02111-1307, USA.
 */

/* Host interface.  Every application containing the VM must provide
 * the VM with an implementation of this interface.
 *
 * This implementation does little more than the simple stdio-based one
 * from the portable Tads 3 sources (tads3/vmhostsi.h).
 */

#ifndef QTADSVMHOSTIFC_H
#define QTADSVMHOSTIFC_H

#include "config.h"

#include "vmhostsi.h"

#include "qtadsio.h"
#include "qtadssettings.h"

class QTadsCVmHostIfc: public CVmHostIfcStdio {
  public:
	QTadsCVmHostIfc( const char *argv0 )
	: CVmHostIfcStdio(argv0)
	{}

	virtual int
	get_io_safety()
	{
		return QTadsIO::settings().fileIoSafetyLevel();
	}
};

#endif // QTADSVMHOSTIFC_H
