/***************************************************************************
                          cupshelper.cpp  -  description
                             -------------------
    begin                : Thu Jun 15 2000
    copyright            : (C) 2000 by Michael Goffioul
    email                : gofioul@emic.ucl.ac.be
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "cupshelper.h"
#include "passworddialog.h"

#include <stdlib.h>
#include <cups/language.h>

const char* cupsGetPasswordCB(const char*)
{
	return CupsHelper::get()->cupsGetPassword();
}

//***********************************************************************************

CupsHelper* CupsHelper::unique_ = 0;

CupsHelper* CupsHelper::get()
{
	if (!unique_) unique_ = new CupsHelper();
	return unique_;
}

CupsHelper::CupsHelper()
{
	host_ = login_ = password_ = QString::null;
	port_ = -1;
	count_ = 0;
	setup();
}

CupsHelper::~CupsHelper()
{
}
/**  */
const QString& CupsHelper::host()
{
	return host_;
}
/**  */
int CupsHelper::port()
{
	return port_;
}
/**  */
void CupsHelper::setHostInfo(const char *host, int port)
{
	host_ = host;
	cupsSetServer(host_);
	port_ = port;
	ippSetPort(port_);
}
/**  */
void CupsHelper::setLoginInfo(const char *usr, const char *pwd)
{
	login_ = usr;
	cupsSetUser(login_);
	password_ = pwd;
}
/**  */
const QString& CupsHelper::login()
{
	return login_;
}
/**  */
const QString& CupsHelper::password()
{
	return password_;
}
/**  */
ipp_t* CupsHelper::newIppRequest()
{
	ipp_t	*request = ippNew();
	request->request.op.request_id = 1;
	cups_lang_t	*lang = cupsLangDefault();
	ippAddString(request,IPP_TAG_OPERATION,IPP_TAG_CHARSET,"attributes-charset",NULL,cupsLangEncoding(lang));
	ippAddString(request,IPP_TAG_OPERATION,IPP_TAG_LANGUAGE,"attributes-natural-language",NULL,lang->language);
	return request;
}
/**  */
ipp_t* CupsHelper::processRequest(ipp_t *req, const char *res)
{
	http_t	*HTTP = httpConnect(host_.data(),port_);
	if (!HTTP)
	{
		ippDelete(req);
		return 0;
	}
	ipp_t	*answer = cupsDoRequest(HTTP,req,res);
	httpClose(HTTP);
	if (!answer)
		return 0;
	if (answer->state == IPP_ERROR || answer->state == IPP_IDLE)
	{
		ippDelete(answer);
		return 0;
	}
	return answer;
}
/**  */
bool CupsHelper::checkHost()
{
	http_t	*HTTP = httpConnect(host_.data(),port_);
	if (!HTTP) return false;
	httpClose(HTTP);
	return true;
}
/**  */
const char* CupsHelper::cupsGetPassword()
{
	if (count_ == 0 && !password_.isNull()) return password_.data();
	else
	{
		count_++;
		// opens a dialog to ask for password
		PasswordDialog	*dlg = new PasswordDialog;
		dlg->setLogin(QString(cupsUser()));
		if (dlg->doIt())
		{
			setLoginInfo(dlg->login(),dlg->password());
			return password_.data();
		}
		else return 0;
	}
}
/**  */
void CupsHelper::setup()
{
	if (host_.isEmpty()) host_ = cupsServer();
	if (login_.isEmpty()) login_ = cupsUser();
	if (port_ < 0) port_ = ippPort();
	cupsSetPasswordCB(cupsGetPasswordCB);
}
/**  */
int CupsHelper::printerType(const char *name, int* state)
{
	ipp_t	*request = newIppRequest();
	QString	str;
	int	value(-1);

	request->request.op.operation_id = IPP_GET_PRINTER_ATTRIBUTES;
	str.sprintf("ipp://%s:%d/printers/%s",host().data(),port(),name);
	ippAddString(request,IPP_TAG_OPERATION,IPP_TAG_URI,"printer-uri",NULL,str.data());
	//str.sprintf("/printers/%s",name);
	str.sprintf("/printers/");
	request = processRequest(request,str.data());
	if (request && request->curtag == IPP_TAG_PRINTER) {
		ipp_attribute_t	*attr = ippFindAttribute(request,"printer-type",IPP_TAG_ENUM);
		if (attr) value = attr->values[0].integer;
		if (state)
		{
			attr = ippFindAttribute(request,"printer-state",IPP_TAG_ENUM);
			if (attr) *state = attr->values[0].integer;
			else *state = -1;
		}
	}
	ippDelete(request);
	return value;
}
