#include "icons.h"

#include <cups/language.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

static cups_lang_t	*lang_ = 0;
void openLang();
void closeLang();

bool isGeneralGroup(const char *txt);
bool isInstallGroup(const char *txt);
bool isJCLGroup(const char *txt);
bool isExtraGroup(const char *txt);

//-------------------------------------------------------------------------

void openLang()
{
	if (!lang_) lang_ = cupsLangDefault();
	if (!lang_) exit(-1);
}

void closeLang()
{
	if (lang_) cupsLangFree(lang_);
}

//-------------------------------------------------------------------------

bool isGeneralGroup(const char *txt)
{
	openLang();
	return (strcmp(txt,cupsLangString(lang_,CUPS_MSG_GENERAL)) == 0);
}

bool isExtraGroup(const char *txt)
{
	openLang();
	return (strcmp(txt,cupsLangString(lang_,CUPS_MSG_EXTRA)) == 0);
}

bool isJCLGroup(const char *txt)
{
	return (strcmp(txt,"JCL") == 0);
}

bool isInstallGroup(const char *txt)
{
	char	*str = strdup(txt);
	for (char *c = str;*c;c++) *c = tolower(*c);
	bool	found = (strstr(str,"install") != NULL);
	free(str);
	return found;
}

//-------------------------------------------------------------------------

#include "printer_general.xpm"
#include "printer_extra.xpm"
#include "printer_install.xpm"
#include "printer_jcl.xpm"

const char** getGroupXPMString(const char *txt)
{
	const char	**xpm(0);
	if (isGeneralGroup(txt)) xpm = printer_general;
	else if (isExtraGroup(txt)) xpm = printer_extra;
	else if (isJCLGroup(txt)) xpm = printer_jcl;
	else if (isInstallGroup(txt)) xpm = printer_install;
	closeLang();
	return xpm;
}

//-------------------------------------------------------------------------

#include "pagesize.xpm"
#include "brightness.xpm"
#include "color_opt.xpm"
#include "cyan.xpm"
#include "magenta.xpm"
#include "yellow.xpm"
#include "duplex.xpm"
#include "gamma.xpm"
#include "gsresol.xpm"
#include "resol.xpm"
#include "saturation.xpm"
#include "contrast.xpm"
#include "inputslot.xpm"
#include "dither.xpm"
#include "imagetype.xpm"

typedef struct
{
	const char	*name;
	const char	**xpm;
} icon_entry;

static icon_entry	icon_db[] = {
	{ "PageSize", pagesize },
	{ "MediaType", pagesize },
	{ "InputSlot", inputslot },
	{ "Brightness", brightness },
	{ "StpBrightness", brightness },
	{ "ColorModel", color_opt },
	{ "Grayscale", color_opt },
	{ "Yellow", yellow },
	{ "StpYellow", yellow },
	{ "Cyan", cyan },
	{ "StpCyan", cyan },
	{ "Magenta", magenta },
	{ "StpMagenta", magenta },
	{ "Gamma", gamma },
	{ "StpGamma", gamma },
	{ "Duplex", duplex },
	{ "GSResolution", gsresol },
	{ "Resolution", resol },
	{ "Saturation", saturation },
	{ "StpSaturation", saturation },
	{ "Contrast", contrast },
	{ "StpContrast", contrast },
	{ "Dither", dither },
	{ "Dithering", dither },
	{ "ImageType", imagetype },
	{ "Quality", pagesize }
};

const char** getOptionXPMString(const char *optionname)
{
	int	db_size = sizeof(icon_db)/sizeof(icon_entry);
	for (int i=0;i<db_size;i++)
		if (strcasecmp(optionname,icon_db[i].name) == 0) return icon_db[i].xpm;
	return NULL;
}
