#include "qppdoptionview.h"
#include "qppdoptionitem.h"
#include "qppdnumericaloptionitem.h"
#include "numericwidget.h"

#include <qlistbox.h>
#include <qradiobutton.h>
#include <qbuttongroup.h>
#include <qwidgetstack.h>
#include <qlayout.h>

#include <cups/ppd.h>

#define	OFF_ID	0
#define	ON_ID	1

QPPDOptionView::QPPDOptionView(QWidget *parent, const char *name)
	: QGroupBox(parent,name)
{
	ppdopt_ = 0;

	setTitle( tr("No option selected") );
	setSizePolicy(QSizePolicy(QSizePolicy::Preferred,QSizePolicy::Minimum));

	stack_ = new QWidgetStack(this);
	optionpickone_ = new QListBox(stack_);
	optionboolean_ = new QButtonGroup(stack_);
	optionnumeric_ = new NumericWidget(stack_);
	optionempty_ = new QWidget(stack_);
	stack_->addWidget(optionpickone_, 1);
	stack_->addWidget(optionboolean_, 2);
	stack_->addWidget(optionnumeric_, 3);
	stack_->addWidget(optionempty_, 0);
	stack_->raiseWidget(optionempty_);

	// Radio buttons creation
	QVBoxLayout	*boolLayout_ = new QVBoxLayout(optionboolean_, 5, 0);
	boolLayout_->addWidget(new QRadioButton(tr("Off"), optionboolean_), 1);
	boolLayout_->addWidget(new QRadioButton(tr("On"), optionboolean_), 1);
	optionboolean_->setTitle("");
	optionboolean_->setFrameStyle(QFrame::NoFrame);

	allowNonChangeable_ = false;

	connect(optionboolean_,SIGNAL(clicked(int)),SLOT(selectionChanged(int)));
	connect(optionpickone_,SIGNAL(highlighted(int)),SLOT(selectionChanged(int)));
	connect(optionnumeric_,SIGNAL(valueChanged(double)),SLOT(valueChanged(double)));

	QVBoxLayout	*mainLayout_ = new QVBoxLayout(this, 11, 0);
	mainLayout_->addSpacing(10);
	mainLayout_->addWidget(stack_);
}

QPPDOptionView::~QPPDOptionView()
{
}

QSize QPPDOptionView::sizeHint() const
{
	return QSize(200,120);
}

void QPPDOptionView::setOption(QListViewItem *item)
{
	// check if option selected
	if (!item || ((QPPDBaseItem*)item)->isGroup())
	{
		ppdopt_ = 0;
		setTitle( tr("No option selected") );
		stack_->raiseWidget(optionempty_);
		return;
	}

	ppdopt_ = (QPPDBaseItem*)item;

	if (ppdopt_->isNumeric())
	{
		// option selected
		QPPDNumericalOptionItem	*opt_ = (QPPDNumericalOptionItem*)ppdopt_;
		setTitle(opt_->option_->text);

		stack_->raiseWidget(optionnumeric_);
		if (opt_->option_->type != 0) optionnumeric_->setFactor(1000);
		optionnumeric_->setLimits(opt_->option_->min, opt_->option_->max);
		optionnumeric_->setValue(opt_->option_->value);
	}
	else
	{
		// option selected
		QPPDOptionItem	*opt_ = (QPPDOptionItem*)ppdopt_;
		setTitle(opt_->option_->text);

		// raising widget
		switch(opt_->option_->ui)
		{
			case PPD_UI_BOOLEAN:
				if (opt_->option_->num_choices == 2)	// we must have 2 choices for a boolean option
				{
					optionboolean_->find(OFF_ID)->setText(opt_->option_->choices[0].text);
					optionboolean_->find(ON_ID)->setText(opt_->option_->choices[1].text);
					if (opt_->currentchoice_ == opt_->option_->choices)
						optionboolean_->setButton(OFF_ID);
					else
						optionboolean_->setButton(ON_ID);
				}
				stack_->raiseWidget(optionboolean_);
		   	break;
			case PPD_UI_PICKONE:
				optionpickone_->clear();
		   	for (int i=0;i<opt_->option_->num_choices;i++)
		   	{
		   		ppd_choice_t	*ch = opt_->option_->choices+i;
				optionpickone_->insertItem(ch->text);
		   		if (opt_->currentchoice_ == ch) optionpickone_->setCurrentItem(i);
		   	}
		   	optionpickone_->centerCurrentItem();
				stack_->raiseWidget(optionpickone_);
				break;
			case PPD_UI_PICKMANY:
				break;
		}
		stack_->setEnabled((opt_->changeable_ || allowNonChangeable_));
	}
}

void QPPDOptionView::selectionChanged(int index)
{
	if (ppdopt_ && ppdopt_->isOption()) ((QPPDOptionItem*)ppdopt_)->setCurrentChoice(index);
	emit optionChanged();
}

void QPPDOptionView::valueChanged(double value)
{
	if (ppdopt_ && ppdopt_->isNumeric())
		((QPPDNumericalOptionItem*)ppdopt_)->setValue(value);
	// do not check constraints for numerical options changes.
}
