/***************************************************************************
                          qtextconfig.h  -  description
                             -------------------
    begin                : Sat Jul 22 2000
    copyright            : (C) 2000 by Michael Goffioul
    email                : gofioul@imec.be
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef QTEXTCONFIG_H
#define QTEXTCONFIG_H

#include "qconfigpage.h"
#include "qtextconfigbase.h"

#include "columnpreview.h"
#include "marginpreview.h"

/**
  *@author Michael Goffioul
  */

class QTextConfig : public QTextConfigBase, public QConfigPage
{
   Q_OBJECT
public: 
	QTextConfig(QWidget *parent=0, const char *name=0);
	~QTextConfig();
  /**  */
  void initOptions(int num_options, cups_option_t *options, global_ppd_file_t *ppd, ipp_t *req = 0);
  void getCupsOptions(int& num_options, cups_option_t **options, bool include_default = false, ipp_t *req = 0);

protected: 
	void initDialog();
  void updateDefaultMargins();
  void updatePagesize();

protected slots: // Protected slots
  void prettyChanged(int ID);
  void customMarginClicked();
  void updateMargins();
  void unitsChanged(int u);

private: // Private attributes
  int currentunits_;
  int	orientation_;
  global_ppd_file_t *ppd_;
  ppd_size_t *pagesize_;
};

#endif
