/****************************************************************************
** Form implementation generated from reading ui file 'addrdialog.ui'
**
** Created: Thu Aug 2 00:13:10 2001
**      by:  The User Interface Compiler (uic)
**
** WARNING! All changes made in this file will be lost!
****************************************************************************/

#include "addrdialog.h"
#include "colordialog.h"
#include "quicklogin.h"
#include "sysconfig.h"
#include "global.h"
#include "settingdialog.h"
#include "qterm.h"

#include <qapplication.h>
#include <math.h>
#include <stdlib.h>
#include <stdio.h>
#include <qstringlist.h>
#include <qcheckbox.h>
#include <qcombobox.h>
#include <qgroupbox.h>
#include <qlabel.h>
#include <qlineedit.h>
#include <qlistbox.h>
#include <qpushbutton.h>
#include <qlayout.h> 
#include <qvariant.h>
#include <qtooltip.h>
#include <qwhatsthis.h>
#include <qfontdialog.h>
#include <qcolordialog.h>
#include <qcolor.h>
#include <qradiobutton.h>
#include <qmessagebox.h>
extern char * itemName[];
extern char fileCfg[];
extern QString pathLib;

/* 
 *  Constructs a addrDialog which is a child of 'parent', with the 
 *  name 'name' and widget flags set to 'f' 
 *
 *  The dialog will by default be modeless, unless you set 'modal' to
 *  TRUE to construct a modal dialog.
 */
addrDialog::addrDialog( QWidget* parent,  const char* name, bool modal, WFlags fl )
    : QDialog( parent, name, modal, fl )
{
    if ( !name )
	setName( "addrDialog" );
    resize( 430, 570 ); 
    setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)0, (QSizePolicy::SizeType)0, sizePolicy().hasHeightForWidth() ) );
    setMinimumSize( QSize( 430, 570 ) );
    setMaximumSize( QSize( 430, 570 ) );
    setCaption( tr( "Address Book" ) );
    setSizeGripEnabled( FALSE );

    fontButton = new QPushButton( this, "fontButton" );
    fontButton->setGeometry( QRect( 20, 480, 106, 28 ) ); 
    fontButton->setText( tr( "&Font" ) );
    connect(fontButton,SIGNAL(clicked()),this,SLOT(onFont()));
    
    colorButton = new QPushButton( this, "colorButton" );
    colorButton->setGeometry( QRect( 170, 480, 106, 28 ) ); 
    colorButton->setText( tr( "&Set Color" ) );
    connect(colorButton,SIGNAL(clicked()),this,SLOT(onColor()));
    
    
    connectButton = new QPushButton( this, "connectButton" );
    connectButton->setGeometry( QRect( 270, 520, 70, 30 ) ); 
    connectButton->setText( tr( "&Connect" ) );
    connect(connectButton,SIGNAL(clicked()),this,SLOT(onConnect()));
    
    updateButton = new QPushButton( this, "updateButton" );
    updateButton->setGeometry( QRect( 160, 520, 70, 30 ) ); 
    updateButton->setText( tr( "&Update" ) );
    connect(updateButton,SIGNAL(clicked()),this,SLOT(onUpdate()));
    
    deleteButton = new QPushButton( this, "deleteButton" );
    deleteButton->setGeometry( QRect( 90, 520, 70, 30 ) ); 
    deleteButton->setText( tr( "&Delete" ) );
    connect(deleteButton,SIGNAL(clicked()),this,SLOT(onDelete()));
   
    addButton = new QPushButton( this, "addButton" );
    addButton->setGeometry( QRect( 20, 520, 70, 30 ) ); 
    addButton->setText( tr( "&Add" ) );
    connect(addButton,SIGNAL(clicked()),this,SLOT(onAdd()));
    
    hostinfoGroupBox = new QGroupBox( this, "hostinfoGroupBox" );
    hostinfoGroupBox->setGeometry( QRect( 20, 160, 390, 90 ) ); 
    hostinfoGroupBox->setTitle( tr( "Host Information" ) );

    TextLabel10 = new QLabel( hostinfoGroupBox, "TextLabel10" );
    TextLabel10->setGeometry( QRect( 10, 50, 91, 21 ) ); 
    TextLabel10->setText( tr( "Host address :" ) );

    TextLabel11 = new QLabel( hostinfoGroupBox, "TextLabel11" );
    TextLabel11->setGeometry( QRect( 240, 50, 51, 21 ) ); 
    TextLabel11->setText( tr( "Port :" ) );

    hostportLineEdit = new QLineEdit( hostinfoGroupBox, "hostportLineEdit" );
    hostportLineEdit->setGeometry( QRect( 310, 50, 70, 22 ) ); 

    hostnameLineEdit = new QLineEdit( hostinfoGroupBox, "hostnameLineEdit" );
    hostnameLineEdit->setGeometry( QRect( 111, 20, 270, 22 ) ); 

    TextLabel9 = new QLabel( hostinfoGroupBox, "TextLabel9" );
    TextLabel9->setGeometry( QRect( 10, 20, 100, 21 ) ); 
    TextLabel9->setText( tr( "Host name :" ) );

    hostaddrLineEdit = new QLineEdit( hostinfoGroupBox, "hostaddrLineEdit" );
    hostaddrLineEdit->setGeometry( QRect( 110, 50, 120, 22 ) ); 

    proxyinfoGroupBox = new QGroupBox( this, "proxyinfoGroupBox" );
    proxyinfoGroupBox->setGeometry( QRect( 20, 350, 390, 120 ) ); 
    proxyinfoGroupBox->setFrameShape( QGroupBox::Box );
    proxyinfoGroupBox->setTitle( tr( "Proxy Information" ) );
    
    
    TextLabel12 = new QLabel( proxyinfoGroupBox, "TextLabel12" );
    TextLabel12->setGeometry( QRect( 10, 20, 91, 21 ) ); 
    TextLabel12->setText( tr( "Proxy server :" ) );

    proxyusrnameLineEdit = new QLineEdit( proxyinfoGroupBox, "proxyusrnameLineEdit" );
    proxyusrnameLineEdit->setGeometry( QRect( 110, 80, 120, 22 ) ); 
    proxyusrnameLineEdit->setEnabled(FALSE);
    
    proxyLineEdit = new QLineEdit( proxyinfoGroupBox, "proxyLineEdit" );
    proxyLineEdit->setGeometry( QRect( 110, 50, 120, 22 ) ); 
    
    ComboBox9 = new QComboBox( FALSE, proxyinfoGroupBox, "ComboBox9" );
    ComboBox9->insertItem( tr( "None" ) );
    ComboBox9->insertItem( tr( "Wingate" ) );
    ComboBox9->insertItem( tr( "Socks V4" ) );
    ComboBox9->insertItem( tr( "Socks V5" ) );
    ComboBox9->setGeometry( QRect( 110, 20, 120, 20 ) ); 
    connect(ComboBox9,SIGNAL(activated(int)),this,SLOT(onProxy(int)));
    
    proxyportLineEdit = new QLineEdit( proxyinfoGroupBox, "proxyportLineEdit" );
    proxyportLineEdit->setGeometry( QRect( 310, 50, 70, 22 ) ); 
    proxyportLineEdit->setEnabled(FALSE);
    
    proxyusrpasswdLineEdit = new QLineEdit( proxyinfoGroupBox, "proxyusrpasswdLineEdit" );
    proxyusrpasswdLineEdit->setGeometry( QRect( 310, 80, 71, 22 ) ); 
    proxyusrpasswdLineEdit->setEchoMode( QLineEdit::Password );
    proxyusrpasswdLineEdit->setEnabled(FALSE);
    
    TextLabel15 = new QLabel( proxyinfoGroupBox, "TextLabel15" );
    TextLabel15->setGeometry( QRect( 10, 80, 81, 21 ) ); 
    TextLabel15->setText( tr( "User name :" ) );

    TextLabel13 = new QLabel( proxyinfoGroupBox, "TextLabel13" );
    TextLabel13->setGeometry( QRect( 10, 50, 81, 21 ) ); 
    TextLabel13->setText( tr( "Proxy :" ) );

    TextLabel14 = new QLabel( proxyinfoGroupBox, "TextLabel14" );
    TextLabel14->setGeometry( QRect( 240, 50, 41, 21 ) ); 
    TextLabel14->setText( tr( "Port :" ) );

    TextLabel16 = new QLabel( proxyinfoGroupBox, "TextLabel16" );
    TextLabel16->setGeometry( QRect( 240, 80, 60, 21 ) ); 
    TextLabel16->setText( tr( "Password :" ) );

    GroupBox4 = new QGroupBox( this, "GroupBox4" );
    GroupBox4->setGeometry( QRect( 20, 251, 390, 90 ) ); 
    GroupBox4->setTitle( tr( "User Information" ) );

    usrinfopasswdLineEdit = new QLineEdit( GroupBox4, "usrinfopasswdLineEdit" );
    usrinfopasswdLineEdit->setEnabled( TRUE );
    usrinfopasswdLineEdit->setGeometry( QRect( 310, 60, 70, 22 ) ); 
    usrinfopasswdLineEdit->setAutoMask( TRUE );
    usrinfopasswdLineEdit->setEchoMode( QLineEdit::Password );
    usrinfopasswdLineEdit->setEdited( TRUE );

    TextLabel1 = new QLabel( GroupBox4, "TextLabel1" );
    TextLabel1->setGeometry( QRect( 10, 60, 81, 21 ) ); 
    TextLabel1->setText( tr( "User name :" ) );

    usrinfonameLineEdit = new QLineEdit( GroupBox4, "usrinfonameLineEdit" );
    usrinfonameLineEdit->setGeometry( QRect( 110, 60, 120, 22 ) ); 

    autologinCheckBox = new QCheckBox( GroupBox4, "autologinCheckBox" );
    autologinCheckBox->setGeometry( QRect( 10, 30, 130, 20 ) ); 
    autologinCheckBox->setText( tr( "Allow Auto Login" ) );
    connect(autologinCheckBox,SIGNAL(toggled(bool)),this,SLOT(onToggled(bool)));
    
    preloginLineEdit = new QLineEdit( GroupBox4, "preloginLineEdit" );
    preloginLineEdit->setGeometry( QRect( 310, 29, 70, 22 ) ); 

    usrinfonameLineEdit->setEnabled(false);
    usrinfopasswdLineEdit->setEnabled(false);
    preloginLineEdit->setEnabled(false);
    
    TextLabel2 = new QLabel( GroupBox4, "TextLabel2" );
    TextLabel2->setGeometry( QRect( 240, 60, 60, 21 ) ); 
    TextLabel2->setText( tr( "Password :" ) );

    TextLabel17 = new QLabel( GroupBox4, "TextLabel17" );
    TextLabel17->setGeometry( QRect( 240, 30, 63, 20 ) ); 
    TextLabel17->setText( tr( "Prelogin :" ) );

    addrListBox = new QListBox( this, "addrListBox" );
    addrListBox->setGeometry( QRect( 20, 10, 390, 130 ) ); 
    connect(addrListBox,SIGNAL(selectionChanged(QListBoxItem *)),this,SLOT(addrUpdateInfo(
				    QListBoxItem*)));
    connect(addrListBox,SIGNAL(doubleClicked(QListBoxItem*)),this,SLOT(onDoubleClicked(QListBoxItem*)));
         
    exitButton = new QPushButton( this, "exitButton" );
    exitButton->setGeometry( QRect( 340, 520, 70, 30 ) ); 
    exitButton->setText( tr( "&Exit" ) );
    connect(exitButton,SIGNAL(clicked()),this,SLOT(onExit()));
    
    
    telnetButton = new QPushButton( this, "telnetButton" );
    telnetButton->setGeometry( QRect( 300, 480, 106, 28 ) ); 
    telnetButton->setText( tr( "&Telnet Set" ) );
    connect(telnetButton,SIGNAL(clicked()),this,SLOT(onTelnet()));
 
     loadAddrFile();
     addrListBox->setCurrentItem(0);
     showAddr();
}
/*  
 *  Destroys the object and frees any allocated resources
 */
addrDialog::~addrDialog()
{
    // no need to delete child widgets, Qt does it all for us
}


void addrDialog::loadAddrFile()
{
	addrList.clear();
	addrListBox->clear();

	CSysConfig conf( fileCfg  );
	QString	strNum=conf.szReadCapItem("bbs list","num");
	addrCount=strNum.toInt();

	QString strTemp;
	QString strSect;
        for(int i=0;i<strNum.toInt();i++)
	{
		strSect.sprintf("bbs %d",i);
		for(int j=0;j<ITEMS;j++)
		{
			char *item = itemName[j];
			strTemp=conf.szReadCapItem(strSect,item);
			if(strTemp.isNull())
				addrList.append("");
			else
				addrList.append(strTemp);

			if(strcmp(item,"name")==0)
				addrListBox->insertItem(QString::fromLocal8Bit(strTemp));

		}


	}
}

void addrDialog::onConnect()
{
	addrCurrent[ADDR]=hostaddrLineEdit->text();
	addrCurrent[PORT]=hostportLineEdit->text();
	addrCurrent[NAME]=hostnameLineEdit->text().local8Bit();


	addrCurrent[PRELOGIN]=preloginLineEdit->text();
	addrCurrent[USER]=usrinfonameLineEdit->text();
	addrCurrent[PASSWORD]=usrinfopasswdLineEdit->text();
	QString strTemp;
	strTemp.sprintf("%d",ComboBox9->currentItem());
	addrCurrent[PROXYENABLE]=strTemp;
	addrCurrent[PROXYADDR]=proxyLineEdit->text();
	addrCurrent[PROXYPORT]=proxyportLineEdit->text();
	addrCurrent[PROXYUSER]=proxyusrnameLineEdit->text();
	addrCurrent[PROXYPASSWORD]=proxyusrpasswdLineEdit->text();
        
        
	done(1);
}

void addrDialog::onExit()
{
	addrList.clear();
	done(0);
}

void addrDialog::onUpdate()
{
	addrCurrent[ADDR]=hostaddrLineEdit->text();
	addrCurrent[PORT]=hostportLineEdit->text();
	addrCurrent[NAME]=hostnameLineEdit->text().local8Bit();
        
	
	if(autologinCheckBox->isChecked())
	{
	   addrCurrent[AUTOLOGIN]="1";	
	   addrCurrent[USER]=usrinfonameLineEdit->text();
	   addrCurrent[PASSWORD]=usrinfopasswdLineEdit->text();
	   addrCurrent[PRELOGIN]=preloginLineEdit->text();
	}
	else
           addrCurrent[AUTOLOGIN]="0";
	

	QString strTemp;
	strTemp.sprintf("%d",ComboBox9->currentItem());
	addrCurrent[PROXYENABLE]=strTemp;
	addrCurrent[PROXYADDR]=proxyLineEdit->text();
	addrCurrent[PROXYPORT]=proxyportLineEdit->text();
	addrCurrent[PROXYUSER]=proxyusrnameLineEdit->text();
	addrCurrent[PROXYPASSWORD]=proxyusrpasswdLineEdit->text();

	CSysConfig conf( fileCfg );
	QString strSect;
	strSect.sprintf("bbs %d",addrListBox->currentItem());


	int nCurrent = addrListBox->currentItem();

	for(int i=0;i<ITEMS;i++)
	{
		
		addrList[nCurrent*ITEMS+i]=addrCurrent[i];
		char *item=itemName[i];
		conf.bChangeCapItem(strSect,item,addrCurrent[i]);
	}

	conf.bSave(  fileCfg );

	addrListBox->changeItem(QString::fromLocal8Bit(addrCurrent[NAME]),addrListBox->currentItem());
}

void addrDialog::onAdd()
{

	addrCurrent[ADDR]=hostaddrLineEdit->text();
	addrCurrent[PORT]=hostportLineEdit->text();
	addrCurrent[NAME]=hostnameLineEdit->text().local8Bit();

	if(autologinCheckBox->isChecked())
	{
	   addrCurrent[AUTOLOGIN]="1";	
	   addrCurrent[USER]=usrinfonameLineEdit->text();
	   addrCurrent[PASSWORD]=usrinfopasswdLineEdit->text();
	   addrCurrent[PRELOGIN]=preloginLineEdit->text();
	}
	else
           addrCurrent[AUTOLOGIN]="0";
	
	QString strTemp;
	strTemp.sprintf("%d",ComboBox9->currentItem());
	addrCurrent[PROXYENABLE]=strTemp;
	addrCurrent[PROXYADDR]=proxyLineEdit->text();
	addrCurrent[PROXYPORT]=proxyportLineEdit->text();
	addrCurrent[PROXYUSER]=proxyusrnameLineEdit->text();
	addrCurrent[PROXYPASSWORD]=proxyusrpasswdLineEdit->text();

	addrCount++;
	CSysConfig conf( fileCfg );
	QString strSect;
	strSect.sprintf("bbs %d",addrCount-1);
	QString strNum;
	strNum.sprintf("%d",addrCount);
	conf.bChangeCapItem("bbs list","num",strNum);

	for(int i=0;i<ITEMS;i++)
	{
		addrList.append(addrCurrent[i]);
		char *item=itemName[i];


		conf.bWriteCapItem(strSect,item,addrCurrent[i]);
	}

	conf.bSave( fileCfg );


	addrListBox->insertItem(QString::fromLocal8Bit(addrCurrent[NAME]));
	addrListBox->setCurrentItem(addrCount-1);
}

void addrDialog::onDelete()
{

	if(addrCount==1)
	{
	      	QMessageBox mb( "QTerm",
		          "Address Book can NOT be empty!",
		          QMessageBox::Warning,
		          QMessageBox::Ok | QMessageBox::Default,0,
		          0,0,0,true);
		mb.exec();

		return;	
	}
			
	int nCurrent = addrListBox->currentItem();
	QStringList::Iterator it;
	for(int i=0;i<ITEMS;i++)
	{
		it=addrList.at(nCurrent*ITEMS);
		addrList.remove(it);
	}

	addrCount--;
	CSysConfig conf( fileCfg );
	QString strNum;
	strNum.sprintf("%d",addrCount);
	conf.bChangeCapItem("bbs list","num",strNum);
	QString strSect;
	strSect.sprintf("bbs %d",addrCount);
	conf.DeleteGroup(strSect);

	conf.bSave( fileCfg );

	addrListBox->removeItem(nCurrent);
	addrListBox->setCurrentItem(0);
	showAddr();
}
void addrDialog::onFont()
{

	bool ok;
	QFont font=fontdlg->getFont(&ok,QFont(addrCurrent[FONT]));
	if(ok==true)
	{
		addrCurrent[FONT]=font.family().local8Bit();
	}
}
void addrDialog::onColor()
{
        int r,g,b;
	colordlg=new colorDialog(this);
	colordlg->fgColor=addrCurrent[FGCOLOR];
	sscanf( colordlg->fgColor,"%d %d %d",&r,&g,&b);
	colordlg->colorFg=QColor(r,g,b);	
	colordlg->bgColor=addrCurrent[BGCOLOR];
	sscanf( colordlg->bgColor,"%d %d %d",&r,&g,&b);	
	colordlg->colorBg=QColor(r,g,b);
	colordlg->repaint();

	if(colordlg->exec()==1)
	{
		addrCurrent[FGCOLOR]=colordlg->fgColor;
		addrCurrent[BGCOLOR]=colordlg->bgColor;		
	}
	delete colordlg;
	
}

void addrDialog::onTelnet()
{

//        printf("synthesize set\n");

        settingdlg = new settingDialog(this);
        settingdlg->wavefilename=addrCurrent[WAVEFILE];
        
        if(addrCurrent[SMARTMENU] == "TRUE")
        {
        	settingdlg->smartCheckBox->setChecked(TRUE);
        	settingdlg->bSmartMenu="TRUE";
        }
        else
        {
        	settingdlg->smartCheckBox->setChecked(FALSE);
        	settingdlg->bSmartMenu="FALSE";        	
        }
        
        if(addrCurrent[HYPERLINK] == "TRUE")
        {
        	settingdlg->hyperCheckBox->setChecked(TRUE);
        	settingdlg->bHyperLink="TRUE";
        }
        else
        {
        	settingdlg->hyperCheckBox->setChecked(FALSE);
        	settingdlg->bHyperLink="FALSE";
        }
        
        if(addrCurrent[ALWAYSHIGHLIGHT] == "TRUE")
        {
        	settingdlg->highlightCheckBox->setChecked(TRUE);
        	settingdlg->bHighLight="TRUE";
        }
        else
        {
        	settingdlg->highlightCheckBox->setChecked(FALSE);
        	settingdlg->bHighLight="FALSE";
        }
        
        if(addrCurrent[EXITWARNING] == "TRUE")
        {
        	settingdlg->CheckBox6->setChecked(TRUE);
        	settingdlg->bExitWarning="TRUE";
        }
        else
        {
        	settingdlg->CheckBox6->setChecked(FALSE);
        	settingdlg->bExitWarning="FALSE";
        }
        
        if(addrCurrent[BLINKTAB] == "TRUE")
        {
        	settingdlg->CheckBox7->setChecked(TRUE);
        	settingdlg->bBlinkTab="TRUE";
        }
        else
        {
        	settingdlg->CheckBox7->setChecked(FALSE);
        	settingdlg->bBlinkTab="FALSE";
        }
        
        	       
        if(settingdlg->wavefilename.isEmpty())
        {

        	settingdlg->speakRadioButton->setChecked(true);
        	settingdlg->onSpeak(true);
        }
        else
        {
        	settingdlg->customRadioButton->setChecked(true);
        	settingdlg->onCustom(true);
        }
       
	settingdlg->codeComboBox->setCurrentItem( addrCurrent[BBSCODE].toInt() );
        settingdlg->automsgLineEdit->setText(QString::fromLocal8Bit(addrCurrent[AUTOREPLY]));
        settingdlg->antiLineEdit->setText(addrCurrent[ANTIIDLESTRING]);
        settingdlg->escLineEdit->setText(addrCurrent[ESCSTRING]);
        
        if(settingdlg->exec()==1)
        {
               addrCurrent[WAVEFILE] = settingdlg->wavefilename;
               addrCurrent[AUTOREPLY] = settingdlg->automsgLineEdit->text().local8Bit();
               addrCurrent[ANTIIDLESTRING] = settingdlg->antiLineEdit->text();
               addrCurrent[ESCSTRING] = settingdlg->escLineEdit->text();
               addrCurrent[SMARTMENU] = settingdlg->bSmartMenu;
               addrCurrent[HYPERLINK] = settingdlg->bHyperLink;
               addrCurrent[ALWAYSHIGHLIGHT] = settingdlg->bHighLight;
               addrCurrent[BLINKTAB]  = settingdlg->bBlinkTab;
               addrCurrent[EXITWARNING] = settingdlg->bExitWarning;               
	       addrCurrent[BBSCODE] = QString::number(settingdlg->codeComboBox->currentItem());
	}

 	delete settingdlg;
					
}


void addrDialog::addrUpdateInfo(QListBoxItem *)
{

	showAddr();

}

void addrDialog::saveAddrFile()
{

}

void addrDialog::showAddr()
{

	int nCurrent = addrListBox->currentItem();
	hostaddrLineEdit->setText(addrList[nCurrent*ITEMS+ADDR]);
	hostportLineEdit->setText(addrList[nCurrent*ITEMS+PORT]);

        hostnameLineEdit->setText(QString::fromLocal8Bit(addrList[nCurrent*ITEMS+NAME]));
	usrinfonameLineEdit->setText(addrList[nCurrent*ITEMS+USER]);
	usrinfopasswdLineEdit->setText(addrList[nCurrent*ITEMS+PASSWORD]);

	ComboBox9->setCurrentItem(addrList[nCurrent*ITEMS+PROXYENABLE].toInt());

	switch(addrList[nCurrent*ITEMS+PROXYENABLE].toInt())
	{
		case 0:
//		     printf("select proxy none\n");

		     proxyLineEdit->setText("");
                     proxyportLineEdit->setText("");
                     proxyusrnameLineEdit->setText("");
                     proxyusrpasswdLineEdit->setText("");
                     proxyusrnameLineEdit->setEnabled(false);
                     proxyLineEdit->setEnabled(false);
                     proxyportLineEdit->setEnabled(false);
                     proxyusrpasswdLineEdit->setEnabled(false);
		     break;
		
		case 1:
//		     printf("select wingate\n");
									    
		     proxyLineEdit->setText(addrList[nCurrent*ITEMS+PROXYADDR]);
                     proxyportLineEdit->setText(addrList[nCurrent*ITEMS+PROXYPORT]);
                     proxyusrnameLineEdit->setText("");
                     proxyusrpasswdLineEdit->setText("");
	
		     proxyLineEdit->setEnabled(true);
		     proxyportLineEdit->setEnabled(true);
		     proxyusrnameLineEdit->setEnabled(false);
		     proxyusrpasswdLineEdit->setEnabled(false);
	
		     break;
		case 2:
//		     printf("select proxy socks4\n");
									    
		     proxyLineEdit->setText(addrList[nCurrent*ITEMS+PROXYADDR]);
                     proxyportLineEdit->setText(addrList[nCurrent*ITEMS+PROXYPORT]);
                     proxyusrnameLineEdit->setText("");
                     proxyusrpasswdLineEdit->setText("");
	
		     proxyLineEdit->setEnabled(true);
		     proxyportLineEdit->setEnabled(true);
		     proxyusrnameLineEdit->setEnabled(false);
		     proxyusrpasswdLineEdit->setEnabled(false);
	
		     break;
		
		case 3:
//		     printf("select proxy sockv5\n");
		     proxyLineEdit->setText(addrList[nCurrent*ITEMS+PROXYADDR]);
		     proxyportLineEdit->setText(addrList[nCurrent*ITEMS+PROXYPORT]);
		     proxyusrnameLineEdit->setText(addrList[nCurrent*ITEMS+PROXYUSER]);
		     proxyusrpasswdLineEdit->setText(addrList[nCurrent*ITEMS+PROXYPASSWORD]);

		     proxyLineEdit->setEnabled(true);
		     proxyportLineEdit->setEnabled(true);
	             proxyusrnameLineEdit->setEnabled(true);
		     proxyusrpasswdLineEdit->setEnabled(true);				
						     
		     break;
		
		default:
//		     printf("error\n");
		     break;

	}	


	if(addrList[nCurrent*ITEMS+AUTOLOGIN]=="1")
	{
		autologinCheckBox->setChecked(true);
	        usrinfonameLineEdit->setEnabled(true);
                usrinfopasswdLineEdit->setEnabled(true);
                preloginLineEdit->setEnabled(true);
		preloginLineEdit->setText(addrList[nCurrent*ITEMS+PRELOGIN]);		
		usrinfonameLineEdit->setText(addrList[nCurrent*ITEMS+USER]);
		usrinfopasswdLineEdit->setText(addrList[nCurrent*ITEMS+PASSWORD]);
	}
	else
	{
		autologinCheckBox->setChecked(false);
        	preloginLineEdit->setText(addrList[nCurrent*ITEMS+PRELOGIN]);	
		usrinfonameLineEdit->setText(addrList[nCurrent*ITEMS+USER]);
		usrinfopasswdLineEdit->setText(addrList[nCurrent*ITEMS+PASSWORD]);
                usrinfonameLineEdit->setEnabled(false);
                usrinfopasswdLineEdit->setEnabled(false);
                preloginLineEdit->setEnabled(false);
	}
	
	addrCurrent.clear();
	for(int i=0;i<ITEMS;i++)
	{
		addrCurrent.append(addrList[nCurrent*ITEMS+i]);
	}
}

void addrDialog::onToggled(bool bOn)
{

	if(bOn==false)
	{
 		usrinfonameLineEdit->setEnabled(false);
        	usrinfopasswdLineEdit->setEnabled(false);
        	preloginLineEdit->setEnabled(false);
		addrCurrent[AUTOLOGIN]="0";
	}
	else
	{
        	usrinfonameLineEdit->setEnabled(true);
        	usrinfopasswdLineEdit->setEnabled(true);
        	preloginLineEdit->setEnabled(true);
		addrCurrent[AUTOLOGIN]="1";
	}
}

void addrDialog::onProxy(int index)
{

        int nCurrent = addrListBox->currentItem();
		
	switch(index)
	{
		case 0:
//		     printf("select proxy none\n");

		     proxyLineEdit->setText("");
                     proxyportLineEdit->setText("");
                     proxyusrnameLineEdit->setText("");
                     proxyusrpasswdLineEdit->setText("");	

                     proxyusrnameLineEdit->setEnabled(false);
                     proxyLineEdit->setEnabled(false);
                     proxyportLineEdit->setEnabled(false);
                     proxyusrpasswdLineEdit->setEnabled(false);
		     break;
		
		case 1:
//		     printf("select wingate proxy \n");
									    
		     proxyLineEdit->setText(addrList[nCurrent*ITEMS+PROXYADDR]);
                     proxyportLineEdit->setText(addrList[nCurrent*ITEMS+PROXYPORT]);
                     proxyusrnameLineEdit->setText(addrList[nCurrent*ITEMS+PROXYUSER]);
                     proxyusrpasswdLineEdit->setText("");
		     proxyLineEdit->setEnabled(true);
		     proxyportLineEdit->setEnabled(true);
	             proxyusrnameLineEdit->setEnabled(false);
		     proxyusrpasswdLineEdit->setEnabled(false);
	
		     break;
		
		case 2:
//		     printf("select proxy sockv4\n");
		     proxyLineEdit->setEnabled(true);
		     proxyportLineEdit->setEnabled(true);
	             proxyusrnameLineEdit->setEnabled(false);
		     proxyusrpasswdLineEdit->setEnabled(false);

		     proxyLineEdit->setText(addrList[nCurrent*ITEMS+PROXYADDR]);
		     proxyportLineEdit->setText(addrList[nCurrent*ITEMS+PROXYPORT]);
		     proxyusrnameLineEdit->setText(addrList[nCurrent*ITEMS+PROXYUSER]);
		     proxyusrpasswdLineEdit->setText(addrList[nCurrent*ITEMS+PROXYPASSWORD]);
						     
		     break;
		case 3:
//		     printf("select proxy sockv4\n");
		     proxyLineEdit->setEnabled(true);
		     proxyportLineEdit->setEnabled(true);
	             proxyusrnameLineEdit->setEnabled(true);
		     proxyusrpasswdLineEdit->setEnabled(true);
				
		     proxyLineEdit->setText(addrList[nCurrent*ITEMS+PROXYADDR]);
		     proxyportLineEdit->setText(addrList[nCurrent*ITEMS+PROXYPORT]);
		     proxyusrnameLineEdit->setText(addrList[nCurrent*ITEMS+PROXYUSER]);
		     proxyusrpasswdLineEdit->setText(addrList[nCurrent*ITEMS+PROXYPASSWORD]);
		
		     break;
		default:
//		     printf("error\n");
		     break;
	}		

}

void addrDialog::onDoubleClicked(QListBoxItem * item)
{

	addrListBox->setCurrentItem( item );
	showAddr();
	
	done(1);
}
