#ifndef AnimatedLabel_h
#define AnimatedLabel_h

// $Id: AnimatedLabel.h,v 1.6 2013/10/25 09:39:35 hupereir Exp $

/******************************************************************************
*
* Copyright (C) 2002 Hugo PEREIRA <mailto: hugo.pereira@free.fr>
*
* This is free software; you can redistribute it and/or modify it under the
* terms of the GNU General Public License as published by the Free Software
* Foundation; either version 2 of the License, or (at your option) any later
* version.
*
* This software is distributed in the hope that it will be useful, but WITHOUT
* Any WARRANTY; without even the implied warranty of MERCHANTABILITY or
* FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
* for more details.
*
* You should have received a copy of the GNU General Public License along with
* this program.  If not, see <http://www.gnu.org/licenses/>.
*
*******************************************************************************/

/*!
  \file AnimatedLabel.h
  \brief animated QLabel object
  \author Hugo Pereira
  \version $Revision: 1.6 $
  \date $Date: 2013/10/25 09:39:35 $
*/

#include <QLabel>

#include "Counter.h"

class TransitionWidget;

class AnimatedLabel: public QLabel, public Counter
{

  Q_OBJECT

  public:

  //! constructor
  AnimatedLabel( QWidget* parent = 0 );

  //! destrutor
  virtual ~AnimatedLabel( void );

  //! transition widget
  TransitionWidget& transitionWidget( void ) const
  { return *transition_widget_; }

  public Q_SLOTS:

  //! set text
  virtual void setText( const QString & );

  //! clear
  virtual void clear( void );

  private:

  //! transition widget
  TransitionWidget* transition_widget_;


};

#endif
