/* -*- Mode: C++; c-basic-offset: 2; tab-width: 2; indent-tabs-mode: nil -*-
 * 
 * Quadra, an action puzzle game
 * Copyright (C) 1998-2000  Ludus Design
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "video.h"
#include "cursor_self.h"
#ifdef UGS_LINUX_X11
#include "cursor_x11.h"
#endif
#include "cursor.h"

RCSID("$Id: cursor.cpp,v 1.3 2000/11/30 01:26:27 pphaneuf Exp $")

Cursor* cursor = NULL;

Cursor* Cursor::New(Sprite* s) {
#ifdef UGS_LINUX_X11
	if(video->xwindow)
		return new Cursor_X11();
#endif
	return new Cursor_Self(s);
}
