/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 1.3.29
 * 
 * This file is not intended to be easily readable and contains a number of 
 * coding conventions designed to improve portability and efficiency. Do not make
 * changes to this file unless you know what you are doing--modify the SWIG 
 * interface file instead. 
 * ----------------------------------------------------------------------------- */


#ifdef __cplusplus
template<class T> class SwigValueWrapper {
    T *tt;
public:
    SwigValueWrapper() : tt(0) { }
    SwigValueWrapper(const SwigValueWrapper<T>& rhs) : tt(new T(*rhs.tt)) { }
    SwigValueWrapper(const T& t) : tt(new T(t)) { }
    ~SwigValueWrapper() { delete tt; } 
    SwigValueWrapper& operator=(const T& t) { delete tt; tt = new T(t); return *this; }
    operator T&() const { return *tt; }
    T *operator&() { return tt; }
private:
    SwigValueWrapper& operator=(const SwigValueWrapper<T>& rhs);
};
#endif

/* -----------------------------------------------------------------------------
 *  This section contains generic SWIG labels for method/variable
 *  declarations/attributes, and other compiler dependent labels.
 * ----------------------------------------------------------------------------- */

/* template workaround for compilers that cannot correctly implement the C++ standard */
#ifndef SWIGTEMPLATEDISAMBIGUATOR
# if defined(__SUNPRO_CC)
#   if (__SUNPRO_CC <= 0x560)
#     define SWIGTEMPLATEDISAMBIGUATOR template
#   else
#     define SWIGTEMPLATEDISAMBIGUATOR 
#   endif
# else
#   define SWIGTEMPLATEDISAMBIGUATOR 
# endif
#endif

/* inline attribute */
#ifndef SWIGINLINE
# if defined(__cplusplus) || (defined(__GNUC__) && !defined(__STRICT_ANSI__))
#   define SWIGINLINE inline
# else
#   define SWIGINLINE
# endif
#endif

/* attribute recognised by some compilers to avoid 'unused' warnings */
#ifndef SWIGUNUSED
# if defined(__GNUC__)
#   if !(defined(__cplusplus)) || (__GNUC__ > 3 || (__GNUC__ == 3 && __GNUC_MINOR__ >= 4))
#     define SWIGUNUSED __attribute__ ((__unused__)) 
#   else
#     define SWIGUNUSED
#   endif
# elif defined(__ICC)
#   define SWIGUNUSED __attribute__ ((__unused__)) 
# else
#   define SWIGUNUSED 
# endif
#endif

#ifndef SWIGUNUSEDPARM
# ifdef __cplusplus
#   define SWIGUNUSEDPARM(p)
# else
#   define SWIGUNUSEDPARM(p) p SWIGUNUSED 
# endif
#endif

/* internal SWIG method */
#ifndef SWIGINTERN
# define SWIGINTERN static SWIGUNUSED
#endif

/* internal inline SWIG method */
#ifndef SWIGINTERNINLINE
# define SWIGINTERNINLINE SWIGINTERN SWIGINLINE
#endif

/* exporting methods */
#if (__GNUC__ >= 4) || (__GNUC__ == 3 && __GNUC_MINOR__ >= 4)
#  ifndef GCC_HASCLASSVISIBILITY
#    define GCC_HASCLASSVISIBILITY
#  endif
#endif

#ifndef SWIGEXPORT
# if defined(_WIN32) || defined(__WIN32__) || defined(__CYGWIN__)
#   if defined(STATIC_LINKED)
#     define SWIGEXPORT
#   else
#     define SWIGEXPORT __declspec(dllexport)
#   endif
# else
#   if defined(__GNUC__) && defined(GCC_HASCLASSVISIBILITY)
#     define SWIGEXPORT __attribute__ ((visibility("default")))
#   else
#     define SWIGEXPORT
#   endif
# endif
#endif

/* calling conventions for Windows */
#ifndef SWIGSTDCALL
# if defined(_WIN32) || defined(__WIN32__) || defined(__CYGWIN__)
#   define SWIGSTDCALL __stdcall
# else
#   define SWIGSTDCALL
# endif 
#endif

/* Deal with Microsoft's attempt at deprecating C standard runtime functions */
#if !defined(SWIG_NO_CRT_SECURE_NO_DEPRECATE) && defined(_MSC_VER)
# define _CRT_SECURE_NO_DEPRECATE
#endif


#include <stdlib.h>
#include <string.h>
#include <stdio.h>


/* Support for throwing C# exceptions from C/C++. There are two types: 
 * Exceptions that take a message and ArgumentExceptions that take a message and a parameter name. */
typedef enum {
  SWIG_CSharpApplicationException,
  SWIG_CSharpArithmeticException,
  SWIG_CSharpDivideByZeroException,
  SWIG_CSharpIndexOutOfRangeException,
  SWIG_CSharpInvalidOperationException,
  SWIG_CSharpIOException,
  SWIG_CSharpNullReferenceException,
  SWIG_CSharpOutOfMemoryException,
  SWIG_CSharpOverflowException,
  SWIG_CSharpSystemException
} SWIG_CSharpExceptionCodes;

typedef enum {
  SWIG_CSharpArgumentException,
  SWIG_CSharpArgumentNullException,
  SWIG_CSharpArgumentOutOfRangeException
} SWIG_CSharpExceptionArgumentCodes;

typedef void (SWIGSTDCALL* SWIG_CSharpExceptionCallback_t)(const char *);
typedef void (SWIGSTDCALL* SWIG_CSharpExceptionArgumentCallback_t)(const char *, const char *);

typedef struct {
  SWIG_CSharpExceptionCodes code;
  SWIG_CSharpExceptionCallback_t callback;
} SWIG_CSharpException_t;

typedef struct {
  SWIG_CSharpExceptionArgumentCodes code;
  SWIG_CSharpExceptionArgumentCallback_t callback;
} SWIG_CSharpExceptionArgument_t;

static SWIG_CSharpException_t SWIG_csharp_exceptions[] = {
  { SWIG_CSharpApplicationException, NULL },
  { SWIG_CSharpArithmeticException, NULL },
  { SWIG_CSharpDivideByZeroException, NULL },
  { SWIG_CSharpIndexOutOfRangeException, NULL },
  { SWIG_CSharpInvalidOperationException, NULL },
  { SWIG_CSharpIOException, NULL },
  { SWIG_CSharpNullReferenceException, NULL },
  { SWIG_CSharpOutOfMemoryException, NULL },
  { SWIG_CSharpOverflowException, NULL },
  { SWIG_CSharpSystemException, NULL }
};

static SWIG_CSharpExceptionArgument_t SWIG_csharp_exceptions_argument[] = {
  { SWIG_CSharpArgumentException, NULL },
  { SWIG_CSharpArgumentNullException, NULL },
  { SWIG_CSharpArgumentOutOfRangeException, NULL },
};

static void SWIGUNUSED SWIG_CSharpSetPendingException(SWIG_CSharpExceptionCodes code, const char *msg) {
  SWIG_CSharpExceptionCallback_t callback = SWIG_csharp_exceptions[SWIG_CSharpApplicationException].callback;
  if (code >=0 && (size_t)code < sizeof(SWIG_csharp_exceptions)/sizeof(SWIG_CSharpException_t)) {
    callback = SWIG_csharp_exceptions[code].callback;
  }
  callback(msg);
}

static void SWIGUNUSED SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpExceptionArgumentCodes code, const char *msg, const char *param_name) {
  SWIG_CSharpExceptionArgumentCallback_t callback = SWIG_csharp_exceptions_argument[SWIG_CSharpArgumentException].callback;
  if (code >=0 && (size_t)code < sizeof(SWIG_csharp_exceptions_argument)/sizeof(SWIG_CSharpExceptionArgument_t)) {
    callback = SWIG_csharp_exceptions_argument[code].callback;
  }
  callback(msg, param_name);
}


#ifdef __cplusplus
extern "C" 
#endif
SWIGEXPORT void SWIGSTDCALL SWIGRegisterExceptionCallbacks_NQuantLibc(
                                                SWIG_CSharpExceptionCallback_t applicationCallback,
                                                SWIG_CSharpExceptionCallback_t arithmeticCallback,
                                                SWIG_CSharpExceptionCallback_t divideByZeroCallback, 
                                                SWIG_CSharpExceptionCallback_t indexOutOfRangeCallback, 
                                                SWIG_CSharpExceptionCallback_t invalidOperationCallback,
                                                SWIG_CSharpExceptionCallback_t ioCallback,
                                                SWIG_CSharpExceptionCallback_t nullReferenceCallback,
                                                SWIG_CSharpExceptionCallback_t outOfMemoryCallback, 
                                                SWIG_CSharpExceptionCallback_t overflowCallback, 
                                                SWIG_CSharpExceptionCallback_t systemCallback) {
  SWIG_csharp_exceptions[SWIG_CSharpApplicationException].callback = applicationCallback;
  SWIG_csharp_exceptions[SWIG_CSharpArithmeticException].callback = arithmeticCallback;
  SWIG_csharp_exceptions[SWIG_CSharpDivideByZeroException].callback = divideByZeroCallback;
  SWIG_csharp_exceptions[SWIG_CSharpIndexOutOfRangeException].callback = indexOutOfRangeCallback;
  SWIG_csharp_exceptions[SWIG_CSharpInvalidOperationException].callback = invalidOperationCallback;
  SWIG_csharp_exceptions[SWIG_CSharpIOException].callback = ioCallback;
  SWIG_csharp_exceptions[SWIG_CSharpNullReferenceException].callback = nullReferenceCallback;
  SWIG_csharp_exceptions[SWIG_CSharpOutOfMemoryException].callback = outOfMemoryCallback;
  SWIG_csharp_exceptions[SWIG_CSharpOverflowException].callback = overflowCallback;
  SWIG_csharp_exceptions[SWIG_CSharpSystemException].callback = systemCallback;
}

#ifdef __cplusplus
extern "C" 
#endif
SWIGEXPORT void SWIGSTDCALL SWIGRegisterExceptionArgumentCallbacks_NQuantLibc(
                                                SWIG_CSharpExceptionArgumentCallback_t argumentCallback,
                                                SWIG_CSharpExceptionArgumentCallback_t argumentNullCallback,
                                                SWIG_CSharpExceptionArgumentCallback_t argumentOutOfRangeCallback) {
  SWIG_csharp_exceptions_argument[SWIG_CSharpArgumentException].callback = argumentCallback;
  SWIG_csharp_exceptions_argument[SWIG_CSharpArgumentNullException].callback = argumentNullCallback;
  SWIG_csharp_exceptions_argument[SWIG_CSharpArgumentOutOfRangeException].callback = argumentOutOfRangeCallback;
}


/* Callback for returning strings to C# without leaking memory */
typedef char * (SWIGSTDCALL* SWIG_CSharpStringHelperCallback)(const char *);
static SWIG_CSharpStringHelperCallback SWIG_csharp_string_callback = NULL;


#ifdef __cplusplus
extern "C" 
#endif
SWIGEXPORT void SWIGSTDCALL SWIGRegisterStringCallback_NQuantLibc(SWIG_CSharpStringHelperCallback callback) {
  SWIG_csharp_string_callback = callback;
}

/* Contract support */

#define SWIG_contract_assert(nullreturn, expr, msg) if (!(expr)) {SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, msg, ""); return nullreturn; } else

/*  Errors in SWIG */
#define  SWIG_UnknownError    	   -1 
#define  SWIG_IOError        	   -2 
#define  SWIG_RuntimeError   	   -3 
#define  SWIG_IndexError     	   -4 
#define  SWIG_TypeError      	   -5 
#define  SWIG_DivisionByZero 	   -6 
#define  SWIG_OverflowError  	   -7 
#define  SWIG_SyntaxError    	   -8 
#define  SWIG_ValueError     	   -9 
#define  SWIG_SystemError    	   -10
#define  SWIG_AttributeError 	   -11
#define  SWIG_MemoryError    	   -12 
#define  SWIG_NullReferenceError   -13




SWIGINTERN void SWIG_CSharpException(int code, const char *msg) {
  if (code == SWIG_ValueError) {
    SWIG_CSharpExceptionArgumentCodes exception_code = SWIG_CSharpArgumentOutOfRangeException;
    SWIG_CSharpSetPendingExceptionArgument(exception_code, msg, 0);
  } else {
    SWIG_CSharpExceptionCodes exception_code = SWIG_CSharpApplicationException;
    switch(code) {
    case SWIG_MemoryError:
      exception_code = SWIG_CSharpOutOfMemoryException;
      break;
    case SWIG_IndexError:
      exception_code = SWIG_CSharpIndexOutOfRangeException;
      break;
    case SWIG_DivisionByZero:
      exception_code = SWIG_CSharpDivideByZeroException;
      break;
    case SWIG_IOError:
      exception_code = SWIG_CSharpIOException;
      break;
    case SWIG_OverflowError:
      exception_code = SWIG_CSharpOverflowException;
      break;
    case SWIG_RuntimeError:
    case SWIG_TypeError:
    case SWIG_SyntaxError:
    case SWIG_SystemError:
    case SWIG_UnknownError:
    default:
      exception_code = SWIG_CSharpApplicationException;
      break;
    }
    SWIG_CSharpSetPendingException(exception_code, msg);
  }
}


#include <stdexcept>


#define SWIGSTDCALL


#include <ql/quantlib.hpp>

#if QL_HEX_VERSION < 0x000313f0
    #error using an old version of QuantLib, please update
#endif

// add here SWIG version check

#if defined(_MSC_VER)         // Microsoft Visual C++ 6.0
// disable Swig-dependent warnings

// 'identifier1' has C-linkage specified,
// but returns UDT 'identifier2' which is incompatible with C
#pragma warning(disable: 4190)

// 'int' : forcing value to bool 'true' or 'false' (performance warning)
#pragma warning(disable: 4800)

// debug info too long etc etc
#pragma warning(disable: 4786)
#endif


#include <stdexcept>


#include <string>


#include <vector>
#include <algorithm>
#include <stdexcept>


#include <map>
#include <algorithm>
#include <stdexcept>


#include <utility>


// generally useful classes
using QuantLib::Error;
using QuantLib::Handle;


using QuantLib::Observer;
using QuantLib::Observable;

SWIGINTERN bool boost_shared_ptr_Sl_Observable_Sg__isNull(boost::shared_ptr<Observable > *self){
                return !(*self);
            }

using QuantLib::Integer;
using QuantLib::BigInteger;
using QuantLib::Natural;
using QuantLib::BigNatural;
using QuantLib::Real;
using QuantLib::Decimal;
using QuantLib::Time;
using QuantLib::Rate;
using QuantLib::Spread;
using QuantLib::DiscountFactor;
using QuantLib::Volatility;
using QuantLib::Size;


using QuantLib::Array;
using QuantLib::Matrix;
using QuantLib::SampledCurve;

SWIGINTERN std::string Array___str__(Array *self){
            std::ostringstream out;
            out << *self;
            return out.str();
        }

typedef QuantLib::LexicographicalView<Array::iterator>
    LexicographicalView;
typedef QuantLib::LexicographicalView<Array::iterator>::y_iterator
    LexicographicalViewColumn;

SWIGINTERN LexicographicalView *new_LexicographicalView(Array &a,Size xSize){
            return new LexicographicalView(a.begin(),a.end(),xSize);
        }
SWIGINTERN std::string LexicographicalView___str__(LexicographicalView *self){
            std::ostringstream s;
            for (Size j=0; j<self->ySize(); j++) {
                s << "\n";
                for (Size i=0; i<self->xSize(); i++) {
                    if (i != 0)
                        s << ",";
                    s << (*self)[i][j];
                }
            }
            s << "\n";
            return s.str();
        }

typedef QuantLib::Matrix::row_iterator MatrixRow;
using QuantLib::outerProduct;
using QuantLib::transpose;
using QuantLib::SVD;

SWIGINTERN std::string Matrix___str__(Matrix *self){
            std::ostringstream out;
            out << *self;
            return out.str();
        }

using QuantLib::pseudoSqrt;
using QuantLib::SalvagingAlgorithm;


using QuantLib::CostFunction;


using QuantLib::Quote;

SWIGINTERN bool boost_shared_ptr_Sl_Quote_Sg__isNull(boost::shared_ptr<Quote > *self){
                return !(*self);
            }
SWIGINTERN boost::shared_ptr<Observable > boost_shared_ptr_Sl_Quote_Sg__asObservable(boost::shared_ptr<Quote > *self){
        return boost::shared_ptr<Observable>(*self);
    }
SWIGINTERN boost::shared_ptr<Observable > Handle_Sl_Quote_Sg__asObservable(Handle<Quote > *self){
        return boost::shared_ptr<Observable>(*self);
    }

using QuantLib::SimpleQuote;
typedef boost::shared_ptr<Quote> SimpleQuotePtr;

SWIGINTERN SimpleQuotePtr *new_SimpleQuotePtr(Real value){
            return new SimpleQuotePtr(new SimpleQuote(value));
        }
SWIGINTERN void SimpleQuotePtr_setValue(SimpleQuotePtr *self,Real value){
            boost::dynamic_pointer_cast<SimpleQuote>(*self)->setValue(value);
        }
SWIGINTERN std::vector<boost::shared_ptr<Quote > > *new_std_vector_Sl_boost_shared_ptr_Sl_Quote_Sg__Sg___SWIG_1(int capacity){
        std::vector<boost::shared_ptr<Quote> >* pv = 0;
        if (capacity >= 0) {
          pv = new std::vector<boost::shared_ptr<Quote> >();
          pv->reserve(capacity);
       } else {
          throw std::out_of_range("capacity");
       }
       return pv;
      }
SWIGINTERN boost::shared_ptr<Quote > std_vector_Sl_boost_shared_ptr_Sl_Quote_Sg__Sg__getitemcopy(std::vector<boost::shared_ptr<Quote > > *self,int index){
        if (index>=0 && index<(int)self->size())
          return (*self)[index];
        else
          throw std::out_of_range("index");
      }
SWIGINTERN std::vector<boost::shared_ptr<Quote > >::const_reference std_vector_Sl_boost_shared_ptr_Sl_Quote_Sg__Sg__getitem(std::vector<boost::shared_ptr<Quote > > *self,int index){
        if (index>=0 && index<(int)self->size())
          return (*self)[index];
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_Quote_Sg__Sg__setitem(std::vector<boost::shared_ptr<Quote > > *self,int index,std::vector<boost::shared_ptr<Quote > >::value_type const &value){
        if (index>=0 && index<(int)self->size())
          (*self)[index] = value;
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_Quote_Sg__Sg__AddRange(std::vector<boost::shared_ptr<Quote > > *self,std::vector<boost::shared_ptr<Quote > > const &values){
        self->insert(self->end(), values.begin(), values.end());
      }
SWIGINTERN std::vector<boost::shared_ptr<Quote > > *std_vector_Sl_boost_shared_ptr_Sl_Quote_Sg__Sg__GetRange(std::vector<boost::shared_ptr<Quote > > *self,int index,int count){
        if (index < 0)
          throw std::out_of_range("index");
        if (count < 0)
          throw std::out_of_range("count");
        if (index >= (int)self->size()+1 || index+count > (int)self->size())
          throw std::invalid_argument("invalid range");
        return new std::vector<boost::shared_ptr<Quote> >(self->begin()+index, self->begin()+index+count);
      }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_Quote_Sg__Sg__Insert(std::vector<boost::shared_ptr<Quote > > *self,int index,std::vector<boost::shared_ptr<Quote > >::value_type const &value){
        if (index>=0 && index<(int)self->size()+1)
          self->insert(self->begin()+index, value);
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_Quote_Sg__Sg__InsertRange(std::vector<boost::shared_ptr<Quote > > *self,int index,std::vector<boost::shared_ptr<Quote > > const &values){
        if (index>=0 && index<(int)self->size()+1)
          self->insert(self->begin()+index, values.begin(), values.end());
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_Quote_Sg__Sg__RemoveAt(std::vector<boost::shared_ptr<Quote > > *self,int index){
        if (index>=0 && index<(int)self->size())
          self->erase(self->begin() + index);
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_Quote_Sg__Sg__RemoveRange(std::vector<boost::shared_ptr<Quote > > *self,int index,int count){
        if (index < 0)
          throw std::out_of_range("index");
        if (count < 0)
          throw std::out_of_range("count");
        if (index >= (int)self->size()+1 || index+count > (int)self->size())
          throw std::invalid_argument("invalid range");
        self->erase(self->begin()+index, self->begin()+index+count);
      }
SWIGINTERN std::vector<boost::shared_ptr<Quote > > *std_vector_Sl_boost_shared_ptr_Sl_Quote_Sg__Sg__Repeat(std::vector<boost::shared_ptr<Quote > >::value_type const &value,int count){
        if (count < 0)
          throw std::out_of_range("count");
        return new std::vector<boost::shared_ptr<Quote> >(count, value);
      }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_Quote_Sg__Sg__Reverse__SWIG_0(std::vector<boost::shared_ptr<Quote > > *self){
        std::reverse(self->begin(), self->end());
      }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_Quote_Sg__Sg__Reverse__SWIG_1(std::vector<boost::shared_ptr<Quote > > *self,int index,int count){
        if (index < 0)
          throw std::out_of_range("index");
        if (count < 0)
          throw std::out_of_range("count");
        if (index >= (int)self->size()+1 || index+count > (int)self->size())
          throw std::invalid_argument("invalid range");
        std::reverse(self->begin()+index, self->begin()+index+count);
      }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_Quote_Sg__Sg__SetRange(std::vector<boost::shared_ptr<Quote > > *self,int index,std::vector<boost::shared_ptr<Quote > > const &values){
        if (index < 0)
          throw std::out_of_range("index");
        if (index+values.size() > self->size())
          throw std::out_of_range("index");
        std::copy(values.begin(), values.end(), self->begin()+index);
      }
SWIGINTERN bool std_vector_Sl_boost_shared_ptr_Sl_Quote_Sg__Sg__Contains(std::vector<boost::shared_ptr<Quote > > *self,std::vector<boost::shared_ptr<Quote > >::value_type const &value){
        return std::find(self->begin(), self->end(), value) != self->end();
      }
SWIGINTERN int std_vector_Sl_boost_shared_ptr_Sl_Quote_Sg__Sg__IndexOf(std::vector<boost::shared_ptr<Quote > > *self,std::vector<boost::shared_ptr<Quote > >::value_type const &value){
        int index = -1;
        std::vector<boost::shared_ptr<Quote> >::iterator it = std::find(self->begin(), self->end(), value);
        if (it != self->end())
          index = it - self->begin();
        return index;
      }
SWIGINTERN int std_vector_Sl_boost_shared_ptr_Sl_Quote_Sg__Sg__LastIndexOf(std::vector<boost::shared_ptr<Quote > > *self,std::vector<boost::shared_ptr<Quote > >::value_type const &value){
        int index = -1;
        std::vector<boost::shared_ptr<Quote> >::reverse_iterator rit = std::find(self->rbegin(), self->rend(), value);
        if (rit != self->rend())
          index = self->rend() - 1 - rit;
        return index;
      }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_Quote_Sg__Sg__Remove(std::vector<boost::shared_ptr<Quote > > *self,std::vector<boost::shared_ptr<Quote > >::value_type const &value){
        std::vector<boost::shared_ptr<Quote> >::iterator it = std::find(self->begin(), self->end(), value);
        if (it != self->end())
          self->erase(it);
      }
SWIGINTERN std::vector<Handle<Quote > > *new_std_vector_Sl_Handle_Sl_Quote_Sg__Sg___SWIG_1(int capacity){
        std::vector<Handle<Quote> >* pv = 0;
        if (capacity >= 0) {
          pv = new std::vector<Handle<Quote> >();
          pv->reserve(capacity);
       } else {
          throw std::out_of_range("capacity");
       }
       return pv;
      }
SWIGINTERN Handle<Quote > std_vector_Sl_Handle_Sl_Quote_Sg__Sg__getitemcopy(std::vector<Handle<Quote > > *self,int index){
        if (index>=0 && index<(int)self->size())
          return (*self)[index];
        else
          throw std::out_of_range("index");
      }
SWIGINTERN std::vector<Handle<Quote > >::const_reference std_vector_Sl_Handle_Sl_Quote_Sg__Sg__getitem(std::vector<Handle<Quote > > *self,int index){
        if (index>=0 && index<(int)self->size())
          return (*self)[index];
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_Handle_Sl_Quote_Sg__Sg__setitem(std::vector<Handle<Quote > > *self,int index,std::vector<Handle<Quote > >::value_type const &value){
        if (index>=0 && index<(int)self->size())
          (*self)[index] = value;
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_Handle_Sl_Quote_Sg__Sg__AddRange(std::vector<Handle<Quote > > *self,std::vector<Handle<Quote > > const &values){
        self->insert(self->end(), values.begin(), values.end());
      }
SWIGINTERN std::vector<Handle<Quote > > *std_vector_Sl_Handle_Sl_Quote_Sg__Sg__GetRange(std::vector<Handle<Quote > > *self,int index,int count){
        if (index < 0)
          throw std::out_of_range("index");
        if (count < 0)
          throw std::out_of_range("count");
        if (index >= (int)self->size()+1 || index+count > (int)self->size())
          throw std::invalid_argument("invalid range");
        return new std::vector<Handle<Quote> >(self->begin()+index, self->begin()+index+count);
      }
SWIGINTERN void std_vector_Sl_Handle_Sl_Quote_Sg__Sg__Insert(std::vector<Handle<Quote > > *self,int index,std::vector<Handle<Quote > >::value_type const &value){
        if (index>=0 && index<(int)self->size()+1)
          self->insert(self->begin()+index, value);
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_Handle_Sl_Quote_Sg__Sg__InsertRange(std::vector<Handle<Quote > > *self,int index,std::vector<Handle<Quote > > const &values){
        if (index>=0 && index<(int)self->size()+1)
          self->insert(self->begin()+index, values.begin(), values.end());
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_Handle_Sl_Quote_Sg__Sg__RemoveAt(std::vector<Handle<Quote > > *self,int index){
        if (index>=0 && index<(int)self->size())
          self->erase(self->begin() + index);
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_Handle_Sl_Quote_Sg__Sg__RemoveRange(std::vector<Handle<Quote > > *self,int index,int count){
        if (index < 0)
          throw std::out_of_range("index");
        if (count < 0)
          throw std::out_of_range("count");
        if (index >= (int)self->size()+1 || index+count > (int)self->size())
          throw std::invalid_argument("invalid range");
        self->erase(self->begin()+index, self->begin()+index+count);
      }
SWIGINTERN std::vector<Handle<Quote > > *std_vector_Sl_Handle_Sl_Quote_Sg__Sg__Repeat(std::vector<Handle<Quote > >::value_type const &value,int count){
        if (count < 0)
          throw std::out_of_range("count");
        return new std::vector<Handle<Quote> >(count, value);
      }
SWIGINTERN void std_vector_Sl_Handle_Sl_Quote_Sg__Sg__Reverse__SWIG_0(std::vector<Handle<Quote > > *self){
        std::reverse(self->begin(), self->end());
      }
SWIGINTERN void std_vector_Sl_Handle_Sl_Quote_Sg__Sg__Reverse__SWIG_1(std::vector<Handle<Quote > > *self,int index,int count){
        if (index < 0)
          throw std::out_of_range("index");
        if (count < 0)
          throw std::out_of_range("count");
        if (index >= (int)self->size()+1 || index+count > (int)self->size())
          throw std::invalid_argument("invalid range");
        std::reverse(self->begin()+index, self->begin()+index+count);
      }
SWIGINTERN void std_vector_Sl_Handle_Sl_Quote_Sg__Sg__SetRange(std::vector<Handle<Quote > > *self,int index,std::vector<Handle<Quote > > const &values){
        if (index < 0)
          throw std::out_of_range("index");
        if (index+values.size() > self->size())
          throw std::out_of_range("index");
        std::copy(values.begin(), values.end(), self->begin()+index);
      }
SWIGINTERN bool std_vector_Sl_Handle_Sl_Quote_Sg__Sg__Contains(std::vector<Handle<Quote > > *self,std::vector<Handle<Quote > >::value_type const &value){
        return std::find(self->begin(), self->end(), value) != self->end();
      }
SWIGINTERN int std_vector_Sl_Handle_Sl_Quote_Sg__Sg__IndexOf(std::vector<Handle<Quote > > *self,std::vector<Handle<Quote > >::value_type const &value){
        int index = -1;
        std::vector<Handle<Quote> >::iterator it = std::find(self->begin(), self->end(), value);
        if (it != self->end())
          index = it - self->begin();
        return index;
      }
SWIGINTERN int std_vector_Sl_Handle_Sl_Quote_Sg__Sg__LastIndexOf(std::vector<Handle<Quote > > *self,std::vector<Handle<Quote > >::value_type const &value){
        int index = -1;
        std::vector<Handle<Quote> >::reverse_iterator rit = std::find(self->rbegin(), self->rend(), value);
        if (rit != self->rend())
          index = self->rend() - 1 - rit;
        return index;
      }
SWIGINTERN void std_vector_Sl_Handle_Sl_Quote_Sg__Sg__Remove(std::vector<Handle<Quote > > *self,std::vector<Handle<Quote > >::value_type const &value){
        std::vector<Handle<Quote> >::iterator it = std::find(self->begin(), self->end(), value);
        if (it != self->end())
          self->erase(it);
      }

using QuantLib::Day;
using QuantLib::Year;


using QuantLib::Weekday;
using QuantLib::Sunday;
using QuantLib::Monday;
using QuantLib::Tuesday;
using QuantLib::Wednesday;
using QuantLib::Thursday;
using QuantLib::Friday;
using QuantLib::Saturday;


using QuantLib::Month;
using QuantLib::January;
using QuantLib::February;
using QuantLib::March;
using QuantLib::April;
using QuantLib::May;
using QuantLib::June;
using QuantLib::July;
using QuantLib::August;
using QuantLib::September;
using QuantLib::October;
using QuantLib::November;
using QuantLib::December;


using QuantLib::TimeUnit;
using QuantLib::Days;
using QuantLib::Weeks;
using QuantLib::Months;
using QuantLib::Years;


using QuantLib::Frequency;
using QuantLib::NoFrequency;
using QuantLib::Once;
using QuantLib::Annual;
using QuantLib::Semiannual;
using QuantLib::EveryFourthMonth;
using QuantLib::Quarterly;
using QuantLib::Bimonthly;
using QuantLib::Monthly;


using QuantLib::Period;
using QuantLib::PeriodParser;

SWIGINTERN Period *new_Period__SWIG_1(std::string const &str){
            return new Period(PeriodParser::parse(str));
        }
SWIGINTERN std::string Period___str__(Period *self){
            std::ostringstream out;
            out << *self;
            return out.str();
        }
SWIGINTERN std::string Period___repr__(Period *self){
            std::ostringstream out;
            out << "Period(\"" << QuantLib::io::short_period(*self) << "\")";
            return out.str();
        }
SWIGINTERN int Period___cmp__(Period *self,Period const &other){
            if (*self < other)
                return -1;
            if (*self == other)
                return 0;
            return 1;
        }
SWIGINTERN std::vector<Period > *new_std_vector_Sl_Period_Sg___SWIG_1(int capacity){
        std::vector<Period >* pv = 0;
        if (capacity >= 0) {
          pv = new std::vector<Period >();
          pv->reserve(capacity);
       } else {
          throw std::out_of_range("capacity");
       }
       return pv;
      }
SWIGINTERN Period std_vector_Sl_Period_Sg__getitemcopy(std::vector<Period > *self,int index){
        if (index>=0 && index<(int)self->size())
          return (*self)[index];
        else
          throw std::out_of_range("index");
      }
SWIGINTERN std::vector<Period >::const_reference std_vector_Sl_Period_Sg__getitem(std::vector<Period > *self,int index){
        if (index>=0 && index<(int)self->size())
          return (*self)[index];
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_Period_Sg__setitem(std::vector<Period > *self,int index,std::vector<Period >::value_type const &value){
        if (index>=0 && index<(int)self->size())
          (*self)[index] = value;
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_Period_Sg__AddRange(std::vector<Period > *self,std::vector<Period > const &values){
        self->insert(self->end(), values.begin(), values.end());
      }
SWIGINTERN std::vector<Period > *std_vector_Sl_Period_Sg__GetRange(std::vector<Period > *self,int index,int count){
        if (index < 0)
          throw std::out_of_range("index");
        if (count < 0)
          throw std::out_of_range("count");
        if (index >= (int)self->size()+1 || index+count > (int)self->size())
          throw std::invalid_argument("invalid range");
        return new std::vector<Period >(self->begin()+index, self->begin()+index+count);
      }
SWIGINTERN void std_vector_Sl_Period_Sg__Insert(std::vector<Period > *self,int index,std::vector<Period >::value_type const &value){
        if (index>=0 && index<(int)self->size()+1)
          self->insert(self->begin()+index, value);
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_Period_Sg__InsertRange(std::vector<Period > *self,int index,std::vector<Period > const &values){
        if (index>=0 && index<(int)self->size()+1)
          self->insert(self->begin()+index, values.begin(), values.end());
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_Period_Sg__RemoveAt(std::vector<Period > *self,int index){
        if (index>=0 && index<(int)self->size())
          self->erase(self->begin() + index);
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_Period_Sg__RemoveRange(std::vector<Period > *self,int index,int count){
        if (index < 0)
          throw std::out_of_range("index");
        if (count < 0)
          throw std::out_of_range("count");
        if (index >= (int)self->size()+1 || index+count > (int)self->size())
          throw std::invalid_argument("invalid range");
        self->erase(self->begin()+index, self->begin()+index+count);
      }
SWIGINTERN std::vector<Period > *std_vector_Sl_Period_Sg__Repeat(std::vector<Period >::value_type const &value,int count){
        if (count < 0)
          throw std::out_of_range("count");
        return new std::vector<Period >(count, value);
      }
SWIGINTERN void std_vector_Sl_Period_Sg__Reverse__SWIG_0(std::vector<Period > *self){
        std::reverse(self->begin(), self->end());
      }
SWIGINTERN void std_vector_Sl_Period_Sg__Reverse__SWIG_1(std::vector<Period > *self,int index,int count){
        if (index < 0)
          throw std::out_of_range("index");
        if (count < 0)
          throw std::out_of_range("count");
        if (index >= (int)self->size()+1 || index+count > (int)self->size())
          throw std::invalid_argument("invalid range");
        std::reverse(self->begin()+index, self->begin()+index+count);
      }
SWIGINTERN void std_vector_Sl_Period_Sg__SetRange(std::vector<Period > *self,int index,std::vector<Period > const &values){
        if (index < 0)
          throw std::out_of_range("index");
        if (index+values.size() > self->size())
          throw std::out_of_range("index");
        std::copy(values.begin(), values.end(), self->begin()+index);
      }

using QuantLib::Date;
using QuantLib::DateParser;

SWIGINTERN Date *new_Date__SWIG_3(std::string const &str,std::string const &fmt){
            return new Date(DateParser::parse(str,fmt));
        }
SWIGINTERN Integer Date_weekdayNumber(Date *self){
            return int(self->weekday());
        }
SWIGINTERN std::string Date___str__(Date *self){
            std::ostringstream out;
            out << *self;
            return out.str();
        }
SWIGINTERN std::string Date___repr__(Date *self){
            std::ostringstream out;
            out << "Date(" << self->dayOfMonth() << ","
                << int(self->month()) << "," << self->year() << ")";
            return out.str();
        }
SWIGINTERN std::string Date_ISO(Date *self){
            std::ostringstream out;
            out << QuantLib::io::iso_date(*self);
            return out.str();
        }
SWIGINTERN std::vector<Date > *new_std_vector_Sl_Date_Sg___SWIG_1(int capacity){
        std::vector<Date >* pv = 0;
        if (capacity >= 0) {
          pv = new std::vector<Date >();
          pv->reserve(capacity);
       } else {
          throw std::out_of_range("capacity");
       }
       return pv;
      }
SWIGINTERN Date std_vector_Sl_Date_Sg__getitemcopy(std::vector<Date > *self,int index){
        if (index>=0 && index<(int)self->size())
          return (*self)[index];
        else
          throw std::out_of_range("index");
      }
SWIGINTERN std::vector<Date >::const_reference std_vector_Sl_Date_Sg__getitem(std::vector<Date > *self,int index){
        if (index>=0 && index<(int)self->size())
          return (*self)[index];
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_Date_Sg__setitem(std::vector<Date > *self,int index,std::vector<Date >::value_type const &value){
        if (index>=0 && index<(int)self->size())
          (*self)[index] = value;
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_Date_Sg__AddRange(std::vector<Date > *self,std::vector<Date > const &values){
        self->insert(self->end(), values.begin(), values.end());
      }
SWIGINTERN std::vector<Date > *std_vector_Sl_Date_Sg__GetRange(std::vector<Date > *self,int index,int count){
        if (index < 0)
          throw std::out_of_range("index");
        if (count < 0)
          throw std::out_of_range("count");
        if (index >= (int)self->size()+1 || index+count > (int)self->size())
          throw std::invalid_argument("invalid range");
        return new std::vector<Date >(self->begin()+index, self->begin()+index+count);
      }
SWIGINTERN void std_vector_Sl_Date_Sg__Insert(std::vector<Date > *self,int index,std::vector<Date >::value_type const &value){
        if (index>=0 && index<(int)self->size()+1)
          self->insert(self->begin()+index, value);
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_Date_Sg__InsertRange(std::vector<Date > *self,int index,std::vector<Date > const &values){
        if (index>=0 && index<(int)self->size()+1)
          self->insert(self->begin()+index, values.begin(), values.end());
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_Date_Sg__RemoveAt(std::vector<Date > *self,int index){
        if (index>=0 && index<(int)self->size())
          self->erase(self->begin() + index);
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_Date_Sg__RemoveRange(std::vector<Date > *self,int index,int count){
        if (index < 0)
          throw std::out_of_range("index");
        if (count < 0)
          throw std::out_of_range("count");
        if (index >= (int)self->size()+1 || index+count > (int)self->size())
          throw std::invalid_argument("invalid range");
        self->erase(self->begin()+index, self->begin()+index+count);
      }
SWIGINTERN std::vector<Date > *std_vector_Sl_Date_Sg__Repeat(std::vector<Date >::value_type const &value,int count){
        if (count < 0)
          throw std::out_of_range("count");
        return new std::vector<Date >(count, value);
      }
SWIGINTERN void std_vector_Sl_Date_Sg__Reverse__SWIG_0(std::vector<Date > *self){
        std::reverse(self->begin(), self->end());
      }
SWIGINTERN void std_vector_Sl_Date_Sg__Reverse__SWIG_1(std::vector<Date > *self,int index,int count){
        if (index < 0)
          throw std::out_of_range("index");
        if (count < 0)
          throw std::out_of_range("count");
        if (index >= (int)self->size()+1 || index+count > (int)self->size())
          throw std::invalid_argument("invalid range");
        std::reverse(self->begin()+index, self->begin()+index+count);
      }
SWIGINTERN void std_vector_Sl_Date_Sg__SetRange(std::vector<Date > *self,int index,std::vector<Date > const &values){
        if (index < 0)
          throw std::out_of_range("index");
        if (index+values.size() > self->size())
          throw std::out_of_range("index");
        std::copy(values.begin(), values.end(), self->begin()+index);
      }

using QuantLib::Null;
typedef int intOrNull;
typedef double doubleOrNull;


int nullInt() { return Null<int>(); }
double nullDouble() { return Null<double>(); }


using QuantLib::DayCounter;

SWIGINTERN std::string DayCounter___str__(DayCounter *self){
            return self->name()+" day counter";
        }

using QuantLib::Compounding;
using QuantLib::Simple;
using QuantLib::Compounded;
using QuantLib::Continuous;
using QuantLib::SimpleThenCompounded;


using QuantLib::InterestRate;

SWIGINTERN std::string InterestRate___str__(InterestRate *self){
            std::ostringstream out;
            out << *self;
            return out.str();
        }

using QuantLib::Calendar;


using QuantLib::BusinessDayConvention;
using QuantLib::Unadjusted;
using QuantLib::Preceding;
using QuantLib::ModifiedPreceding;
using QuantLib::Following;
using QuantLib::ModifiedFollowing;
using QuantLib::MonthEndReference;
using QuantLib::UnadjustedMonthEnd;


using QuantLib::JointCalendarRule;
using QuantLib::JoinHolidays;
using QuantLib::JoinBusinessDays;

SWIGINTERN std::string Calendar___str__(Calendar *self){
            return self->name()+" calendar";
        }

using QuantLib::Rounding;
using QuantLib::UpRounding;
using QuantLib::DownRounding;
using QuantLib::ClosestRounding;
using QuantLib::CeilingTruncation;
using QuantLib::FloorTruncation;


using QuantLib::Currency;

SWIGINTERN std::string Currency___str__(Currency *self){
            return self->name();
        }

using QuantLib::Extrapolator;


// safe versions which copy their arguments
template <class I>
class SafeInterpolation {
  public:
    SafeInterpolation(const Array& x, const Array& y)
    : x_(x), y_(y), f_(x_.begin(),x_.end(),y_.begin()) {}
    Real operator()(Real x, bool allowExtrapolation=false) {
        return f_(x, allowExtrapolation);
    }
    Array x_, y_;
    I f_;
};


typedef SafeInterpolation<QuantLib::LinearInterpolation> SafeLinearInterpolation;


typedef SafeInterpolation<QuantLib::LogLinearInterpolation> SafeLogLinearInterpolation;


typedef SafeInterpolation<QuantLib::BackwardFlatInterpolation> SafeBackwardFlatInterpolation;


typedef SafeInterpolation<QuantLib::ForwardFlatInterpolation> SafeForwardFlatInterpolation;


typedef SafeInterpolation<QuantLib::NaturalCubicSpline> SafeNaturalCubicSpline;

SWIGINTERN Real SafeNaturalCubicSpline_derivative__SWIG_0(SafeNaturalCubicSpline *self,Real x,bool extrapolate=false){
        return self->f_.derivative(x,extrapolate);
    }
SWIGINTERN Real SafeNaturalCubicSpline_secondDerivative__SWIG_0(SafeNaturalCubicSpline *self,Real x,bool extrapolate=false){
        return self->f_.secondDerivative(x,extrapolate);
    }

typedef SafeInterpolation<QuantLib::NaturalMonotonicCubicSpline> SafeNaturalMonotonicCubicSpline;

SWIGINTERN Real SafeNaturalMonotonicCubicSpline_derivative__SWIG_0(SafeNaturalMonotonicCubicSpline *self,Real x,bool extrapolate=false){
        return self->f_.derivative(x,extrapolate);
    }
SWIGINTERN Real SafeNaturalMonotonicCubicSpline_secondDerivative__SWIG_0(SafeNaturalMonotonicCubicSpline *self,Real x,bool extrapolate=false){
        return self->f_.secondDerivative(x,extrapolate);
    }

// safe versions which copy their arguments
template <class I>
class SafeInterpolation2D {
  public:
    SafeInterpolation2D(const Array& x, const Array& y, const Matrix& m)
    : x_(x), y_(y), m_(m), f_(x_.begin(),x_.end(),y_.begin(),y_.end(),m_) {}
    Real operator()(Real x, Real y, bool allowExtrapolation=false) {
        return f_(x,y, allowExtrapolation);
    }
  protected:
    Array x_, y_;
    Matrix m_;
    I f_;
};


typedef SafeInterpolation2D<QuantLib::BilinearInterpolation> SafeBilinearInterpolation;


typedef SafeInterpolation2D<QuantLib::BicubicSpline> SafeBicubicSpline;


using QuantLib::BackwardFlat;
using QuantLib::ForwardFlat;
using QuantLib::Linear;
using QuantLib::LogLinear;
using QuantLib::Cubic;


using QuantLib::YieldTermStructure;

SWIGINTERN bool boost_shared_ptr_Sl_YieldTermStructure_Sg__isNull(boost::shared_ptr<YieldTermStructure > *self){
                return !(*self);
            }
SWIGINTERN boost::shared_ptr<Observable > boost_shared_ptr_Sl_YieldTermStructure_Sg__asObservable(boost::shared_ptr<YieldTermStructure > *self){
        return boost::shared_ptr<Observable>(*self);
    }
SWIGINTERN boost::shared_ptr<Observable > Handle_Sl_YieldTermStructure_Sg__asObservable(Handle<YieldTermStructure > *self){
        return boost::shared_ptr<Observable>(*self);
    }

using QuantLib::ImpliedTermStructure;
typedef boost::shared_ptr<YieldTermStructure> ImpliedTermStructurePtr;

SWIGINTERN ImpliedTermStructurePtr *new_ImpliedTermStructurePtr(Handle<YieldTermStructure > const &curveHandle,Date const &referenceDate){
            return new ImpliedTermStructurePtr(
                new ImpliedTermStructure(curveHandle, referenceDate));
        }

using QuantLib::ZeroSpreadedTermStructure;
using QuantLib::ForwardSpreadedTermStructure;
typedef boost::shared_ptr<YieldTermStructure> ZeroSpreadedTermStructurePtr;
typedef boost::shared_ptr<YieldTermStructure> ForwardSpreadedTermStructurePtr;

SWIGINTERN ZeroSpreadedTermStructurePtr *new_ZeroSpreadedTermStructurePtr(Handle<YieldTermStructure > const &curveHandle,Handle<Quote > const &spreadHandle){
            return new ZeroSpreadedTermStructurePtr(
                new ZeroSpreadedTermStructure(curveHandle,spreadHandle));
        }
SWIGINTERN ForwardSpreadedTermStructurePtr *new_ForwardSpreadedTermStructurePtr(Handle<YieldTermStructure > const &curveHandle,Handle<Quote > const &spreadHandle){
            return new ForwardSpreadedTermStructurePtr(
                new ForwardSpreadedTermStructure(curveHandle,spreadHandle));
        }

using QuantLib::FlatForward;
typedef boost::shared_ptr<YieldTermStructure> FlatForwardPtr;

SWIGINTERN FlatForwardPtr *new_FlatForwardPtr__SWIG_0(Date const &referenceDate,Handle<Quote > const &forward,DayCounter const &dayCounter,Compounding compounding=QuantLib::Continuous,Frequency frequency=QuantLib::Annual){
            return new FlatForwardPtr(
                           new FlatForward(referenceDate,forward,dayCounter,
                                           compounding,frequency));
        }
SWIGINTERN FlatForwardPtr *new_FlatForwardPtr__SWIG_3(Date const &referenceDate,Rate forward,DayCounter const &dayCounter,Compounding compounding=QuantLib::Continuous,Frequency frequency=QuantLib::Annual){
            return new FlatForwardPtr(
                           new FlatForward(referenceDate,forward,dayCounter,
                                           compounding,frequency));
        }
SWIGINTERN FlatForwardPtr *new_FlatForwardPtr__SWIG_6(Integer settlementDays,Calendar const &calendar,Handle<Quote > const &forward,DayCounter const &dayCounter,Compounding compounding=QuantLib::Continuous,Frequency frequency=QuantLib::Annual){
            return new FlatForwardPtr(
                 new FlatForward(settlementDays,calendar,forward,dayCounter,
                                 compounding,frequency));
        }
SWIGINTERN FlatForwardPtr *new_FlatForwardPtr__SWIG_9(Integer settlementDays,Calendar const &calendar,Rate forward,DayCounter const &dayCounter,Compounding compounding=QuantLib::Continuous,Frequency frequency=QuantLib::Annual){
            return new FlatForwardPtr(
                 new FlatForward(settlementDays,calendar,forward,dayCounter,
                                 compounding,frequency));
        }

using QuantLib::BlackModel;

SWIGINTERN bool boost_shared_ptr_Sl_BlackModel_Sg__isNull(boost::shared_ptr<BlackModel > *self){
                return !(*self);
            }
SWIGINTERN boost::shared_ptr<BlackModel > *new_boost_shared_ptr_Sl_BlackModel_Sg_(Handle<Quote > const &volatility,Handle<YieldTermStructure > const &termStructure){
        return new boost::shared_ptr<BlackModel>(
            new BlackModel(volatility,termStructure));
    }

using QuantLib::PricingEngine;

SWIGINTERN bool boost_shared_ptr_Sl_PricingEngine_Sg__isNull(boost::shared_ptr<PricingEngine > *self){
                return !(*self);
            }

using QuantLib::Instrument;

SWIGINTERN bool boost_shared_ptr_Sl_Instrument_Sg__isNull(boost::shared_ptr<Instrument > *self){
                return !(*self);
            }
SWIGINTERN boost::shared_ptr<Observable > boost_shared_ptr_Sl_Instrument_Sg__asObservable(boost::shared_ptr<Instrument > *self){
        return boost::shared_ptr<Observable>(*self);
    }

using QuantLib::Stock;
typedef boost::shared_ptr<Instrument> StockPtr;

SWIGINTERN StockPtr *new_StockPtr(Handle<Quote > const &quote){
            return new StockPtr(new Stock(quote));
        }
SWIGINTERN std::vector<int > *new_std_vector_Sl_int_Sg___SWIG_1(int capacity){
        std::vector<int >* pv = 0;
        if (capacity >= 0) {
          pv = new std::vector<int >();
          pv->reserve(capacity);
       } else {
          throw std::out_of_range("capacity");
       }
       return pv;
      }
SWIGINTERN int std_vector_Sl_int_Sg__getitemcopy(std::vector<int > *self,int index){
        if (index>=0 && index<(int)self->size())
          return (*self)[index];
        else
          throw std::out_of_range("index");
      }
SWIGINTERN std::vector<int >::const_reference std_vector_Sl_int_Sg__getitem(std::vector<int > *self,int index){
        if (index>=0 && index<(int)self->size())
          return (*self)[index];
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_int_Sg__setitem(std::vector<int > *self,int index,std::vector<int >::value_type const &value){
        if (index>=0 && index<(int)self->size())
          (*self)[index] = value;
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_int_Sg__AddRange(std::vector<int > *self,std::vector<int > const &values){
        self->insert(self->end(), values.begin(), values.end());
      }
SWIGINTERN std::vector<int > *std_vector_Sl_int_Sg__GetRange(std::vector<int > *self,int index,int count){
        if (index < 0)
          throw std::out_of_range("index");
        if (count < 0)
          throw std::out_of_range("count");
        if (index >= (int)self->size()+1 || index+count > (int)self->size())
          throw std::invalid_argument("invalid range");
        return new std::vector<int >(self->begin()+index, self->begin()+index+count);
      }
SWIGINTERN void std_vector_Sl_int_Sg__Insert(std::vector<int > *self,int index,std::vector<int >::value_type const &value){
        if (index>=0 && index<(int)self->size()+1)
          self->insert(self->begin()+index, value);
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_int_Sg__InsertRange(std::vector<int > *self,int index,std::vector<int > const &values){
        if (index>=0 && index<(int)self->size()+1)
          self->insert(self->begin()+index, values.begin(), values.end());
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_int_Sg__RemoveAt(std::vector<int > *self,int index){
        if (index>=0 && index<(int)self->size())
          self->erase(self->begin() + index);
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_int_Sg__RemoveRange(std::vector<int > *self,int index,int count){
        if (index < 0)
          throw std::out_of_range("index");
        if (count < 0)
          throw std::out_of_range("count");
        if (index >= (int)self->size()+1 || index+count > (int)self->size())
          throw std::invalid_argument("invalid range");
        self->erase(self->begin()+index, self->begin()+index+count);
      }
SWIGINTERN std::vector<int > *std_vector_Sl_int_Sg__Repeat(std::vector<int >::value_type const &value,int count){
        if (count < 0)
          throw std::out_of_range("count");
        return new std::vector<int >(count, value);
      }
SWIGINTERN void std_vector_Sl_int_Sg__Reverse__SWIG_0(std::vector<int > *self){
        std::reverse(self->begin(), self->end());
      }
SWIGINTERN void std_vector_Sl_int_Sg__Reverse__SWIG_1(std::vector<int > *self,int index,int count){
        if (index < 0)
          throw std::out_of_range("index");
        if (count < 0)
          throw std::out_of_range("count");
        if (index >= (int)self->size()+1 || index+count > (int)self->size())
          throw std::invalid_argument("invalid range");
        std::reverse(self->begin()+index, self->begin()+index+count);
      }
SWIGINTERN void std_vector_Sl_int_Sg__SetRange(std::vector<int > *self,int index,std::vector<int > const &values){
        if (index < 0)
          throw std::out_of_range("index");
        if (index+values.size() > self->size())
          throw std::out_of_range("index");
        std::copy(values.begin(), values.end(), self->begin()+index);
      }
SWIGINTERN bool std_vector_Sl_int_Sg__Contains(std::vector<int > *self,std::vector<int >::value_type const &value){
        return std::find(self->begin(), self->end(), value) != self->end();
      }
SWIGINTERN int std_vector_Sl_int_Sg__IndexOf(std::vector<int > *self,std::vector<int >::value_type const &value){
        int index = -1;
        std::vector<int >::iterator it = std::find(self->begin(), self->end(), value);
        if (it != self->end())
          index = it - self->begin();
        return index;
      }
SWIGINTERN int std_vector_Sl_int_Sg__LastIndexOf(std::vector<int > *self,std::vector<int >::value_type const &value){
        int index = -1;
        std::vector<int >::reverse_iterator rit = std::find(self->rbegin(), self->rend(), value);
        if (rit != self->rend())
          index = self->rend() - 1 - rit;
        return index;
      }
SWIGINTERN void std_vector_Sl_int_Sg__Remove(std::vector<int > *self,std::vector<int >::value_type const &value){
        std::vector<int >::iterator it = std::find(self->begin(), self->end(), value);
        if (it != self->end())
          self->erase(it);
      }
SWIGINTERN std::vector<double > *new_std_vector_Sl_double_Sg___SWIG_1(int capacity){
        std::vector<double >* pv = 0;
        if (capacity >= 0) {
          pv = new std::vector<double >();
          pv->reserve(capacity);
       } else {
          throw std::out_of_range("capacity");
       }
       return pv;
      }
SWIGINTERN double std_vector_Sl_double_Sg__getitemcopy(std::vector<double > *self,int index){
        if (index>=0 && index<(int)self->size())
          return (*self)[index];
        else
          throw std::out_of_range("index");
      }
SWIGINTERN std::vector<double >::const_reference std_vector_Sl_double_Sg__getitem(std::vector<double > *self,int index){
        if (index>=0 && index<(int)self->size())
          return (*self)[index];
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_double_Sg__setitem(std::vector<double > *self,int index,std::vector<double >::value_type const &value){
        if (index>=0 && index<(int)self->size())
          (*self)[index] = value;
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_double_Sg__AddRange(std::vector<double > *self,std::vector<double > const &values){
        self->insert(self->end(), values.begin(), values.end());
      }
SWIGINTERN std::vector<double > *std_vector_Sl_double_Sg__GetRange(std::vector<double > *self,int index,int count){
        if (index < 0)
          throw std::out_of_range("index");
        if (count < 0)
          throw std::out_of_range("count");
        if (index >= (int)self->size()+1 || index+count > (int)self->size())
          throw std::invalid_argument("invalid range");
        return new std::vector<double >(self->begin()+index, self->begin()+index+count);
      }
SWIGINTERN void std_vector_Sl_double_Sg__Insert(std::vector<double > *self,int index,std::vector<double >::value_type const &value){
        if (index>=0 && index<(int)self->size()+1)
          self->insert(self->begin()+index, value);
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_double_Sg__InsertRange(std::vector<double > *self,int index,std::vector<double > const &values){
        if (index>=0 && index<(int)self->size()+1)
          self->insert(self->begin()+index, values.begin(), values.end());
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_double_Sg__RemoveAt(std::vector<double > *self,int index){
        if (index>=0 && index<(int)self->size())
          self->erase(self->begin() + index);
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_double_Sg__RemoveRange(std::vector<double > *self,int index,int count){
        if (index < 0)
          throw std::out_of_range("index");
        if (count < 0)
          throw std::out_of_range("count");
        if (index >= (int)self->size()+1 || index+count > (int)self->size())
          throw std::invalid_argument("invalid range");
        self->erase(self->begin()+index, self->begin()+index+count);
      }
SWIGINTERN std::vector<double > *std_vector_Sl_double_Sg__Repeat(std::vector<double >::value_type const &value,int count){
        if (count < 0)
          throw std::out_of_range("count");
        return new std::vector<double >(count, value);
      }
SWIGINTERN void std_vector_Sl_double_Sg__Reverse__SWIG_0(std::vector<double > *self){
        std::reverse(self->begin(), self->end());
      }
SWIGINTERN void std_vector_Sl_double_Sg__Reverse__SWIG_1(std::vector<double > *self,int index,int count){
        if (index < 0)
          throw std::out_of_range("index");
        if (count < 0)
          throw std::out_of_range("count");
        if (index >= (int)self->size()+1 || index+count > (int)self->size())
          throw std::invalid_argument("invalid range");
        std::reverse(self->begin()+index, self->begin()+index+count);
      }
SWIGINTERN void std_vector_Sl_double_Sg__SetRange(std::vector<double > *self,int index,std::vector<double > const &values){
        if (index < 0)
          throw std::out_of_range("index");
        if (index+values.size() > self->size())
          throw std::out_of_range("index");
        std::copy(values.begin(), values.end(), self->begin()+index);
      }
SWIGINTERN bool std_vector_Sl_double_Sg__Contains(std::vector<double > *self,std::vector<double >::value_type const &value){
        return std::find(self->begin(), self->end(), value) != self->end();
      }
SWIGINTERN int std_vector_Sl_double_Sg__IndexOf(std::vector<double > *self,std::vector<double >::value_type const &value){
        int index = -1;
        std::vector<double >::iterator it = std::find(self->begin(), self->end(), value);
        if (it != self->end())
          index = it - self->begin();
        return index;
      }
SWIGINTERN int std_vector_Sl_double_Sg__LastIndexOf(std::vector<double > *self,std::vector<double >::value_type const &value){
        int index = -1;
        std::vector<double >::reverse_iterator rit = std::find(self->rbegin(), self->rend(), value);
        if (rit != self->rend())
          index = self->rend() - 1 - rit;
        return index;
      }
SWIGINTERN void std_vector_Sl_double_Sg__Remove(std::vector<double > *self,std::vector<double >::value_type const &value){
        std::vector<double >::iterator it = std::find(self->begin(), self->end(), value);
        if (it != self->end())
          self->erase(it);
      }
SWIGINTERN std::vector<std::string > *new_std_vector_Sl_std_string_Sg___SWIG_1(int capacity){
        std::vector<std::string >* pv = 0;
        if (capacity >= 0) {
          pv = new std::vector<std::string >();
          pv->reserve(capacity);
       } else {
          throw std::out_of_range("capacity");
       }
       return pv;
      }
SWIGINTERN std::string std_vector_Sl_std_string_Sg__getitemcopy(std::vector<std::string > *self,int index){
        if (index>=0 && index<(int)self->size())
          return (*self)[index];
        else
          throw std::out_of_range("index");
      }
SWIGINTERN std::vector<std::string >::const_reference std_vector_Sl_std_string_Sg__getitem(std::vector<std::string > *self,int index){
        if (index>=0 && index<(int)self->size())
          return (*self)[index];
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_std_string_Sg__setitem(std::vector<std::string > *self,int index,std::vector<std::string >::value_type const &value){
        if (index>=0 && index<(int)self->size())
          (*self)[index] = value;
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_std_string_Sg__AddRange(std::vector<std::string > *self,std::vector<std::string > const &values){
        self->insert(self->end(), values.begin(), values.end());
      }
SWIGINTERN std::vector<std::string > *std_vector_Sl_std_string_Sg__GetRange(std::vector<std::string > *self,int index,int count){
        if (index < 0)
          throw std::out_of_range("index");
        if (count < 0)
          throw std::out_of_range("count");
        if (index >= (int)self->size()+1 || index+count > (int)self->size())
          throw std::invalid_argument("invalid range");
        return new std::vector<std::string >(self->begin()+index, self->begin()+index+count);
      }
SWIGINTERN void std_vector_Sl_std_string_Sg__Insert(std::vector<std::string > *self,int index,std::vector<std::string >::value_type const &value){
        if (index>=0 && index<(int)self->size()+1)
          self->insert(self->begin()+index, value);
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_std_string_Sg__InsertRange(std::vector<std::string > *self,int index,std::vector<std::string > const &values){
        if (index>=0 && index<(int)self->size()+1)
          self->insert(self->begin()+index, values.begin(), values.end());
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_std_string_Sg__RemoveAt(std::vector<std::string > *self,int index){
        if (index>=0 && index<(int)self->size())
          self->erase(self->begin() + index);
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_std_string_Sg__RemoveRange(std::vector<std::string > *self,int index,int count){
        if (index < 0)
          throw std::out_of_range("index");
        if (count < 0)
          throw std::out_of_range("count");
        if (index >= (int)self->size()+1 || index+count > (int)self->size())
          throw std::invalid_argument("invalid range");
        self->erase(self->begin()+index, self->begin()+index+count);
      }
SWIGINTERN std::vector<std::string > *std_vector_Sl_std_string_Sg__Repeat(std::vector<std::string >::value_type const &value,int count){
        if (count < 0)
          throw std::out_of_range("count");
        return new std::vector<std::string >(count, value);
      }
SWIGINTERN void std_vector_Sl_std_string_Sg__Reverse__SWIG_0(std::vector<std::string > *self){
        std::reverse(self->begin(), self->end());
      }
SWIGINTERN void std_vector_Sl_std_string_Sg__Reverse__SWIG_1(std::vector<std::string > *self,int index,int count){
        if (index < 0)
          throw std::out_of_range("index");
        if (count < 0)
          throw std::out_of_range("count");
        if (index >= (int)self->size()+1 || index+count > (int)self->size())
          throw std::invalid_argument("invalid range");
        std::reverse(self->begin()+index, self->begin()+index+count);
      }
SWIGINTERN void std_vector_Sl_std_string_Sg__SetRange(std::vector<std::string > *self,int index,std::vector<std::string > const &values){
        if (index < 0)
          throw std::out_of_range("index");
        if (index+values.size() > self->size())
          throw std::out_of_range("index");
        std::copy(values.begin(), values.end(), self->begin()+index);
      }
SWIGINTERN bool std_vector_Sl_std_string_Sg__Contains(std::vector<std::string > *self,std::vector<std::string >::value_type const &value){
        return std::find(self->begin(), self->end(), value) != self->end();
      }
SWIGINTERN int std_vector_Sl_std_string_Sg__IndexOf(std::vector<std::string > *self,std::vector<std::string >::value_type const &value){
        int index = -1;
        std::vector<std::string >::iterator it = std::find(self->begin(), self->end(), value);
        if (it != self->end())
          index = it - self->begin();
        return index;
      }
SWIGINTERN int std_vector_Sl_std_string_Sg__LastIndexOf(std::vector<std::string > *self,std::vector<std::string >::value_type const &value){
        int index = -1;
        std::vector<std::string >::reverse_iterator rit = std::find(self->rbegin(), self->rend(), value);
        if (rit != self->rend())
          index = self->rend() - 1 - rit;
        return index;
      }
SWIGINTERN void std_vector_Sl_std_string_Sg__Remove(std::vector<std::string > *self,std::vector<std::string >::value_type const &value){
        std::vector<std::string >::iterator it = std::find(self->begin(), self->end(), value);
        if (it != self->end())
          self->erase(it);
      }
SWIGINTERN std::vector<std::pair<Date,double > > *new_std_vector_Sl_std_pair_Sl_Date_Sc_double_Sg__Sg___SWIG_1(int capacity){
        std::vector<std::pair<Date,double> >* pv = 0;
        if (capacity >= 0) {
          pv = new std::vector<std::pair<Date,double> >();
          pv->reserve(capacity);
       } else {
          throw std::out_of_range("capacity");
       }
       return pv;
      }
SWIGINTERN std::pair<Date,double > std_vector_Sl_std_pair_Sl_Date_Sc_double_Sg__Sg__getitemcopy(std::vector<std::pair<Date,double > > *self,int index){
        if (index>=0 && index<(int)self->size())
          return (*self)[index];
        else
          throw std::out_of_range("index");
      }
SWIGINTERN std::vector<std::pair<Date,double > >::const_reference std_vector_Sl_std_pair_Sl_Date_Sc_double_Sg__Sg__getitem(std::vector<std::pair<Date,double > > *self,int index){
        if (index>=0 && index<(int)self->size())
          return (*self)[index];
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_std_pair_Sl_Date_Sc_double_Sg__Sg__setitem(std::vector<std::pair<Date,double > > *self,int index,std::vector<std::pair<Date,double > >::value_type const &value){
        if (index>=0 && index<(int)self->size())
          (*self)[index] = value;
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_std_pair_Sl_Date_Sc_double_Sg__Sg__AddRange(std::vector<std::pair<Date,double > > *self,std::vector<std::pair<Date,double > > const &values){
        self->insert(self->end(), values.begin(), values.end());
      }
SWIGINTERN std::vector<std::pair<Date,double > > *std_vector_Sl_std_pair_Sl_Date_Sc_double_Sg__Sg__GetRange(std::vector<std::pair<Date,double > > *self,int index,int count){
        if (index < 0)
          throw std::out_of_range("index");
        if (count < 0)
          throw std::out_of_range("count");
        if (index >= (int)self->size()+1 || index+count > (int)self->size())
          throw std::invalid_argument("invalid range");
        return new std::vector<std::pair<Date,double> >(self->begin()+index, self->begin()+index+count);
      }
SWIGINTERN void std_vector_Sl_std_pair_Sl_Date_Sc_double_Sg__Sg__Insert(std::vector<std::pair<Date,double > > *self,int index,std::vector<std::pair<Date,double > >::value_type const &value){
        if (index>=0 && index<(int)self->size()+1)
          self->insert(self->begin()+index, value);
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_std_pair_Sl_Date_Sc_double_Sg__Sg__InsertRange(std::vector<std::pair<Date,double > > *self,int index,std::vector<std::pair<Date,double > > const &values){
        if (index>=0 && index<(int)self->size()+1)
          self->insert(self->begin()+index, values.begin(), values.end());
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_std_pair_Sl_Date_Sc_double_Sg__Sg__RemoveAt(std::vector<std::pair<Date,double > > *self,int index){
        if (index>=0 && index<(int)self->size())
          self->erase(self->begin() + index);
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_std_pair_Sl_Date_Sc_double_Sg__Sg__RemoveRange(std::vector<std::pair<Date,double > > *self,int index,int count){
        if (index < 0)
          throw std::out_of_range("index");
        if (count < 0)
          throw std::out_of_range("count");
        if (index >= (int)self->size()+1 || index+count > (int)self->size())
          throw std::invalid_argument("invalid range");
        self->erase(self->begin()+index, self->begin()+index+count);
      }
SWIGINTERN std::vector<std::pair<Date,double > > *std_vector_Sl_std_pair_Sl_Date_Sc_double_Sg__Sg__Repeat(std::vector<std::pair<Date,double > >::value_type const &value,int count){
        if (count < 0)
          throw std::out_of_range("count");
        return new std::vector<std::pair<Date,double> >(count, value);
      }
SWIGINTERN void std_vector_Sl_std_pair_Sl_Date_Sc_double_Sg__Sg__Reverse__SWIG_0(std::vector<std::pair<Date,double > > *self){
        std::reverse(self->begin(), self->end());
      }
SWIGINTERN void std_vector_Sl_std_pair_Sl_Date_Sc_double_Sg__Sg__Reverse__SWIG_1(std::vector<std::pair<Date,double > > *self,int index,int count){
        if (index < 0)
          throw std::out_of_range("index");
        if (count < 0)
          throw std::out_of_range("count");
        if (index >= (int)self->size()+1 || index+count > (int)self->size())
          throw std::invalid_argument("invalid range");
        std::reverse(self->begin()+index, self->begin()+index+count);
      }
SWIGINTERN void std_vector_Sl_std_pair_Sl_Date_Sc_double_Sg__Sg__SetRange(std::vector<std::pair<Date,double > > *self,int index,std::vector<std::pair<Date,double > > const &values){
        if (index < 0)
          throw std::out_of_range("index");
        if (index+values.size() > self->size())
          throw std::out_of_range("index");
        std::copy(values.begin(), values.end(), self->begin()+index);
      }
SWIGINTERN bool std_vector_Sl_std_pair_Sl_Date_Sc_double_Sg__Sg__Contains(std::vector<std::pair<Date,double > > *self,std::vector<std::pair<Date,double > >::value_type const &value){
        return std::find(self->begin(), self->end(), value) != self->end();
      }
SWIGINTERN int std_vector_Sl_std_pair_Sl_Date_Sc_double_Sg__Sg__IndexOf(std::vector<std::pair<Date,double > > *self,std::vector<std::pair<Date,double > >::value_type const &value){
        int index = -1;
        std::vector<std::pair<Date,double> >::iterator it = std::find(self->begin(), self->end(), value);
        if (it != self->end())
          index = it - self->begin();
        return index;
      }
SWIGINTERN int std_vector_Sl_std_pair_Sl_Date_Sc_double_Sg__Sg__LastIndexOf(std::vector<std::pair<Date,double > > *self,std::vector<std::pair<Date,double > >::value_type const &value){
        int index = -1;
        std::vector<std::pair<Date,double> >::reverse_iterator rit = std::find(self->rbegin(), self->rend(), value);
        if (rit != self->rend())
          index = self->rend() - 1 - rit;
        return index;
      }
SWIGINTERN void std_vector_Sl_std_pair_Sl_Date_Sc_double_Sg__Sg__Remove(std::vector<std::pair<Date,double > > *self,std::vector<std::pair<Date,double > >::value_type const &value){
        std::vector<std::pair<Date,double> >::iterator it = std::find(self->begin(), self->end(), value);
        if (it != self->end())
          self->erase(it);
      }

using QuantLib::History;
typedef History::Entry HistoryEntry;

SWIGINTERN Size History___len__(History *self){
            return self->size();
        }

using QuantLib::IndexManager;


using QuantLib::Index;

SWIGINTERN bool boost_shared_ptr_Sl_Index_Sg__isNull(boost::shared_ptr<Index > *self){
                return !(*self);
            }
SWIGINTERN void boost_shared_ptr_Sl_Index_Sg__addFixings(boost::shared_ptr<Index > *self,std::vector<Date > const &fixingDates,std::vector<Rate > const &fixings){
            (*self)->addFixings(fixingDates.begin(),fixingDates.end(),
                                fixings.begin());
        }
SWIGINTERN std::string boost_shared_ptr_Sl_Index_Sg____str__(boost::shared_ptr<Index > *self){
        if (*self)
            return (*self)->name()+" index";
        else
            return "Null index";
    }

using QuantLib::Xibor;
typedef boost::shared_ptr<Index> XiborPtr;

SWIGINTERN XiborPtr *new_XiborPtr(std::string const &familyName,Integer n,TimeUnit units,Integer settlementDays,Currency const &currency,Calendar const &calendar,BusinessDayConvention convention,DayCounter const &dayCounter,Handle<YieldTermStructure > const &h){
            return new XiborPtr(new Xibor(familyName, n, units, settlementDays,
                                          currency, calendar, convention,
                                          dayCounter, h));
        }
SWIGINTERN Period XiborPtr_tenor(XiborPtr *self){
            return boost::dynamic_pointer_cast<Xibor>(*self)->tenor();
        }
SWIGINTERN Frequency XiborPtr_frequency(XiborPtr *self){
            return boost::dynamic_pointer_cast<Xibor>(*self)->frequency();
        }
SWIGINTERN Currency XiborPtr_currency(XiborPtr *self){
            return boost::dynamic_pointer_cast<Xibor>(*self)->currency();
        }
SWIGINTERN Calendar XiborPtr_calendar(XiborPtr *self){
            return boost::dynamic_pointer_cast<Xibor>(*self)->calendar();
        }
SWIGINTERN bool XiborPtr_isAdjusted(XiborPtr *self){
            return boost::dynamic_pointer_cast<Xibor>(*self)->isAdjusted();
        }
SWIGINTERN BusinessDayConvention XiborPtr_businessDayConvention(XiborPtr *self){
            return boost::dynamic_pointer_cast<Xibor>(*self)
                 ->businessDayConvention();
        }
SWIGINTERN DayCounter XiborPtr_dayCounter(XiborPtr *self){
            return boost::dynamic_pointer_cast<Xibor>(*self)->dayCounter();
        }

using QuantLib::AUDLibor;
typedef boost::shared_ptr<Index> AUDLiborPtr;

SWIGINTERN AUDLiborPtr *new_AUDLiborPtr__SWIG_0(Integer n,TimeUnit units,Handle<YieldTermStructure > const &h,DayCounter const &dayCount=QuantLib::Actual360()){
          return new AUDLiborPtr(new AUDLibor(n,units,h,dayCount));
      }

using QuantLib::CADLibor;
typedef boost::shared_ptr<Index> CADLiborPtr;

SWIGINTERN CADLiborPtr *new_CADLiborPtr__SWIG_0(Integer n,TimeUnit units,Handle<YieldTermStructure > const &h,DayCounter const &dayCount=QuantLib::Actual360()){
          return new CADLiborPtr(new CADLibor(n,units,h,dayCount));
      }

using QuantLib::Cdor;
typedef boost::shared_ptr<Index> CdorPtr;

SWIGINTERN CdorPtr *new_CdorPtr__SWIG_0(Integer n,TimeUnit units,Handle<YieldTermStructure > const &h,DayCounter const &dayCount=QuantLib::Actual360()){
          return new CdorPtr(new Cdor(n,units,h,dayCount));
      }

using QuantLib::CHFLibor;
typedef boost::shared_ptr<Index> CHFLiborPtr;

SWIGINTERN CHFLiborPtr *new_CHFLiborPtr__SWIG_0(Integer n,TimeUnit units,Handle<YieldTermStructure > const &h,DayCounter const &dayCount=QuantLib::Actual360()){
          return new CHFLiborPtr(new CHFLibor(n,units,h,dayCount));
      }

using QuantLib::Euribor;
typedef boost::shared_ptr<Index> EuriborPtr;

SWIGINTERN EuriborPtr *new_EuriborPtr__SWIG_0(Integer n,TimeUnit units,Handle<YieldTermStructure > const &h,DayCounter const &dayCount=QuantLib::Actual360()){
          return new EuriborPtr(new Euribor(n,units,h,dayCount));
      }

using QuantLib::GBPLibor;
typedef boost::shared_ptr<Index> GBPLiborPtr;

SWIGINTERN GBPLiborPtr *new_GBPLiborPtr__SWIG_0(Integer n,TimeUnit units,Handle<YieldTermStructure > const &h,DayCounter const &dayCount=QuantLib::Actual365Fixed()){
          return new GBPLiborPtr(new GBPLibor(n,units,h,dayCount));
      }

using QuantLib::Jibar;
typedef boost::shared_ptr<Index> JibarPtr;

SWIGINTERN JibarPtr *new_JibarPtr__SWIG_0(Integer n,TimeUnit units,Handle<YieldTermStructure > const &h,DayCounter const &dayCount=QuantLib::Actual365Fixed()){
          return new JibarPtr(new Jibar(n,units,h,dayCount));
      }

using QuantLib::JPYLibor;
typedef boost::shared_ptr<Index> JPYLiborPtr;

SWIGINTERN JPYLiborPtr *new_JPYLiborPtr__SWIG_0(Integer n,TimeUnit units,Handle<YieldTermStructure > const &h,DayCounter const &dayCount=QuantLib::Actual360()){
          return new JPYLiborPtr(new JPYLibor(n,units,h,dayCount));
      }

using QuantLib::Tibor;
typedef boost::shared_ptr<Index> TiborPtr;

SWIGINTERN TiborPtr *new_TiborPtr__SWIG_0(Integer n,TimeUnit units,Handle<YieldTermStructure > const &h,DayCounter const &dayCount=QuantLib::Actual365Fixed()){
          return new TiborPtr(new Tibor(n,units,h,dayCount));
      }

using QuantLib::TRLibor;
typedef boost::shared_ptr<Index> TRLiborPtr;

SWIGINTERN TRLiborPtr *new_TRLiborPtr__SWIG_0(Integer n,TimeUnit units,Handle<YieldTermStructure > const &h,DayCounter const &dayCount=QuantLib::Actual360()){
          return new TRLiborPtr(new TRLibor(n,units,h,dayCount));
      }

using QuantLib::USDLibor;
typedef boost::shared_ptr<Index> USDLiborPtr;

SWIGINTERN USDLiborPtr *new_USDLiborPtr__SWIG_0(Integer n,TimeUnit units,Handle<YieldTermStructure > const &h,DayCounter const &dayCount=QuantLib::Actual360()){
          return new USDLiborPtr(new USDLibor(n,units,h,dayCount));
      }

using QuantLib::Zibor;
typedef boost::shared_ptr<Index> ZiborPtr;

SWIGINTERN ZiborPtr *new_ZiborPtr__SWIG_0(Integer n,TimeUnit units,Handle<YieldTermStructure > const &h,DayCounter const &dayCount=QuantLib::Actual360()){
          return new ZiborPtr(new Zibor(n,units,h,dayCount));
      }

using QuantLib::Schedule;


using QuantLib::BlackVolTermStructure;
using QuantLib::LocalVolTermStructure;
using QuantLib::CapletVolatilityStructure;

SWIGINTERN bool boost_shared_ptr_Sl_BlackVolTermStructure_Sg__isNull(boost::shared_ptr<BlackVolTermStructure > *self){
                return !(*self);
            }
SWIGINTERN boost::shared_ptr<Observable > boost_shared_ptr_Sl_BlackVolTermStructure_Sg__asObservable(boost::shared_ptr<BlackVolTermStructure > *self){
        return boost::shared_ptr<Observable>(*self);
    }
SWIGINTERN boost::shared_ptr<Observable > Handle_Sl_BlackVolTermStructure_Sg__asObservable(Handle<BlackVolTermStructure > *self){
        return boost::shared_ptr<Observable>(*self);
    }
SWIGINTERN bool boost_shared_ptr_Sl_LocalVolTermStructure_Sg__isNull(boost::shared_ptr<LocalVolTermStructure > *self){
                return !(*self);
            }
SWIGINTERN boost::shared_ptr<Observable > boost_shared_ptr_Sl_LocalVolTermStructure_Sg__asObservable(boost::shared_ptr<LocalVolTermStructure > *self){
        return boost::shared_ptr<Observable>(*self);
    }
SWIGINTERN boost::shared_ptr<Observable > Handle_Sl_LocalVolTermStructure_Sg__asObservable(Handle<LocalVolTermStructure > *self){
        return boost::shared_ptr<Observable>(*self);
    }
SWIGINTERN bool boost_shared_ptr_Sl_CapletVolatilityStructure_Sg__isNull(boost::shared_ptr<CapletVolatilityStructure > *self){
                return !(*self);
            }
SWIGINTERN boost::shared_ptr<Observable > boost_shared_ptr_Sl_CapletVolatilityStructure_Sg__asObservable(boost::shared_ptr<CapletVolatilityStructure > *self){
        return boost::shared_ptr<Observable>(*self);
    }
SWIGINTERN boost::shared_ptr<Observable > Handle_Sl_CapletVolatilityStructure_Sg__asObservable(Handle<CapletVolatilityStructure > *self){
        return boost::shared_ptr<Observable>(*self);
    }

using QuantLib::BlackConstantVol;
typedef boost::shared_ptr<BlackVolTermStructure> BlackConstantVolPtr;

SWIGINTERN BlackConstantVolPtr *new_BlackConstantVolPtr__SWIG_0(Date const &referenceDate,Volatility volatility,DayCounter const &dayCounter){
            return new BlackConstantVolPtr(
                new BlackConstantVol(referenceDate, volatility, dayCounter));
        }
SWIGINTERN BlackConstantVolPtr *new_BlackConstantVolPtr__SWIG_1(Date const &referenceDate,Handle<Quote > const &volatility,DayCounter const &dayCounter){
            return new BlackConstantVolPtr(
                new BlackConstantVol(referenceDate, volatility, dayCounter));
        }
SWIGINTERN BlackConstantVolPtr *new_BlackConstantVolPtr__SWIG_2(Integer settlementDays,Calendar const &calendar,Volatility volatility,DayCounter const &dayCounter){
            return new BlackConstantVolPtr(
                new BlackConstantVol(settlementDays, calendar,
                                     volatility, dayCounter));
        }
SWIGINTERN BlackConstantVolPtr *new_BlackConstantVolPtr__SWIG_3(Integer settlementDays,Calendar const &calendar,Handle<Quote > const &volatility,DayCounter const &dayCounter){
            return new BlackConstantVolPtr(
                new BlackConstantVol(settlementDays, calendar,
                                     volatility, dayCounter));
        }

using QuantLib::BlackVarianceSurface;
typedef boost::shared_ptr<BlackVolTermStructure> BlackVarianceSurfacePtr;

SWIGINTERN BlackVarianceSurfacePtr *new_BlackVarianceSurfacePtr__SWIG_0(Date const &referenceDate,std::vector<Date > const &dates,std::vector<Real > const &strikes,Matrix const &blackVols,DayCounter const &dayCounter,BlackVarianceSurface::Extrapolation lower=BlackVarianceSurface::InterpolatorDefaultExtrapolation,BlackVarianceSurface::Extrapolation upper=BlackVarianceSurface::InterpolatorDefaultExtrapolation){
            return new BlackVarianceSurfacePtr(
                new BlackVarianceSurface(referenceDate,dates,strikes,
                                         blackVols,dayCounter,lower,upper));
        }

using QuantLib::LocalConstantVol;
typedef boost::shared_ptr<LocalVolTermStructure> LocalConstantVolPtr;

SWIGINTERN LocalConstantVolPtr *new_LocalConstantVolPtr__SWIG_0(Date const &referenceDate,Volatility volatility,DayCounter const &dayCounter){
            return new LocalConstantVolPtr(
                new LocalConstantVol(referenceDate, volatility, dayCounter));
        }
SWIGINTERN LocalConstantVolPtr *new_LocalConstantVolPtr__SWIG_1(Date const &referenceDate,Handle<Quote > const &volatility,DayCounter const &dayCounter){
            return new LocalConstantVolPtr(
                new LocalConstantVol(referenceDate, volatility, dayCounter));
        }
SWIGINTERN LocalConstantVolPtr *new_LocalConstantVolPtr__SWIG_2(Integer settlementDays,Calendar const &calendar,Volatility volatility,DayCounter const &dayCounter){
            return new LocalConstantVolPtr(
                new LocalConstantVol(settlementDays, calendar,
                                     volatility, dayCounter));
        }
SWIGINTERN LocalConstantVolPtr *new_LocalConstantVolPtr__SWIG_3(Integer settlementDays,Calendar const &calendar,Handle<Quote > const &volatility,DayCounter const &dayCounter){
            return new LocalConstantVolPtr(
                new LocalConstantVol(settlementDays, calendar,
                                     volatility, dayCounter));
        }

using QuantLib::CapletConstantVolatility;
typedef boost::shared_ptr<CapletVolatilityStructure> CapletConstantVolatilityPtr;

SWIGINTERN CapletConstantVolatilityPtr *new_CapletConstantVolatilityPtr__SWIG_0(Date const &referenceDate,Volatility volatility,DayCounter const &dayCounter){
            return new CapletConstantVolatilityPtr(
                new CapletConstantVolatility(referenceDate, volatility, dayCounter));
        }
SWIGINTERN CapletConstantVolatilityPtr *new_CapletConstantVolatilityPtr__SWIG_1(Date const &referenceDate,Handle<Quote > const &volatility,DayCounter const &dayCounter){
            return new CapletConstantVolatilityPtr(
                new CapletConstantVolatility(referenceDate, volatility, dayCounter));
        }
SWIGINTERN CapletConstantVolatilityPtr *new_CapletConstantVolatilityPtr__SWIG_2(Integer settlementDays,Calendar const &calendar,Volatility volatility,DayCounter const &dayCounter){
            return new CapletConstantVolatilityPtr(
                new CapletConstantVolatility(settlementDays, calendar,
                                     volatility, dayCounter));
        }
SWIGINTERN CapletConstantVolatilityPtr *new_CapletConstantVolatilityPtr__SWIG_3(Integer settlementDays,Calendar const &calendar,Handle<Quote > const &volatility,DayCounter const &dayCounter){
            return new CapletConstantVolatilityPtr(
                new CapletConstantVolatility(settlementDays, calendar,
                                     volatility, dayCounter));
        }

using QuantLib::CashFlow;

SWIGINTERN bool boost_shared_ptr_Sl_CashFlow_Sg__isNull(boost::shared_ptr<CashFlow > *self){
                return !(*self);
            }
SWIGINTERN boost::shared_ptr<Observable > boost_shared_ptr_Sl_CashFlow_Sg__asObservable(boost::shared_ptr<CashFlow > *self){
        return boost::shared_ptr<Observable>(*self);
    }

using QuantLib::SimpleCashFlow;
using QuantLib::FixedRateCoupon;
using QuantLib::ParCoupon;
using QuantLib::FloatingRateCoupon;
using QuantLib::IndexedCoupon;
using QuantLib::UpFrontIndexedCoupon;
using QuantLib::InArrearIndexedCoupon;

using QuantLib::IndexedCouponVector;

typedef boost::shared_ptr<CashFlow> SimpleCashFlowPtr;
typedef boost::shared_ptr<CashFlow> FixedRateCouponPtr;
typedef boost::shared_ptr<CashFlow> ParCouponPtr;
typedef boost::shared_ptr<CashFlow> FloatingRateCouponPtr;
typedef boost::shared_ptr<CashFlow> IndexedCouponPtr;
typedef boost::shared_ptr<CashFlow> UpFrontIndexedCouponPtr;
typedef boost::shared_ptr<CashFlow> InArrearIndexedCouponPtr;

SWIGINTERN SimpleCashFlowPtr *new_SimpleCashFlowPtr(Real amount,Date const &date){
            return new SimpleCashFlowPtr(new SimpleCashFlow(amount,date));
        }
SWIGINTERN FixedRateCouponPtr *new_FixedRateCouponPtr__SWIG_0(Real nominal,Date const &paymentDate,Rate rate,DayCounter const &dayCounter,Date const &startDate,Date const &endDate,Date const &refPeriodStart=Date(),Date const &refPeriodEnd=Date()){
            return new FixedRateCouponPtr(
                new FixedRateCoupon(nominal, paymentDate, rate,
                                    dayCounter, startDate, endDate,
                                    refPeriodStart, refPeriodEnd));
        }
SWIGINTERN ParCouponPtr *new_ParCouponPtr__SWIG_0(Real nominal,Date const &paymentDate,XiborPtr const &index,Date const &startDate,Date const &endDate,Integer fixingDays,Spread spread=0.0,Date const &refPeriodStart=Date(),Date const &refPeriodEnd=Date()){
            boost::shared_ptr<Xibor> libor =
                boost::dynamic_pointer_cast<Xibor>(index);
            return new ParCouponPtr(
                new ParCoupon(nominal, paymentDate, libor,
                              startDate, endDate, fixingDays, spread,
                              refPeriodStart, refPeriodEnd));
        }
SWIGINTERN Date ParCouponPtr_accrualStartDate(ParCouponPtr *self){
            return boost::dynamic_pointer_cast<ParCoupon>(*self)
                 ->accrualStartDate();
        }
SWIGINTERN Date ParCouponPtr_accrualEndDate(ParCouponPtr *self){
            return boost::dynamic_pointer_cast<ParCoupon>(*self)
                 ->accrualEndDate();
        }
SWIGINTERN Rate ParCouponPtr_rate(ParCouponPtr *self){
            return boost::dynamic_pointer_cast<ParCoupon>(*self)->rate();
        }
SWIGINTERN Rate ParCouponPtr_indexFixing(ParCouponPtr *self){
            return boost::dynamic_pointer_cast<ParCoupon>(*self)
                ->indexFixing();
        }
SWIGINTERN Real ParCouponPtr_nominal(ParCouponPtr *self){
            return boost::dynamic_pointer_cast<ParCoupon>(*self)->nominal();
        }
SWIGINTERN Rate FloatingRateCouponPtr_rate(FloatingRateCouponPtr *self){
            return boost::dynamic_pointer_cast<FloatingRateCoupon>(*self)->rate();
        }
SWIGINTERN Integer FloatingRateCouponPtr_fixingDays(FloatingRateCouponPtr *self){
            return boost::dynamic_pointer_cast<FloatingRateCoupon>(*self)
                ->fixingDays();
    }
SWIGINTERN Rate FloatingRateCouponPtr_spread(FloatingRateCouponPtr *self){
            return boost::dynamic_pointer_cast<FloatingRateCoupon>(*self)
                ->spread();
        }
SWIGINTERN Rate FloatingRateCouponPtr_indexFixing(FloatingRateCouponPtr *self){
            return boost::dynamic_pointer_cast<FloatingRateCoupon>(*self)
                ->indexFixing();
        }
SWIGINTERN Date FloatingRateCouponPtr_fixingDate(FloatingRateCouponPtr *self){
            return boost::dynamic_pointer_cast<FloatingRateCoupon>(*self)
                ->fixingDate();
        }
SWIGINTERN UpFrontIndexedCouponPtr *new_UpFrontIndexedCouponPtr__SWIG_0(Real nominal,Date const &paymentDate,XiborPtr const &index,Date const &startDate,Date const &endDate,Integer fixingDays,Spread spread=0.0,Date const &refPeriodStart=Date(),Date const &refPeriodEnd=Date(),DayCounter const &dayCounter=DayCounter()){
            boost::shared_ptr<Xibor> libor =
                boost::dynamic_pointer_cast<Xibor>(index);
            return new UpFrontIndexedCouponPtr(
                new UpFrontIndexedCoupon(nominal, paymentDate, libor,
                                         startDate, endDate,
                                         fixingDays, spread,
                                         refPeriodStart, refPeriodEnd,
                                         dayCounter));
        }
SWIGINTERN InArrearIndexedCouponPtr *new_InArrearIndexedCouponPtr__SWIG_0(Real nominal,Date const &paymentDate,XiborPtr const &index,Date const &startDate,Date const &endDate,Integer fixingDays,Spread spread=0.0,Date const &refPeriodStart=Date(),Date const &refPeriodEnd=Date(),DayCounter const &dayCounter=DayCounter()){
            boost::shared_ptr<Xibor> libor =
                boost::dynamic_pointer_cast<Xibor>(index);
            return new InArrearIndexedCouponPtr(
                new InArrearIndexedCoupon(nominal, paymentDate, libor,
                                          startDate, endDate,
                                          fixingDays, spread,
                                          refPeriodStart, refPeriodEnd,
                                          dayCounter));
        }
SWIGINTERN void InArrearIndexedCouponPtr_setCapletVolatility(InArrearIndexedCouponPtr *self,Handle<CapletVolatilityStructure > const &c){
            boost::dynamic_pointer_cast<InArrearIndexedCoupon>(*self)
                ->setCapletVolatility(c);
        }
SWIGINTERN std::vector<boost::shared_ptr<CashFlow > > *new_std_vector_Sl_boost_shared_ptr_Sl_CashFlow_Sg__Sg___SWIG_1(int capacity){
        std::vector<boost::shared_ptr<CashFlow> >* pv = 0;
        if (capacity >= 0) {
          pv = new std::vector<boost::shared_ptr<CashFlow> >();
          pv->reserve(capacity);
       } else {
          throw std::out_of_range("capacity");
       }
       return pv;
      }
SWIGINTERN boost::shared_ptr<CashFlow > std_vector_Sl_boost_shared_ptr_Sl_CashFlow_Sg__Sg__getitemcopy(std::vector<boost::shared_ptr<CashFlow > > *self,int index){
        if (index>=0 && index<(int)self->size())
          return (*self)[index];
        else
          throw std::out_of_range("index");
      }
SWIGINTERN std::vector<boost::shared_ptr<CashFlow > >::const_reference std_vector_Sl_boost_shared_ptr_Sl_CashFlow_Sg__Sg__getitem(std::vector<boost::shared_ptr<CashFlow > > *self,int index){
        if (index>=0 && index<(int)self->size())
          return (*self)[index];
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_CashFlow_Sg__Sg__setitem(std::vector<boost::shared_ptr<CashFlow > > *self,int index,std::vector<boost::shared_ptr<CashFlow > >::value_type const &value){
        if (index>=0 && index<(int)self->size())
          (*self)[index] = value;
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_CashFlow_Sg__Sg__AddRange(std::vector<boost::shared_ptr<CashFlow > > *self,std::vector<boost::shared_ptr<CashFlow > > const &values){
        self->insert(self->end(), values.begin(), values.end());
      }
SWIGINTERN std::vector<boost::shared_ptr<CashFlow > > *std_vector_Sl_boost_shared_ptr_Sl_CashFlow_Sg__Sg__GetRange(std::vector<boost::shared_ptr<CashFlow > > *self,int index,int count){
        if (index < 0)
          throw std::out_of_range("index");
        if (count < 0)
          throw std::out_of_range("count");
        if (index >= (int)self->size()+1 || index+count > (int)self->size())
          throw std::invalid_argument("invalid range");
        return new std::vector<boost::shared_ptr<CashFlow> >(self->begin()+index, self->begin()+index+count);
      }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_CashFlow_Sg__Sg__Insert(std::vector<boost::shared_ptr<CashFlow > > *self,int index,std::vector<boost::shared_ptr<CashFlow > >::value_type const &value){
        if (index>=0 && index<(int)self->size()+1)
          self->insert(self->begin()+index, value);
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_CashFlow_Sg__Sg__InsertRange(std::vector<boost::shared_ptr<CashFlow > > *self,int index,std::vector<boost::shared_ptr<CashFlow > > const &values){
        if (index>=0 && index<(int)self->size()+1)
          self->insert(self->begin()+index, values.begin(), values.end());
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_CashFlow_Sg__Sg__RemoveAt(std::vector<boost::shared_ptr<CashFlow > > *self,int index){
        if (index>=0 && index<(int)self->size())
          self->erase(self->begin() + index);
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_CashFlow_Sg__Sg__RemoveRange(std::vector<boost::shared_ptr<CashFlow > > *self,int index,int count){
        if (index < 0)
          throw std::out_of_range("index");
        if (count < 0)
          throw std::out_of_range("count");
        if (index >= (int)self->size()+1 || index+count > (int)self->size())
          throw std::invalid_argument("invalid range");
        self->erase(self->begin()+index, self->begin()+index+count);
      }
SWIGINTERN std::vector<boost::shared_ptr<CashFlow > > *std_vector_Sl_boost_shared_ptr_Sl_CashFlow_Sg__Sg__Repeat(std::vector<boost::shared_ptr<CashFlow > >::value_type const &value,int count){
        if (count < 0)
          throw std::out_of_range("count");
        return new std::vector<boost::shared_ptr<CashFlow> >(count, value);
      }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_CashFlow_Sg__Sg__Reverse__SWIG_0(std::vector<boost::shared_ptr<CashFlow > > *self){
        std::reverse(self->begin(), self->end());
      }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_CashFlow_Sg__Sg__Reverse__SWIG_1(std::vector<boost::shared_ptr<CashFlow > > *self,int index,int count){
        if (index < 0)
          throw std::out_of_range("index");
        if (count < 0)
          throw std::out_of_range("count");
        if (index >= (int)self->size()+1 || index+count > (int)self->size())
          throw std::invalid_argument("invalid range");
        std::reverse(self->begin()+index, self->begin()+index+count);
      }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_CashFlow_Sg__Sg__SetRange(std::vector<boost::shared_ptr<CashFlow > > *self,int index,std::vector<boost::shared_ptr<CashFlow > > const &values){
        if (index < 0)
          throw std::out_of_range("index");
        if (index+values.size() > self->size())
          throw std::out_of_range("index");
        std::copy(values.begin(), values.end(), self->begin()+index);
      }
SWIGINTERN bool std_vector_Sl_boost_shared_ptr_Sl_CashFlow_Sg__Sg__Contains(std::vector<boost::shared_ptr<CashFlow > > *self,std::vector<boost::shared_ptr<CashFlow > >::value_type const &value){
        return std::find(self->begin(), self->end(), value) != self->end();
      }
SWIGINTERN int std_vector_Sl_boost_shared_ptr_Sl_CashFlow_Sg__Sg__IndexOf(std::vector<boost::shared_ptr<CashFlow > > *self,std::vector<boost::shared_ptr<CashFlow > >::value_type const &value){
        int index = -1;
        std::vector<boost::shared_ptr<CashFlow> >::iterator it = std::find(self->begin(), self->end(), value);
        if (it != self->end())
          index = it - self->begin();
        return index;
      }
SWIGINTERN int std_vector_Sl_boost_shared_ptr_Sl_CashFlow_Sg__Sg__LastIndexOf(std::vector<boost::shared_ptr<CashFlow > > *self,std::vector<boost::shared_ptr<CashFlow > >::value_type const &value){
        int index = -1;
        std::vector<boost::shared_ptr<CashFlow> >::reverse_iterator rit = std::find(self->rbegin(), self->rend(), value);
        if (rit != self->rend())
          index = self->rend() - 1 - rit;
        return index;
      }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_CashFlow_Sg__Sg__Remove(std::vector<boost::shared_ptr<CashFlow > > *self,std::vector<boost::shared_ptr<CashFlow > >::value_type const &value){
        std::vector<boost::shared_ptr<CashFlow> >::iterator it = std::find(self->begin(), self->end(), value);
        if (it != self->end())
          self->erase(it);
      }

using QuantLib::FixedRateCouponVector;


std::vector<boost::shared_ptr<CashFlow> >
FloatingRateCouponVector(const Schedule& schedule,
                         BusinessDayConvention paymentAdjustment,
                         const std::vector<Real>& nominals,
                         const XiborPtr& index, Integer fixingDays,
                         const std::vector<Spread>& spreads =
                             std::vector<Spread>()) {
    boost::shared_ptr<Xibor> libor =
        boost::dynamic_pointer_cast<Xibor>(index);
    return QuantLib::FloatingRateCouponVector(schedule,paymentAdjustment,
                                              nominals,libor,
                                              fixingDays,spreads);
}

std::vector<boost::shared_ptr<CashFlow> >
ParCouponVector(const Schedule& schedule,
                BusinessDayConvention paymentAdjustment,
                const std::vector<Real>& nominals,
                const XiborPtr& index, Integer fixingDays,
                const std::vector<Spread>& spreads = std::vector<Spread>()) {
    boost::shared_ptr<Xibor> libor =
        boost::dynamic_pointer_cast<Xibor>(index);
    return QuantLib::IndexedCouponVector<ParCoupon>(schedule,paymentAdjustment,
                                                    nominals,libor,
                                                    fixingDays,spreads);
}

std::vector<boost::shared_ptr<CashFlow> >
InArrearIndexedCouponVector(const Schedule& schedule,
                            BusinessDayConvention paymentAdjustment,
                            const std::vector<Real>& nominals,
                            const XiborPtr& index, Integer fixingDays,
                            const std::vector<Spread>& spreads =
                                                      std::vector<Spread>()) {
    boost::shared_ptr<Xibor> libor =
        boost::dynamic_pointer_cast<Xibor>(index);
    return QuantLib::IndexedCouponVector<InArrearIndexedCoupon>(
                                                  schedule, paymentAdjustment,
                                                  nominals,libor,
                                                  fixingDays,spreads);
}


using QuantLib::Cashflows;
using QuantLib::Duration;


using QuantLib::Bond;
using QuantLib::ZeroCouponBond;
using QuantLib::FixedCouponBond;
using QuantLib::FloatingRateBond;
typedef boost::shared_ptr<Instrument> BondPtr;
typedef boost::shared_ptr<Instrument> ZeroCouponBondPtr;
typedef boost::shared_ptr<Instrument> FixedCouponBondPtr;
typedef boost::shared_ptr<Instrument> FloatingRateBondPtr;

SWIGINTERN Date BondPtr_settlementDate(BondPtr *self){
            return boost::dynamic_pointer_cast<Bond>(*self)->settlementDate();
        }
SWIGINTERN std::vector<boost::shared_ptr<CashFlow > > BondPtr_cashflows(BondPtr const *self){
            return boost::dynamic_pointer_cast<Bond>(*self)->cashflows();
        }
SWIGINTERN boost::shared_ptr<CashFlow > BondPtr_redemption(BondPtr const *self){
            return boost::dynamic_pointer_cast<Bond>(*self)->redemption();
        }
SWIGINTERN Calendar BondPtr_calendar(BondPtr const *self){
            return boost::dynamic_pointer_cast<Bond>(*self)->calendar();
        }
SWIGINTERN BusinessDayConvention BondPtr_accrualConvention(BondPtr const *self){
            return boost::dynamic_pointer_cast<Bond>(*self)
                ->accrualConvention();
        }
SWIGINTERN BusinessDayConvention BondPtr_paymentConvention(BondPtr const *self){
            return boost::dynamic_pointer_cast<Bond>(*self)
                ->paymentConvention();
        }
SWIGINTERN DayCounter BondPtr_dayCounter(BondPtr const *self){
            return boost::dynamic_pointer_cast<Bond>(*self)->dayCounter();
        }
SWIGINTERN Frequency BondPtr_frequency(BondPtr const *self){
            return boost::dynamic_pointer_cast<Bond>(*self)->frequency();
        }
SWIGINTERN Real BondPtr_cleanPrice__SWIG_0(BondPtr *self){
            return boost::dynamic_pointer_cast<Bond>(*self)->cleanPrice();
        }
SWIGINTERN Real BondPtr_cleanPrice__SWIG_1(BondPtr *self,Rate yield,Compounding compounding,Date const &settlement=Date()){
            return boost::dynamic_pointer_cast<Bond>(*self)
                ->cleanPrice(yield,compounding,settlement);
        }
SWIGINTERN Real BondPtr_dirtyPrice__SWIG_0(BondPtr *self){
            return boost::dynamic_pointer_cast<Bond>(*self)->dirtyPrice();
        }
SWIGINTERN Real BondPtr_dirtyPrice__SWIG_1(BondPtr *self,Rate yield,Compounding compounding,Date const &settlement=Date()){
            return boost::dynamic_pointer_cast<Bond>(*self)
                ->dirtyPrice(yield,compounding,settlement);
        }
SWIGINTERN Real BondPtr_yield__SWIG_0(BondPtr *self,Compounding compounding,Real accuracy=1.0e-8,Size maxEvaluations=100){
            return boost::dynamic_pointer_cast<Bond>(*self)
                ->yield(compounding,accuracy,maxEvaluations);
        }
SWIGINTERN Real BondPtr_yield__SWIG_3(BondPtr *self,Real cleanPrice,Compounding compounding,Date const &settlement=Date(),Real accuracy=1.0e-8,Size maxEvaluations=100){
            return boost::dynamic_pointer_cast<Bond>(*self)
                ->yield(cleanPrice,compounding,settlement,
                        accuracy,maxEvaluations);
        }
SWIGINTERN Real BondPtr_accruedAmount__SWIG_0(BondPtr *self,Date const &settlement=Date()){
            return boost::dynamic_pointer_cast<Bond>(*self)
                ->accruedAmount(settlement);
        }
SWIGINTERN ZeroCouponBondPtr *new_ZeroCouponBondPtr__SWIG_0(Date const &issueDate,Date const &maturityDate,Integer settlementDays,DayCounter const &dayCounter,Calendar const &calendar,BusinessDayConvention convention=QuantLib::Following,Real redemption=100.0,Handle<YieldTermStructure > const &discountCurve=Handle<YieldTermStructure >()){
            return new ZeroCouponBondPtr(
                new ZeroCouponBond(issueDate, maturityDate, settlementDays,
                                   dayCounter, calendar, convention,
                                   redemption, discountCurve));
        }
SWIGINTERN FixedCouponBondPtr *new_FixedCouponBondPtr__SWIG_0(Date const &issueDate,Date const &datedDate,Date const &maturityDate,Integer settlementDays,std::vector<Rate > const &coupons,Frequency couponFrequency,Calendar const &calendar,DayCounter const &dayCounter,BusinessDayConvention accrualConvention=QuantLib::Following,BusinessDayConvention paymentConvention=QuantLib::Following,Real redemption=100.0,Handle<YieldTermStructure > const &discountCurve=Handle<YieldTermStructure >(),Date const &stub=Date(),bool fromEnd=true){
            return new FixedCouponBondPtr(
                new FixedCouponBond(issueDate, datedDate, maturityDate,
                                    settlementDays, coupons, couponFrequency,
                                    calendar, 
				    dayCounter,  
				    accrualConvention,
				    paymentConvention,
                                    redemption, discountCurve, stub, fromEnd));
        }
SWIGINTERN FloatingRateBondPtr *new_FloatingRateBondPtr__SWIG_0(Date const &issueDate,Date const &datedDate,Date const &maturityDate,Integer settlementDays,XiborPtr const &index,Integer fixingDays,std::vector<Spread > const &spreads,Frequency couponFrequency,Calendar const &calendar,DayCounter const &dayCounter,BusinessDayConvention accrualConvention=Following,BusinessDayConvention paymentConvention=Following,Real redemption=100.0,Handle<YieldTermStructure > const &discountCurve=Handle<YieldTermStructure >(),Date const &stub=Date(),bool fromEnd=true){
            boost::shared_ptr<Xibor> libor =
                boost::dynamic_pointer_cast<Xibor>(index);
            return new FloatingRateBondPtr(
                new FloatingRateBond(issueDate, datedDate, maturityDate,
                                     settlementDays, libor, fixingDays,
                                     spreads, couponFrequency,
                                     calendar, dayCounter, 
				     accrualConvention,
				     paymentConvention, 
                                     redemption, discountCurve,
                                     stub, fromEnd));
        }

using QuantLib::Price;
using QuantLib::Callability;
using QuantLib::CallabilitySchedule;

SWIGINTERN bool boost_shared_ptr_Sl_Callability_Sg__isNull(boost::shared_ptr<Callability > *self){
                return !(*self);
            }

using QuantLib::SoftCallability;
typedef boost::shared_ptr<Callability> SoftCallabilityPtr;

SWIGINTERN SoftCallabilityPtr *new_SoftCallabilityPtr(Price const &price,Date const &date,Real trigger){
            return new SoftCallabilityPtr(new SoftCallability(price,date,
                                                              trigger));
        }
SWIGINTERN std::vector<boost::shared_ptr<Callability > > *new_std_vector_Sl_boost_shared_ptr_Sl_Callability_Sg__Sg___SWIG_1(int capacity){
        std::vector<boost::shared_ptr<Callability> >* pv = 0;
        if (capacity >= 0) {
          pv = new std::vector<boost::shared_ptr<Callability> >();
          pv->reserve(capacity);
       } else {
          throw std::out_of_range("capacity");
       }
       return pv;
      }
SWIGINTERN boost::shared_ptr<Callability > std_vector_Sl_boost_shared_ptr_Sl_Callability_Sg__Sg__getitemcopy(std::vector<boost::shared_ptr<Callability > > *self,int index){
        if (index>=0 && index<(int)self->size())
          return (*self)[index];
        else
          throw std::out_of_range("index");
      }
SWIGINTERN std::vector<boost::shared_ptr<Callability > >::const_reference std_vector_Sl_boost_shared_ptr_Sl_Callability_Sg__Sg__getitem(std::vector<boost::shared_ptr<Callability > > *self,int index){
        if (index>=0 && index<(int)self->size())
          return (*self)[index];
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_Callability_Sg__Sg__setitem(std::vector<boost::shared_ptr<Callability > > *self,int index,std::vector<boost::shared_ptr<Callability > >::value_type const &value){
        if (index>=0 && index<(int)self->size())
          (*self)[index] = value;
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_Callability_Sg__Sg__AddRange(std::vector<boost::shared_ptr<Callability > > *self,std::vector<boost::shared_ptr<Callability > > const &values){
        self->insert(self->end(), values.begin(), values.end());
      }
SWIGINTERN std::vector<boost::shared_ptr<Callability > > *std_vector_Sl_boost_shared_ptr_Sl_Callability_Sg__Sg__GetRange(std::vector<boost::shared_ptr<Callability > > *self,int index,int count){
        if (index < 0)
          throw std::out_of_range("index");
        if (count < 0)
          throw std::out_of_range("count");
        if (index >= (int)self->size()+1 || index+count > (int)self->size())
          throw std::invalid_argument("invalid range");
        return new std::vector<boost::shared_ptr<Callability> >(self->begin()+index, self->begin()+index+count);
      }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_Callability_Sg__Sg__Insert(std::vector<boost::shared_ptr<Callability > > *self,int index,std::vector<boost::shared_ptr<Callability > >::value_type const &value){
        if (index>=0 && index<(int)self->size()+1)
          self->insert(self->begin()+index, value);
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_Callability_Sg__Sg__InsertRange(std::vector<boost::shared_ptr<Callability > > *self,int index,std::vector<boost::shared_ptr<Callability > > const &values){
        if (index>=0 && index<(int)self->size()+1)
          self->insert(self->begin()+index, values.begin(), values.end());
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_Callability_Sg__Sg__RemoveAt(std::vector<boost::shared_ptr<Callability > > *self,int index){
        if (index>=0 && index<(int)self->size())
          self->erase(self->begin() + index);
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_Callability_Sg__Sg__RemoveRange(std::vector<boost::shared_ptr<Callability > > *self,int index,int count){
        if (index < 0)
          throw std::out_of_range("index");
        if (count < 0)
          throw std::out_of_range("count");
        if (index >= (int)self->size()+1 || index+count > (int)self->size())
          throw std::invalid_argument("invalid range");
        self->erase(self->begin()+index, self->begin()+index+count);
      }
SWIGINTERN std::vector<boost::shared_ptr<Callability > > *std_vector_Sl_boost_shared_ptr_Sl_Callability_Sg__Sg__Repeat(std::vector<boost::shared_ptr<Callability > >::value_type const &value,int count){
        if (count < 0)
          throw std::out_of_range("count");
        return new std::vector<boost::shared_ptr<Callability> >(count, value);
      }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_Callability_Sg__Sg__Reverse__SWIG_0(std::vector<boost::shared_ptr<Callability > > *self){
        std::reverse(self->begin(), self->end());
      }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_Callability_Sg__Sg__Reverse__SWIG_1(std::vector<boost::shared_ptr<Callability > > *self,int index,int count){
        if (index < 0)
          throw std::out_of_range("index");
        if (count < 0)
          throw std::out_of_range("count");
        if (index >= (int)self->size()+1 || index+count > (int)self->size())
          throw std::invalid_argument("invalid range");
        std::reverse(self->begin()+index, self->begin()+index+count);
      }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_Callability_Sg__Sg__SetRange(std::vector<boost::shared_ptr<Callability > > *self,int index,std::vector<boost::shared_ptr<Callability > > const &values){
        if (index < 0)
          throw std::out_of_range("index");
        if (index+values.size() > self->size())
          throw std::out_of_range("index");
        std::copy(values.begin(), values.end(), self->begin()+index);
      }
SWIGINTERN bool std_vector_Sl_boost_shared_ptr_Sl_Callability_Sg__Sg__Contains(std::vector<boost::shared_ptr<Callability > > *self,std::vector<boost::shared_ptr<Callability > >::value_type const &value){
        return std::find(self->begin(), self->end(), value) != self->end();
      }
SWIGINTERN int std_vector_Sl_boost_shared_ptr_Sl_Callability_Sg__Sg__IndexOf(std::vector<boost::shared_ptr<Callability > > *self,std::vector<boost::shared_ptr<Callability > >::value_type const &value){
        int index = -1;
        std::vector<boost::shared_ptr<Callability> >::iterator it = std::find(self->begin(), self->end(), value);
        if (it != self->end())
          index = it - self->begin();
        return index;
      }
SWIGINTERN int std_vector_Sl_boost_shared_ptr_Sl_Callability_Sg__Sg__LastIndexOf(std::vector<boost::shared_ptr<Callability > > *self,std::vector<boost::shared_ptr<Callability > >::value_type const &value){
        int index = -1;
        std::vector<boost::shared_ptr<Callability> >::reverse_iterator rit = std::find(self->rbegin(), self->rend(), value);
        if (rit != self->rend())
          index = self->rend() - 1 - rit;
        return index;
      }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_Callability_Sg__Sg__Remove(std::vector<boost::shared_ptr<Callability > > *self,std::vector<boost::shared_ptr<Callability > >::value_type const &value){
        std::vector<boost::shared_ptr<Callability> >::iterator it = std::find(self->begin(), self->end(), value);
        if (it != self->end())
          self->erase(it);
      }

using QuantLib::Exercise;

SWIGINTERN bool boost_shared_ptr_Sl_Exercise_Sg__isNull(boost::shared_ptr<Exercise > *self){
                return !(*self);
            }

using QuantLib::EuropeanExercise;
using QuantLib::AmericanExercise;
using QuantLib::BermudanExercise;
typedef boost::shared_ptr<Exercise> EuropeanExercisePtr;
typedef boost::shared_ptr<Exercise> AmericanExercisePtr;
typedef boost::shared_ptr<Exercise> BermudanExercisePtr;

SWIGINTERN EuropeanExercisePtr *new_EuropeanExercisePtr(Date const &date){
            return new EuropeanExercisePtr(new EuropeanExercise(date));
        }
SWIGINTERN AmericanExercisePtr *new_AmericanExercisePtr__SWIG_0(Date const &earliestDate,Date const &latestDate,bool payoffAtExpiry=false){
            return new AmericanExercisePtr(
                                        new AmericanExercise(earliestDate,
                                                             latestDate,
                                                             payoffAtExpiry));
        }
SWIGINTERN BermudanExercisePtr *new_BermudanExercisePtr__SWIG_0(std::vector<Date > const &dates,bool payoffAtExpiry=false){
            return new BermudanExercisePtr(
                                        new BermudanExercise(dates,
                                                             payoffAtExpiry));
        }

using QuantLib::StochasticProcess;

SWIGINTERN bool boost_shared_ptr_Sl_StochasticProcess_Sg__isNull(boost::shared_ptr<StochasticProcess > *self){
                return !(*self);
            }

using QuantLib::StochasticProcess1D;
typedef boost::shared_ptr<StochasticProcess> StochasticProcess1DPtr;


using QuantLib::BlackScholesProcess;
typedef boost::shared_ptr<StochasticProcess> BlackScholesProcessPtr;

SWIGINTERN BlackScholesProcessPtr *new_BlackScholesProcessPtr(Handle<Quote > const &s0,Handle<YieldTermStructure > const &dividendTS,Handle<YieldTermStructure > const &riskFreeTS,Handle<BlackVolTermStructure > const &volTS){
          return new BlackScholesProcessPtr(
                              new BlackScholesProcess(s0, dividendTS,
                                                      riskFreeTS, volTS));
      }

using QuantLib::Merton76Process;
typedef boost::shared_ptr<StochasticProcess> Merton76ProcessPtr;

SWIGINTERN Merton76ProcessPtr *new_Merton76ProcessPtr(Handle<Quote > const &stateVariable,Handle<YieldTermStructure > const &dividendTS,Handle<YieldTermStructure > const &riskFreeTS,Handle<BlackVolTermStructure > const &volTS,Handle<Quote > const &jumpIntensity,Handle<Quote > const &meanLogJump,Handle<Quote > const &jumpVolatility){
            return new Merton76ProcessPtr(
                              new Merton76Process(stateVariable, dividendTS,
                                                  riskFreeTS, volTS,
                                                  jumpIntensity, meanLogJump,
                                                  jumpVolatility));
      }
SWIGINTERN std::vector<StochasticProcess1DPtr > *new_std_vector_Sl_StochasticProcess1DPtr_Sg___SWIG_1(int capacity){
        std::vector<StochasticProcess1DPtr >* pv = 0;
        if (capacity >= 0) {
          pv = new std::vector<StochasticProcess1DPtr >();
          pv->reserve(capacity);
       } else {
          throw std::out_of_range("capacity");
       }
       return pv;
      }
SWIGINTERN StochasticProcess1DPtr std_vector_Sl_StochasticProcess1DPtr_Sg__getitemcopy(std::vector<StochasticProcess1DPtr > *self,int index){
        if (index>=0 && index<(int)self->size())
          return (*self)[index];
        else
          throw std::out_of_range("index");
      }
SWIGINTERN std::vector<StochasticProcess1DPtr >::const_reference std_vector_Sl_StochasticProcess1DPtr_Sg__getitem(std::vector<StochasticProcess1DPtr > *self,int index){
        if (index>=0 && index<(int)self->size())
          return (*self)[index];
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_StochasticProcess1DPtr_Sg__setitem(std::vector<StochasticProcess1DPtr > *self,int index,std::vector<StochasticProcess1DPtr >::value_type const &value){
        if (index>=0 && index<(int)self->size())
          (*self)[index] = value;
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_StochasticProcess1DPtr_Sg__AddRange(std::vector<StochasticProcess1DPtr > *self,std::vector<StochasticProcess1DPtr > const &values){
        self->insert(self->end(), values.begin(), values.end());
      }
SWIGINTERN std::vector<StochasticProcess1DPtr > *std_vector_Sl_StochasticProcess1DPtr_Sg__GetRange(std::vector<StochasticProcess1DPtr > *self,int index,int count){
        if (index < 0)
          throw std::out_of_range("index");
        if (count < 0)
          throw std::out_of_range("count");
        if (index >= (int)self->size()+1 || index+count > (int)self->size())
          throw std::invalid_argument("invalid range");
        return new std::vector<StochasticProcess1DPtr >(self->begin()+index, self->begin()+index+count);
      }
SWIGINTERN void std_vector_Sl_StochasticProcess1DPtr_Sg__Insert(std::vector<StochasticProcess1DPtr > *self,int index,std::vector<StochasticProcess1DPtr >::value_type const &value){
        if (index>=0 && index<(int)self->size()+1)
          self->insert(self->begin()+index, value);
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_StochasticProcess1DPtr_Sg__InsertRange(std::vector<StochasticProcess1DPtr > *self,int index,std::vector<StochasticProcess1DPtr > const &values){
        if (index>=0 && index<(int)self->size()+1)
          self->insert(self->begin()+index, values.begin(), values.end());
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_StochasticProcess1DPtr_Sg__RemoveAt(std::vector<StochasticProcess1DPtr > *self,int index){
        if (index>=0 && index<(int)self->size())
          self->erase(self->begin() + index);
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_StochasticProcess1DPtr_Sg__RemoveRange(std::vector<StochasticProcess1DPtr > *self,int index,int count){
        if (index < 0)
          throw std::out_of_range("index");
        if (count < 0)
          throw std::out_of_range("count");
        if (index >= (int)self->size()+1 || index+count > (int)self->size())
          throw std::invalid_argument("invalid range");
        self->erase(self->begin()+index, self->begin()+index+count);
      }
SWIGINTERN std::vector<StochasticProcess1DPtr > *std_vector_Sl_StochasticProcess1DPtr_Sg__Repeat(std::vector<StochasticProcess1DPtr >::value_type const &value,int count){
        if (count < 0)
          throw std::out_of_range("count");
        return new std::vector<StochasticProcess1DPtr >(count, value);
      }
SWIGINTERN void std_vector_Sl_StochasticProcess1DPtr_Sg__Reverse__SWIG_0(std::vector<StochasticProcess1DPtr > *self){
        std::reverse(self->begin(), self->end());
      }
SWIGINTERN void std_vector_Sl_StochasticProcess1DPtr_Sg__Reverse__SWIG_1(std::vector<StochasticProcess1DPtr > *self,int index,int count){
        if (index < 0)
          throw std::out_of_range("index");
        if (count < 0)
          throw std::out_of_range("count");
        if (index >= (int)self->size()+1 || index+count > (int)self->size())
          throw std::invalid_argument("invalid range");
        std::reverse(self->begin()+index, self->begin()+index+count);
      }
SWIGINTERN void std_vector_Sl_StochasticProcess1DPtr_Sg__SetRange(std::vector<StochasticProcess1DPtr > *self,int index,std::vector<StochasticProcess1DPtr > const &values){
        if (index < 0)
          throw std::out_of_range("index");
        if (index+values.size() > self->size())
          throw std::out_of_range("index");
        std::copy(values.begin(), values.end(), self->begin()+index);
      }
SWIGINTERN bool std_vector_Sl_StochasticProcess1DPtr_Sg__Contains(std::vector<StochasticProcess1DPtr > *self,std::vector<StochasticProcess1DPtr >::value_type const &value){
        return std::find(self->begin(), self->end(), value) != self->end();
      }
SWIGINTERN int std_vector_Sl_StochasticProcess1DPtr_Sg__IndexOf(std::vector<StochasticProcess1DPtr > *self,std::vector<StochasticProcess1DPtr >::value_type const &value){
        int index = -1;
        std::vector<StochasticProcess1DPtr >::iterator it = std::find(self->begin(), self->end(), value);
        if (it != self->end())
          index = it - self->begin();
        return index;
      }
SWIGINTERN int std_vector_Sl_StochasticProcess1DPtr_Sg__LastIndexOf(std::vector<StochasticProcess1DPtr > *self,std::vector<StochasticProcess1DPtr >::value_type const &value){
        int index = -1;
        std::vector<StochasticProcess1DPtr >::reverse_iterator rit = std::find(self->rbegin(), self->rend(), value);
        if (rit != self->rend())
          index = self->rend() - 1 - rit;
        return index;
      }
SWIGINTERN void std_vector_Sl_StochasticProcess1DPtr_Sg__Remove(std::vector<StochasticProcess1DPtr > *self,std::vector<StochasticProcess1DPtr >::value_type const &value){
        std::vector<StochasticProcess1DPtr >::iterator it = std::find(self->begin(), self->end(), value);
        if (it != self->end())
          self->erase(it);
      }

using QuantLib::Option;
using QuantLib::Barrier;


using QuantLib::Payoff;
using QuantLib::StrikedTypePayoff;

SWIGINTERN bool boost_shared_ptr_Sl_Payoff_Sg__isNull(boost::shared_ptr<Payoff > *self){
                return !(*self);
            }

using QuantLib::VanillaOption;
typedef boost::shared_ptr<Instrument> VanillaOptionPtr;

SWIGINTERN VanillaOptionPtr *new_VanillaOptionPtr__SWIG_0(boost::shared_ptr<StochasticProcess > const &process,boost::shared_ptr<Payoff > const &payoff,boost::shared_ptr<Exercise > const &exercise,boost::shared_ptr<PricingEngine > const &engine=boost::shared_ptr<PricingEngine >()){
            boost::shared_ptr<StrikedTypePayoff> stPayoff =
                 boost::dynamic_pointer_cast<StrikedTypePayoff>(payoff);
            QL_REQUIRE(stPayoff, "wrong payoff given");
            return new VanillaOptionPtr(
                         new VanillaOption(process,stPayoff,exercise,engine));
        }
SWIGINTERN Real VanillaOptionPtr_delta(VanillaOptionPtr *self){
            return boost::dynamic_pointer_cast<VanillaOption>(*self)->delta();
        }
SWIGINTERN Real VanillaOptionPtr_gamma(VanillaOptionPtr *self){
            return boost::dynamic_pointer_cast<VanillaOption>(*self)->gamma();
        }
SWIGINTERN Real VanillaOptionPtr_theta(VanillaOptionPtr *self){
            return boost::dynamic_pointer_cast<VanillaOption>(*self)->theta();
        }
SWIGINTERN Real VanillaOptionPtr_thetaPerDay(VanillaOptionPtr *self){
            return boost::dynamic_pointer_cast<VanillaOption>(*self)
                ->thetaPerDay();
        }
SWIGINTERN Real VanillaOptionPtr_vega(VanillaOptionPtr *self){
            return boost::dynamic_pointer_cast<VanillaOption>(*self)->vega();
        }
SWIGINTERN Real VanillaOptionPtr_rho(VanillaOptionPtr *self){
            return boost::dynamic_pointer_cast<VanillaOption>(*self)->rho();
        }
SWIGINTERN Real VanillaOptionPtr_dividendRho(VanillaOptionPtr *self){
            return boost::dynamic_pointer_cast<VanillaOption>(*self)
                 ->dividendRho();
        }
SWIGINTERN Real VanillaOptionPtr_strikeSensitivity(VanillaOptionPtr *self){
            return boost::dynamic_pointer_cast<VanillaOption>(*self)
                 ->strikeSensitivity();
        }
SWIGINTERN SampledCurve VanillaOptionPtr_priceCurve(VanillaOptionPtr *self){
            return boost::dynamic_pointer_cast<VanillaOption>(*self)
                 ->priceCurve();
    }
SWIGINTERN Volatility VanillaOptionPtr_impliedVolatility__SWIG_0(VanillaOptionPtr *self,Real targetValue,Real accuracy=1.0e-4,Size maxEvaluations=100,Volatility minVol=1.0e-4,Volatility maxVol=4.0){
            return boost::dynamic_pointer_cast<VanillaOption>(*self)
                 ->impliedVolatility(targetValue,accuracy,maxEvaluations,
                                     minVol,maxVol);
        }

using QuantLib::EuropeanOption;
typedef boost::shared_ptr<Instrument> EuropeanOptionPtr;

SWIGINTERN EuropeanOptionPtr *new_EuropeanOptionPtr__SWIG_0(boost::shared_ptr<StochasticProcess > const &process,boost::shared_ptr<Payoff > const &payoff,boost::shared_ptr<Exercise > const &exercise,boost::shared_ptr<PricingEngine > const &engine=boost::shared_ptr<PricingEngine >()){
            boost::shared_ptr<StrikedTypePayoff> stPayoff =
                 boost::dynamic_pointer_cast<StrikedTypePayoff>(payoff);
            QL_REQUIRE(stPayoff, "wrong payoff given");
            return new EuropeanOptionPtr(
                        new EuropeanOption(process,stPayoff,exercise,engine));
        }

using QuantLib::AnalyticEuropeanEngine;
typedef boost::shared_ptr<PricingEngine> AnalyticEuropeanEnginePtr;

SWIGINTERN AnalyticEuropeanEnginePtr *new_AnalyticEuropeanEnginePtr(){
            return new AnalyticEuropeanEnginePtr(new AnalyticEuropeanEngine);
        }

using QuantLib::IntegralEngine;
typedef boost::shared_ptr<PricingEngine> IntegralEnginePtr;

SWIGINTERN IntegralEnginePtr *new_IntegralEnginePtr(){
            return new IntegralEnginePtr(new IntegralEngine);
        }

using QuantLib::FDEuropeanEngine;
typedef boost::shared_ptr<PricingEngine> FDEuropeanEnginePtr;

SWIGINTERN FDEuropeanEnginePtr *new_FDEuropeanEnginePtr__SWIG_0(Size timeSteps=100,Size gridPoints=100,bool timeDependent=false){
            return new FDEuropeanEnginePtr(
                    new FDEuropeanEngine(timeSteps,gridPoints,timeDependent));
        }

using QuantLib::BinomialVanillaEngine;
using QuantLib::CoxRossRubinstein;
using QuantLib::JarrowRudd;
using QuantLib::AdditiveEQPBinomialTree;
using QuantLib::Trigeorgis;
using QuantLib::Tian;
using QuantLib::LeisenReimer;
typedef boost::shared_ptr<PricingEngine> BinomialVanillaEnginePtr;

SWIGINTERN BinomialVanillaEnginePtr *new_BinomialVanillaEnginePtr(std::string const &type,Size steps){
            std::string s = QuantLib::lowercase(type);
            if (s == "crr" || s == "coxrossrubinstein")
                return new BinomialVanillaEnginePtr(
                    new BinomialVanillaEngine<CoxRossRubinstein>(steps));
            else if (s == "jr" || s == "jarrowrudd")
                return new BinomialVanillaEnginePtr(
                    new BinomialVanillaEngine<JarrowRudd>(steps));
            else if (s == "eqp")
                return new BinomialVanillaEnginePtr(
                    new BinomialVanillaEngine<AdditiveEQPBinomialTree>(steps));
            else if (s == "trigeorgis")
                return new BinomialVanillaEnginePtr(
                    new BinomialVanillaEngine<Trigeorgis>(steps));
            else if (s == "tian")
                return new BinomialVanillaEnginePtr(
                    new BinomialVanillaEngine<Tian>(steps));
            else if (s == "lr" || s == "leisenreimer")
                return new BinomialVanillaEnginePtr(
                    new BinomialVanillaEngine<LeisenReimer>(steps));
            else
                QL_FAIL("unknown binomial engine type: "+s);
        }

using QuantLib::MCEuropeanEngine;
using QuantLib::PseudoRandom;
using QuantLib::LowDiscrepancy;
typedef boost::shared_ptr<PricingEngine> MCEuropeanEnginePtr;

SWIGINTERN MCEuropeanEnginePtr *new_MCEuropeanEnginePtr(std::string const &traits,intOrNull timeSteps=Null<Size >(),intOrNull timeStepsPerYear=Null<Size >(),bool brownianBridge=false,bool antitheticVariate=false,bool controlVariate=false,intOrNull requiredSamples=Null<Size >(),doubleOrNull requiredTolerance=Null<Real >(),intOrNull maxSamples=Null<Size >(),BigInteger seed=0){
            std::string s = QuantLib::lowercase(traits);
            QL_REQUIRE(Size(timeSteps) != Null<Size>() ||
                       Size(timeStepsPerYear) != Null<Size>(),
                       "number of steps not specified");
            if (s == "pseudorandom" || s == "pr")
                return new MCEuropeanEnginePtr(
                         new MCEuropeanEngine<PseudoRandom>(timeSteps,
                                                            timeStepsPerYear,
                                                            brownianBridge,
                                                            antitheticVariate,
                                                            controlVariate,
                                                            requiredSamples,
                                                            requiredTolerance,
                                                            maxSamples,
                                                            seed));
            else if (s == "lowdiscrepancy" || s == "ld")
                return new MCEuropeanEnginePtr(
                       new MCEuropeanEngine<LowDiscrepancy>(timeSteps,
                                                            timeStepsPerYear,
                                                            brownianBridge,
                                                            antitheticVariate,
                                                            controlVariate,
                                                            requiredSamples,
                                                            requiredTolerance,
                                                            maxSamples,
                                                            seed));
            else
                QL_FAIL("unknown Monte Carlo engine type: "+s);
        }

using QuantLib::FDAmericanEngine;
using QuantLib::FDShoutEngine;
typedef boost::shared_ptr<PricingEngine> FDAmericanEnginePtr;
typedef boost::shared_ptr<PricingEngine> FDShoutEnginePtr;

SWIGINTERN FDAmericanEnginePtr *new_FDAmericanEnginePtr__SWIG_0(Size timeSteps=100,Size gridPoints=100,bool timeDependent=false){
            return new FDAmericanEnginePtr(
                    new FDAmericanEngine(timeSteps,gridPoints,timeDependent));
        }
SWIGINTERN FDShoutEnginePtr *new_FDShoutEnginePtr__SWIG_0(Size timeSteps=100,Size gridPoints=100,bool timeDependent=false){
            return new FDShoutEnginePtr(
                       new FDShoutEngine(timeSteps,gridPoints,timeDependent));
        }

using QuantLib::BaroneAdesiWhaleyApproximationEngine;
typedef boost::shared_ptr<PricingEngine>
    BaroneAdesiWhaleyApproximationEnginePtr;

SWIGINTERN BaroneAdesiWhaleyApproximationEnginePtr *new_BaroneAdesiWhaleyApproximationEnginePtr(){
            return new BaroneAdesiWhaleyApproximationEnginePtr(
                new BaroneAdesiWhaleyApproximationEngine);
        }

using QuantLib::BjerksundStenslandApproximationEngine;
typedef boost::shared_ptr<PricingEngine>
    BjerksundStenslandApproximationEnginePtr;

SWIGINTERN BjerksundStenslandApproximationEnginePtr *new_BjerksundStenslandApproximationEnginePtr(){
            return new BjerksundStenslandApproximationEnginePtr(
                new BjerksundStenslandApproximationEngine);
        }

using QuantLib::AnalyticDigitalAmericanEngine;
typedef boost::shared_ptr<PricingEngine> AnalyticDigitalAmericanEnginePtr;

SWIGINTERN AnalyticDigitalAmericanEnginePtr *new_AnalyticDigitalAmericanEnginePtr(){
            return new AnalyticDigitalAmericanEnginePtr(
                new AnalyticDigitalAmericanEngine);
        }

using QuantLib::DividendVanillaOption;
typedef boost::shared_ptr<Instrument> DividendVanillaOptionPtr;

SWIGINTERN DividendVanillaOptionPtr *new_DividendVanillaOptionPtr__SWIG_0(boost::shared_ptr<StochasticProcess > const &process,boost::shared_ptr<Payoff > const &payoff,boost::shared_ptr<Exercise > const &exercise,std::vector<Date > const &dividendDates,std::vector<Real > const &dividends,boost::shared_ptr<PricingEngine > const &engine=boost::shared_ptr<PricingEngine >()){
            boost::shared_ptr<StrikedTypePayoff> stPayoff =
                 boost::dynamic_pointer_cast<StrikedTypePayoff>(payoff);
            QL_REQUIRE(stPayoff, "wrong payoff given");
            return new DividendVanillaOptionPtr(
                   new DividendVanillaOption(process,stPayoff,exercise,
                                             dividendDates,dividends,engine));
        }
SWIGINTERN Real DividendVanillaOptionPtr_delta(DividendVanillaOptionPtr *self){
            return boost::dynamic_pointer_cast<DividendVanillaOption>(*self)
                ->delta();
        }
SWIGINTERN Real DividendVanillaOptionPtr_gamma(DividendVanillaOptionPtr *self){
            return boost::dynamic_pointer_cast<DividendVanillaOption>(*self)
                ->gamma();
        }
SWIGINTERN Real DividendVanillaOptionPtr_theta(DividendVanillaOptionPtr *self){
            return boost::dynamic_pointer_cast<DividendVanillaOption>(*self)
                ->theta();
        }
SWIGINTERN Real DividendVanillaOptionPtr_vega(DividendVanillaOptionPtr *self){
            return boost::dynamic_pointer_cast<DividendVanillaOption>(*self)
                ->vega();
        }
SWIGINTERN Real DividendVanillaOptionPtr_rho(DividendVanillaOptionPtr *self){
            return boost::dynamic_pointer_cast<DividendVanillaOption>(*self)
                ->rho();
        }
SWIGINTERN Real DividendVanillaOptionPtr_dividendRho(DividendVanillaOptionPtr *self){
            return boost::dynamic_pointer_cast<DividendVanillaOption>(*self)
                 ->dividendRho();
        }
SWIGINTERN Real DividendVanillaOptionPtr_strikeSensitivity(DividendVanillaOptionPtr *self){
            return boost::dynamic_pointer_cast<DividendVanillaOption>(*self)
                 ->strikeSensitivity();
        }
SWIGINTERN SampledCurve DividendVanillaOptionPtr_priceCurve(DividendVanillaOptionPtr *self){
            return boost::dynamic_pointer_cast<DividendVanillaOption>(*self)
                 ->priceCurve();
    }
SWIGINTERN Volatility DividendVanillaOptionPtr_impliedVolatility__SWIG_0(DividendVanillaOptionPtr *self,Real targetValue,Real accuracy=1.0e-4,Size maxEvaluations=100,Volatility minVol=1.0e-4,Volatility maxVol=4.0){
            return boost::dynamic_pointer_cast<DividendVanillaOption>(*self)
                 ->impliedVolatility(targetValue,accuracy,maxEvaluations,
                                     minVol,maxVol);
        }

using QuantLib::AnalyticDividendEuropeanEngine;
typedef boost::shared_ptr<PricingEngine> AnalyticDividendEuropeanEnginePtr;

SWIGINTERN AnalyticDividendEuropeanEnginePtr *new_AnalyticDividendEuropeanEnginePtr(){
            return new AnalyticDividendEuropeanEnginePtr(
                new AnalyticDividendEuropeanEngine);
        }

using QuantLib::FDDividendEuropeanEngine;
using QuantLib::FDDividendAmericanEngine;
typedef boost::shared_ptr<PricingEngine> FDDividendEuropeanEnginePtr;
typedef boost::shared_ptr<PricingEngine> FDDividendAmericanEnginePtr;

SWIGINTERN FDDividendEuropeanEnginePtr *new_FDDividendEuropeanEnginePtr__SWIG_0(Size timeSteps=100,Size gridPoints=100,bool timeDependent=false){
            return new FDDividendEuropeanEnginePtr(
                new FDDividendEuropeanEngine(timeSteps,gridPoints,
                                             timeDependent));
        }
SWIGINTERN FDDividendAmericanEnginePtr *new_FDDividendAmericanEnginePtr__SWIG_0(Size timeSteps=100,Size gridPoints=100,bool timeDependent=false){
            return new FDDividendAmericanEnginePtr(
                new FDDividendAmericanEngine(timeSteps,gridPoints,
                                             timeDependent));
        }

using QuantLib::BarrierOption;
typedef boost::shared_ptr<Instrument> BarrierOptionPtr;

SWIGINTERN BarrierOptionPtr *new_BarrierOptionPtr__SWIG_0(Barrier::Type barrierType,Real barrier,Real rebate,boost::shared_ptr<StochasticProcess > const &process,boost::shared_ptr<Payoff > const &payoff,boost::shared_ptr<Exercise > const &exercise,boost::shared_ptr<PricingEngine > const &engine=boost::shared_ptr<PricingEngine >()){
            boost::shared_ptr<StrikedTypePayoff> stPayoff =
                 boost::dynamic_pointer_cast<StrikedTypePayoff>(payoff);
            QL_REQUIRE(stPayoff, "wrong payoff given");
            return new BarrierOptionPtr(
                         new BarrierOption(barrierType, barrier, rebate,
                                           process,stPayoff,exercise,engine));
        }
SWIGINTERN Real BarrierOptionPtr_delta(BarrierOptionPtr *self){
            return boost::dynamic_pointer_cast<BarrierOption>(*self)->delta();
        }
SWIGINTERN Real BarrierOptionPtr_gamma(BarrierOptionPtr *self){
            return boost::dynamic_pointer_cast<BarrierOption>(*self)->gamma();
        }
SWIGINTERN Real BarrierOptionPtr_theta(BarrierOptionPtr *self){
            return boost::dynamic_pointer_cast<BarrierOption>(*self)->theta();
        }
SWIGINTERN Real BarrierOptionPtr_vega(BarrierOptionPtr *self){
            return boost::dynamic_pointer_cast<BarrierOption>(*self)->vega();
        }
SWIGINTERN Real BarrierOptionPtr_rho(BarrierOptionPtr *self){
            return boost::dynamic_pointer_cast<BarrierOption>(*self)->rho();
        }
SWIGINTERN Real BarrierOptionPtr_dividendRho(BarrierOptionPtr *self){
            return boost::dynamic_pointer_cast<BarrierOption>(*self)
                 ->dividendRho();
        }
SWIGINTERN Real BarrierOptionPtr_strikeSensitivity(BarrierOptionPtr *self){
            return boost::dynamic_pointer_cast<BarrierOption>(*self)
                 ->strikeSensitivity();
        }
SWIGINTERN SampledCurve BarrierOptionPtr_priceCurve(BarrierOptionPtr *self){
            return boost::dynamic_pointer_cast<BarrierOption>(*self)
                 ->priceCurve();
    }
SWIGINTERN Volatility BarrierOptionPtr_impliedVolatility__SWIG_0(BarrierOptionPtr *self,Real targetValue,Real accuracy=1.0e-4,Size maxEvaluations=100,Volatility minVol=1.0e-4,Volatility maxVol=4.0){
            return boost::dynamic_pointer_cast<BarrierOption>(*self)
                 ->impliedVolatility(targetValue,accuracy,maxEvaluations,
                                     minVol,maxVol);
        }

using QuantLib::AnalyticBarrierEngine;
typedef boost::shared_ptr<PricingEngine> AnalyticBarrierEnginePtr;

SWIGINTERN AnalyticBarrierEnginePtr *new_AnalyticBarrierEnginePtr(){
            return new AnalyticBarrierEnginePtr(new AnalyticBarrierEngine);
        }

using QuantLib::MCBarrierEngine;
typedef boost::shared_ptr<PricingEngine> MCBarrierEnginePtr;

SWIGINTERN MCBarrierEnginePtr *new_MCBarrierEnginePtr(std::string const &traits,Size timeStepsPerYear=Null<Size >(),bool brownianBridge=false,bool antitheticVariate=false,bool controlVariate=false,intOrNull requiredSamples=Null<Size >(),doubleOrNull requiredTolerance=Null<Real >(),intOrNull maxSamples=Null<Size >(),bool isBiased=false,BigInteger seed=0){
            std::string s = QuantLib::lowercase(traits);
            if (s == "pseudorandom" || s == "pr")
                return new MCBarrierEnginePtr(
                         new MCBarrierEngine<PseudoRandom>(timeStepsPerYear,
                                                           brownianBridge,
                                                           antitheticVariate,
                                                           controlVariate,
                                                           requiredSamples,
                                                           requiredTolerance,
                                                           maxSamples,
                                                           isBiased,
                                                           seed));
            else if (s == "lowdiscrepancy" || s == "ld")
                return new MCBarrierEnginePtr(
                       new MCBarrierEngine<LowDiscrepancy>(timeStepsPerYear,
                                                           brownianBridge,
                                                           antitheticVariate,
                                                           controlVariate,
                                                           requiredSamples,
                                                           requiredTolerance,
                                                           maxSamples,
                                                           isBiased,
                                                           seed));
            else
                QL_FAIL("unknown Monte Carlo engine type: "+s);
        }

using QuantLib::CapFloor;
using QuantLib::Cap;
using QuantLib::Floor;
using QuantLib::Collar;

typedef boost::shared_ptr<Instrument> CapFloorPtr;
typedef boost::shared_ptr<Instrument> CapPtr;
typedef boost::shared_ptr<Instrument> FloorPtr;
typedef boost::shared_ptr<Instrument> CollarPtr;

SWIGINTERN Volatility CapFloorPtr_impliedVolatility__SWIG_0(CapFloorPtr const *self,Real price,Real accuracy=1.0e-4,Size maxEvaluations=100,Volatility minVol=1.0e-7,Volatility maxVol=4.0){
	  return boost::dynamic_pointer_cast<CapFloor>(*self)->
	    impliedVolatility(price, accuracy, maxEvaluations,
			      minVol, maxVol);
	}
SWIGINTERN CapPtr *new_CapPtr(std::vector<boost::shared_ptr<CashFlow > > const &leg,std::vector<Rate > const &capRates,Handle<YieldTermStructure > const &h,boost::shared_ptr<PricingEngine > const &engine){
            return new CapPtr(new Cap(leg,capRates,h,engine));
        }
SWIGINTERN FloorPtr *new_FloorPtr(std::vector<boost::shared_ptr<CashFlow > > const &leg,std::vector<Rate > const &floorRates,Handle<YieldTermStructure > const &h,boost::shared_ptr<PricingEngine > const &engine){
            return new FloorPtr(new Floor(leg,floorRates,h,engine));
        }
SWIGINTERN CollarPtr *new_CollarPtr(std::vector<boost::shared_ptr<CashFlow > > const &leg,std::vector<Rate > const &capRates,std::vector<Rate > const &floorRates,Handle<YieldTermStructure > const &h,boost::shared_ptr<PricingEngine > const &engine){
            return new CollarPtr(new Collar(leg,capRates,floorRates,h,engine));
        }

using QuantLib::BlackCapFloorEngine;
typedef boost::shared_ptr<PricingEngine> BlackCapFloorEnginePtr;

SWIGINTERN BlackCapFloorEnginePtr *new_BlackCapFloorEnginePtr(boost::shared_ptr<BlackModel > const &model){
            return new BlackCapFloorEnginePtr(new BlackCapFloorEngine(model));
        }

using QuantLib::CompoundForward;
typedef boost::shared_ptr<YieldTermStructure> CompoundForwardPtr;

SWIGINTERN CompoundForwardPtr *new_CompoundForwardPtr(Date const &settlementDate,std::vector<Date > const &dates,std::vector<Rate > const &rates,Calendar calendar,BusinessDayConvention roll,Integer compounding,DayCounter const &dayCounter){
	        return new CompoundForwardPtr(
                new CompoundForward(settlementDate,
                                    dates, rates, calendar, roll,
                                    compounding, dayCounter));
        }
SWIGINTERN std::vector<Date > const &CompoundForwardPtr_dates(CompoundForwardPtr *self){
            return boost::dynamic_pointer_cast<CompoundForward>(*self)
                 ->dates();
        }
SWIGINTERN Rate CompoundForwardPtr_compoundForward__SWIG_0(CompoundForwardPtr const *self,Date const &d1,Integer f,bool extrapolate=false){
	       return
			 boost::dynamic_pointer_cast<CompoundForward>(*self)
                 ->compoundForward(d1, f, extrapolate);
        }
SWIGINTERN Rate CompoundForwardPtr_compoundForward__SWIG_2(CompoundForwardPtr const *self,Time const t1,Integer f,bool extrapolate=false){
	       return
	 boost::dynamic_pointer_cast<CompoundForward>(*self)
                 ->compoundForward(t1, f, extrapolate);
        }

using QuantLib::Dividend;

SWIGINTERN bool boost_shared_ptr_Sl_Dividend_Sg__isNull(boost::shared_ptr<Dividend > *self){
                return !(*self);
            }

using QuantLib::FixedDividend;
using QuantLib::FractionalDividend;
using QuantLib::DividendSchedule;

typedef boost::shared_ptr<Dividend> FixedDividendPtr;
typedef boost::shared_ptr<Dividend> FractionalDividendPtr;

SWIGINTERN FixedDividendPtr *new_FixedDividendPtr(Real amount,Date const &date){
            return new FixedDividendPtr(new FixedDividend(amount,date));
        }
SWIGINTERN FractionalDividendPtr *new_FractionalDividendPtr(Rate rate,Date const &date){
            return new FractionalDividendPtr(
                                     new FractionalDividend(rate,date));
        }

using QuantLib::ConvertibleZeroCouponBond;
using QuantLib::ConvertibleFixedCouponBond;
using QuantLib::ConvertibleFloatingRateBond;
using QuantLib::BinomialConvertibleEngine;
typedef boost::shared_ptr<Instrument> ConvertibleZeroCouponBondPtr;
typedef boost::shared_ptr<Instrument> ConvertibleFixedCouponBondPtr;
typedef boost::shared_ptr<Instrument> ConvertibleFloatingRateBondPtr;
typedef boost::shared_ptr<PricingEngine> BinomialConvertibleEnginePtr;

SWIGINTERN ConvertibleZeroCouponBondPtr *new_ConvertibleZeroCouponBondPtr__SWIG_0(boost::shared_ptr<StochasticProcess > const &process,boost::shared_ptr<Exercise > const &exercise,boost::shared_ptr<PricingEngine > const &engine,Real conversionRatio,DividendSchedule const &dividends,CallabilitySchedule const &callability,Handle<Quote > const &creditSpread,Date const &issueDate,Integer settlementDays,DayCounter const &dayCounter,Schedule const &schedule,Real redemption=100){
            return new ConvertibleZeroCouponBondPtr(
                     new ConvertibleZeroCouponBond(process, exercise, engine,
                                                   conversionRatio, dividends,
                                                   callability, creditSpread,
                                                   issueDate, settlementDays,
                                                   dayCounter, schedule,
                                                   redemption));
        }
SWIGINTERN ConvertibleFixedCouponBondPtr *new_ConvertibleFixedCouponBondPtr__SWIG_0(boost::shared_ptr<StochasticProcess > const &process,boost::shared_ptr<Exercise > const &exercise,boost::shared_ptr<PricingEngine > const &engine,Real conversionRatio,DividendSchedule const &dividends,CallabilitySchedule const &callability,Handle<Quote > const &creditSpread,Date const &issueDate,Integer settlementDays,std::vector<Rate > const &coupons,DayCounter const &dayCounter,Schedule const &schedule,Real redemption=100){
            return new ConvertibleFixedCouponBondPtr(
                    new ConvertibleFixedCouponBond(process, exercise, engine,
                                                   conversionRatio, dividends,
                                                   callability, creditSpread,
                                                   issueDate, settlementDays,
                                                   coupons, dayCounter,
                                                   schedule, redemption));
        }
SWIGINTERN ConvertibleFloatingRateBondPtr *new_ConvertibleFloatingRateBondPtr__SWIG_0(boost::shared_ptr<StochasticProcess > const &process,boost::shared_ptr<Exercise > const &exercise,boost::shared_ptr<PricingEngine > const &engine,Real conversionRatio,DividendSchedule const &dividends,CallabilitySchedule const &callability,Handle<Quote > const &creditSpread,Date const &issueDate,Integer settlementDays,XiborPtr const &index,Integer fixingDays,std::vector<Spread > const &spreads,DayCounter const &dayCounter,Schedule const &schedule,Real redemption=100){
            boost::shared_ptr<Xibor> libor =
                boost::dynamic_pointer_cast<Xibor>(index);
            return new ConvertibleFloatingRateBondPtr(
                   new ConvertibleFloatingRateBond(process, exercise, engine,
                                                   conversionRatio, dividends,
                                                   callability, creditSpread,
                                                   issueDate, settlementDays,
                                                   libor, fixingDays, spreads,
                                                   dayCounter, schedule,
                                                   redemption));
        }
SWIGINTERN BinomialConvertibleEnginePtr *new_BinomialConvertibleEnginePtr(std::string const &type,Size steps){
            std::string s = QuantLib::lowercase(type);
            if (s == "crr" || s == "coxrossrubinstein")
                return new BinomialConvertibleEnginePtr(
                    new BinomialConvertibleEngine<CoxRossRubinstein>(steps));
            else if (s == "jr" || s == "jarrowrudd")
                return new BinomialConvertibleEnginePtr(
                    new BinomialConvertibleEngine<JarrowRudd>(steps));
            else if (s == "eqp")
                return new BinomialConvertibleEnginePtr(
                    new BinomialConvertibleEngine<AdditiveEQPBinomialTree>(
                                                                      steps));
            else if (s == "trigeorgis")
                return new BinomialConvertibleEnginePtr(
                    new BinomialConvertibleEngine<Trigeorgis>(steps));
            else if (s == "tian")
                return new BinomialConvertibleEnginePtr(
                    new BinomialConvertibleEngine<Tian>(steps));
            else if (s == "lr" || s == "leisenreimer")
                return new BinomialConvertibleEnginePtr(
                    new BinomialConvertibleEngine<LeisenReimer>(steps));
            else
                QL_FAIL("unknown binomial engine type: "+s);
        }

using QuantLib::InterpolatedDiscountCurve;


typedef boost::shared_ptr<YieldTermStructure> DiscountCurvePtr;

SWIGINTERN DiscountCurvePtr *new_DiscountCurvePtr__SWIG_0(std::vector<Date > const &dates,std::vector<DiscountFactor > const &discounts,DayCounter const &dayCounter,LogLinear const &i=LogLinear()){
            return new DiscountCurvePtr(
                new InterpolatedDiscountCurve<LogLinear>(dates,discounts,
                                                            dayCounter,i));
        }
SWIGINTERN std::vector<Date > const &DiscountCurvePtr_dates(DiscountCurvePtr *self){
            typedef InterpolatedDiscountCurve<LogLinear> DiscountCurve;
            return boost::dynamic_pointer_cast<DiscountCurve>(*self)->dates();
        }
SWIGINTERN std::vector<DiscountFactor > const &DiscountCurvePtr_discounts(DiscountCurvePtr *self){
            typedef InterpolatedDiscountCurve<LogLinear> DiscountCurve;
            return boost::dynamic_pointer_cast<DiscountCurve>(*self)->discounts();
        }
SWIGINTERN std::vector<std::pair<Date,DiscountFactor > > DiscountCurvePtr_nodes(DiscountCurvePtr *self){
            typedef InterpolatedDiscountCurve<LogLinear> DiscountCurve;
            return boost::dynamic_pointer_cast<DiscountCurve>(*self)->nodes();
        }

using QuantLib::NormalDistribution;
using QuantLib::CumulativeNormalDistribution;
using QuantLib::MoroInverseCumulativeNormal;
using QuantLib::InverseCumulativeNormal;


using QuantLib::Money;

SWIGINTERN void Money_setConversionType(Money::ConversionType type){
            Money::conversionType = type;
        }
SWIGINTERN void Money_setBaseCurrency(Currency const &c){
            Money::baseCurrency = c;
        }

using QuantLib::ExchangeRate;
using QuantLib::ExchangeRateManager;


using QuantLib::InterpolatedForwardCurve;


typedef boost::shared_ptr<YieldTermStructure> ForwardCurvePtr;

SWIGINTERN ForwardCurvePtr *new_ForwardCurvePtr__SWIG_0(std::vector<Date > const &dates,std::vector<Rate > const &forwards,DayCounter const &dayCounter,BackwardFlat const &i=BackwardFlat()){
            return new ForwardCurvePtr(
                new InterpolatedForwardCurve<BackwardFlat>(dates,forwards,
                                                           dayCounter,i));
        }
SWIGINTERN std::vector<Date > const &ForwardCurvePtr_dates(ForwardCurvePtr *self){
            typedef InterpolatedForwardCurve<BackwardFlat> ForwardCurve;
            return boost::dynamic_pointer_cast<ForwardCurve>(*self)->dates();
        }
SWIGINTERN std::vector<Rate > const &ForwardCurvePtr_forwards(ForwardCurvePtr *self){
            typedef InterpolatedForwardCurve<BackwardFlat> ForwardCurve;
            return boost::dynamic_pointer_cast<ForwardCurve>(*self)->forwards();
        }
SWIGINTERN std::vector<std::pair<Date,Rate > > ForwardCurvePtr_nodes(ForwardCurvePtr *self){
            typedef InterpolatedForwardCurve<BackwardFlat> ForwardCurve;
            return boost::dynamic_pointer_cast<ForwardCurve>(*self)->nodes();
        }

using QuantLib::TimeGrid;

SWIGINTERN TimeGrid *new_TimeGrid__SWIG_2(std::vector<Time > const &times){
            return new TimeGrid(times.begin(), times.end());
        }
SWIGINTERN TimeGrid *new_TimeGrid__SWIG_3(std::vector<Time > const &times,Size steps){
            return new TimeGrid(times.begin(), times.end(), steps);
        }

using QuantLib::SegmentIntegral;
using QuantLib::TrapezoidIntegral;
using QuantLib::SimpsonIntegral;
using QuantLib::KronrodIntegral;


using QuantLib::Sample;

using QuantLib::LecuyerUniformRng;
using QuantLib::KnuthUniformRng;
using QuantLib::MersenneTwisterUniformRng;

typedef QuantLib::PseudoRandom::urng_type UniformRandomGenerator;

using QuantLib::CLGaussianRng;
using QuantLib::BoxMullerGaussianRng;
using QuantLib::InverseCumulativeRng;

typedef QuantLib::PseudoRandom::rng_type GaussianRandomGenerator;

using QuantLib::RandomSequenceGenerator;

typedef QuantLib::PseudoRandom::ursg_type UniformRandomSequenceGenerator;

using QuantLib::HaltonRsg;
using QuantLib::SobolRsg;

typedef QuantLib::LowDiscrepancy::ursg_type
    UniformLowDiscrepancySequenceGenerator;

using QuantLib::InverseCumulativeRsg;

typedef QuantLib::PseudoRandom::rsg_type GaussianRandomSequenceGenerator;
typedef QuantLib::LowDiscrepancy::rsg_type
    GaussianLowDiscrepancySequenceGenerator;

SWIGINTERN double Sample_Sl_Real_Sg__value(Sample<Real > *self){ return self->value; }
SWIGINTERN Real Sample_Sl_Real_Sg__weight(Sample<Real > *self){ return self->weight; }
SWIGINTERN Array Sample_Sl_Array_Sg__value(Sample<Array > *self){ return self->value; }
SWIGINTERN Real Sample_Sl_Array_Sg__weight(Sample<Array > *self){ return self->weight; }

Matrix getCovariance(const Array& volatilities, const Matrix& correlations) {
    return QuantLib::getCovariance(volatilities.begin(),
                                   volatilities.end(),
                                   correlations);
}


using QuantLib::Path;


typedef QuantLib::PathGenerator<GaussianRandomSequenceGenerator>
    GaussianPathGenerator;

SWIGINTERN Path Sample_Sl_Path_Sg__value(Sample<Path > *self){ return self->value; }
SWIGINTERN Real Sample_Sl_Path_Sg__weight(Sample<Path > *self){ return self->weight; }
SWIGINTERN GaussianPathGenerator *new_GaussianPathGenerator(StochasticProcess1DPtr const &process,Time length,Size steps,GaussianRandomSequenceGenerator const &rsg,bool brownianBridge){
            boost::shared_ptr<StochasticProcess1D> process1d =
                boost::dynamic_pointer_cast<StochasticProcess1D>(process);
            return new GaussianPathGenerator(process1d,length,steps,
                                             rsg,brownianBridge);
        }

using QuantLib::MultiPath;


typedef QuantLib::MultiPathGenerator<GaussianRandomSequenceGenerator>
    GaussianMultiPathGenerator;

SWIGINTERN MultiPath Sample_Sl_MultiPath_Sg__value(Sample<MultiPath > *self){ return self->value; }
SWIGINTERN Real Sample_Sl_MultiPath_Sg__weight(Sample<MultiPath > *self){ return self->weight; }
SWIGINTERN GaussianMultiPathGenerator *new_GaussianMultiPathGenerator__SWIG_0(boost::shared_ptr<StochasticProcess > const &process,std::vector<Time > const &times,GaussianRandomSequenceGenerator const &generator,bool brownianBridge=false){
          return new GaussianMultiPathGenerator(process,
                                                QuantLib::TimeGrid(
                                                    times.begin(),
                                                    times.end()),
                                                generator,
                                                brownianBridge);
      }

typedef QuantLib::BoundaryCondition<QuantLib::TridiagonalOperator>
		BoundaryCondition;

SWIGINTERN bool boost_shared_ptr_Sl_BoundaryCondition_Sg__isNull(boost::shared_ptr<BoundaryCondition > *self){
                return !(*self);
            }

using QuantLib::NeumannBC;
using QuantLib::DirichletBC;
typedef boost::shared_ptr<BoundaryCondition> NeumannBCPtr;
typedef boost::shared_ptr<BoundaryCondition> DirichletBCPtr;

SWIGINTERN NeumannBCPtr *new_NeumannBCPtr(Real value,BoundaryCondition::Side side){
            return new NeumannBCPtr(new NeumannBC(value, side));
        }
SWIGINTERN DirichletBCPtr *new_DirichletBCPtr(Real value,BoundaryCondition::Side side){
            return new DirichletBCPtr(new DirichletBC(value, side));
        }

using QuantLib::TridiagonalOperator;


using QuantLib::DPlus;
using QuantLib::DMinus;
using QuantLib::DZero;
using QuantLib::DPlusDMinus;


using QuantLib::SymmetricEigenvalues;
using QuantLib::SymmetricEigenvectors;


using QuantLib::Bisection;
using QuantLib::Brent;
using QuantLib::FalsePosition;
using QuantLib::Newton;
using QuantLib::NewtonSafe;
using QuantLib::Ridder;
using QuantLib::Secant;


using QuantLib::Constraint;
using QuantLib::BoundaryConstraint;
using QuantLib::NoConstraint;
using QuantLib::PositiveConstraint;


using QuantLib::EndCriteria;


using QuantLib::OptimizationMethod;
using QuantLib::ConjugateGradient;
using QuantLib::Simplex;
using QuantLib::SteepestDescent;


using QuantLib::Problem;


    class Optimizer {};


using QuantLib::PlainVanillaPayoff;
using QuantLib::PercentageStrikePayoff;
using QuantLib::CashOrNothingPayoff;
using QuantLib::AssetOrNothingPayoff;
using QuantLib::SuperSharePayoff;
using QuantLib::GapPayoff;
typedef boost::shared_ptr<Payoff> PlainVanillaPayoffPtr;
typedef boost::shared_ptr<Payoff> PercentageStrikePayoffPtr;
typedef boost::shared_ptr<Payoff> CashOrNothingPayoffPtr;
typedef boost::shared_ptr<Payoff> AssetOrNothingPayoffPtr;
typedef boost::shared_ptr<Payoff> SuperSharePayoffPtr;
typedef boost::shared_ptr<Payoff> GapPayoffPtr;

SWIGINTERN PlainVanillaPayoffPtr *new_PlainVanillaPayoffPtr(Option::Type type,Real strike){
            return new PlainVanillaPayoffPtr(
                                        new PlainVanillaPayoff(type, strike));
        }
SWIGINTERN PercentageStrikePayoffPtr *new_PercentageStrikePayoffPtr(Option::Type type,Real moneyness){
            return new PercentageStrikePayoffPtr(
                                 new PercentageStrikePayoff(type, moneyness));
        }
SWIGINTERN CashOrNothingPayoffPtr *new_CashOrNothingPayoffPtr(Option::Type type,Real strike,Real payoff){
            return new CashOrNothingPayoffPtr(
                               new CashOrNothingPayoff(type, strike, payoff));
        }
SWIGINTERN AssetOrNothingPayoffPtr *new_AssetOrNothingPayoffPtr(Option::Type type,Real strike){
            return new AssetOrNothingPayoffPtr(
                                      new AssetOrNothingPayoff(type, strike));
        }
SWIGINTERN SuperSharePayoffPtr *new_SuperSharePayoffPtr(Option::Type type,Real strike,Real increment){
            return new SuperSharePayoffPtr(
                               new SuperSharePayoff(type, strike, increment));
        }
SWIGINTERN GapPayoffPtr *new_GapPayoffPtr(Option::Type type,Real strike,Real strikePayoff){
            return new GapPayoffPtr(
                               new GapPayoff(type, strike, strikePayoff));
        }

using QuantLib::RateHelper;
using QuantLib::DepositRateHelper;
using QuantLib::FraRateHelper;
using QuantLib::FuturesRateHelper;
using QuantLib::SwapRateHelper;
using QuantLib::FixedCouponBondHelper;
typedef boost::shared_ptr<RateHelper> DepositRateHelperPtr;
typedef boost::shared_ptr<RateHelper> FraRateHelperPtr;
typedef boost::shared_ptr<RateHelper> FuturesRateHelperPtr;
typedef boost::shared_ptr<RateHelper> SwapRateHelperPtr;
typedef boost::shared_ptr<RateHelper> FixedCouponBondHelperPtr;

SWIGINTERN bool boost_shared_ptr_Sl_RateHelper_Sg__isNull(boost::shared_ptr<RateHelper > *self){
                return !(*self);
            }
SWIGINTERN DepositRateHelperPtr *new_DepositRateHelperPtr__SWIG_0(Handle<Quote > const &rate,Integer n,TimeUnit units,Integer settlementDays,Calendar const &calendar,BusinessDayConvention convention,DayCounter const &dayCounter){
            return new DepositRateHelperPtr(
                new DepositRateHelper(rate,n,units,settlementDays,
                                      calendar,convention,dayCounter));
        }
SWIGINTERN DepositRateHelperPtr *new_DepositRateHelperPtr__SWIG_1(Rate rate,Integer n,TimeUnit units,Integer settlementDays,Calendar const &calendar,BusinessDayConvention convention,DayCounter const &dayCounter){
            return new DepositRateHelperPtr(
                new DepositRateHelper(rate,n,units,settlementDays,
                                      calendar,convention,dayCounter));
        }
SWIGINTERN DepositRateHelperPtr *new_DepositRateHelperPtr__SWIG_2(Handle<Quote > const &rate,Period const &tenor,Integer settlementDays,Calendar const &calendar,BusinessDayConvention convention,DayCounter const &dayCounter){
            return new DepositRateHelperPtr(
                new DepositRateHelper(rate,tenor,settlementDays,
                                      calendar,convention,dayCounter));
        }
SWIGINTERN DepositRateHelperPtr *new_DepositRateHelperPtr__SWIG_3(Rate rate,Period const &tenor,Integer settlementDays,Calendar const &calendar,BusinessDayConvention convention,DayCounter const &dayCounter){
            return new DepositRateHelperPtr(
                new DepositRateHelper(rate,tenor,settlementDays,
                                      calendar,convention,dayCounter));
        }
SWIGINTERN FraRateHelperPtr *new_FraRateHelperPtr__SWIG_0(Handle<Quote > const &rate,Integer monthsToStart,Integer monthsToEnd,Integer settlementDays,Calendar const &calendar,BusinessDayConvention convention,DayCounter const &dayCounter){
            return new FraRateHelperPtr(
                new FraRateHelper(rate,monthsToStart,monthsToEnd,
                                  settlementDays,calendar,convention,
                                  dayCounter));
        }
SWIGINTERN FraRateHelperPtr *new_FraRateHelperPtr__SWIG_1(Rate rate,Integer monthsToStart,Integer monthsToEnd,Integer settlementDays,Calendar const &calendar,BusinessDayConvention convention,DayCounter const &dayCounter){
            return new FraRateHelperPtr(
                new FraRateHelper(rate,monthsToStart,monthsToEnd,
                                  settlementDays,calendar,convention,
                                  dayCounter));
        }
SWIGINTERN FuturesRateHelperPtr *new_FuturesRateHelperPtr__SWIG_0(Handle<Quote > const &price,Date const &immDate,Integer nMonths,Calendar const &calendar,BusinessDayConvention convention,DayCounter const &dayCounter,Handle<Quote > const &convexityAdjustment){
            return new FuturesRateHelperPtr(
                new FuturesRateHelper(price,immDate,nMonths,
                                      calendar,convention,dayCounter,
                                      convexityAdjustment));
        }
SWIGINTERN FuturesRateHelperPtr *new_FuturesRateHelperPtr__SWIG_1(Handle<Quote > const &price,Date const &immDate,Integer nMonths,Calendar const &calendar,BusinessDayConvention convention,DayCounter const &dayCounter,Rate convexityAdjustment=0.0){
            return new FuturesRateHelperPtr(
                new FuturesRateHelper(price,immDate,nMonths,
                                      calendar,convention,dayCounter,
                                      convexityAdjustment));
        }
SWIGINTERN FuturesRateHelperPtr *new_FuturesRateHelperPtr__SWIG_3(Real price,Date const &immDate,Integer nMonths,Calendar const &calendar,BusinessDayConvention convention,DayCounter const &dayCounter,Rate convexityAdjustment=0.0){
            return new FuturesRateHelperPtr(
                new FuturesRateHelper(price,immDate,nMonths,
                                      calendar,convention,dayCounter,
                                      convexityAdjustment));
        }
SWIGINTERN FuturesRateHelperPtr *new_FuturesRateHelperPtr__SWIG_5(Handle<Quote > const &price,Date const &immDate,Date const &matDate,Calendar const &calendar,BusinessDayConvention convention,DayCounter const &dayCounter){
            return new FuturesRateHelperPtr(
                new FuturesRateHelper(price,immDate,matDate,
                                      calendar,convention,dayCounter));
        }
SWIGINTERN SwapRateHelperPtr *new_SwapRateHelperPtr__SWIG_0(Handle<Quote > const &rate,Integer n,TimeUnit units,Integer settlementDays,Calendar const &calendar,Frequency fixedFrequency,BusinessDayConvention fixedConvention,DayCounter const &fixedDayCount,Frequency floatingFrequency,BusinessDayConvention floatingConvention,DayCounter const &floatingDayCount){
            return new SwapRateHelperPtr(
                new SwapRateHelper(rate, n, units, settlementDays,
                                   calendar, fixedFrequency, fixedConvention,
                                   fixedDayCount, floatingFrequency,
                                   floatingConvention,
                                   floatingDayCount));
        }
SWIGINTERN SwapRateHelperPtr *new_SwapRateHelperPtr__SWIG_1(Rate rate,Integer n,TimeUnit units,Integer settlementDays,Calendar const &calendar,Frequency fixedFrequency,BusinessDayConvention fixedConvention,DayCounter const &fixedDayCount,Frequency floatingFrequency,BusinessDayConvention floatingConvention,DayCounter const &floatingDayCount){
            return new SwapRateHelperPtr(
                new SwapRateHelper(rate, n, units, settlementDays,
                                   calendar, fixedFrequency, fixedConvention,
                                   fixedDayCount, floatingFrequency,
                                   floatingConvention,
                                   floatingDayCount));
        }
SWIGINTERN SwapRateHelperPtr *new_SwapRateHelperPtr__SWIG_2(Handle<Quote > const &rate,Period const &tenor,Integer settlementDays,Calendar const &calendar,Frequency fixedFrequency,BusinessDayConvention fixedConvention,DayCounter const &fixedDayCount,XiborPtr const &index){
            boost::shared_ptr<Xibor> libor =
                boost::dynamic_pointer_cast<Xibor>(index);
            return new SwapRateHelperPtr(
                new SwapRateHelper(rate, tenor, settlementDays,
                                   calendar, fixedFrequency, fixedConvention,
                                   fixedDayCount, libor));
        }
SWIGINTERN SwapRateHelperPtr *new_SwapRateHelperPtr__SWIG_3(Rate rate,Period const &tenor,Integer settlementDays,Calendar const &calendar,Frequency fixedFrequency,BusinessDayConvention fixedConvention,DayCounter const &fixedDayCount,XiborPtr const &index){
            boost::shared_ptr<Xibor> libor =
                boost::dynamic_pointer_cast<Xibor>(index);
            return new SwapRateHelperPtr(
                new SwapRateHelper(rate, tenor, settlementDays,
                                   calendar, fixedFrequency, fixedConvention,
                                   fixedDayCount, libor));
        }
SWIGINTERN FixedCouponBondHelperPtr *new_FixedCouponBondHelperPtr__SWIG_0(Handle<Quote > const &cleanPrice,Date const &issueDate,Date const &datedDate,Date const &maturityDate,Integer settlementDays,std::vector<Rate > const &coupons,Frequency frequency,Calendar const &calendar,DayCounter const &dayCounter,BusinessDayConvention accrualConvention=Following,BusinessDayConvention paymentConvention=Following,Real redemption=100.0,Date const &stub=Date(),bool fromEnd=true){
            return new FixedCouponBondHelperPtr(
                new FixedCouponBondHelper(cleanPrice, issueDate, datedDate,
                                          maturityDate, settlementDays,
                                          coupons, frequency,
                                          calendar,
                                          dayCounter,
                                          accrualConvention,
                                          paymentConvention,
                                          redemption,
                                          stub, fromEnd));
        }
SWIGINTERN std::vector<boost::shared_ptr<RateHelper > > *new_std_vector_Sl_boost_shared_ptr_Sl_RateHelper_Sg__Sg___SWIG_1(int capacity){
        std::vector<boost::shared_ptr<RateHelper> >* pv = 0;
        if (capacity >= 0) {
          pv = new std::vector<boost::shared_ptr<RateHelper> >();
          pv->reserve(capacity);
       } else {
          throw std::out_of_range("capacity");
       }
       return pv;
      }
SWIGINTERN boost::shared_ptr<RateHelper > std_vector_Sl_boost_shared_ptr_Sl_RateHelper_Sg__Sg__getitemcopy(std::vector<boost::shared_ptr<RateHelper > > *self,int index){
        if (index>=0 && index<(int)self->size())
          return (*self)[index];
        else
          throw std::out_of_range("index");
      }
SWIGINTERN std::vector<boost::shared_ptr<RateHelper > >::const_reference std_vector_Sl_boost_shared_ptr_Sl_RateHelper_Sg__Sg__getitem(std::vector<boost::shared_ptr<RateHelper > > *self,int index){
        if (index>=0 && index<(int)self->size())
          return (*self)[index];
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_RateHelper_Sg__Sg__setitem(std::vector<boost::shared_ptr<RateHelper > > *self,int index,std::vector<boost::shared_ptr<RateHelper > >::value_type const &value){
        if (index>=0 && index<(int)self->size())
          (*self)[index] = value;
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_RateHelper_Sg__Sg__AddRange(std::vector<boost::shared_ptr<RateHelper > > *self,std::vector<boost::shared_ptr<RateHelper > > const &values){
        self->insert(self->end(), values.begin(), values.end());
      }
SWIGINTERN std::vector<boost::shared_ptr<RateHelper > > *std_vector_Sl_boost_shared_ptr_Sl_RateHelper_Sg__Sg__GetRange(std::vector<boost::shared_ptr<RateHelper > > *self,int index,int count){
        if (index < 0)
          throw std::out_of_range("index");
        if (count < 0)
          throw std::out_of_range("count");
        if (index >= (int)self->size()+1 || index+count > (int)self->size())
          throw std::invalid_argument("invalid range");
        return new std::vector<boost::shared_ptr<RateHelper> >(self->begin()+index, self->begin()+index+count);
      }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_RateHelper_Sg__Sg__Insert(std::vector<boost::shared_ptr<RateHelper > > *self,int index,std::vector<boost::shared_ptr<RateHelper > >::value_type const &value){
        if (index>=0 && index<(int)self->size()+1)
          self->insert(self->begin()+index, value);
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_RateHelper_Sg__Sg__InsertRange(std::vector<boost::shared_ptr<RateHelper > > *self,int index,std::vector<boost::shared_ptr<RateHelper > > const &values){
        if (index>=0 && index<(int)self->size()+1)
          self->insert(self->begin()+index, values.begin(), values.end());
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_RateHelper_Sg__Sg__RemoveAt(std::vector<boost::shared_ptr<RateHelper > > *self,int index){
        if (index>=0 && index<(int)self->size())
          self->erase(self->begin() + index);
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_RateHelper_Sg__Sg__RemoveRange(std::vector<boost::shared_ptr<RateHelper > > *self,int index,int count){
        if (index < 0)
          throw std::out_of_range("index");
        if (count < 0)
          throw std::out_of_range("count");
        if (index >= (int)self->size()+1 || index+count > (int)self->size())
          throw std::invalid_argument("invalid range");
        self->erase(self->begin()+index, self->begin()+index+count);
      }
SWIGINTERN std::vector<boost::shared_ptr<RateHelper > > *std_vector_Sl_boost_shared_ptr_Sl_RateHelper_Sg__Sg__Repeat(std::vector<boost::shared_ptr<RateHelper > >::value_type const &value,int count){
        if (count < 0)
          throw std::out_of_range("count");
        return new std::vector<boost::shared_ptr<RateHelper> >(count, value);
      }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_RateHelper_Sg__Sg__Reverse__SWIG_0(std::vector<boost::shared_ptr<RateHelper > > *self){
        std::reverse(self->begin(), self->end());
      }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_RateHelper_Sg__Sg__Reverse__SWIG_1(std::vector<boost::shared_ptr<RateHelper > > *self,int index,int count){
        if (index < 0)
          throw std::out_of_range("index");
        if (count < 0)
          throw std::out_of_range("count");
        if (index >= (int)self->size()+1 || index+count > (int)self->size())
          throw std::invalid_argument("invalid range");
        std::reverse(self->begin()+index, self->begin()+index+count);
      }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_RateHelper_Sg__Sg__SetRange(std::vector<boost::shared_ptr<RateHelper > > *self,int index,std::vector<boost::shared_ptr<RateHelper > > const &values){
        if (index < 0)
          throw std::out_of_range("index");
        if (index+values.size() > self->size())
          throw std::out_of_range("index");
        std::copy(values.begin(), values.end(), self->begin()+index);
      }
SWIGINTERN bool std_vector_Sl_boost_shared_ptr_Sl_RateHelper_Sg__Sg__Contains(std::vector<boost::shared_ptr<RateHelper > > *self,std::vector<boost::shared_ptr<RateHelper > >::value_type const &value){
        return std::find(self->begin(), self->end(), value) != self->end();
      }
SWIGINTERN int std_vector_Sl_boost_shared_ptr_Sl_RateHelper_Sg__Sg__IndexOf(std::vector<boost::shared_ptr<RateHelper > > *self,std::vector<boost::shared_ptr<RateHelper > >::value_type const &value){
        int index = -1;
        std::vector<boost::shared_ptr<RateHelper> >::iterator it = std::find(self->begin(), self->end(), value);
        if (it != self->end())
          index = it - self->begin();
        return index;
      }
SWIGINTERN int std_vector_Sl_boost_shared_ptr_Sl_RateHelper_Sg__Sg__LastIndexOf(std::vector<boost::shared_ptr<RateHelper > > *self,std::vector<boost::shared_ptr<RateHelper > >::value_type const &value){
        int index = -1;
        std::vector<boost::shared_ptr<RateHelper> >::reverse_iterator rit = std::find(self->rbegin(), self->rend(), value);
        if (rit != self->rend())
          index = self->rend() - 1 - rit;
        return index;
      }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_RateHelper_Sg__Sg__Remove(std::vector<boost::shared_ptr<RateHelper > > *self,std::vector<boost::shared_ptr<RateHelper > >::value_type const &value){
        std::vector<boost::shared_ptr<RateHelper> >::iterator it = std::find(self->begin(), self->end(), value);
        if (it != self->end())
          self->erase(it);
      }

using QuantLib::Discount;
using QuantLib::ZeroYield;
using QuantLib::ForwardRate;


using QuantLib::PiecewiseYieldCurve;


typedef boost::shared_ptr<YieldTermStructure> PiecewiseFlatForwardPtr;

SWIGINTERN PiecewiseFlatForwardPtr *new_PiecewiseFlatForwardPtr__SWIG_0(Date const &referenceDate,std::vector<boost::shared_ptr<RateHelper > > const &instruments,DayCounter const &dayCounter,Real accuracy=1.0e-12,LogLinear const &i=LogLinear()){
            return new PiecewiseFlatForwardPtr(
                new PiecewiseYieldCurve<Discount,LogLinear>(
                                                    referenceDate,instruments,
                                                    dayCounter,accuracy,i));
        }
SWIGINTERN PiecewiseFlatForwardPtr *new_PiecewiseFlatForwardPtr__SWIG_3(Integer settlementDays,Calendar const &calendar,std::vector<boost::shared_ptr<RateHelper > > const &instruments,DayCounter const &dayCounter,Real accuracy=1.0e-12,LogLinear const &i=LogLinear()){
            return new PiecewiseFlatForwardPtr(
                new PiecewiseYieldCurve<Discount,LogLinear>(
                                        settlementDays, calendar, instruments,
                                        dayCounter, accuracy, i));
        }
SWIGINTERN std::vector<Date > const &PiecewiseFlatForwardPtr_dates(PiecewiseFlatForwardPtr *self){
            typedef PiecewiseYieldCurve<Discount,LogLinear> PiecewiseFlatForward;
            return boost::dynamic_pointer_cast<PiecewiseFlatForward>(*self)->dates();
        }
SWIGINTERN std::vector<Time > const &PiecewiseFlatForwardPtr_times(PiecewiseFlatForwardPtr *self){
            typedef PiecewiseYieldCurve<Discount,LogLinear> PiecewiseFlatForward;
            return boost::dynamic_pointer_cast<PiecewiseFlatForward>(*self)->times();
        }
SWIGINTERN std::vector<std::pair<Date,Real > > PiecewiseFlatForwardPtr_nodes(PiecewiseFlatForwardPtr *self){
            typedef PiecewiseYieldCurve<Discount,LogLinear> PiecewiseFlatForward;
            return boost::dynamic_pointer_cast<PiecewiseFlatForward>(*self)->nodes();
        }

using QuantLib::Settings;

SWIGINTERN Date Settings_getEvaluationDate(Settings *self){
            return self->evaluationDate();
        }
SWIGINTERN void Settings_setEvaluationDate(Settings *self,Date const &d){
            self->evaluationDate() = d;
        }

using QuantLib::CalibrationHelper;
using QuantLib::SwaptionHelper;
using QuantLib::CapHelper;
typedef boost::shared_ptr<CalibrationHelper> SwaptionHelperPtr;
typedef boost::shared_ptr<CalibrationHelper> CapHelperPtr;

SWIGINTERN bool boost_shared_ptr_Sl_CalibrationHelper_Sg__isNull(boost::shared_ptr<CalibrationHelper > *self){
                return !(*self);
            }
SWIGINTERN SwaptionHelperPtr *new_SwaptionHelperPtr(Period const &maturity,Period const &length,Handle<Quote > const &volatility,XiborPtr const &index,Frequency fixedLegFrequency,DayCounter const &fixedLegDayCounter,DayCounter const &floatingLegDayCounter,Handle<YieldTermStructure > const &termStructure){
            boost::shared_ptr<Xibor> libor =
                boost::dynamic_pointer_cast<Xibor>(index);
            return new SwaptionHelperPtr(
                new SwaptionHelper(maturity,length,volatility,
                                   libor,fixedLegFrequency,
                                   fixedLegDayCounter,
                   floatingLegDayCounter,
                   termStructure));
        }
SWIGINTERN std::vector<Time > SwaptionHelperPtr_times(SwaptionHelperPtr *self){
            std::list<Time> l;
            (*self)->addTimesTo(l);
            std::vector<Time> v;
            std::copy(l.begin(),l.end(),std::back_inserter(v));
            return v;
        }
SWIGINTERN CapHelperPtr *new_CapHelperPtr(Period const &length,Handle<Quote > const &volatility,XiborPtr const &index,Frequency fixedLegFrequency,DayCounter const &fixedLegDayCounter,bool includeFirstSwaplet,Handle<YieldTermStructure > const &termStructure){
            boost::shared_ptr<Xibor> libor =
                boost::dynamic_pointer_cast<Xibor>(index);
            return new CapHelperPtr(
                new CapHelper(length,volatility,libor,fixedLegFrequency,
                              fixedLegDayCounter,includeFirstSwaplet,
                              termStructure));
        }
SWIGINTERN std::vector<Time > CapHelperPtr_times(CapHelperPtr *self){
            std::list<Time> l;
            (*self)->addTimesTo(l);
            std::vector<Time> v;
            std::copy(l.begin(),l.end(),std::back_inserter(v));
            return v;
        }
SWIGINTERN std::vector<boost::shared_ptr<CalibrationHelper > > *new_std_vector_Sl_boost_shared_ptr_Sl_CalibrationHelper_Sg__Sg___SWIG_1(int capacity){
        std::vector<boost::shared_ptr<CalibrationHelper> >* pv = 0;
        if (capacity >= 0) {
          pv = new std::vector<boost::shared_ptr<CalibrationHelper> >();
          pv->reserve(capacity);
       } else {
          throw std::out_of_range("capacity");
       }
       return pv;
      }
SWIGINTERN boost::shared_ptr<CalibrationHelper > std_vector_Sl_boost_shared_ptr_Sl_CalibrationHelper_Sg__Sg__getitemcopy(std::vector<boost::shared_ptr<CalibrationHelper > > *self,int index){
        if (index>=0 && index<(int)self->size())
          return (*self)[index];
        else
          throw std::out_of_range("index");
      }
SWIGINTERN std::vector<boost::shared_ptr<CalibrationHelper > >::const_reference std_vector_Sl_boost_shared_ptr_Sl_CalibrationHelper_Sg__Sg__getitem(std::vector<boost::shared_ptr<CalibrationHelper > > *self,int index){
        if (index>=0 && index<(int)self->size())
          return (*self)[index];
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_CalibrationHelper_Sg__Sg__setitem(std::vector<boost::shared_ptr<CalibrationHelper > > *self,int index,std::vector<boost::shared_ptr<CalibrationHelper > >::value_type const &value){
        if (index>=0 && index<(int)self->size())
          (*self)[index] = value;
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_CalibrationHelper_Sg__Sg__AddRange(std::vector<boost::shared_ptr<CalibrationHelper > > *self,std::vector<boost::shared_ptr<CalibrationHelper > > const &values){
        self->insert(self->end(), values.begin(), values.end());
      }
SWIGINTERN std::vector<boost::shared_ptr<CalibrationHelper > > *std_vector_Sl_boost_shared_ptr_Sl_CalibrationHelper_Sg__Sg__GetRange(std::vector<boost::shared_ptr<CalibrationHelper > > *self,int index,int count){
        if (index < 0)
          throw std::out_of_range("index");
        if (count < 0)
          throw std::out_of_range("count");
        if (index >= (int)self->size()+1 || index+count > (int)self->size())
          throw std::invalid_argument("invalid range");
        return new std::vector<boost::shared_ptr<CalibrationHelper> >(self->begin()+index, self->begin()+index+count);
      }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_CalibrationHelper_Sg__Sg__Insert(std::vector<boost::shared_ptr<CalibrationHelper > > *self,int index,std::vector<boost::shared_ptr<CalibrationHelper > >::value_type const &value){
        if (index>=0 && index<(int)self->size()+1)
          self->insert(self->begin()+index, value);
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_CalibrationHelper_Sg__Sg__InsertRange(std::vector<boost::shared_ptr<CalibrationHelper > > *self,int index,std::vector<boost::shared_ptr<CalibrationHelper > > const &values){
        if (index>=0 && index<(int)self->size()+1)
          self->insert(self->begin()+index, values.begin(), values.end());
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_CalibrationHelper_Sg__Sg__RemoveAt(std::vector<boost::shared_ptr<CalibrationHelper > > *self,int index){
        if (index>=0 && index<(int)self->size())
          self->erase(self->begin() + index);
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_CalibrationHelper_Sg__Sg__RemoveRange(std::vector<boost::shared_ptr<CalibrationHelper > > *self,int index,int count){
        if (index < 0)
          throw std::out_of_range("index");
        if (count < 0)
          throw std::out_of_range("count");
        if (index >= (int)self->size()+1 || index+count > (int)self->size())
          throw std::invalid_argument("invalid range");
        self->erase(self->begin()+index, self->begin()+index+count);
      }
SWIGINTERN std::vector<boost::shared_ptr<CalibrationHelper > > *std_vector_Sl_boost_shared_ptr_Sl_CalibrationHelper_Sg__Sg__Repeat(std::vector<boost::shared_ptr<CalibrationHelper > >::value_type const &value,int count){
        if (count < 0)
          throw std::out_of_range("count");
        return new std::vector<boost::shared_ptr<CalibrationHelper> >(count, value);
      }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_CalibrationHelper_Sg__Sg__Reverse__SWIG_0(std::vector<boost::shared_ptr<CalibrationHelper > > *self){
        std::reverse(self->begin(), self->end());
      }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_CalibrationHelper_Sg__Sg__Reverse__SWIG_1(std::vector<boost::shared_ptr<CalibrationHelper > > *self,int index,int count){
        if (index < 0)
          throw std::out_of_range("index");
        if (count < 0)
          throw std::out_of_range("count");
        if (index >= (int)self->size()+1 || index+count > (int)self->size())
          throw std::invalid_argument("invalid range");
        std::reverse(self->begin()+index, self->begin()+index+count);
      }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_CalibrationHelper_Sg__Sg__SetRange(std::vector<boost::shared_ptr<CalibrationHelper > > *self,int index,std::vector<boost::shared_ptr<CalibrationHelper > > const &values){
        if (index < 0)
          throw std::out_of_range("index");
        if (index+values.size() > self->size())
          throw std::out_of_range("index");
        std::copy(values.begin(), values.end(), self->begin()+index);
      }
SWIGINTERN bool std_vector_Sl_boost_shared_ptr_Sl_CalibrationHelper_Sg__Sg__Contains(std::vector<boost::shared_ptr<CalibrationHelper > > *self,std::vector<boost::shared_ptr<CalibrationHelper > >::value_type const &value){
        return std::find(self->begin(), self->end(), value) != self->end();
      }
SWIGINTERN int std_vector_Sl_boost_shared_ptr_Sl_CalibrationHelper_Sg__Sg__IndexOf(std::vector<boost::shared_ptr<CalibrationHelper > > *self,std::vector<boost::shared_ptr<CalibrationHelper > >::value_type const &value){
        int index = -1;
        std::vector<boost::shared_ptr<CalibrationHelper> >::iterator it = std::find(self->begin(), self->end(), value);
        if (it != self->end())
          index = it - self->begin();
        return index;
      }
SWIGINTERN int std_vector_Sl_boost_shared_ptr_Sl_CalibrationHelper_Sg__Sg__LastIndexOf(std::vector<boost::shared_ptr<CalibrationHelper > > *self,std::vector<boost::shared_ptr<CalibrationHelper > >::value_type const &value){
        int index = -1;
        std::vector<boost::shared_ptr<CalibrationHelper> >::reverse_iterator rit = std::find(self->rbegin(), self->rend(), value);
        if (rit != self->rend())
          index = self->rend() - 1 - rit;
        return index;
      }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_CalibrationHelper_Sg__Sg__Remove(std::vector<boost::shared_ptr<CalibrationHelper > > *self,std::vector<boost::shared_ptr<CalibrationHelper > >::value_type const &value){
        std::vector<boost::shared_ptr<CalibrationHelper> >::iterator it = std::find(self->begin(), self->end(), value);
        if (it != self->end())
          self->erase(it);
      }

using QuantLib::ShortRateModel;

SWIGINTERN bool boost_shared_ptr_Sl_ShortRateModel_Sg__isNull(boost::shared_ptr<ShortRateModel > *self){
                return !(*self);
            }
SWIGINTERN boost::shared_ptr<Observable > boost_shared_ptr_Sl_ShortRateModel_Sg__asObservable(boost::shared_ptr<ShortRateModel > *self){
        return boost::shared_ptr<Observable>(*self);
    }

using QuantLib::HullWhite;
using QuantLib::BlackKarasinski;
using QuantLib::G2;
typedef boost::shared_ptr<ShortRateModel> HullWhitePtr;
typedef boost::shared_ptr<ShortRateModel> BlackKarasinskiPtr;
typedef boost::shared_ptr<ShortRateModel> G2Ptr;

SWIGINTERN HullWhitePtr *new_HullWhitePtr__SWIG_0(Handle<YieldTermStructure > const &termStructure,Real a=0.1,Real sigma=0.01){
            return new HullWhitePtr(
                new HullWhite(termStructure, a, sigma));
        }
SWIGINTERN BlackKarasinskiPtr *new_BlackKarasinskiPtr__SWIG_0(Handle<YieldTermStructure > const &termStructure,Real a=0.1,Real sigma=0.1){
            return new BlackKarasinskiPtr(
                new BlackKarasinski(termStructure, a, sigma));
        }
SWIGINTERN G2Ptr *new_G2Ptr__SWIG_0(Handle<YieldTermStructure > const &termStructure,Real a=0.1,Real sigma=0.01,Real b=0.1,Real eta=0.01,Real rho=-0.75){
            return new G2Ptr(new G2(termStructure, a, sigma, b, eta, rho));
        }

using QuantLib::JamshidianSwaptionEngine;
using QuantLib::TreeSwaptionEngine;
using QuantLib::AnalyticCapFloorEngine;
using QuantLib::TreeCapFloorEngine;
using QuantLib::G2SwaptionEngine;
typedef boost::shared_ptr<PricingEngine> JamshidianSwaptionEnginePtr;
typedef boost::shared_ptr<PricingEngine> TreeSwaptionEnginePtr;
typedef boost::shared_ptr<PricingEngine> AnalyticCapFloorEnginePtr;
typedef boost::shared_ptr<PricingEngine> TreeCapFloorEnginePtr;
typedef boost::shared_ptr<PricingEngine> G2SwaptionEnginePtr;

SWIGINTERN JamshidianSwaptionEnginePtr *new_JamshidianSwaptionEnginePtr(boost::shared_ptr<ShortRateModel > const &model){
            using QuantLib::OneFactorAffineModel;
            boost::shared_ptr<OneFactorAffineModel> m =
                 boost::dynamic_pointer_cast<OneFactorAffineModel>(model);
            QL_REQUIRE(model, "affine model required");
            return new JamshidianSwaptionEnginePtr(
                                             new JamshidianSwaptionEngine(m));
        }
SWIGINTERN TreeSwaptionEnginePtr *new_TreeSwaptionEnginePtr__SWIG_0(boost::shared_ptr<ShortRateModel > const &model,Size timeSteps){
            return new TreeSwaptionEnginePtr(
                                     new TreeSwaptionEngine(model,timeSteps));
        }
SWIGINTERN TreeSwaptionEnginePtr *new_TreeSwaptionEnginePtr__SWIG_1(boost::shared_ptr<ShortRateModel > const &model,TimeGrid const &grid){
            return new TreeSwaptionEnginePtr(
                                     new TreeSwaptionEngine(model,grid));
        }
SWIGINTERN AnalyticCapFloorEnginePtr *new_AnalyticCapFloorEnginePtr(boost::shared_ptr<ShortRateModel > const &model){
            using QuantLib::OneFactorAffineModel;
            boost::shared_ptr<OneFactorAffineModel> m =
                 boost::dynamic_pointer_cast<OneFactorAffineModel>(model);
            QL_REQUIRE(model, "affine model required");
            return new AnalyticCapFloorEnginePtr(
                                           new AnalyticCapFloorEngine(m));
        }
SWIGINTERN TreeCapFloorEnginePtr *new_TreeCapFloorEnginePtr__SWIG_0(boost::shared_ptr<ShortRateModel > const &model,Size timeSteps){
            return new TreeCapFloorEnginePtr(
                                     new TreeCapFloorEngine(model,timeSteps));
        }
SWIGINTERN TreeCapFloorEnginePtr *new_TreeCapFloorEnginePtr__SWIG_1(boost::shared_ptr<ShortRateModel > const &model,TimeGrid const &grid){
            return new TreeCapFloorEnginePtr(
                                     new TreeCapFloorEngine(model,grid));
        }
SWIGINTERN G2SwaptionEnginePtr *new_G2SwaptionEnginePtr(boost::shared_ptr<ShortRateModel > const &model,Real range,Size intervals){
            boost::shared_ptr<G2> g2 =
                boost::dynamic_pointer_cast<G2>(model);
            return new G2SwaptionEnginePtr(
                                    new G2SwaptionEngine(g2,range,intervals));
        }

using QuantLib::Statistics;
using QuantLib::RiskStatistics;
using QuantLib::SequenceStatistics;

SWIGINTERN void Statistics_add__SWIG_2(Statistics *self,std::vector<Real > const &values){
            self->addSequence(values.begin(), values.end());
        }
SWIGINTERN void Statistics_add__SWIG_3(Statistics *self,std::vector<Real > const &values,std::vector<Real > const &weights){
            self->addSequence(values.begin(), values.end(), weights.begin());
        }

using QuantLib::TimeBasket;


using QuantLib::Swap;
using QuantLib::VanillaSwap;
typedef boost::shared_ptr<Instrument> SwapPtr;
typedef boost::shared_ptr<Instrument> VanillaSwapPtr;

SWIGINTERN SwapPtr *new_SwapPtr(std::vector<boost::shared_ptr<CashFlow > > const &firstLeg,std::vector<boost::shared_ptr<CashFlow > > const &secondLeg,Handle<YieldTermStructure > const &termStructure){
            return new SwapPtr(new Swap(firstLeg, secondLeg,
                                        termStructure));
        }
SWIGINTERN Date SwapPtr_startDate(SwapPtr *self){
            return boost::dynamic_pointer_cast<Swap>(*self)->startDate();
        }
SWIGINTERN Date SwapPtr_maturity(SwapPtr *self){
            return boost::dynamic_pointer_cast<Swap>(*self)->maturity();
        }
SWIGINTERN Real SwapPtr_firstLegBPS(SwapPtr *self){
            return boost::dynamic_pointer_cast<Swap>(*self)->firstLegBPS();
        }
SWIGINTERN Real SwapPtr_secondLegBPS(SwapPtr *self){
            return boost::dynamic_pointer_cast<Swap>(*self)->secondLegBPS();
        }
SWIGINTERN VanillaSwapPtr *new_VanillaSwapPtr(bool payFixedRate,Real nominal,Schedule const &fixedSchedule,Rate fixedRate,DayCounter const &fixedDayCount,Schedule const &floatSchedule,XiborPtr const &index,Integer indexFixingDays,Spread spread,DayCounter const &floatingDayCount,Handle<YieldTermStructure > const &termStructure){
            boost::shared_ptr<Xibor> libor =
                boost::dynamic_pointer_cast<Xibor>(index);
            return new VanillaSwapPtr(
                new VanillaSwap(payFixedRate,nominal,fixedSchedule,fixedRate,
                               fixedDayCount,floatSchedule,libor,
                               indexFixingDays,spread,
			       floatingDayCount,
			       termStructure));
        }
SWIGINTERN Rate VanillaSwapPtr_fairRate(VanillaSwapPtr *self){
            return boost::dynamic_pointer_cast<VanillaSwap>(*self)->fairRate();
        }
SWIGINTERN Spread VanillaSwapPtr_fairSpread(VanillaSwapPtr *self){
            return boost::dynamic_pointer_cast<VanillaSwap>(*self)
                 ->fairSpread();
        }
SWIGINTERN Real VanillaSwapPtr_fixedLegBPS(VanillaSwapPtr *self){
            return boost::dynamic_pointer_cast<VanillaSwap>(*self)
                 ->fixedLegBPS();
        }
SWIGINTERN Real VanillaSwapPtr_floatingLegBPS(VanillaSwapPtr *self){
            return boost::dynamic_pointer_cast<VanillaSwap>(*self)
                 ->floatingLegBPS();
        }

using QuantLib::Swaption;
typedef boost::shared_ptr<Instrument> SwaptionPtr;

SWIGINTERN SwaptionPtr *new_SwaptionPtr(VanillaSwapPtr const &simpleSwap,boost::shared_ptr<Exercise > const &exercise,Handle<YieldTermStructure > const &termStructure,boost::shared_ptr<PricingEngine > const &engine){
            boost::shared_ptr<VanillaSwap> swap =
                 boost::dynamic_pointer_cast<VanillaSwap>(simpleSwap);
            QL_REQUIRE(swap, "simple swap required");
            return new SwaptionPtr(new Swaption(swap,exercise,
                                                termStructure,engine));
        }

using QuantLib::BlackSwaptionEngine;
typedef boost::shared_ptr<PricingEngine> BlackSwaptionEnginePtr;

SWIGINTERN BlackSwaptionEnginePtr *new_BlackSwaptionEnginePtr(boost::shared_ptr<BlackModel > const &model){
            return new BlackSwaptionEnginePtr(new BlackSwaptionEngine(model));
        }

using QuantLib::TimeSeries;
using QuantLib::IntervalPrice;

SWIGINTERN TimeSeries<Real > *new_TimeSeries_Sl_Real_Sg___SWIG_1(std::vector<Date > const &d,std::vector<double > const &v){
            return new TimeSeries<double>(d.begin(), d.end(), v.begin());
        }
SWIGINTERN TimeSeries<IntervalPrice > *new_TimeSeries_Sl_IntervalPrice_Sg___SWIG_1(std::vector<Date > const &d,std::vector<IntervalPrice > const &v){
            return new TimeSeries<IntervalPrice>(d.begin(), d.end(), v.begin());
        }
SWIGINTERN std::vector<IntervalPrice > *new_std_vector_Sl_IntervalPrice_Sg___SWIG_1(int capacity){
        std::vector<IntervalPrice >* pv = 0;
        if (capacity >= 0) {
          pv = new std::vector<IntervalPrice >();
          pv->reserve(capacity);
       } else {
          throw std::out_of_range("capacity");
       }
       return pv;
      }
SWIGINTERN IntervalPrice std_vector_Sl_IntervalPrice_Sg__getitemcopy(std::vector<IntervalPrice > *self,int index){
        if (index>=0 && index<(int)self->size())
          return (*self)[index];
        else
          throw std::out_of_range("index");
      }
SWIGINTERN std::vector<IntervalPrice >::const_reference std_vector_Sl_IntervalPrice_Sg__getitem(std::vector<IntervalPrice > *self,int index){
        if (index>=0 && index<(int)self->size())
          return (*self)[index];
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_IntervalPrice_Sg__setitem(std::vector<IntervalPrice > *self,int index,std::vector<IntervalPrice >::value_type const &value){
        if (index>=0 && index<(int)self->size())
          (*self)[index] = value;
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_IntervalPrice_Sg__AddRange(std::vector<IntervalPrice > *self,std::vector<IntervalPrice > const &values){
        self->insert(self->end(), values.begin(), values.end());
      }
SWIGINTERN std::vector<IntervalPrice > *std_vector_Sl_IntervalPrice_Sg__GetRange(std::vector<IntervalPrice > *self,int index,int count){
        if (index < 0)
          throw std::out_of_range("index");
        if (count < 0)
          throw std::out_of_range("count");
        if (index >= (int)self->size()+1 || index+count > (int)self->size())
          throw std::invalid_argument("invalid range");
        return new std::vector<IntervalPrice >(self->begin()+index, self->begin()+index+count);
      }
SWIGINTERN void std_vector_Sl_IntervalPrice_Sg__Insert(std::vector<IntervalPrice > *self,int index,std::vector<IntervalPrice >::value_type const &value){
        if (index>=0 && index<(int)self->size()+1)
          self->insert(self->begin()+index, value);
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_IntervalPrice_Sg__InsertRange(std::vector<IntervalPrice > *self,int index,std::vector<IntervalPrice > const &values){
        if (index>=0 && index<(int)self->size()+1)
          self->insert(self->begin()+index, values.begin(), values.end());
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_IntervalPrice_Sg__RemoveAt(std::vector<IntervalPrice > *self,int index){
        if (index>=0 && index<(int)self->size())
          self->erase(self->begin() + index);
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_IntervalPrice_Sg__RemoveRange(std::vector<IntervalPrice > *self,int index,int count){
        if (index < 0)
          throw std::out_of_range("index");
        if (count < 0)
          throw std::out_of_range("count");
        if (index >= (int)self->size()+1 || index+count > (int)self->size())
          throw std::invalid_argument("invalid range");
        self->erase(self->begin()+index, self->begin()+index+count);
      }
SWIGINTERN std::vector<IntervalPrice > *std_vector_Sl_IntervalPrice_Sg__Repeat(std::vector<IntervalPrice >::value_type const &value,int count){
        if (count < 0)
          throw std::out_of_range("count");
        return new std::vector<IntervalPrice >(count, value);
      }
SWIGINTERN void std_vector_Sl_IntervalPrice_Sg__Reverse__SWIG_0(std::vector<IntervalPrice > *self){
        std::reverse(self->begin(), self->end());
      }
SWIGINTERN void std_vector_Sl_IntervalPrice_Sg__Reverse__SWIG_1(std::vector<IntervalPrice > *self,int index,int count){
        if (index < 0)
          throw std::out_of_range("index");
        if (count < 0)
          throw std::out_of_range("count");
        if (index >= (int)self->size()+1 || index+count > (int)self->size())
          throw std::invalid_argument("invalid range");
        std::reverse(self->begin()+index, self->begin()+index+count);
      }
SWIGINTERN void std_vector_Sl_IntervalPrice_Sg__SetRange(std::vector<IntervalPrice > *self,int index,std::vector<IntervalPrice > const &values){
        if (index < 0)
          throw std::out_of_range("index");
        if (index+values.size() > self->size())
          throw std::out_of_range("index");
        std::copy(values.begin(), values.end(), self->begin()+index);
      }

using QuantLib::ConstantEstimator;
using QuantLib::SimpleLocalEstimator;
using QuantLib::GarmanKlassSigma1;
using QuantLib::ParkinsonSigma;
using QuantLib::GarmanKlassSigma3;
using QuantLib::GarmanKlassSigma4;
using QuantLib::GarmanKlassSigma5;
using QuantLib::GarmanKlassSigma6;


using QuantLib::InterpolatedZeroCurve;


typedef boost::shared_ptr<YieldTermStructure> ZeroCurvePtr;

SWIGINTERN ZeroCurvePtr *new_ZeroCurvePtr__SWIG_0(std::vector<Date > const &dates,std::vector<Rate > const &yields,DayCounter const &dayCounter,Linear const &i=Linear()){
            return new ZeroCurvePtr(
                new InterpolatedZeroCurve<Linear>(dates,yields,
                                                        dayCounter,i));
        }
SWIGINTERN std::vector<Date > const &ZeroCurvePtr_dates(ZeroCurvePtr *self){
            typedef InterpolatedZeroCurve<Linear> ZeroCurve;
            return boost::dynamic_pointer_cast<ZeroCurve>(*self)->dates();
        }
SWIGINTERN std::vector<Rate > const &ZeroCurvePtr_zeroRates(ZeroCurvePtr *self){
            typedef InterpolatedZeroCurve<Linear> ZeroCurve;
            return boost::dynamic_pointer_cast<ZeroCurve>(*self)->zeroRates();
        }
SWIGINTERN std::vector<std::pair<Date,Rate > > ZeroCurvePtr_nodes(ZeroCurvePtr *self){
            typedef InterpolatedZeroCurve<Linear> ZeroCurve;
            return boost::dynamic_pointer_cast<ZeroCurve>(*self)->nodes();
        }

using QuantLib::DiscreteGeometricASO;


// single asset
using QuantLib::McDiscreteArithmeticASO;

// multi asset
using QuantLib::McMaxBasket;
using QuantLib::McEverest;
using QuantLib::McHimalaya;
using QuantLib::McPagoda;

SWIGINTERN std::vector<Handle<YieldTermStructure > > *new_std_vector_Sl_Handle_Sl_YieldTermStructure_Sg__Sg___SWIG_1(int capacity){
        std::vector<Handle<YieldTermStructure> >* pv = 0;
        if (capacity >= 0) {
          pv = new std::vector<Handle<YieldTermStructure> >();
          pv->reserve(capacity);
       } else {
          throw std::out_of_range("capacity");
       }
       return pv;
      }
SWIGINTERN Handle<YieldTermStructure > std_vector_Sl_Handle_Sl_YieldTermStructure_Sg__Sg__getitemcopy(std::vector<Handle<YieldTermStructure > > *self,int index){
        if (index>=0 && index<(int)self->size())
          return (*self)[index];
        else
          throw std::out_of_range("index");
      }
SWIGINTERN std::vector<Handle<YieldTermStructure > >::const_reference std_vector_Sl_Handle_Sl_YieldTermStructure_Sg__Sg__getitem(std::vector<Handle<YieldTermStructure > > *self,int index){
        if (index>=0 && index<(int)self->size())
          return (*self)[index];
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_Handle_Sl_YieldTermStructure_Sg__Sg__setitem(std::vector<Handle<YieldTermStructure > > *self,int index,std::vector<Handle<YieldTermStructure > >::value_type const &value){
        if (index>=0 && index<(int)self->size())
          (*self)[index] = value;
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_Handle_Sl_YieldTermStructure_Sg__Sg__AddRange(std::vector<Handle<YieldTermStructure > > *self,std::vector<Handle<YieldTermStructure > > const &values){
        self->insert(self->end(), values.begin(), values.end());
      }
SWIGINTERN std::vector<Handle<YieldTermStructure > > *std_vector_Sl_Handle_Sl_YieldTermStructure_Sg__Sg__GetRange(std::vector<Handle<YieldTermStructure > > *self,int index,int count){
        if (index < 0)
          throw std::out_of_range("index");
        if (count < 0)
          throw std::out_of_range("count");
        if (index >= (int)self->size()+1 || index+count > (int)self->size())
          throw std::invalid_argument("invalid range");
        return new std::vector<Handle<YieldTermStructure> >(self->begin()+index, self->begin()+index+count);
      }
SWIGINTERN void std_vector_Sl_Handle_Sl_YieldTermStructure_Sg__Sg__Insert(std::vector<Handle<YieldTermStructure > > *self,int index,std::vector<Handle<YieldTermStructure > >::value_type const &value){
        if (index>=0 && index<(int)self->size()+1)
          self->insert(self->begin()+index, value);
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_Handle_Sl_YieldTermStructure_Sg__Sg__InsertRange(std::vector<Handle<YieldTermStructure > > *self,int index,std::vector<Handle<YieldTermStructure > > const &values){
        if (index>=0 && index<(int)self->size()+1)
          self->insert(self->begin()+index, values.begin(), values.end());
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_Handle_Sl_YieldTermStructure_Sg__Sg__RemoveAt(std::vector<Handle<YieldTermStructure > > *self,int index){
        if (index>=0 && index<(int)self->size())
          self->erase(self->begin() + index);
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_Handle_Sl_YieldTermStructure_Sg__Sg__RemoveRange(std::vector<Handle<YieldTermStructure > > *self,int index,int count){
        if (index < 0)
          throw std::out_of_range("index");
        if (count < 0)
          throw std::out_of_range("count");
        if (index >= (int)self->size()+1 || index+count > (int)self->size())
          throw std::invalid_argument("invalid range");
        self->erase(self->begin()+index, self->begin()+index+count);
      }
SWIGINTERN std::vector<Handle<YieldTermStructure > > *std_vector_Sl_Handle_Sl_YieldTermStructure_Sg__Sg__Repeat(std::vector<Handle<YieldTermStructure > >::value_type const &value,int count){
        if (count < 0)
          throw std::out_of_range("count");
        return new std::vector<Handle<YieldTermStructure> >(count, value);
      }
SWIGINTERN void std_vector_Sl_Handle_Sl_YieldTermStructure_Sg__Sg__Reverse__SWIG_0(std::vector<Handle<YieldTermStructure > > *self){
        std::reverse(self->begin(), self->end());
      }
SWIGINTERN void std_vector_Sl_Handle_Sl_YieldTermStructure_Sg__Sg__Reverse__SWIG_1(std::vector<Handle<YieldTermStructure > > *self,int index,int count){
        if (index < 0)
          throw std::out_of_range("index");
        if (count < 0)
          throw std::out_of_range("count");
        if (index >= (int)self->size()+1 || index+count > (int)self->size())
          throw std::invalid_argument("invalid range");
        std::reverse(self->begin()+index, self->begin()+index+count);
      }
SWIGINTERN void std_vector_Sl_Handle_Sl_YieldTermStructure_Sg__Sg__SetRange(std::vector<Handle<YieldTermStructure > > *self,int index,std::vector<Handle<YieldTermStructure > > const &values){
        if (index < 0)
          throw std::out_of_range("index");
        if (index+values.size() > self->size())
          throw std::out_of_range("index");
        std::copy(values.begin(), values.end(), self->begin()+index);
      }
SWIGINTERN bool std_vector_Sl_Handle_Sl_YieldTermStructure_Sg__Sg__Contains(std::vector<Handle<YieldTermStructure > > *self,std::vector<Handle<YieldTermStructure > >::value_type const &value){
        return std::find(self->begin(), self->end(), value) != self->end();
      }
SWIGINTERN int std_vector_Sl_Handle_Sl_YieldTermStructure_Sg__Sg__IndexOf(std::vector<Handle<YieldTermStructure > > *self,std::vector<Handle<YieldTermStructure > >::value_type const &value){
        int index = -1;
        std::vector<Handle<YieldTermStructure> >::iterator it = std::find(self->begin(), self->end(), value);
        if (it != self->end())
          index = it - self->begin();
        return index;
      }
SWIGINTERN int std_vector_Sl_Handle_Sl_YieldTermStructure_Sg__Sg__LastIndexOf(std::vector<Handle<YieldTermStructure > > *self,std::vector<Handle<YieldTermStructure > >::value_type const &value){
        int index = -1;
        std::vector<Handle<YieldTermStructure> >::reverse_iterator rit = std::find(self->rbegin(), self->rend(), value);
        if (rit != self->rend())
          index = self->rend() - 1 - rit;
        return index;
      }
SWIGINTERN void std_vector_Sl_Handle_Sl_YieldTermStructure_Sg__Sg__Remove(std::vector<Handle<YieldTermStructure > > *self,std::vector<Handle<YieldTermStructure > >::value_type const &value){
        std::vector<Handle<YieldTermStructure> >::iterator it = std::find(self->begin(), self->end(), value);
        if (it != self->end())
          self->erase(it);
      }
SWIGINTERN std::vector<Handle<BlackVolTermStructure > > *new_std_vector_Sl_Handle_Sl_BlackVolTermStructure_Sg__Sg___SWIG_1(int capacity){
        std::vector<Handle<BlackVolTermStructure> >* pv = 0;
        if (capacity >= 0) {
          pv = new std::vector<Handle<BlackVolTermStructure> >();
          pv->reserve(capacity);
       } else {
          throw std::out_of_range("capacity");
       }
       return pv;
      }
SWIGINTERN Handle<BlackVolTermStructure > std_vector_Sl_Handle_Sl_BlackVolTermStructure_Sg__Sg__getitemcopy(std::vector<Handle<BlackVolTermStructure > > *self,int index){
        if (index>=0 && index<(int)self->size())
          return (*self)[index];
        else
          throw std::out_of_range("index");
      }
SWIGINTERN std::vector<Handle<BlackVolTermStructure > >::const_reference std_vector_Sl_Handle_Sl_BlackVolTermStructure_Sg__Sg__getitem(std::vector<Handle<BlackVolTermStructure > > *self,int index){
        if (index>=0 && index<(int)self->size())
          return (*self)[index];
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_Handle_Sl_BlackVolTermStructure_Sg__Sg__setitem(std::vector<Handle<BlackVolTermStructure > > *self,int index,std::vector<Handle<BlackVolTermStructure > >::value_type const &value){
        if (index>=0 && index<(int)self->size())
          (*self)[index] = value;
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_Handle_Sl_BlackVolTermStructure_Sg__Sg__AddRange(std::vector<Handle<BlackVolTermStructure > > *self,std::vector<Handle<BlackVolTermStructure > > const &values){
        self->insert(self->end(), values.begin(), values.end());
      }
SWIGINTERN std::vector<Handle<BlackVolTermStructure > > *std_vector_Sl_Handle_Sl_BlackVolTermStructure_Sg__Sg__GetRange(std::vector<Handle<BlackVolTermStructure > > *self,int index,int count){
        if (index < 0)
          throw std::out_of_range("index");
        if (count < 0)
          throw std::out_of_range("count");
        if (index >= (int)self->size()+1 || index+count > (int)self->size())
          throw std::invalid_argument("invalid range");
        return new std::vector<Handle<BlackVolTermStructure> >(self->begin()+index, self->begin()+index+count);
      }
SWIGINTERN void std_vector_Sl_Handle_Sl_BlackVolTermStructure_Sg__Sg__Insert(std::vector<Handle<BlackVolTermStructure > > *self,int index,std::vector<Handle<BlackVolTermStructure > >::value_type const &value){
        if (index>=0 && index<(int)self->size()+1)
          self->insert(self->begin()+index, value);
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_Handle_Sl_BlackVolTermStructure_Sg__Sg__InsertRange(std::vector<Handle<BlackVolTermStructure > > *self,int index,std::vector<Handle<BlackVolTermStructure > > const &values){
        if (index>=0 && index<(int)self->size()+1)
          self->insert(self->begin()+index, values.begin(), values.end());
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_Handle_Sl_BlackVolTermStructure_Sg__Sg__RemoveAt(std::vector<Handle<BlackVolTermStructure > > *self,int index){
        if (index>=0 && index<(int)self->size())
          self->erase(self->begin() + index);
        else
          throw std::out_of_range("index");
      }
SWIGINTERN void std_vector_Sl_Handle_Sl_BlackVolTermStructure_Sg__Sg__RemoveRange(std::vector<Handle<BlackVolTermStructure > > *self,int index,int count){
        if (index < 0)
          throw std::out_of_range("index");
        if (count < 0)
          throw std::out_of_range("count");
        if (index >= (int)self->size()+1 || index+count > (int)self->size())
          throw std::invalid_argument("invalid range");
        self->erase(self->begin()+index, self->begin()+index+count);
      }
SWIGINTERN std::vector<Handle<BlackVolTermStructure > > *std_vector_Sl_Handle_Sl_BlackVolTermStructure_Sg__Sg__Repeat(std::vector<Handle<BlackVolTermStructure > >::value_type const &value,int count){
        if (count < 0)
          throw std::out_of_range("count");
        return new std::vector<Handle<BlackVolTermStructure> >(count, value);
      }
SWIGINTERN void std_vector_Sl_Handle_Sl_BlackVolTermStructure_Sg__Sg__Reverse__SWIG_0(std::vector<Handle<BlackVolTermStructure > > *self){
        std::reverse(self->begin(), self->end());
      }
SWIGINTERN void std_vector_Sl_Handle_Sl_BlackVolTermStructure_Sg__Sg__Reverse__SWIG_1(std::vector<Handle<BlackVolTermStructure > > *self,int index,int count){
        if (index < 0)
          throw std::out_of_range("index");
        if (count < 0)
          throw std::out_of_range("count");
        if (index >= (int)self->size()+1 || index+count > (int)self->size())
          throw std::invalid_argument("invalid range");
        std::reverse(self->begin()+index, self->begin()+index+count);
      }
SWIGINTERN void std_vector_Sl_Handle_Sl_BlackVolTermStructure_Sg__Sg__SetRange(std::vector<Handle<BlackVolTermStructure > > *self,int index,std::vector<Handle<BlackVolTermStructure > > const &values){
        if (index < 0)
          throw std::out_of_range("index");
        if (index+values.size() > self->size())
          throw std::out_of_range("index");
        std::copy(values.begin(), values.end(), self->begin()+index);
      }
SWIGINTERN bool std_vector_Sl_Handle_Sl_BlackVolTermStructure_Sg__Sg__Contains(std::vector<Handle<BlackVolTermStructure > > *self,std::vector<Handle<BlackVolTermStructure > >::value_type const &value){
        return std::find(self->begin(), self->end(), value) != self->end();
      }
SWIGINTERN int std_vector_Sl_Handle_Sl_BlackVolTermStructure_Sg__Sg__IndexOf(std::vector<Handle<BlackVolTermStructure > > *self,std::vector<Handle<BlackVolTermStructure > >::value_type const &value){
        int index = -1;
        std::vector<Handle<BlackVolTermStructure> >::iterator it = std::find(self->begin(), self->end(), value);
        if (it != self->end())
          index = it - self->begin();
        return index;
      }
SWIGINTERN int std_vector_Sl_Handle_Sl_BlackVolTermStructure_Sg__Sg__LastIndexOf(std::vector<Handle<BlackVolTermStructure > > *self,std::vector<Handle<BlackVolTermStructure > >::value_type const &value){
        int index = -1;
        std::vector<Handle<BlackVolTermStructure> >::reverse_iterator rit = std::find(self->rbegin(), self->rend(), value);
        if (rit != self->rend())
          index = self->rend() - 1 - rit;
        return index;
      }
SWIGINTERN void std_vector_Sl_Handle_Sl_BlackVolTermStructure_Sg__Sg__Remove(std::vector<Handle<BlackVolTermStructure > > *self,std::vector<Handle<BlackVolTermStructure > >::value_type const &value){
        std::vector<Handle<BlackVolTermStructure> >::iterator it = std::find(self->begin(), self->end(), value);
        if (it != self->end())
          self->erase(it);
      }

using QuantLib::SwaptionVolatilityStructure;

SWIGINTERN bool boost_shared_ptr_Sl_SwaptionVolatilityStructure_Sg__isNull(boost::shared_ptr<SwaptionVolatilityStructure > *self){
                return !(*self);
            }
SWIGINTERN boost::shared_ptr<Observable > boost_shared_ptr_Sl_SwaptionVolatilityStructure_Sg__asObservable(boost::shared_ptr<SwaptionVolatilityStructure > *self){
        return boost::shared_ptr<Observable>(*self);
    }
SWIGINTERN boost::shared_ptr<Observable > Handle_Sl_SwaptionVolatilityStructure_Sg__asObservable(Handle<SwaptionVolatilityStructure > *self){
        return boost::shared_ptr<Observable>(*self);
    }

using QuantLib::SwaptionVolatilityMatrix;
typedef boost::shared_ptr<SwaptionVolatilityStructure>
    SwaptionVolatilityMatrixPtr;

SWIGINTERN SwaptionVolatilityMatrixPtr *new_SwaptionVolatilityMatrixPtr(Date const &referenceDate,std::vector<Date > const &dates,std::vector<Period > const &lengths,Matrix const &vols,DayCounter const &dayCounter){
            return new SwaptionVolatilityMatrixPtr(
                new SwaptionVolatilityMatrix(referenceDate,dates,lengths,
                                             vols,dayCounter));
        }

using QuantLib::CapVolatilityStructure;

SWIGINTERN bool boost_shared_ptr_Sl_CapVolatilityStructure_Sg__isNull(boost::shared_ptr<CapVolatilityStructure > *self){
                return !(*self);
            }
SWIGINTERN boost::shared_ptr<Observable > boost_shared_ptr_Sl_CapVolatilityStructure_Sg__asObservable(boost::shared_ptr<CapVolatilityStructure > *self){
        return boost::shared_ptr<Observable>(*self);
    }
SWIGINTERN boost::shared_ptr<Observable > Handle_Sl_CapVolatilityStructure_Sg__asObservable(Handle<CapVolatilityStructure > *self){
        return boost::shared_ptr<Observable>(*self);
    }

using QuantLib::CapVolatilityVector;
typedef boost::shared_ptr<CapVolatilityStructure> CapVolatilityVectorPtr;

SWIGINTERN CapVolatilityVectorPtr *new_CapVolatilityVectorPtr__SWIG_0(Date const &referenceDate,std::vector<Period > const &lengths,std::vector<Volatility > const &vols,DayCounter const &dayCounter){
            return new CapVolatilityVectorPtr(
                new CapVolatilityVector(referenceDate,lengths,
                                        vols,dayCounter));
        }
SWIGINTERN CapVolatilityVectorPtr *new_CapVolatilityVectorPtr__SWIG_1(Integer settlementDays,Calendar const &calendar,std::vector<Period > const &lengths,std::vector<Volatility > const &vols,DayCounter const &dayCounter){
            return new CapVolatilityVectorPtr(
                new CapVolatilityVector(settlementDays,calendar,
                                        lengths,vols,dayCounter));
        }

#ifdef __cplusplus
extern "C" {
#endif

SWIGEXPORT void * SWIGSTDCALL CSharp_Observable___deref__(void * jarg1) {
  void * jresult ;
  boost::shared_ptr<Observable > *arg1 = (boost::shared_ptr<Observable > *) 0 ;
  Observable *result = 0 ;
  
  arg1 = (boost::shared_ptr<Observable > *)jarg1; 
  {
    try {
      result = (Observable *)(arg1)->operator ->();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT unsigned int SWIGSTDCALL CSharp_Observable_isNull(void * jarg1) {
  unsigned int jresult ;
  boost::shared_ptr<Observable > *arg1 = (boost::shared_ptr<Observable > *) 0 ;
  bool result;
  
  arg1 = (boost::shared_ptr<Observable > *)jarg1; 
  {
    try {
      result = (bool)boost_shared_ptr_Sl_Observable_Sg__isNull(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_Observable() {
  void * jresult ;
  boost::shared_ptr<Observable > *result = 0 ;
  
  {
    try {
      result = (boost::shared_ptr<Observable > *)new boost::shared_ptr<Observable >();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_Observable(void * jarg1) {
  boost::shared_ptr<Observable > *arg1 = (boost::shared_ptr<Observable > *) 0 ;
  
  arg1 = (boost::shared_ptr<Observable > *)jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_QlArray__SWIG_0() {
  void * jresult ;
  Array *result = 0 ;
  
  {
    try {
      result = (Array *)new Array();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_QlArray__SWIG_1(unsigned long jarg1, double jarg2) {
  void * jresult ;
  Size arg1 ;
  Real arg2 ;
  Array *result = 0 ;
  
  arg1 = (Size)jarg1; 
  arg2 = (Real)jarg2; 
  {
    try {
      result = (Array *)new Array(arg1,arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_QlArray__SWIG_2(unsigned long jarg1) {
  void * jresult ;
  Size arg1 ;
  Array *result = 0 ;
  
  arg1 = (Size)jarg1; 
  {
    try {
      result = (Array *)new Array(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_QlArray__SWIG_3(void * jarg1) {
  void * jresult ;
  Array *arg1 = 0 ;
  Array *result = 0 ;
  
  arg1 = (Array *)jarg1;
  if(!arg1) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Array const & type is null", 0);
    return 0;
  } 
  {
    try {
      result = (Array *)new Array((Array const &)*arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT unsigned long SWIGSTDCALL CSharp_QlArray_size(void * jarg1) {
  unsigned long jresult ;
  Array *arg1 = (Array *) 0 ;
  Size result;
  
  arg1 = (Array *)jarg1; 
  {
    try {
      result = ((Array const *)arg1)->size();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT char * SWIGSTDCALL CSharp_QlArray___str__(void * jarg1) {
  char * jresult ;
  Array *arg1 = (Array *) 0 ;
  std::string result;
  
  arg1 = (Array *)jarg1; 
  {
    try {
      result = Array___str__(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = SWIG_csharp_string_callback((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_QlArray(void * jarg1) {
  Array *arg1 = (Array *) 0 ;
  
  arg1 = (Array *)jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT unsigned long SWIGSTDCALL CSharp_LexicographicalView_xSize(void * jarg1) {
  unsigned long jresult ;
  LexicographicalView *arg1 = (LexicographicalView *) 0 ;
  Size result;
  
  arg1 = (LexicographicalView *)jarg1; 
  {
    try {
      result = ((LexicographicalView const *)arg1)->xSize();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT unsigned long SWIGSTDCALL CSharp_LexicographicalView_ySize(void * jarg1) {
  unsigned long jresult ;
  LexicographicalView *arg1 = (LexicographicalView *) 0 ;
  Size result;
  
  arg1 = (LexicographicalView *)jarg1; 
  {
    try {
      result = ((LexicographicalView const *)arg1)->ySize();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_LexicographicalView(void * jarg1, unsigned long jarg2) {
  void * jresult ;
  Array *arg1 = 0 ;
  Size arg2 ;
  LexicographicalView *result = 0 ;
  
  arg1 = (Array *)jarg1;
  if(!arg1) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Array & type is null", 0);
    return 0;
  } 
  arg2 = (Size)jarg2; 
  {
    try {
      result = (LexicographicalView *)new_LexicographicalView(*arg1,arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT char * SWIGSTDCALL CSharp_LexicographicalView___str__(void * jarg1) {
  char * jresult ;
  LexicographicalView *arg1 = (LexicographicalView *) 0 ;
  std::string result;
  
  arg1 = (LexicographicalView *)jarg1; 
  {
    try {
      result = LexicographicalView___str__(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = SWIG_csharp_string_callback((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_LexicographicalView(void * jarg1) {
  LexicographicalView *arg1 = (LexicographicalView *) 0 ;
  
  arg1 = (LexicographicalView *)jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_Matrix__SWIG_0() {
  void * jresult ;
  Matrix *result = 0 ;
  
  {
    try {
      result = (Matrix *)new Matrix();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_Matrix__SWIG_1(unsigned long jarg1, unsigned long jarg2, double jarg3) {
  void * jresult ;
  Size arg1 ;
  Size arg2 ;
  Real arg3 ;
  Matrix *result = 0 ;
  
  arg1 = (Size)jarg1; 
  arg2 = (Size)jarg2; 
  arg3 = (Real)jarg3; 
  {
    try {
      result = (Matrix *)new Matrix(arg1,arg2,arg3);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_Matrix__SWIG_2(unsigned long jarg1, unsigned long jarg2) {
  void * jresult ;
  Size arg1 ;
  Size arg2 ;
  Matrix *result = 0 ;
  
  arg1 = (Size)jarg1; 
  arg2 = (Size)jarg2; 
  {
    try {
      result = (Matrix *)new Matrix(arg1,arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_Matrix__SWIG_3(void * jarg1) {
  void * jresult ;
  Matrix *arg1 = 0 ;
  Matrix *result = 0 ;
  
  arg1 = (Matrix *)jarg1;
  if(!arg1) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Matrix const & type is null", 0);
    return 0;
  } 
  {
    try {
      result = (Matrix *)new Matrix((Matrix const &)*arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT unsigned long SWIGSTDCALL CSharp_Matrix_rows(void * jarg1) {
  unsigned long jresult ;
  Matrix *arg1 = (Matrix *) 0 ;
  Size result;
  
  arg1 = (Matrix *)jarg1; 
  {
    try {
      result = ((Matrix const *)arg1)->rows();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT unsigned long SWIGSTDCALL CSharp_Matrix_columns(void * jarg1) {
  unsigned long jresult ;
  Matrix *arg1 = (Matrix *) 0 ;
  Size result;
  
  arg1 = (Matrix *)jarg1; 
  {
    try {
      result = ((Matrix const *)arg1)->columns();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT char * SWIGSTDCALL CSharp_Matrix___str__(void * jarg1) {
  char * jresult ;
  Matrix *arg1 = (Matrix *) 0 ;
  std::string result;
  
  arg1 = (Matrix *)jarg1; 
  {
    try {
      result = Matrix___str__(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = SWIG_csharp_string_callback((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_Matrix(void * jarg1) {
  Matrix *arg1 = (Matrix *) 0 ;
  
  arg1 = (Matrix *)jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_SalvagingAlgorithm() {
  void * jresult ;
  SalvagingAlgorithm *result = 0 ;
  
  {
    try {
      result = (SalvagingAlgorithm *)new SalvagingAlgorithm();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_SalvagingAlgorithm(void * jarg1) {
  SalvagingAlgorithm *arg1 = (SalvagingAlgorithm *) 0 ;
  
  arg1 = (SalvagingAlgorithm *)jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_transpose(void * jarg1) {
  void * jresult ;
  Matrix *arg1 = 0 ;
  Matrix result;
  
  arg1 = (Matrix *)jarg1;
  if(!arg1) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Matrix const & type is null", 0);
    return 0;
  } 
  {
    try {
      result = transpose((Matrix const &)*arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = new Matrix((Matrix &)result); 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_outerProduct(void * jarg1, void * jarg2) {
  void * jresult ;
  Array *arg1 = 0 ;
  Array *arg2 = 0 ;
  Matrix result;
  
  arg1 = (Array *)jarg1;
  if(!arg1) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Array const & type is null", 0);
    return 0;
  } 
  arg2 = (Array *)jarg2;
  if(!arg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Array const & type is null", 0);
    return 0;
  } 
  {
    try {
      result = outerProduct((Array const &)*arg1,(Array const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = new Matrix((Matrix &)result); 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_pseudoSqrt(void * jarg1, int jarg2) {
  void * jresult ;
  Matrix *arg1 = 0 ;
  SalvagingAlgorithm::Type arg2 ;
  Matrix result;
  
  arg1 = (Matrix *)jarg1;
  if(!arg1) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Matrix const & type is null", 0);
    return 0;
  } 
  arg2 = (SalvagingAlgorithm::Type)jarg2; 
  {
    try {
      result = pseudoSqrt((Matrix const &)*arg1,arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = new Matrix((Matrix &)result); 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_SVD(void * jarg1) {
  void * jresult ;
  Matrix *arg1 = 0 ;
  SVD *result = 0 ;
  
  arg1 = (Matrix *)jarg1;
  if(!arg1) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Matrix const & type is null", 0);
    return 0;
  } 
  {
    try {
      result = (SVD *)new SVD((Matrix const &)*arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_SVD_U(void * jarg1) {
  void * jresult ;
  SVD *arg1 = (SVD *) 0 ;
  Matrix *result = 0 ;
  
  arg1 = (SVD *)jarg1; 
  {
    try {
      {
        Matrix const &_result_ref = ((SVD const *)arg1)->U();
        result = (Matrix *) &_result_ref;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_SVD_V(void * jarg1) {
  void * jresult ;
  SVD *arg1 = (SVD *) 0 ;
  Matrix *result = 0 ;
  
  arg1 = (SVD *)jarg1; 
  {
    try {
      {
        Matrix const &_result_ref = ((SVD const *)arg1)->V();
        result = (Matrix *) &_result_ref;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_SVD_S(void * jarg1) {
  void * jresult ;
  SVD *arg1 = (SVD *) 0 ;
  Matrix result;
  
  arg1 = (SVD *)jarg1; 
  {
    try {
      result = ((SVD const *)arg1)->S();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = new Matrix((Matrix &)result); 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_SVD_singularValues(void * jarg1) {
  void * jresult ;
  SVD *arg1 = (SVD *) 0 ;
  Array *result = 0 ;
  
  arg1 = (SVD *)jarg1; 
  {
    try {
      {
        Array const &_result_ref = ((SVD const *)arg1)->singularValues();
        result = (Array *) &_result_ref;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_SVD(void * jarg1) {
  SVD *arg1 = (SVD *) 0 ;
  
  arg1 = (SVD *)jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_Quote___deref__(void * jarg1) {
  void * jresult ;
  boost::shared_ptr<Quote > *arg1 = (boost::shared_ptr<Quote > *) 0 ;
  Quote *result = 0 ;
  
  arg1 = (boost::shared_ptr<Quote > *)jarg1; 
  {
    try {
      result = (Quote *)(arg1)->operator ->();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT unsigned int SWIGSTDCALL CSharp_Quote_isNull(void * jarg1) {
  unsigned int jresult ;
  boost::shared_ptr<Quote > *arg1 = (boost::shared_ptr<Quote > *) 0 ;
  bool result;
  
  arg1 = (boost::shared_ptr<Quote > *)jarg1; 
  {
    try {
      result = (bool)boost_shared_ptr_Sl_Quote_Sg__isNull(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_Quote_asObservable(void * jarg1) {
  void * jresult ;
  boost::shared_ptr<Quote > *arg1 = (boost::shared_ptr<Quote > *) 0 ;
  boost::shared_ptr<Observable > result;
  
  arg1 = (boost::shared_ptr<Quote > *)jarg1; 
  {
    try {
      result = boost_shared_ptr_Sl_Quote_Sg__asObservable(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = new boost::shared_ptr<Observable >((boost::shared_ptr<Observable > &)result); 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_Quote() {
  void * jresult ;
  boost::shared_ptr<Quote > *result = 0 ;
  
  {
    try {
      result = (boost::shared_ptr<Quote > *)new boost::shared_ptr<Quote >();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_Quote(void * jarg1) {
  boost::shared_ptr<Quote > *arg1 = (boost::shared_ptr<Quote > *) 0 ;
  
  arg1 = (boost::shared_ptr<Quote > *)jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT double SWIGSTDCALL CSharp_Quote_value(void * jarg1) {
  double jresult ;
  boost::shared_ptr<Quote > *arg1 = (boost::shared_ptr<Quote > *) 0 ;
  Real result;
  
  arg1 = (boost::shared_ptr<Quote > *)jarg1; 
  {
    try {
      result = (Real)(*arg1)->value();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_QuoteHandle__SWIG_0(void * jarg1) {
  void * jresult ;
  boost::shared_ptr<Quote > *arg1 = 0 ;
  Handle<Quote > *result = 0 ;
  
  arg1 = (boost::shared_ptr<Quote > *)jarg1;
  if(!arg1) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "boost::shared_ptr<Quote > const & type is null", 0);
    return 0;
  } 
  {
    try {
      result = (Handle<Quote > *)new Handle<Quote >((boost::shared_ptr<Quote > const &)*arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_QuoteHandle__SWIG_1() {
  void * jresult ;
  Handle<Quote > *result = 0 ;
  
  {
    try {
      result = (Handle<Quote > *)new Handle<Quote >();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuoteHandle___deref__(void * jarg1) {
  void * jresult ;
  Handle<Quote > *arg1 = (Handle<Quote > *) 0 ;
  boost::shared_ptr<Quote > result;
  
  arg1 = (Handle<Quote > *)jarg1; 
  {
    try {
      result = (arg1)->operator ->();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = new boost::shared_ptr<Quote >((boost::shared_ptr<Quote > &)result); 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuoteHandle_linkTo(void * jarg1, void * jarg2) {
  Handle<Quote > *arg1 = (Handle<Quote > *) 0 ;
  boost::shared_ptr<Quote > *arg2 = 0 ;
  
  arg1 = (Handle<Quote > *)jarg1; 
  arg2 = (boost::shared_ptr<Quote > *)jarg2;
  if(!arg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "boost::shared_ptr<Quote > const & type is null", 0);
    return ;
  } 
  {
    try {
      (arg1)->linkTo((boost::shared_ptr<Quote > const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT unsigned int SWIGSTDCALL CSharp_QuoteHandle_empty(void * jarg1) {
  unsigned int jresult ;
  Handle<Quote > *arg1 = (Handle<Quote > *) 0 ;
  bool result;
  
  arg1 = (Handle<Quote > *)jarg1; 
  {
    try {
      result = (bool)(arg1)->empty();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuoteHandle_asObservable(void * jarg1) {
  void * jresult ;
  Handle<Quote > *arg1 = (Handle<Quote > *) 0 ;
  boost::shared_ptr<Observable > result;
  
  arg1 = (Handle<Quote > *)jarg1; 
  {
    try {
      result = Handle_Sl_Quote_Sg__asObservable(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = new boost::shared_ptr<Observable >((boost::shared_ptr<Observable > &)result); 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_QuoteHandle(void * jarg1) {
  Handle<Quote > *arg1 = (Handle<Quote > *) 0 ;
  
  arg1 = (Handle<Quote > *)jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT double SWIGSTDCALL CSharp_QuoteHandle_value(void * jarg1) {
  double jresult ;
  Handle<Quote > *arg1 = (Handle<Quote > *) 0 ;
  Real result;
  
  arg1 = (Handle<Quote > *)jarg1; 
  {
    try {
      result = (Real)(*arg1)->value();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_SimpleQuote(double jarg1) {
  void * jresult ;
  Real arg1 ;
  SimpleQuotePtr *result = 0 ;
  
  arg1 = (Real)jarg1; 
  {
    try {
      result = (SimpleQuotePtr *)new_SimpleQuotePtr(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_SimpleQuote_setValue(void * jarg1, double jarg2) {
  SimpleQuotePtr *arg1 = (SimpleQuotePtr *) 0 ;
  Real arg2 ;
  
  arg1 = (SimpleQuotePtr *)jarg1; 
  arg2 = (Real)jarg2; 
  {
    try {
      SimpleQuotePtr_setValue(arg1,arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_SimpleQuote(void * jarg1) {
  SimpleQuotePtr *arg1 = (SimpleQuotePtr *) 0 ;
  
  arg1 = (SimpleQuotePtr *)jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuoteVector_Clear(void * jarg1) {
  std::vector<boost::shared_ptr<Quote > > *arg1 = (std::vector<boost::shared_ptr<Quote > > *) 0 ;
  
  arg1 = (std::vector<boost::shared_ptr<Quote > > *)jarg1; 
  {
    try {
      (arg1)->clear();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuoteVector_Add(void * jarg1, void * jarg2) {
  std::vector<boost::shared_ptr<Quote > > *arg1 = (std::vector<boost::shared_ptr<Quote > > *) 0 ;
  std::vector<boost::shared_ptr<Quote > >::value_type *arg2 = 0 ;
  
  arg1 = (std::vector<boost::shared_ptr<Quote > > *)jarg1; 
  arg2 = (std::vector<boost::shared_ptr<Quote > >::value_type *)jarg2;
  if(!arg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "std::vector<boost::shared_ptr<Quote > >::value_type const & type is null", 0);
    return ;
  } 
  {
    try {
      (arg1)->push_back((std::vector<boost::shared_ptr<Quote > >::value_type const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT unsigned long SWIGSTDCALL CSharp_QuoteVector_size(void * jarg1) {
  unsigned long jresult ;
  std::vector<boost::shared_ptr<Quote > > *arg1 = (std::vector<boost::shared_ptr<Quote > > *) 0 ;
  std::vector<boost::shared_ptr<Quote > >::size_type result;
  
  arg1 = (std::vector<boost::shared_ptr<Quote > > *)jarg1; 
  {
    try {
      result = ((std::vector<boost::shared_ptr<Quote > > const *)arg1)->size();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT unsigned long SWIGSTDCALL CSharp_QuoteVector_capacity(void * jarg1) {
  unsigned long jresult ;
  std::vector<boost::shared_ptr<Quote > > *arg1 = (std::vector<boost::shared_ptr<Quote > > *) 0 ;
  std::vector<boost::shared_ptr<Quote > >::size_type result;
  
  arg1 = (std::vector<boost::shared_ptr<Quote > > *)jarg1; 
  {
    try {
      result = ((std::vector<boost::shared_ptr<Quote > > const *)arg1)->capacity();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuoteVector_reserve(void * jarg1, unsigned long jarg2) {
  std::vector<boost::shared_ptr<Quote > > *arg1 = (std::vector<boost::shared_ptr<Quote > > *) 0 ;
  std::vector<boost::shared_ptr<Quote > >::size_type arg2 ;
  
  arg1 = (std::vector<boost::shared_ptr<Quote > > *)jarg1; 
  arg2 = (std::vector<boost::shared_ptr<Quote > >::size_type)jarg2; 
  {
    try {
      (arg1)->reserve(arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_QuoteVector__SWIG_0() {
  void * jresult ;
  std::vector<boost::shared_ptr<Quote > > *result = 0 ;
  
  {
    try {
      result = (std::vector<boost::shared_ptr<Quote > > *)new std::vector<boost::shared_ptr<Quote > >();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_QuoteVector__SWIG_1(int jarg1) {
  void * jresult ;
  int arg1 ;
  std::vector<boost::shared_ptr<Quote > > *result = 0 ;
  
  arg1 = (int)jarg1; 
  {
    try {
      try {
        result = (std::vector<boost::shared_ptr<Quote > > *)new_std_vector_Sl_boost_shared_ptr_Sl_Quote_Sg__Sg___SWIG_1(arg1);
      }
      catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return 0;
      }
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuoteVector_getitemcopy(void * jarg1, int jarg2) {
  void * jresult ;
  std::vector<boost::shared_ptr<Quote > > *arg1 = (std::vector<boost::shared_ptr<Quote > > *) 0 ;
  int arg2 ;
  boost::shared_ptr<Quote > result;
  
  arg1 = (std::vector<boost::shared_ptr<Quote > > *)jarg1; 
  arg2 = (int)jarg2; 
  {
    try {
      try {
        result = std_vector_Sl_boost_shared_ptr_Sl_Quote_Sg__Sg__getitemcopy(arg1,arg2);
      }
      catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return 0;
      }
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = new boost::shared_ptr<Quote >((boost::shared_ptr<Quote > &)result); 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuoteVector_getitem(void * jarg1, int jarg2) {
  void * jresult ;
  std::vector<boost::shared_ptr<Quote > > *arg1 = (std::vector<boost::shared_ptr<Quote > > *) 0 ;
  int arg2 ;
  std::vector<boost::shared_ptr<Quote > >::value_type *result = 0 ;
  
  arg1 = (std::vector<boost::shared_ptr<Quote > > *)jarg1; 
  arg2 = (int)jarg2; 
  {
    try {
      try {
        {
          std::vector<boost::shared_ptr<Quote > >::const_reference _result_ref = std_vector_Sl_boost_shared_ptr_Sl_Quote_Sg__Sg__getitem(arg1,arg2);
          result = (std::vector<boost::shared_ptr<Quote > >::value_type *) &_result_ref;
        }
      }
      catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return 0;
      }
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuoteVector_setitem(void * jarg1, int jarg2, void * jarg3) {
  std::vector<boost::shared_ptr<Quote > > *arg1 = (std::vector<boost::shared_ptr<Quote > > *) 0 ;
  int arg2 ;
  std::vector<boost::shared_ptr<Quote > >::value_type *arg3 = 0 ;
  
  arg1 = (std::vector<boost::shared_ptr<Quote > > *)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (std::vector<boost::shared_ptr<Quote > >::value_type *)jarg3;
  if(!arg3) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "std::vector<boost::shared_ptr<Quote > >::value_type const & type is null", 0);
    return ;
  } 
  {
    try {
      try {
        std_vector_Sl_boost_shared_ptr_Sl_Quote_Sg__Sg__setitem(arg1,arg2,(boost::shared_ptr<Quote > const &)*arg3);
      }
      catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return ;
      }
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuoteVector_AddRange(void * jarg1, void * jarg2) {
  std::vector<boost::shared_ptr<Quote > > *arg1 = (std::vector<boost::shared_ptr<Quote > > *) 0 ;
  std::vector<boost::shared_ptr<Quote > > *arg2 = 0 ;
  
  arg1 = (std::vector<boost::shared_ptr<Quote > > *)jarg1; 
  arg2 = (std::vector<boost::shared_ptr<Quote > > *)jarg2;
  if(!arg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "std::vector<boost::shared_ptr<Quote > > const & type is null", 0);
    return ;
  } 
  {
    try {
      std_vector_Sl_boost_shared_ptr_Sl_Quote_Sg__Sg__AddRange(arg1,(std::vector<boost::shared_ptr<Quote > > const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuoteVector_GetRange(void * jarg1, int jarg2, int jarg3) {
  void * jresult ;
  std::vector<boost::shared_ptr<Quote > > *arg1 = (std::vector<boost::shared_ptr<Quote > > *) 0 ;
  int arg2 ;
  int arg3 ;
  std::vector<boost::shared_ptr<Quote > > *result = 0 ;
  
  arg1 = (std::vector<boost::shared_ptr<Quote > > *)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  {
    try {
      try {
        result = (std::vector<boost::shared_ptr<Quote > > *)std_vector_Sl_boost_shared_ptr_Sl_Quote_Sg__Sg__GetRange(arg1,arg2,arg3);
      }
      catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return 0;
      }
      catch(std::invalid_argument &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentException, (&_e)->what(), "");
        return 0;
      }
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuoteVector_Insert(void * jarg1, int jarg2, void * jarg3) {
  std::vector<boost::shared_ptr<Quote > > *arg1 = (std::vector<boost::shared_ptr<Quote > > *) 0 ;
  int arg2 ;
  std::vector<boost::shared_ptr<Quote > >::value_type *arg3 = 0 ;
  
  arg1 = (std::vector<boost::shared_ptr<Quote > > *)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (std::vector<boost::shared_ptr<Quote > >::value_type *)jarg3;
  if(!arg3) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "std::vector<boost::shared_ptr<Quote > >::value_type const & type is null", 0);
    return ;
  } 
  {
    try {
      try {
        std_vector_Sl_boost_shared_ptr_Sl_Quote_Sg__Sg__Insert(arg1,arg2,(boost::shared_ptr<Quote > const &)*arg3);
      }
      catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return ;
      }
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuoteVector_InsertRange(void * jarg1, int jarg2, void * jarg3) {
  std::vector<boost::shared_ptr<Quote > > *arg1 = (std::vector<boost::shared_ptr<Quote > > *) 0 ;
  int arg2 ;
  std::vector<boost::shared_ptr<Quote > > *arg3 = 0 ;
  
  arg1 = (std::vector<boost::shared_ptr<Quote > > *)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (std::vector<boost::shared_ptr<Quote > > *)jarg3;
  if(!arg3) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "std::vector<boost::shared_ptr<Quote > > const & type is null", 0);
    return ;
  } 
  {
    try {
      try {
        std_vector_Sl_boost_shared_ptr_Sl_Quote_Sg__Sg__InsertRange(arg1,arg2,(std::vector<boost::shared_ptr<Quote > > const &)*arg3);
      }
      catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return ;
      }
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuoteVector_RemoveAt(void * jarg1, int jarg2) {
  std::vector<boost::shared_ptr<Quote > > *arg1 = (std::vector<boost::shared_ptr<Quote > > *) 0 ;
  int arg2 ;
  
  arg1 = (std::vector<boost::shared_ptr<Quote > > *)jarg1; 
  arg2 = (int)jarg2; 
  {
    try {
      try {
        std_vector_Sl_boost_shared_ptr_Sl_Quote_Sg__Sg__RemoveAt(arg1,arg2);
      }
      catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return ;
      }
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuoteVector_RemoveRange(void * jarg1, int jarg2, int jarg3) {
  std::vector<boost::shared_ptr<Quote > > *arg1 = (std::vector<boost::shared_ptr<Quote > > *) 0 ;
  int arg2 ;
  int arg3 ;
  
  arg1 = (std::vector<boost::shared_ptr<Quote > > *)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  {
    try {
      try {
        std_vector_Sl_boost_shared_ptr_Sl_Quote_Sg__Sg__RemoveRange(arg1,arg2,arg3);
      }
      catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return ;
      }
      catch(std::invalid_argument &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentException, (&_e)->what(), "");
        return ;
      }
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuoteVector_Repeat(void * jarg1, int jarg2) {
  void * jresult ;
  std::vector<boost::shared_ptr<Quote > >::value_type *arg1 = 0 ;
  int arg2 ;
  std::vector<boost::shared_ptr<Quote > > *result = 0 ;
  
  arg1 = (std::vector<boost::shared_ptr<Quote > >::value_type *)jarg1;
  if(!arg1) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "std::vector<boost::shared_ptr<Quote > >::value_type const & type is null", 0);
    return 0;
  } 
  arg2 = (int)jarg2; 
  {
    try {
      try {
        result = (std::vector<boost::shared_ptr<Quote > > *)std_vector_Sl_boost_shared_ptr_Sl_Quote_Sg__Sg__Repeat((boost::shared_ptr<Quote > const &)*arg1,arg2);
      }
      catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return 0;
      }
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuoteVector_Reverse__SWIG_0(void * jarg1) {
  std::vector<boost::shared_ptr<Quote > > *arg1 = (std::vector<boost::shared_ptr<Quote > > *) 0 ;
  
  arg1 = (std::vector<boost::shared_ptr<Quote > > *)jarg1; 
  {
    try {
      std_vector_Sl_boost_shared_ptr_Sl_Quote_Sg__Sg__Reverse__SWIG_0(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuoteVector_Reverse__SWIG_1(void * jarg1, int jarg2, int jarg3) {
  std::vector<boost::shared_ptr<Quote > > *arg1 = (std::vector<boost::shared_ptr<Quote > > *) 0 ;
  int arg2 ;
  int arg3 ;
  
  arg1 = (std::vector<boost::shared_ptr<Quote > > *)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  {
    try {
      try {
        std_vector_Sl_boost_shared_ptr_Sl_Quote_Sg__Sg__Reverse__SWIG_1(arg1,arg2,arg3);
      }
      catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return ;
      }
      catch(std::invalid_argument &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentException, (&_e)->what(), "");
        return ;
      }
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuoteVector_SetRange(void * jarg1, int jarg2, void * jarg3) {
  std::vector<boost::shared_ptr<Quote > > *arg1 = (std::vector<boost::shared_ptr<Quote > > *) 0 ;
  int arg2 ;
  std::vector<boost::shared_ptr<Quote > > *arg3 = 0 ;
  
  arg1 = (std::vector<boost::shared_ptr<Quote > > *)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (std::vector<boost::shared_ptr<Quote > > *)jarg3;
  if(!arg3) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "std::vector<boost::shared_ptr<Quote > > const & type is null", 0);
    return ;
  } 
  {
    try {
      try {
        std_vector_Sl_boost_shared_ptr_Sl_Quote_Sg__Sg__SetRange(arg1,arg2,(std::vector<boost::shared_ptr<Quote > > const &)*arg3);
      }
      catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return ;
      }
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT unsigned int SWIGSTDCALL CSharp_QuoteVector_Contains(void * jarg1, void * jarg2) {
  unsigned int jresult ;
  std::vector<boost::shared_ptr<Quote > > *arg1 = (std::vector<boost::shared_ptr<Quote > > *) 0 ;
  std::vector<boost::shared_ptr<Quote > >::value_type *arg2 = 0 ;
  bool result;
  
  arg1 = (std::vector<boost::shared_ptr<Quote > > *)jarg1; 
  arg2 = (std::vector<boost::shared_ptr<Quote > >::value_type *)jarg2;
  if(!arg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "std::vector<boost::shared_ptr<Quote > >::value_type const & type is null", 0);
    return 0;
  } 
  {
    try {
      result = (bool)std_vector_Sl_boost_shared_ptr_Sl_Quote_Sg__Sg__Contains(arg1,(boost::shared_ptr<Quote > const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT int SWIGSTDCALL CSharp_QuoteVector_IndexOf(void * jarg1, void * jarg2) {
  int jresult ;
  std::vector<boost::shared_ptr<Quote > > *arg1 = (std::vector<boost::shared_ptr<Quote > > *) 0 ;
  std::vector<boost::shared_ptr<Quote > >::value_type *arg2 = 0 ;
  int result;
  
  arg1 = (std::vector<boost::shared_ptr<Quote > > *)jarg1; 
  arg2 = (std::vector<boost::shared_ptr<Quote > >::value_type *)jarg2;
  if(!arg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "std::vector<boost::shared_ptr<Quote > >::value_type const & type is null", 0);
    return 0;
  } 
  {
    try {
      result = (int)std_vector_Sl_boost_shared_ptr_Sl_Quote_Sg__Sg__IndexOf(arg1,(boost::shared_ptr<Quote > const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT int SWIGSTDCALL CSharp_QuoteVector_LastIndexOf(void * jarg1, void * jarg2) {
  int jresult ;
  std::vector<boost::shared_ptr<Quote > > *arg1 = (std::vector<boost::shared_ptr<Quote > > *) 0 ;
  std::vector<boost::shared_ptr<Quote > >::value_type *arg2 = 0 ;
  int result;
  
  arg1 = (std::vector<boost::shared_ptr<Quote > > *)jarg1; 
  arg2 = (std::vector<boost::shared_ptr<Quote > >::value_type *)jarg2;
  if(!arg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "std::vector<boost::shared_ptr<Quote > >::value_type const & type is null", 0);
    return 0;
  } 
  {
    try {
      result = (int)std_vector_Sl_boost_shared_ptr_Sl_Quote_Sg__Sg__LastIndexOf(arg1,(boost::shared_ptr<Quote > const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuoteVector_Remove(void * jarg1, void * jarg2) {
  std::vector<boost::shared_ptr<Quote > > *arg1 = (std::vector<boost::shared_ptr<Quote > > *) 0 ;
  std::vector<boost::shared_ptr<Quote > >::value_type *arg2 = 0 ;
  
  arg1 = (std::vector<boost::shared_ptr<Quote > > *)jarg1; 
  arg2 = (std::vector<boost::shared_ptr<Quote > >::value_type *)jarg2;
  if(!arg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "std::vector<boost::shared_ptr<Quote > >::value_type const & type is null", 0);
    return ;
  } 
  {
    try {
      std_vector_Sl_boost_shared_ptr_Sl_Quote_Sg__Sg__Remove(arg1,(boost::shared_ptr<Quote > const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_QuoteVector(void * jarg1) {
  std::vector<boost::shared_ptr<Quote > > *arg1 = (std::vector<boost::shared_ptr<Quote > > *) 0 ;
  
  arg1 = (std::vector<boost::shared_ptr<Quote > > *)jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuoteHandleVector_Clear(void * jarg1) {
  std::vector<Handle<Quote > > *arg1 = (std::vector<Handle<Quote > > *) 0 ;
  
  arg1 = (std::vector<Handle<Quote > > *)jarg1; 
  {
    try {
      (arg1)->clear();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuoteHandleVector_Add(void * jarg1, void * jarg2) {
  std::vector<Handle<Quote > > *arg1 = (std::vector<Handle<Quote > > *) 0 ;
  std::vector<Handle<Quote > >::value_type *arg2 = 0 ;
  
  arg1 = (std::vector<Handle<Quote > > *)jarg1; 
  arg2 = (std::vector<Handle<Quote > >::value_type *)jarg2;
  if(!arg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "std::vector<Handle<Quote > >::value_type const & type is null", 0);
    return ;
  } 
  {
    try {
      (arg1)->push_back((std::vector<Handle<Quote > >::value_type const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT unsigned long SWIGSTDCALL CSharp_QuoteHandleVector_size(void * jarg1) {
  unsigned long jresult ;
  std::vector<Handle<Quote > > *arg1 = (std::vector<Handle<Quote > > *) 0 ;
  std::vector<Handle<Quote > >::size_type result;
  
  arg1 = (std::vector<Handle<Quote > > *)jarg1; 
  {
    try {
      result = ((std::vector<Handle<Quote > > const *)arg1)->size();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT unsigned long SWIGSTDCALL CSharp_QuoteHandleVector_capacity(void * jarg1) {
  unsigned long jresult ;
  std::vector<Handle<Quote > > *arg1 = (std::vector<Handle<Quote > > *) 0 ;
  std::vector<Handle<Quote > >::size_type result;
  
  arg1 = (std::vector<Handle<Quote > > *)jarg1; 
  {
    try {
      result = ((std::vector<Handle<Quote > > const *)arg1)->capacity();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuoteHandleVector_reserve(void * jarg1, unsigned long jarg2) {
  std::vector<Handle<Quote > > *arg1 = (std::vector<Handle<Quote > > *) 0 ;
  std::vector<Handle<Quote > >::size_type arg2 ;
  
  arg1 = (std::vector<Handle<Quote > > *)jarg1; 
  arg2 = (std::vector<Handle<Quote > >::size_type)jarg2; 
  {
    try {
      (arg1)->reserve(arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_QuoteHandleVector__SWIG_0() {
  void * jresult ;
  std::vector<Handle<Quote > > *result = 0 ;
  
  {
    try {
      result = (std::vector<Handle<Quote > > *)new std::vector<Handle<Quote > >();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_QuoteHandleVector__SWIG_1(int jarg1) {
  void * jresult ;
  int arg1 ;
  std::vector<Handle<Quote > > *result = 0 ;
  
  arg1 = (int)jarg1; 
  {
    try {
      try {
        result = (std::vector<Handle<Quote > > *)new_std_vector_Sl_Handle_Sl_Quote_Sg__Sg___SWIG_1(arg1);
      }
      catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return 0;
      }
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuoteHandleVector_getitemcopy(void * jarg1, int jarg2) {
  void * jresult ;
  std::vector<Handle<Quote > > *arg1 = (std::vector<Handle<Quote > > *) 0 ;
  int arg2 ;
  Handle<Quote > result;
  
  arg1 = (std::vector<Handle<Quote > > *)jarg1; 
  arg2 = (int)jarg2; 
  {
    try {
      try {
        result = std_vector_Sl_Handle_Sl_Quote_Sg__Sg__getitemcopy(arg1,arg2);
      }
      catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return 0;
      }
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = new Handle<Quote >((Handle<Quote > &)result); 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuoteHandleVector_getitem(void * jarg1, int jarg2) {
  void * jresult ;
  std::vector<Handle<Quote > > *arg1 = (std::vector<Handle<Quote > > *) 0 ;
  int arg2 ;
  std::vector<Handle<Quote > >::value_type *result = 0 ;
  
  arg1 = (std::vector<Handle<Quote > > *)jarg1; 
  arg2 = (int)jarg2; 
  {
    try {
      try {
        {
          std::vector<Handle<Quote > >::const_reference _result_ref = std_vector_Sl_Handle_Sl_Quote_Sg__Sg__getitem(arg1,arg2);
          result = (std::vector<Handle<Quote > >::value_type *) &_result_ref;
        }
      }
      catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return 0;
      }
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuoteHandleVector_setitem(void * jarg1, int jarg2, void * jarg3) {
  std::vector<Handle<Quote > > *arg1 = (std::vector<Handle<Quote > > *) 0 ;
  int arg2 ;
  std::vector<Handle<Quote > >::value_type *arg3 = 0 ;
  
  arg1 = (std::vector<Handle<Quote > > *)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (std::vector<Handle<Quote > >::value_type *)jarg3;
  if(!arg3) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "std::vector<Handle<Quote > >::value_type const & type is null", 0);
    return ;
  } 
  {
    try {
      try {
        std_vector_Sl_Handle_Sl_Quote_Sg__Sg__setitem(arg1,arg2,(Handle<Quote > const &)*arg3);
      }
      catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return ;
      }
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuoteHandleVector_AddRange(void * jarg1, void * jarg2) {
  std::vector<Handle<Quote > > *arg1 = (std::vector<Handle<Quote > > *) 0 ;
  std::vector<Handle<Quote > > *arg2 = 0 ;
  
  arg1 = (std::vector<Handle<Quote > > *)jarg1; 
  arg2 = (std::vector<Handle<Quote > > *)jarg2;
  if(!arg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "std::vector<Handle<Quote > > const & type is null", 0);
    return ;
  } 
  {
    try {
      std_vector_Sl_Handle_Sl_Quote_Sg__Sg__AddRange(arg1,(std::vector<Handle<Quote > > const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuoteHandleVector_GetRange(void * jarg1, int jarg2, int jarg3) {
  void * jresult ;
  std::vector<Handle<Quote > > *arg1 = (std::vector<Handle<Quote > > *) 0 ;
  int arg2 ;
  int arg3 ;
  std::vector<Handle<Quote > > *result = 0 ;
  
  arg1 = (std::vector<Handle<Quote > > *)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  {
    try {
      try {
        result = (std::vector<Handle<Quote > > *)std_vector_Sl_Handle_Sl_Quote_Sg__Sg__GetRange(arg1,arg2,arg3);
      }
      catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return 0;
      }
      catch(std::invalid_argument &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentException, (&_e)->what(), "");
        return 0;
      }
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuoteHandleVector_Insert(void * jarg1, int jarg2, void * jarg3) {
  std::vector<Handle<Quote > > *arg1 = (std::vector<Handle<Quote > > *) 0 ;
  int arg2 ;
  std::vector<Handle<Quote > >::value_type *arg3 = 0 ;
  
  arg1 = (std::vector<Handle<Quote > > *)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (std::vector<Handle<Quote > >::value_type *)jarg3;
  if(!arg3) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "std::vector<Handle<Quote > >::value_type const & type is null", 0);
    return ;
  } 
  {
    try {
      try {
        std_vector_Sl_Handle_Sl_Quote_Sg__Sg__Insert(arg1,arg2,(Handle<Quote > const &)*arg3);
      }
      catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return ;
      }
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuoteHandleVector_InsertRange(void * jarg1, int jarg2, void * jarg3) {
  std::vector<Handle<Quote > > *arg1 = (std::vector<Handle<Quote > > *) 0 ;
  int arg2 ;
  std::vector<Handle<Quote > > *arg3 = 0 ;
  
  arg1 = (std::vector<Handle<Quote > > *)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (std::vector<Handle<Quote > > *)jarg3;
  if(!arg3) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "std::vector<Handle<Quote > > const & type is null", 0);
    return ;
  } 
  {
    try {
      try {
        std_vector_Sl_Handle_Sl_Quote_Sg__Sg__InsertRange(arg1,arg2,(std::vector<Handle<Quote > > const &)*arg3);
      }
      catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return ;
      }
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuoteHandleVector_RemoveAt(void * jarg1, int jarg2) {
  std::vector<Handle<Quote > > *arg1 = (std::vector<Handle<Quote > > *) 0 ;
  int arg2 ;
  
  arg1 = (std::vector<Handle<Quote > > *)jarg1; 
  arg2 = (int)jarg2; 
  {
    try {
      try {
        std_vector_Sl_Handle_Sl_Quote_Sg__Sg__RemoveAt(arg1,arg2);
      }
      catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return ;
      }
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuoteHandleVector_RemoveRange(void * jarg1, int jarg2, int jarg3) {
  std::vector<Handle<Quote > > *arg1 = (std::vector<Handle<Quote > > *) 0 ;
  int arg2 ;
  int arg3 ;
  
  arg1 = (std::vector<Handle<Quote > > *)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  {
    try {
      try {
        std_vector_Sl_Handle_Sl_Quote_Sg__Sg__RemoveRange(arg1,arg2,arg3);
      }
      catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return ;
      }
      catch(std::invalid_argument &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentException, (&_e)->what(), "");
        return ;
      }
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_QuoteHandleVector_Repeat(void * jarg1, int jarg2) {
  void * jresult ;
  std::vector<Handle<Quote > >::value_type *arg1 = 0 ;
  int arg2 ;
  std::vector<Handle<Quote > > *result = 0 ;
  
  arg1 = (std::vector<Handle<Quote > >::value_type *)jarg1;
  if(!arg1) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "std::vector<Handle<Quote > >::value_type const & type is null", 0);
    return 0;
  } 
  arg2 = (int)jarg2; 
  {
    try {
      try {
        result = (std::vector<Handle<Quote > > *)std_vector_Sl_Handle_Sl_Quote_Sg__Sg__Repeat((Handle<Quote > const &)*arg1,arg2);
      }
      catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return 0;
      }
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuoteHandleVector_Reverse__SWIG_0(void * jarg1) {
  std::vector<Handle<Quote > > *arg1 = (std::vector<Handle<Quote > > *) 0 ;
  
  arg1 = (std::vector<Handle<Quote > > *)jarg1; 
  {
    try {
      std_vector_Sl_Handle_Sl_Quote_Sg__Sg__Reverse__SWIG_0(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuoteHandleVector_Reverse__SWIG_1(void * jarg1, int jarg2, int jarg3) {
  std::vector<Handle<Quote > > *arg1 = (std::vector<Handle<Quote > > *) 0 ;
  int arg2 ;
  int arg3 ;
  
  arg1 = (std::vector<Handle<Quote > > *)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  {
    try {
      try {
        std_vector_Sl_Handle_Sl_Quote_Sg__Sg__Reverse__SWIG_1(arg1,arg2,arg3);
      }
      catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return ;
      }
      catch(std::invalid_argument &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentException, (&_e)->what(), "");
        return ;
      }
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuoteHandleVector_SetRange(void * jarg1, int jarg2, void * jarg3) {
  std::vector<Handle<Quote > > *arg1 = (std::vector<Handle<Quote > > *) 0 ;
  int arg2 ;
  std::vector<Handle<Quote > > *arg3 = 0 ;
  
  arg1 = (std::vector<Handle<Quote > > *)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (std::vector<Handle<Quote > > *)jarg3;
  if(!arg3) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "std::vector<Handle<Quote > > const & type is null", 0);
    return ;
  } 
  {
    try {
      try {
        std_vector_Sl_Handle_Sl_Quote_Sg__Sg__SetRange(arg1,arg2,(std::vector<Handle<Quote > > const &)*arg3);
      }
      catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return ;
      }
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT unsigned int SWIGSTDCALL CSharp_QuoteHandleVector_Contains(void * jarg1, void * jarg2) {
  unsigned int jresult ;
  std::vector<Handle<Quote > > *arg1 = (std::vector<Handle<Quote > > *) 0 ;
  std::vector<Handle<Quote > >::value_type *arg2 = 0 ;
  bool result;
  
  arg1 = (std::vector<Handle<Quote > > *)jarg1; 
  arg2 = (std::vector<Handle<Quote > >::value_type *)jarg2;
  if(!arg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "std::vector<Handle<Quote > >::value_type const & type is null", 0);
    return 0;
  } 
  {
    try {
      result = (bool)std_vector_Sl_Handle_Sl_Quote_Sg__Sg__Contains(arg1,(Handle<Quote > const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT int SWIGSTDCALL CSharp_QuoteHandleVector_IndexOf(void * jarg1, void * jarg2) {
  int jresult ;
  std::vector<Handle<Quote > > *arg1 = (std::vector<Handle<Quote > > *) 0 ;
  std::vector<Handle<Quote > >::value_type *arg2 = 0 ;
  int result;
  
  arg1 = (std::vector<Handle<Quote > > *)jarg1; 
  arg2 = (std::vector<Handle<Quote > >::value_type *)jarg2;
  if(!arg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "std::vector<Handle<Quote > >::value_type const & type is null", 0);
    return 0;
  } 
  {
    try {
      result = (int)std_vector_Sl_Handle_Sl_Quote_Sg__Sg__IndexOf(arg1,(Handle<Quote > const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT int SWIGSTDCALL CSharp_QuoteHandleVector_LastIndexOf(void * jarg1, void * jarg2) {
  int jresult ;
  std::vector<Handle<Quote > > *arg1 = (std::vector<Handle<Quote > > *) 0 ;
  std::vector<Handle<Quote > >::value_type *arg2 = 0 ;
  int result;
  
  arg1 = (std::vector<Handle<Quote > > *)jarg1; 
  arg2 = (std::vector<Handle<Quote > >::value_type *)jarg2;
  if(!arg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "std::vector<Handle<Quote > >::value_type const & type is null", 0);
    return 0;
  } 
  {
    try {
      result = (int)std_vector_Sl_Handle_Sl_Quote_Sg__Sg__LastIndexOf(arg1,(Handle<Quote > const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_QuoteHandleVector_Remove(void * jarg1, void * jarg2) {
  std::vector<Handle<Quote > > *arg1 = (std::vector<Handle<Quote > > *) 0 ;
  std::vector<Handle<Quote > >::value_type *arg2 = 0 ;
  
  arg1 = (std::vector<Handle<Quote > > *)jarg1; 
  arg2 = (std::vector<Handle<Quote > >::value_type *)jarg2;
  if(!arg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "std::vector<Handle<Quote > >::value_type const & type is null", 0);
    return ;
  } 
  {
    try {
      std_vector_Sl_Handle_Sl_Quote_Sg__Sg__Remove(arg1,(Handle<Quote > const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_QuoteHandleVector(void * jarg1) {
  std::vector<Handle<Quote > > *arg1 = (std::vector<Handle<Quote > > *) 0 ;
  
  arg1 = (std::vector<Handle<Quote > > *)jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_Period__SWIG_0(int jarg1, int jarg2) {
  void * jresult ;
  Integer arg1 ;
  TimeUnit arg2 ;
  Period *result = 0 ;
  
  arg1 = (Integer)jarg1; 
  arg2 = (TimeUnit)jarg2; 
  {
    try {
      result = (Period *)new Period(arg1,arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT int SWIGSTDCALL CSharp_Period_length(void * jarg1) {
  int jresult ;
  Period *arg1 = (Period *) 0 ;
  Integer result;
  
  arg1 = (Period *)jarg1; 
  {
    try {
      result = (Integer)((Period const *)arg1)->length();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT int SWIGSTDCALL CSharp_Period_units(void * jarg1) {
  int jresult ;
  Period *arg1 = (Period *) 0 ;
  TimeUnit result;
  
  arg1 = (Period *)jarg1; 
  {
    try {
      result = (TimeUnit)((Period const *)arg1)->units();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_Period__SWIG_1(char * jarg1) {
  void * jresult ;
  std::string *arg1 = 0 ;
  Period *result = 0 ;
  
  if (!jarg1) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "null string", 0);
    return 0;
  }
  std::string arg1_str(jarg1);
  arg1 = &arg1_str; 
  {
    try {
      result = (Period *)new_Period__SWIG_1((std::string const &)*arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT char * SWIGSTDCALL CSharp_Period___str__(void * jarg1) {
  char * jresult ;
  Period *arg1 = (Period *) 0 ;
  std::string result;
  
  arg1 = (Period *)jarg1; 
  {
    try {
      result = Period___str__(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = SWIG_csharp_string_callback((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT char * SWIGSTDCALL CSharp_Period___repr__(void * jarg1) {
  char * jresult ;
  Period *arg1 = (Period *) 0 ;
  std::string result;
  
  arg1 = (Period *)jarg1; 
  {
    try {
      result = Period___repr__(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = SWIG_csharp_string_callback((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT int SWIGSTDCALL CSharp_Period___cmp__(void * jarg1, void * jarg2) {
  int jresult ;
  Period *arg1 = (Period *) 0 ;
  Period *arg2 = 0 ;
  int result;
  
  arg1 = (Period *)jarg1; 
  arg2 = (Period *)jarg2;
  if(!arg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Period const & type is null", 0);
    return 0;
  } 
  {
    try {
      result = (int)Period___cmp__(arg1,(Period const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_Period(void * jarg1) {
  Period *arg1 = (Period *) 0 ;
  
  arg1 = (Period *)jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_PeriodVector_Clear(void * jarg1) {
  std::vector<Period > *arg1 = (std::vector<Period > *) 0 ;
  
  arg1 = (std::vector<Period > *)jarg1; 
  {
    try {
      (arg1)->clear();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_PeriodVector_Add(void * jarg1, void * jarg2) {
  std::vector<Period > *arg1 = (std::vector<Period > *) 0 ;
  std::vector<Period >::value_type *arg2 = 0 ;
  
  arg1 = (std::vector<Period > *)jarg1; 
  arg2 = (std::vector<Period >::value_type *)jarg2;
  if(!arg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "std::vector<Period >::value_type const & type is null", 0);
    return ;
  } 
  {
    try {
      (arg1)->push_back((std::vector<Period >::value_type const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT unsigned long SWIGSTDCALL CSharp_PeriodVector_size(void * jarg1) {
  unsigned long jresult ;
  std::vector<Period > *arg1 = (std::vector<Period > *) 0 ;
  std::vector<Period >::size_type result;
  
  arg1 = (std::vector<Period > *)jarg1; 
  {
    try {
      result = ((std::vector<Period > const *)arg1)->size();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT unsigned long SWIGSTDCALL CSharp_PeriodVector_capacity(void * jarg1) {
  unsigned long jresult ;
  std::vector<Period > *arg1 = (std::vector<Period > *) 0 ;
  std::vector<Period >::size_type result;
  
  arg1 = (std::vector<Period > *)jarg1; 
  {
    try {
      result = ((std::vector<Period > const *)arg1)->capacity();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_PeriodVector_reserve(void * jarg1, unsigned long jarg2) {
  std::vector<Period > *arg1 = (std::vector<Period > *) 0 ;
  std::vector<Period >::size_type arg2 ;
  
  arg1 = (std::vector<Period > *)jarg1; 
  arg2 = (std::vector<Period >::size_type)jarg2; 
  {
    try {
      (arg1)->reserve(arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_PeriodVector__SWIG_0() {
  void * jresult ;
  std::vector<Period > *result = 0 ;
  
  {
    try {
      result = (std::vector<Period > *)new std::vector<Period >();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_PeriodVector__SWIG_1(int jarg1) {
  void * jresult ;
  int arg1 ;
  std::vector<Period > *result = 0 ;
  
  arg1 = (int)jarg1; 
  {
    try {
      try {
        result = (std::vector<Period > *)new_std_vector_Sl_Period_Sg___SWIG_1(arg1);
      }
      catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return 0;
      }
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_PeriodVector_getitemcopy(void * jarg1, int jarg2) {
  void * jresult ;
  std::vector<Period > *arg1 = (std::vector<Period > *) 0 ;
  int arg2 ;
  SwigValueWrapper<Period > result;
  
  arg1 = (std::vector<Period > *)jarg1; 
  arg2 = (int)jarg2; 
  {
    try {
      try {
        result = std_vector_Sl_Period_Sg__getitemcopy(arg1,arg2);
      }
      catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return 0;
      }
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = new Period((Period &)result); 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_PeriodVector_getitem(void * jarg1, int jarg2) {
  void * jresult ;
  std::vector<Period > *arg1 = (std::vector<Period > *) 0 ;
  int arg2 ;
  std::vector<Period >::value_type *result = 0 ;
  
  arg1 = (std::vector<Period > *)jarg1; 
  arg2 = (int)jarg2; 
  {
    try {
      try {
        {
          std::vector<Period >::const_reference _result_ref = std_vector_Sl_Period_Sg__getitem(arg1,arg2);
          result = (std::vector<Period >::value_type *) &_result_ref;
        }
      }
      catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return 0;
      }
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_PeriodVector_setitem(void * jarg1, int jarg2, void * jarg3) {
  std::vector<Period > *arg1 = (std::vector<Period > *) 0 ;
  int arg2 ;
  std::vector<Period >::value_type *arg3 = 0 ;
  
  arg1 = (std::vector<Period > *)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (std::vector<Period >::value_type *)jarg3;
  if(!arg3) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "std::vector<Period >::value_type const & type is null", 0);
    return ;
  } 
  {
    try {
      try {
        std_vector_Sl_Period_Sg__setitem(arg1,arg2,(Period const &)*arg3);
      }
      catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return ;
      }
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_PeriodVector_AddRange(void * jarg1, void * jarg2) {
  std::vector<Period > *arg1 = (std::vector<Period > *) 0 ;
  std::vector<Period > *arg2 = 0 ;
  
  arg1 = (std::vector<Period > *)jarg1; 
  arg2 = (std::vector<Period > *)jarg2;
  if(!arg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "std::vector<Period > const & type is null", 0);
    return ;
  } 
  {
    try {
      std_vector_Sl_Period_Sg__AddRange(arg1,(std::vector<Period > const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_PeriodVector_GetRange(void * jarg1, int jarg2, int jarg3) {
  void * jresult ;
  std::vector<Period > *arg1 = (std::vector<Period > *) 0 ;
  int arg2 ;
  int arg3 ;
  std::vector<Period > *result = 0 ;
  
  arg1 = (std::vector<Period > *)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  {
    try {
      try {
        result = (std::vector<Period > *)std_vector_Sl_Period_Sg__GetRange(arg1,arg2,arg3);
      }
      catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return 0;
      }
      catch(std::invalid_argument &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentException, (&_e)->what(), "");
        return 0;
      }
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_PeriodVector_Insert(void * jarg1, int jarg2, void * jarg3) {
  std::vector<Period > *arg1 = (std::vector<Period > *) 0 ;
  int arg2 ;
  std::vector<Period >::value_type *arg3 = 0 ;
  
  arg1 = (std::vector<Period > *)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (std::vector<Period >::value_type *)jarg3;
  if(!arg3) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "std::vector<Period >::value_type const & type is null", 0);
    return ;
  } 
  {
    try {
      try {
        std_vector_Sl_Period_Sg__Insert(arg1,arg2,(Period const &)*arg3);
      }
      catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return ;
      }
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_PeriodVector_InsertRange(void * jarg1, int jarg2, void * jarg3) {
  std::vector<Period > *arg1 = (std::vector<Period > *) 0 ;
  int arg2 ;
  std::vector<Period > *arg3 = 0 ;
  
  arg1 = (std::vector<Period > *)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (std::vector<Period > *)jarg3;
  if(!arg3) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "std::vector<Period > const & type is null", 0);
    return ;
  } 
  {
    try {
      try {
        std_vector_Sl_Period_Sg__InsertRange(arg1,arg2,(std::vector<Period > const &)*arg3);
      }
      catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return ;
      }
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_PeriodVector_RemoveAt(void * jarg1, int jarg2) {
  std::vector<Period > *arg1 = (std::vector<Period > *) 0 ;
  int arg2 ;
  
  arg1 = (std::vector<Period > *)jarg1; 
  arg2 = (int)jarg2; 
  {
    try {
      try {
        std_vector_Sl_Period_Sg__RemoveAt(arg1,arg2);
      }
      catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return ;
      }
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_PeriodVector_RemoveRange(void * jarg1, int jarg2, int jarg3) {
  std::vector<Period > *arg1 = (std::vector<Period > *) 0 ;
  int arg2 ;
  int arg3 ;
  
  arg1 = (std::vector<Period > *)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  {
    try {
      try {
        std_vector_Sl_Period_Sg__RemoveRange(arg1,arg2,arg3);
      }
      catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return ;
      }
      catch(std::invalid_argument &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentException, (&_e)->what(), "");
        return ;
      }
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_PeriodVector_Repeat(void * jarg1, int jarg2) {
  void * jresult ;
  std::vector<Period >::value_type *arg1 = 0 ;
  int arg2 ;
  std::vector<Period > *result = 0 ;
  
  arg1 = (std::vector<Period >::value_type *)jarg1;
  if(!arg1) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "std::vector<Period >::value_type const & type is null", 0);
    return 0;
  } 
  arg2 = (int)jarg2; 
  {
    try {
      try {
        result = (std::vector<Period > *)std_vector_Sl_Period_Sg__Repeat((Period const &)*arg1,arg2);
      }
      catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return 0;
      }
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_PeriodVector_Reverse__SWIG_0(void * jarg1) {
  std::vector<Period > *arg1 = (std::vector<Period > *) 0 ;
  
  arg1 = (std::vector<Period > *)jarg1; 
  {
    try {
      std_vector_Sl_Period_Sg__Reverse__SWIG_0(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_PeriodVector_Reverse__SWIG_1(void * jarg1, int jarg2, int jarg3) {
  std::vector<Period > *arg1 = (std::vector<Period > *) 0 ;
  int arg2 ;
  int arg3 ;
  
  arg1 = (std::vector<Period > *)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  {
    try {
      try {
        std_vector_Sl_Period_Sg__Reverse__SWIG_1(arg1,arg2,arg3);
      }
      catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return ;
      }
      catch(std::invalid_argument &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentException, (&_e)->what(), "");
        return ;
      }
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_PeriodVector_SetRange(void * jarg1, int jarg2, void * jarg3) {
  std::vector<Period > *arg1 = (std::vector<Period > *) 0 ;
  int arg2 ;
  std::vector<Period > *arg3 = 0 ;
  
  arg1 = (std::vector<Period > *)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (std::vector<Period > *)jarg3;
  if(!arg3) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "std::vector<Period > const & type is null", 0);
    return ;
  } 
  {
    try {
      try {
        std_vector_Sl_Period_Sg__SetRange(arg1,arg2,(std::vector<Period > const &)*arg3);
      }
      catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return ;
      }
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_PeriodVector(void * jarg1) {
  std::vector<Period > *arg1 = (std::vector<Period > *) 0 ;
  
  arg1 = (std::vector<Period > *)jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_Date__SWIG_0() {
  void * jresult ;
  Date *result = 0 ;
  
  {
    try {
      result = (Date *)new Date();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_Date__SWIG_1(int jarg1, int jarg2, int jarg3) {
  void * jresult ;
  Day arg1 ;
  Month arg2 ;
  Year arg3 ;
  Date *result = 0 ;
  
  arg1 = (Day)jarg1; 
  arg2 = (Month)jarg2; 
  arg3 = (Year)jarg3; 
  {
    try {
      result = (Date *)new Date(arg1,arg2,arg3);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_Date__SWIG_2(long jarg1) {
  void * jresult ;
  BigInteger arg1 ;
  Date *result = 0 ;
  
  arg1 = (BigInteger)jarg1; 
  {
    try {
      result = (Date *)new Date(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT int SWIGSTDCALL CSharp_Date_weekday(void * jarg1) {
  int jresult ;
  Date *arg1 = (Date *) 0 ;
  Weekday result;
  
  arg1 = (Date *)jarg1; 
  {
    try {
      result = (Weekday)((Date const *)arg1)->weekday();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT int SWIGSTDCALL CSharp_Date_dayOfMonth(void * jarg1) {
  int jresult ;
  Date *arg1 = (Date *) 0 ;
  Day result;
  
  arg1 = (Date *)jarg1; 
  {
    try {
      result = (Day)((Date const *)arg1)->dayOfMonth();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT int SWIGSTDCALL CSharp_Date_dayOfYear(void * jarg1) {
  int jresult ;
  Date *arg1 = (Date *) 0 ;
  Day result;
  
  arg1 = (Date *)jarg1; 
  {
    try {
      result = (Day)((Date const *)arg1)->dayOfYear();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT int SWIGSTDCALL CSharp_Date_month(void * jarg1) {
  int jresult ;
  Date *arg1 = (Date *) 0 ;
  Month result;
  
  arg1 = (Date *)jarg1; 
  {
    try {
      result = (Month)((Date const *)arg1)->month();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT int SWIGSTDCALL CSharp_Date_year(void * jarg1) {
  int jresult ;
  Date *arg1 = (Date *) 0 ;
  Year result;
  
  arg1 = (Date *)jarg1; 
  {
    try {
      result = (Year)((Date const *)arg1)->year();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT long SWIGSTDCALL CSharp_Date_serialNumber(void * jarg1) {
  long jresult ;
  Date *arg1 = (Date *) 0 ;
  BigInteger result;
  
  arg1 = (Date *)jarg1; 
  {
    try {
      result = (BigInteger)((Date const *)arg1)->serialNumber();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT unsigned int SWIGSTDCALL CSharp_Date_isLeap(int jarg1) {
  unsigned int jresult ;
  Year arg1 ;
  bool result;
  
  arg1 = (Year)jarg1; 
  {
    try {
      result = (bool)Date::isLeap(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_Date_minDate() {
  void * jresult ;
  Date result;
  
  {
    try {
      result = Date::minDate();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = new Date((Date &)result); 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_Date_maxDate() {
  void * jresult ;
  Date result;
  
  {
    try {
      result = Date::maxDate();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = new Date((Date &)result); 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_Date_todaysDate() {
  void * jresult ;
  Date result;
  
  {
    try {
      result = Date::todaysDate();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = new Date((Date &)result); 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_Date_endOfMonth(void * jarg1) {
  void * jresult ;
  Date *arg1 = 0 ;
  Date result;
  
  arg1 = (Date *)jarg1;
  if(!arg1) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
    return 0;
  } 
  {
    try {
      result = Date::endOfMonth((Date const &)*arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = new Date((Date &)result); 
  return jresult;
}


SWIGEXPORT unsigned int SWIGSTDCALL CSharp_Date_isEOM(void * jarg1) {
  unsigned int jresult ;
  Date *arg1 = 0 ;
  bool result;
  
  arg1 = (Date *)jarg1;
  if(!arg1) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
    return 0;
  } 
  {
    try {
      result = (bool)Date::isEOM((Date const &)*arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_Date_nextWeekday(void * jarg1, int jarg2) {
  void * jresult ;
  Date *arg1 = 0 ;
  Weekday arg2 ;
  Date result;
  
  arg1 = (Date *)jarg1;
  if(!arg1) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
    return 0;
  } 
  arg2 = (Weekday)jarg2; 
  {
    try {
      result = Date::nextWeekday((Date const &)*arg1,arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = new Date((Date &)result); 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_Date_nthWeekday(unsigned long jarg1, int jarg2, int jarg3, int jarg4) {
  void * jresult ;
  Size arg1 ;
  Weekday arg2 ;
  Month arg3 ;
  Year arg4 ;
  Date result;
  
  arg1 = (Size)jarg1; 
  arg2 = (Weekday)jarg2; 
  arg3 = (Month)jarg3; 
  arg4 = (Year)jarg4; 
  {
    try {
      result = Date::nthWeekday(arg1,arg2,arg3,arg4);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = new Date((Date &)result); 
  return jresult;
}


SWIGEXPORT unsigned int SWIGSTDCALL CSharp_Date_isIMMdate(void * jarg1) {
  unsigned int jresult ;
  Date *arg1 = 0 ;
  bool result;
  
  arg1 = (Date *)jarg1;
  if(!arg1) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
    return 0;
  } 
  {
    try {
      result = (bool)Date::isIMMdate((Date const &)*arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_Date_nextIMMdate(void * jarg1) {
  void * jresult ;
  Date *arg1 = 0 ;
  Date result;
  
  arg1 = (Date *)jarg1;
  if(!arg1) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
    return 0;
  } 
  {
    try {
      result = Date::nextIMMdate((Date const &)*arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = new Date((Date &)result); 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_Date__SWIG_3(char * jarg1, char * jarg2) {
  void * jresult ;
  std::string *arg1 = 0 ;
  std::string *arg2 = 0 ;
  Date *result = 0 ;
  
  if (!jarg1) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "null string", 0);
    return 0;
  }
  std::string arg1_str(jarg1);
  arg1 = &arg1_str; 
  if (!jarg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "null string", 0);
    return 0;
  }
  std::string arg2_str(jarg2);
  arg2 = &arg2_str; 
  {
    try {
      result = (Date *)new_Date__SWIG_3((std::string const &)*arg1,(std::string const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT int SWIGSTDCALL CSharp_Date_weekdayNumber(void * jarg1) {
  int jresult ;
  Date *arg1 = (Date *) 0 ;
  Integer result;
  
  arg1 = (Date *)jarg1; 
  {
    try {
      result = (Integer)Date_weekdayNumber(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT char * SWIGSTDCALL CSharp_Date___str__(void * jarg1) {
  char * jresult ;
  Date *arg1 = (Date *) 0 ;
  std::string result;
  
  arg1 = (Date *)jarg1; 
  {
    try {
      result = Date___str__(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = SWIG_csharp_string_callback((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT char * SWIGSTDCALL CSharp_Date___repr__(void * jarg1) {
  char * jresult ;
  Date *arg1 = (Date *) 0 ;
  std::string result;
  
  arg1 = (Date *)jarg1; 
  {
    try {
      result = Date___repr__(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = SWIG_csharp_string_callback((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT char * SWIGSTDCALL CSharp_Date_ISO(void * jarg1) {
  char * jresult ;
  Date *arg1 = (Date *) 0 ;
  std::string result;
  
  arg1 = (Date *)jarg1; 
  {
    try {
      result = Date_ISO(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = SWIG_csharp_string_callback((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_Date(void * jarg1) {
  Date *arg1 = (Date *) 0 ;
  
  arg1 = (Date *)jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_DateParser_parse(char * jarg1, char * jarg2) {
  void * jresult ;
  std::string *arg1 = 0 ;
  std::string *arg2 = 0 ;
  Date result;
  
  if (!jarg1) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "null string", 0);
    return 0;
  }
  std::string arg1_str(jarg1);
  arg1 = &arg1_str; 
  if (!jarg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "null string", 0);
    return 0;
  }
  std::string arg2_str(jarg2);
  arg2 = &arg2_str; 
  {
    try {
      result = DateParser::parse((std::string const &)*arg1,(std::string const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = new Date((Date &)result); 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_DateParser_parseISO(char * jarg1) {
  void * jresult ;
  std::string *arg1 = 0 ;
  Date result;
  
  if (!jarg1) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "null string", 0);
    return 0;
  }
  std::string arg1_str(jarg1);
  arg1 = &arg1_str; 
  {
    try {
      result = DateParser::parseISO((std::string const &)*arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = new Date((Date &)result); 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_DateParser() {
  void * jresult ;
  DateParser *result = 0 ;
  
  {
    try {
      result = (DateParser *)new DateParser();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_DateParser(void * jarg1) {
  DateParser *arg1 = (DateParser *) 0 ;
  
  arg1 = (DateParser *)jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_PeriodParser_parse(char * jarg1) {
  void * jresult ;
  std::string *arg1 = 0 ;
  SwigValueWrapper<Period > result;
  
  if (!jarg1) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "null string", 0);
    return 0;
  }
  std::string arg1_str(jarg1);
  arg1 = &arg1_str; 
  {
    try {
      result = PeriodParser::parse((std::string const &)*arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = new Period((Period &)result); 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_PeriodParser() {
  void * jresult ;
  PeriodParser *result = 0 ;
  
  {
    try {
      result = (PeriodParser *)new PeriodParser();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_PeriodParser(void * jarg1) {
  PeriodParser *arg1 = (PeriodParser *) 0 ;
  
  arg1 = (PeriodParser *)jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_DateVector_Clear(void * jarg1) {
  std::vector<Date > *arg1 = (std::vector<Date > *) 0 ;
  
  arg1 = (std::vector<Date > *)jarg1; 
  {
    try {
      (arg1)->clear();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_DateVector_Add(void * jarg1, void * jarg2) {
  std::vector<Date > *arg1 = (std::vector<Date > *) 0 ;
  std::vector<Date >::value_type *arg2 = 0 ;
  
  arg1 = (std::vector<Date > *)jarg1; 
  arg2 = (std::vector<Date >::value_type *)jarg2;
  if(!arg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "std::vector<Date >::value_type const & type is null", 0);
    return ;
  } 
  {
    try {
      (arg1)->push_back((std::vector<Date >::value_type const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT unsigned long SWIGSTDCALL CSharp_DateVector_size(void * jarg1) {
  unsigned long jresult ;
  std::vector<Date > *arg1 = (std::vector<Date > *) 0 ;
  std::vector<Date >::size_type result;
  
  arg1 = (std::vector<Date > *)jarg1; 
  {
    try {
      result = ((std::vector<Date > const *)arg1)->size();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT unsigned long SWIGSTDCALL CSharp_DateVector_capacity(void * jarg1) {
  unsigned long jresult ;
  std::vector<Date > *arg1 = (std::vector<Date > *) 0 ;
  std::vector<Date >::size_type result;
  
  arg1 = (std::vector<Date > *)jarg1; 
  {
    try {
      result = ((std::vector<Date > const *)arg1)->capacity();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_DateVector_reserve(void * jarg1, unsigned long jarg2) {
  std::vector<Date > *arg1 = (std::vector<Date > *) 0 ;
  std::vector<Date >::size_type arg2 ;
  
  arg1 = (std::vector<Date > *)jarg1; 
  arg2 = (std::vector<Date >::size_type)jarg2; 
  {
    try {
      (arg1)->reserve(arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_DateVector__SWIG_0() {
  void * jresult ;
  std::vector<Date > *result = 0 ;
  
  {
    try {
      result = (std::vector<Date > *)new std::vector<Date >();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_DateVector__SWIG_1(int jarg1) {
  void * jresult ;
  int arg1 ;
  std::vector<Date > *result = 0 ;
  
  arg1 = (int)jarg1; 
  {
    try {
      try {
        result = (std::vector<Date > *)new_std_vector_Sl_Date_Sg___SWIG_1(arg1);
      }
      catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return 0;
      }
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_DateVector_getitemcopy(void * jarg1, int jarg2) {
  void * jresult ;
  std::vector<Date > *arg1 = (std::vector<Date > *) 0 ;
  int arg2 ;
  Date result;
  
  arg1 = (std::vector<Date > *)jarg1; 
  arg2 = (int)jarg2; 
  {
    try {
      try {
        result = std_vector_Sl_Date_Sg__getitemcopy(arg1,arg2);
      }
      catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return 0;
      }
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = new Date((Date &)result); 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_DateVector_getitem(void * jarg1, int jarg2) {
  void * jresult ;
  std::vector<Date > *arg1 = (std::vector<Date > *) 0 ;
  int arg2 ;
  std::vector<Date >::value_type *result = 0 ;
  
  arg1 = (std::vector<Date > *)jarg1; 
  arg2 = (int)jarg2; 
  {
    try {
      try {
        {
          std::vector<Date >::const_reference _result_ref = std_vector_Sl_Date_Sg__getitem(arg1,arg2);
          result = (std::vector<Date >::value_type *) &_result_ref;
        }
      }
      catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return 0;
      }
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_DateVector_setitem(void * jarg1, int jarg2, void * jarg3) {
  std::vector<Date > *arg1 = (std::vector<Date > *) 0 ;
  int arg2 ;
  std::vector<Date >::value_type *arg3 = 0 ;
  
  arg1 = (std::vector<Date > *)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (std::vector<Date >::value_type *)jarg3;
  if(!arg3) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "std::vector<Date >::value_type const & type is null", 0);
    return ;
  } 
  {
    try {
      try {
        std_vector_Sl_Date_Sg__setitem(arg1,arg2,(Date const &)*arg3);
      }
      catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return ;
      }
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_DateVector_AddRange(void * jarg1, void * jarg2) {
  std::vector<Date > *arg1 = (std::vector<Date > *) 0 ;
  std::vector<Date > *arg2 = 0 ;
  
  arg1 = (std::vector<Date > *)jarg1; 
  arg2 = (std::vector<Date > *)jarg2;
  if(!arg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "std::vector<Date > const & type is null", 0);
    return ;
  } 
  {
    try {
      std_vector_Sl_Date_Sg__AddRange(arg1,(std::vector<Date > const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_DateVector_GetRange(void * jarg1, int jarg2, int jarg3) {
  void * jresult ;
  std::vector<Date > *arg1 = (std::vector<Date > *) 0 ;
  int arg2 ;
  int arg3 ;
  std::vector<Date > *result = 0 ;
  
  arg1 = (std::vector<Date > *)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  {
    try {
      try {
        result = (std::vector<Date > *)std_vector_Sl_Date_Sg__GetRange(arg1,arg2,arg3);
      }
      catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return 0;
      }
      catch(std::invalid_argument &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentException, (&_e)->what(), "");
        return 0;
      }
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_DateVector_Insert(void * jarg1, int jarg2, void * jarg3) {
  std::vector<Date > *arg1 = (std::vector<Date > *) 0 ;
  int arg2 ;
  std::vector<Date >::value_type *arg3 = 0 ;
  
  arg1 = (std::vector<Date > *)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (std::vector<Date >::value_type *)jarg3;
  if(!arg3) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "std::vector<Date >::value_type const & type is null", 0);
    return ;
  } 
  {
    try {
      try {
        std_vector_Sl_Date_Sg__Insert(arg1,arg2,(Date const &)*arg3);
      }
      catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return ;
      }
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_DateVector_InsertRange(void * jarg1, int jarg2, void * jarg3) {
  std::vector<Date > *arg1 = (std::vector<Date > *) 0 ;
  int arg2 ;
  std::vector<Date > *arg3 = 0 ;
  
  arg1 = (std::vector<Date > *)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (std::vector<Date > *)jarg3;
  if(!arg3) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "std::vector<Date > const & type is null", 0);
    return ;
  } 
  {
    try {
      try {
        std_vector_Sl_Date_Sg__InsertRange(arg1,arg2,(std::vector<Date > const &)*arg3);
      }
      catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return ;
      }
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_DateVector_RemoveAt(void * jarg1, int jarg2) {
  std::vector<Date > *arg1 = (std::vector<Date > *) 0 ;
  int arg2 ;
  
  arg1 = (std::vector<Date > *)jarg1; 
  arg2 = (int)jarg2; 
  {
    try {
      try {
        std_vector_Sl_Date_Sg__RemoveAt(arg1,arg2);
      }
      catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return ;
      }
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_DateVector_RemoveRange(void * jarg1, int jarg2, int jarg3) {
  std::vector<Date > *arg1 = (std::vector<Date > *) 0 ;
  int arg2 ;
  int arg3 ;
  
  arg1 = (std::vector<Date > *)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  {
    try {
      try {
        std_vector_Sl_Date_Sg__RemoveRange(arg1,arg2,arg3);
      }
      catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return ;
      }
      catch(std::invalid_argument &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentException, (&_e)->what(), "");
        return ;
      }
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_DateVector_Repeat(void * jarg1, int jarg2) {
  void * jresult ;
  std::vector<Date >::value_type *arg1 = 0 ;
  int arg2 ;
  std::vector<Date > *result = 0 ;
  
  arg1 = (std::vector<Date >::value_type *)jarg1;
  if(!arg1) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "std::vector<Date >::value_type const & type is null", 0);
    return 0;
  } 
  arg2 = (int)jarg2; 
  {
    try {
      try {
        result = (std::vector<Date > *)std_vector_Sl_Date_Sg__Repeat((Date const &)*arg1,arg2);
      }
      catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return 0;
      }
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_DateVector_Reverse__SWIG_0(void * jarg1) {
  std::vector<Date > *arg1 = (std::vector<Date > *) 0 ;
  
  arg1 = (std::vector<Date > *)jarg1; 
  {
    try {
      std_vector_Sl_Date_Sg__Reverse__SWIG_0(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_DateVector_Reverse__SWIG_1(void * jarg1, int jarg2, int jarg3) {
  std::vector<Date > *arg1 = (std::vector<Date > *) 0 ;
  int arg2 ;
  int arg3 ;
  
  arg1 = (std::vector<Date > *)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  {
    try {
      try {
        std_vector_Sl_Date_Sg__Reverse__SWIG_1(arg1,arg2,arg3);
      }
      catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return ;
      }
      catch(std::invalid_argument &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentException, (&_e)->what(), "");
        return ;
      }
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_DateVector_SetRange(void * jarg1, int jarg2, void * jarg3) {
  std::vector<Date > *arg1 = (std::vector<Date > *) 0 ;
  int arg2 ;
  std::vector<Date > *arg3 = 0 ;
  
  arg1 = (std::vector<Date > *)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (std::vector<Date > *)jarg3;
  if(!arg3) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "std::vector<Date > const & type is null", 0);
    return ;
  } 
  {
    try {
      try {
        std_vector_Sl_Date_Sg__SetRange(arg1,arg2,(std::vector<Date > const &)*arg3);
      }
      catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return ;
      }
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_DateVector(void * jarg1) {
  std::vector<Date > *arg1 = (std::vector<Date > *) 0 ;
  
  arg1 = (std::vector<Date > *)jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT int SWIGSTDCALL CSharp_nullInt() {
  int jresult ;
  int result;
  
  {
    try {
      result = (int)nullInt();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT double SWIGSTDCALL CSharp_nullDouble() {
  double jresult ;
  double result;
  
  {
    try {
      result = (double)nullDouble();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT long SWIGSTDCALL CSharp_DayCounter_dayCount(void * jarg1, void * jarg2, void * jarg3) {
  long jresult ;
  DayCounter *arg1 = (DayCounter *) 0 ;
  Date *arg2 = 0 ;
  Date *arg3 = 0 ;
  BigInteger result;
  
  arg1 = (DayCounter *)jarg1; 
  arg2 = (Date *)jarg2;
  if(!arg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
    return 0;
  } 
  arg3 = (Date *)jarg3;
  if(!arg3) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
    return 0;
  } 
  {
    try {
      result = (BigInteger)(arg1)->dayCount((Date const &)*arg2,(Date const &)*arg3);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT double SWIGSTDCALL CSharp_DayCounter_yearFraction__SWIG_0(void * jarg1, void * jarg2, void * jarg3, void * jarg4, void * jarg5) {
  double jresult ;
  DayCounter *arg1 = (DayCounter *) 0 ;
  Date *arg2 = 0 ;
  Date *arg3 = 0 ;
  Date *arg4 = 0 ;
  Date *arg5 = 0 ;
  Time result;
  
  arg1 = (DayCounter *)jarg1; 
  arg2 = (Date *)jarg2;
  if(!arg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
    return 0;
  } 
  arg3 = (Date *)jarg3;
  if(!arg3) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
    return 0;
  } 
  arg4 = (Date *)jarg4;
  if(!arg4) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
    return 0;
  } 
  arg5 = (Date *)jarg5;
  if(!arg5) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
    return 0;
  } 
  {
    try {
      result = (Time)(arg1)->yearFraction((Date const &)*arg2,(Date const &)*arg3,(Date const &)*arg4,(Date const &)*arg5);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT double SWIGSTDCALL CSharp_DayCounter_yearFraction__SWIG_1(void * jarg1, void * jarg2, void * jarg3, void * jarg4) {
  double jresult ;
  DayCounter *arg1 = (DayCounter *) 0 ;
  Date *arg2 = 0 ;
  Date *arg3 = 0 ;
  Date *arg4 = 0 ;
  Time result;
  
  arg1 = (DayCounter *)jarg1; 
  arg2 = (Date *)jarg2;
  if(!arg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
    return 0;
  } 
  arg3 = (Date *)jarg3;
  if(!arg3) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
    return 0;
  } 
  arg4 = (Date *)jarg4;
  if(!arg4) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
    return 0;
  } 
  {
    try {
      result = (Time)(arg1)->yearFraction((Date const &)*arg2,(Date const &)*arg3,(Date const &)*arg4);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT double SWIGSTDCALL CSharp_DayCounter_yearFraction__SWIG_2(void * jarg1, void * jarg2, void * jarg3) {
  double jresult ;
  DayCounter *arg1 = (DayCounter *) 0 ;
  Date *arg2 = 0 ;
  Date *arg3 = 0 ;
  Time result;
  
  arg1 = (DayCounter *)jarg1; 
  arg2 = (Date *)jarg2;
  if(!arg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
    return 0;
  } 
  arg3 = (Date *)jarg3;
  if(!arg3) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
    return 0;
  } 
  {
    try {
      result = (Time)(arg1)->yearFraction((Date const &)*arg2,(Date const &)*arg3);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT char * SWIGSTDCALL CSharp_DayCounter___str__(void * jarg1) {
  char * jresult ;
  DayCounter *arg1 = (DayCounter *) 0 ;
  std::string result;
  
  arg1 = (DayCounter *)jarg1; 
  {
    try {
      result = DayCounter___str__(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = SWIG_csharp_string_callback((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_DayCounter(void * jarg1) {
  DayCounter *arg1 = (DayCounter *) 0 ;
  
  arg1 = (DayCounter *)jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_Actual360() {
  void * jresult ;
  QuantLib::Actual360 *result = 0 ;
  
  {
    try {
      result = (QuantLib::Actual360 *)new QuantLib::Actual360();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_Actual360(void * jarg1) {
  QuantLib::Actual360 *arg1 = (QuantLib::Actual360 *) 0 ;
  
  arg1 = (QuantLib::Actual360 *)jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_Actual365Fixed() {
  void * jresult ;
  QuantLib::Actual365Fixed *result = 0 ;
  
  {
    try {
      result = (QuantLib::Actual365Fixed *)new QuantLib::Actual365Fixed();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_Actual365Fixed(void * jarg1) {
  QuantLib::Actual365Fixed *arg1 = (QuantLib::Actual365Fixed *) 0 ;
  
  arg1 = (QuantLib::Actual365Fixed *)jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_Thirty360__SWIG_0(int jarg1) {
  void * jresult ;
  QuantLib::Thirty360::Convention arg1 ;
  QuantLib::Thirty360 *result = 0 ;
  
  arg1 = (QuantLib::Thirty360::Convention)jarg1; 
  {
    try {
      result = (QuantLib::Thirty360 *)new QuantLib::Thirty360(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_Thirty360__SWIG_1() {
  void * jresult ;
  QuantLib::Thirty360 *result = 0 ;
  
  {
    try {
      result = (QuantLib::Thirty360 *)new QuantLib::Thirty360();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_Thirty360(void * jarg1) {
  QuantLib::Thirty360 *arg1 = (QuantLib::Thirty360 *) 0 ;
  
  arg1 = (QuantLib::Thirty360 *)jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_ActualActual__SWIG_0(int jarg1) {
  void * jresult ;
  QuantLib::ActualActual::Convention arg1 ;
  QuantLib::ActualActual *result = 0 ;
  
  arg1 = (QuantLib::ActualActual::Convention)jarg1; 
  {
    try {
      result = (QuantLib::ActualActual *)new QuantLib::ActualActual(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_ActualActual__SWIG_1() {
  void * jresult ;
  QuantLib::ActualActual *result = 0 ;
  
  {
    try {
      result = (QuantLib::ActualActual *)new QuantLib::ActualActual();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_ActualActual(void * jarg1) {
  QuantLib::ActualActual *arg1 = (QuantLib::ActualActual *) 0 ;
  
  arg1 = (QuantLib::ActualActual *)jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_OneDayCounter() {
  void * jresult ;
  QuantLib::OneDayCounter *result = 0 ;
  
  {
    try {
      result = (QuantLib::OneDayCounter *)new QuantLib::OneDayCounter();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_OneDayCounter(void * jarg1) {
  QuantLib::OneDayCounter *arg1 = (QuantLib::OneDayCounter *) 0 ;
  
  arg1 = (QuantLib::OneDayCounter *)jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_SimpleDayCounter() {
  void * jresult ;
  QuantLib::SimpleDayCounter *result = 0 ;
  
  {
    try {
      result = (QuantLib::SimpleDayCounter *)new QuantLib::SimpleDayCounter();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_SimpleDayCounter(void * jarg1) {
  QuantLib::SimpleDayCounter *arg1 = (QuantLib::SimpleDayCounter *) 0 ;
  
  arg1 = (QuantLib::SimpleDayCounter *)jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_InterestRate__SWIG_0() {
  void * jresult ;
  InterestRate *result = 0 ;
  
  {
    try {
      result = (InterestRate *)new InterestRate();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_InterestRate__SWIG_1(double jarg1, void * jarg2, int jarg3, int jarg4) {
  void * jresult ;
  Rate arg1 ;
  DayCounter *arg2 = 0 ;
  Compounding arg3 ;
  Frequency arg4 ;
  InterestRate *result = 0 ;
  
  arg1 = (Rate)jarg1; 
  arg2 = (DayCounter *)jarg2;
  if(!arg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "DayCounter const & type is null", 0);
    return 0;
  } 
  arg3 = (Compounding)jarg3; 
  arg4 = (Frequency)jarg4; 
  {
    try {
      result = (InterestRate *)new InterestRate(arg1,(DayCounter const &)*arg2,arg3,arg4);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_InterestRate__SWIG_2(double jarg1, void * jarg2, int jarg3) {
  void * jresult ;
  Rate arg1 ;
  DayCounter *arg2 = 0 ;
  Compounding arg3 ;
  InterestRate *result = 0 ;
  
  arg1 = (Rate)jarg1; 
  arg2 = (DayCounter *)jarg2;
  if(!arg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "DayCounter const & type is null", 0);
    return 0;
  } 
  arg3 = (Compounding)jarg3; 
  {
    try {
      result = (InterestRate *)new InterestRate(arg1,(DayCounter const &)*arg2,arg3);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT double SWIGSTDCALL CSharp_InterestRate_rate(void * jarg1) {
  double jresult ;
  InterestRate *arg1 = (InterestRate *) 0 ;
  Rate result;
  
  arg1 = (InterestRate *)jarg1; 
  {
    try {
      result = (Rate)((InterestRate const *)arg1)->rate();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_InterestRate_dayCounter(void * jarg1) {
  void * jresult ;
  InterestRate *arg1 = (InterestRate *) 0 ;
  SwigValueWrapper<DayCounter > result;
  
  arg1 = (InterestRate *)jarg1; 
  {
    try {
      result = ((InterestRate const *)arg1)->dayCounter();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = new DayCounter((DayCounter &)result); 
  return jresult;
}


SWIGEXPORT int SWIGSTDCALL CSharp_InterestRate_compounding(void * jarg1) {
  int jresult ;
  InterestRate *arg1 = (InterestRate *) 0 ;
  Compounding result;
  
  arg1 = (InterestRate *)jarg1; 
  {
    try {
      result = (Compounding)((InterestRate const *)arg1)->compounding();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT int SWIGSTDCALL CSharp_InterestRate_frequency(void * jarg1) {
  int jresult ;
  InterestRate *arg1 = (InterestRate *) 0 ;
  Frequency result;
  
  arg1 = (InterestRate *)jarg1; 
  {
    try {
      result = (Frequency)((InterestRate const *)arg1)->frequency();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT double SWIGSTDCALL CSharp_InterestRate_discountFactor__SWIG_0(void * jarg1, double jarg2) {
  double jresult ;
  InterestRate *arg1 = (InterestRate *) 0 ;
  Time arg2 ;
  DiscountFactor result;
  
  arg1 = (InterestRate *)jarg1; 
  arg2 = (Time)jarg2; 
  {
    try {
      result = (DiscountFactor)((InterestRate const *)arg1)->discountFactor(arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT double SWIGSTDCALL CSharp_InterestRate_discountFactor__SWIG_1(void * jarg1, void * jarg2, void * jarg3) {
  double jresult ;
  InterestRate *arg1 = (InterestRate *) 0 ;
  Date arg2 ;
  Date arg3 ;
  DiscountFactor result;
  Date *argp2 ;
  Date *argp3 ;
  
  arg1 = (InterestRate *)jarg1; 
  argp2 = (Date *)jarg2; 
  if (!argp2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Attempt to dereference null Date", 0);
    return 0;
  }
  arg2 = *argp2; 
  argp3 = (Date *)jarg3; 
  if (!argp3) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Attempt to dereference null Date", 0);
    return 0;
  }
  arg3 = *argp3; 
  {
    try {
      result = (DiscountFactor)((InterestRate const *)arg1)->discountFactor(arg2,arg3);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT double SWIGSTDCALL CSharp_InterestRate_compoundFactor__SWIG_0(void * jarg1, double jarg2) {
  double jresult ;
  InterestRate *arg1 = (InterestRate *) 0 ;
  Time arg2 ;
  Real result;
  
  arg1 = (InterestRate *)jarg1; 
  arg2 = (Time)jarg2; 
  {
    try {
      result = (Real)((InterestRate const *)arg1)->compoundFactor(arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT double SWIGSTDCALL CSharp_InterestRate_compoundFactor__SWIG_1(void * jarg1, void * jarg2, void * jarg3) {
  double jresult ;
  InterestRate *arg1 = (InterestRate *) 0 ;
  Date arg2 ;
  Date arg3 ;
  Real result;
  Date *argp2 ;
  Date *argp3 ;
  
  arg1 = (InterestRate *)jarg1; 
  argp2 = (Date *)jarg2; 
  if (!argp2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Attempt to dereference null Date", 0);
    return 0;
  }
  arg2 = *argp2; 
  argp3 = (Date *)jarg3; 
  if (!argp3) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Attempt to dereference null Date", 0);
    return 0;
  }
  arg3 = *argp3; 
  {
    try {
      result = (Real)((InterestRate const *)arg1)->compoundFactor(arg2,arg3);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_InterestRate_impliedRate__SWIG_0(double jarg1, double jarg2, void * jarg3, int jarg4, int jarg5) {
  void * jresult ;
  Real arg1 ;
  Time arg2 ;
  DayCounter *arg3 = 0 ;
  Compounding arg4 ;
  Frequency arg5 ;
  InterestRate result;
  
  arg1 = (Real)jarg1; 
  arg2 = (Time)jarg2; 
  arg3 = (DayCounter *)jarg3;
  if(!arg3) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "DayCounter const & type is null", 0);
    return 0;
  } 
  arg4 = (Compounding)jarg4; 
  arg5 = (Frequency)jarg5; 
  {
    try {
      result = InterestRate::impliedRate(arg1,arg2,(DayCounter const &)*arg3,arg4,arg5);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = new InterestRate((InterestRate &)result); 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_InterestRate_impliedRate__SWIG_1(double jarg1, double jarg2, void * jarg3, int jarg4) {
  void * jresult ;
  Real arg1 ;
  Time arg2 ;
  DayCounter *arg3 = 0 ;
  Compounding arg4 ;
  InterestRate result;
  
  arg1 = (Real)jarg1; 
  arg2 = (Time)jarg2; 
  arg3 = (DayCounter *)jarg3;
  if(!arg3) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "DayCounter const & type is null", 0);
    return 0;
  } 
  arg4 = (Compounding)jarg4; 
  {
    try {
      result = InterestRate::impliedRate(arg1,arg2,(DayCounter const &)*arg3,arg4);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = new InterestRate((InterestRate &)result); 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_InterestRate_impliedRate__SWIG_2(double jarg1, void * jarg2, void * jarg3, void * jarg4, int jarg5, int jarg6) {
  void * jresult ;
  Real arg1 ;
  Date *arg2 = 0 ;
  Date *arg3 = 0 ;
  DayCounter *arg4 = 0 ;
  Compounding arg5 ;
  Frequency arg6 ;
  InterestRate result;
  
  arg1 = (Real)jarg1; 
  arg2 = (Date *)jarg2;
  if(!arg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
    return 0;
  } 
  arg3 = (Date *)jarg3;
  if(!arg3) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
    return 0;
  } 
  arg4 = (DayCounter *)jarg4;
  if(!arg4) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "DayCounter const & type is null", 0);
    return 0;
  } 
  arg5 = (Compounding)jarg5; 
  arg6 = (Frequency)jarg6; 
  {
    try {
      result = InterestRate::impliedRate(arg1,(Date const &)*arg2,(Date const &)*arg3,(DayCounter const &)*arg4,arg5,arg6);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = new InterestRate((InterestRate &)result); 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_InterestRate_impliedRate__SWIG_3(double jarg1, void * jarg2, void * jarg3, void * jarg4, int jarg5) {
  void * jresult ;
  Real arg1 ;
  Date *arg2 = 0 ;
  Date *arg3 = 0 ;
  DayCounter *arg4 = 0 ;
  Compounding arg5 ;
  InterestRate result;
  
  arg1 = (Real)jarg1; 
  arg2 = (Date *)jarg2;
  if(!arg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
    return 0;
  } 
  arg3 = (Date *)jarg3;
  if(!arg3) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
    return 0;
  } 
  arg4 = (DayCounter *)jarg4;
  if(!arg4) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "DayCounter const & type is null", 0);
    return 0;
  } 
  arg5 = (Compounding)jarg5; 
  {
    try {
      result = InterestRate::impliedRate(arg1,(Date const &)*arg2,(Date const &)*arg3,(DayCounter const &)*arg4,arg5);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = new InterestRate((InterestRate &)result); 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_InterestRate_equivalentRate__SWIG_0(void * jarg1, double jarg2, int jarg3, int jarg4) {
  void * jresult ;
  InterestRate *arg1 = (InterestRate *) 0 ;
  Time arg2 ;
  Compounding arg3 ;
  Frequency arg4 ;
  InterestRate result;
  
  arg1 = (InterestRate *)jarg1; 
  arg2 = (Time)jarg2; 
  arg3 = (Compounding)jarg3; 
  arg4 = (Frequency)jarg4; 
  {
    try {
      result = ((InterestRate const *)arg1)->equivalentRate(arg2,arg3,arg4);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = new InterestRate((InterestRate &)result); 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_InterestRate_equivalentRate__SWIG_1(void * jarg1, double jarg2, int jarg3) {
  void * jresult ;
  InterestRate *arg1 = (InterestRate *) 0 ;
  Time arg2 ;
  Compounding arg3 ;
  InterestRate result;
  
  arg1 = (InterestRate *)jarg1; 
  arg2 = (Time)jarg2; 
  arg3 = (Compounding)jarg3; 
  {
    try {
      result = ((InterestRate const *)arg1)->equivalentRate(arg2,arg3);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = new InterestRate((InterestRate &)result); 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_InterestRate_equivalentRate__SWIG_2(void * jarg1, void * jarg2, void * jarg3, void * jarg4, int jarg5, int jarg6) {
  void * jresult ;
  InterestRate *arg1 = (InterestRate *) 0 ;
  Date *arg2 = 0 ;
  Date *arg3 = 0 ;
  DayCounter *arg4 = 0 ;
  Compounding arg5 ;
  Frequency arg6 ;
  InterestRate result;
  
  arg1 = (InterestRate *)jarg1; 
  arg2 = (Date *)jarg2;
  if(!arg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
    return 0;
  } 
  arg3 = (Date *)jarg3;
  if(!arg3) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
    return 0;
  } 
  arg4 = (DayCounter *)jarg4;
  if(!arg4) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "DayCounter const & type is null", 0);
    return 0;
  } 
  arg5 = (Compounding)jarg5; 
  arg6 = (Frequency)jarg6; 
  {
    try {
      result = ((InterestRate const *)arg1)->equivalentRate((Date const &)*arg2,(Date const &)*arg3,(DayCounter const &)*arg4,arg5,arg6);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = new InterestRate((InterestRate &)result); 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_InterestRate_equivalentRate__SWIG_3(void * jarg1, void * jarg2, void * jarg3, void * jarg4, int jarg5) {
  void * jresult ;
  InterestRate *arg1 = (InterestRate *) 0 ;
  Date *arg2 = 0 ;
  Date *arg3 = 0 ;
  DayCounter *arg4 = 0 ;
  Compounding arg5 ;
  InterestRate result;
  
  arg1 = (InterestRate *)jarg1; 
  arg2 = (Date *)jarg2;
  if(!arg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
    return 0;
  } 
  arg3 = (Date *)jarg3;
  if(!arg3) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
    return 0;
  } 
  arg4 = (DayCounter *)jarg4;
  if(!arg4) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "DayCounter const & type is null", 0);
    return 0;
  } 
  arg5 = (Compounding)jarg5; 
  {
    try {
      result = ((InterestRate const *)arg1)->equivalentRate((Date const &)*arg2,(Date const &)*arg3,(DayCounter const &)*arg4,arg5);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = new InterestRate((InterestRate &)result); 
  return jresult;
}


SWIGEXPORT char * SWIGSTDCALL CSharp_InterestRate___str__(void * jarg1) {
  char * jresult ;
  InterestRate *arg1 = (InterestRate *) 0 ;
  std::string result;
  
  arg1 = (InterestRate *)jarg1; 
  {
    try {
      result = InterestRate___str__(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = SWIG_csharp_string_callback((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_InterestRate(void * jarg1) {
  InterestRate *arg1 = (InterestRate *) 0 ;
  
  arg1 = (InterestRate *)jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT unsigned int SWIGSTDCALL CSharp_Calendar_isBusinessDay(void * jarg1, void * jarg2) {
  unsigned int jresult ;
  Calendar *arg1 = (Calendar *) 0 ;
  Date *arg2 = 0 ;
  bool result;
  
  arg1 = (Calendar *)jarg1; 
  arg2 = (Date *)jarg2;
  if(!arg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
    return 0;
  } 
  {
    try {
      result = (bool)(arg1)->isBusinessDay((Date const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT unsigned int SWIGSTDCALL CSharp_Calendar_isHoliday(void * jarg1, void * jarg2) {
  unsigned int jresult ;
  Calendar *arg1 = (Calendar *) 0 ;
  Date *arg2 = 0 ;
  bool result;
  
  arg1 = (Calendar *)jarg1; 
  arg2 = (Date *)jarg2;
  if(!arg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
    return 0;
  } 
  {
    try {
      result = (bool)(arg1)->isHoliday((Date const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT unsigned int SWIGSTDCALL CSharp_Calendar_isEndOfMonth(void * jarg1, void * jarg2) {
  unsigned int jresult ;
  Calendar *arg1 = (Calendar *) 0 ;
  Date *arg2 = 0 ;
  bool result;
  
  arg1 = (Calendar *)jarg1; 
  arg2 = (Date *)jarg2;
  if(!arg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
    return 0;
  } 
  {
    try {
      result = (bool)(arg1)->isEndOfMonth((Date const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_Calendar_addHoliday(void * jarg1, void * jarg2) {
  Calendar *arg1 = (Calendar *) 0 ;
  Date *arg2 = 0 ;
  
  arg1 = (Calendar *)jarg1; 
  arg2 = (Date *)jarg2;
  if(!arg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
    return ;
  } 
  {
    try {
      (arg1)->addHoliday((Date const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_Calendar_removeHoliday(void * jarg1, void * jarg2) {
  Calendar *arg1 = (Calendar *) 0 ;
  Date *arg2 = 0 ;
  
  arg1 = (Calendar *)jarg1; 
  arg2 = (Date *)jarg2;
  if(!arg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
    return ;
  } 
  {
    try {
      (arg1)->removeHoliday((Date const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_Calendar_adjust__SWIG_0(void * jarg1, void * jarg2, int jarg3, void * jarg4) {
  void * jresult ;
  Calendar *arg1 = (Calendar *) 0 ;
  Date *arg2 = 0 ;
  BusinessDayConvention arg3 ;
  Date *arg4 = 0 ;
  Date result;
  
  arg1 = (Calendar *)jarg1; 
  arg2 = (Date *)jarg2;
  if(!arg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
    return 0;
  } 
  arg3 = (BusinessDayConvention)jarg3; 
  arg4 = (Date *)jarg4;
  if(!arg4) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
    return 0;
  } 
  {
    try {
      result = (arg1)->adjust((Date const &)*arg2,arg3,(Date const &)*arg4);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = new Date((Date &)result); 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_Calendar_adjust__SWIG_1(void * jarg1, void * jarg2, int jarg3) {
  void * jresult ;
  Calendar *arg1 = (Calendar *) 0 ;
  Date *arg2 = 0 ;
  BusinessDayConvention arg3 ;
  Date result;
  
  arg1 = (Calendar *)jarg1; 
  arg2 = (Date *)jarg2;
  if(!arg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
    return 0;
  } 
  arg3 = (BusinessDayConvention)jarg3; 
  {
    try {
      result = (arg1)->adjust((Date const &)*arg2,arg3);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = new Date((Date &)result); 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_Calendar_adjust__SWIG_2(void * jarg1, void * jarg2) {
  void * jresult ;
  Calendar *arg1 = (Calendar *) 0 ;
  Date *arg2 = 0 ;
  Date result;
  
  arg1 = (Calendar *)jarg1; 
  arg2 = (Date *)jarg2;
  if(!arg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
    return 0;
  } 
  {
    try {
      result = (arg1)->adjust((Date const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = new Date((Date &)result); 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_Calendar_advance__SWIG_0(void * jarg1, void * jarg2, int jarg3, int jarg4, int jarg5) {
  void * jresult ;
  Calendar *arg1 = (Calendar *) 0 ;
  Date *arg2 = 0 ;
  Integer arg3 ;
  TimeUnit arg4 ;
  BusinessDayConvention arg5 ;
  Date result;
  
  arg1 = (Calendar *)jarg1; 
  arg2 = (Date *)jarg2;
  if(!arg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
    return 0;
  } 
  arg3 = (Integer)jarg3; 
  arg4 = (TimeUnit)jarg4; 
  arg5 = (BusinessDayConvention)jarg5; 
  {
    try {
      result = (arg1)->advance((Date const &)*arg2,arg3,arg4,arg5);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = new Date((Date &)result); 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_Calendar_advance__SWIG_1(void * jarg1, void * jarg2, int jarg3, int jarg4) {
  void * jresult ;
  Calendar *arg1 = (Calendar *) 0 ;
  Date *arg2 = 0 ;
  Integer arg3 ;
  TimeUnit arg4 ;
  Date result;
  
  arg1 = (Calendar *)jarg1; 
  arg2 = (Date *)jarg2;
  if(!arg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
    return 0;
  } 
  arg3 = (Integer)jarg3; 
  arg4 = (TimeUnit)jarg4; 
  {
    try {
      result = (arg1)->advance((Date const &)*arg2,arg3,arg4);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = new Date((Date &)result); 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_Calendar_advance__SWIG_2(void * jarg1, void * jarg2, void * jarg3, int jarg4) {
  void * jresult ;
  Calendar *arg1 = (Calendar *) 0 ;
  Date *arg2 = 0 ;
  Period *arg3 = 0 ;
  BusinessDayConvention arg4 ;
  Date result;
  
  arg1 = (Calendar *)jarg1; 
  arg2 = (Date *)jarg2;
  if(!arg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
    return 0;
  } 
  arg3 = (Period *)jarg3;
  if(!arg3) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Period const & type is null", 0);
    return 0;
  } 
  arg4 = (BusinessDayConvention)jarg4; 
  {
    try {
      result = (arg1)->advance((Date const &)*arg2,(Period const &)*arg3,arg4);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = new Date((Date &)result); 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_Calendar_advance__SWIG_3(void * jarg1, void * jarg2, void * jarg3) {
  void * jresult ;
  Calendar *arg1 = (Calendar *) 0 ;
  Date *arg2 = 0 ;
  Period *arg3 = 0 ;
  Date result;
  
  arg1 = (Calendar *)jarg1; 
  arg2 = (Date *)jarg2;
  if(!arg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
    return 0;
  } 
  arg3 = (Period *)jarg3;
  if(!arg3) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Period const & type is null", 0);
    return 0;
  } 
  {
    try {
      result = (arg1)->advance((Date const &)*arg2,(Period const &)*arg3);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = new Date((Date &)result); 
  return jresult;
}


SWIGEXPORT char * SWIGSTDCALL CSharp_Calendar___str__(void * jarg1) {
  char * jresult ;
  Calendar *arg1 = (Calendar *) 0 ;
  std::string result;
  
  arg1 = (Calendar *)jarg1; 
  {
    try {
      result = Calendar___str__(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = SWIG_csharp_string_callback((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_Calendar(void * jarg1) {
  Calendar *arg1 = (Calendar *) 0 ;
  
  arg1 = (Calendar *)jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_Argentina__SWIG_0(int jarg1) {
  void * jresult ;
  QuantLib::Argentina::Market arg1 ;
  QuantLib::Argentina *result = 0 ;
  
  arg1 = (QuantLib::Argentina::Market)jarg1; 
  {
    try {
      result = (QuantLib::Argentina *)new QuantLib::Argentina(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_Argentina__SWIG_1() {
  void * jresult ;
  QuantLib::Argentina *result = 0 ;
  
  {
    try {
      result = (QuantLib::Argentina *)new QuantLib::Argentina();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_Argentina(void * jarg1) {
  QuantLib::Argentina *arg1 = (QuantLib::Argentina *) 0 ;
  
  arg1 = (QuantLib::Argentina *)jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_Australia() {
  void * jresult ;
  QuantLib::Australia *result = 0 ;
  
  {
    try {
      result = (QuantLib::Australia *)new QuantLib::Australia();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_Australia(void * jarg1) {
  QuantLib::Australia *arg1 = (QuantLib::Australia *) 0 ;
  
  arg1 = (QuantLib::Australia *)jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_Canada() {
  void * jresult ;
  QuantLib::Canada *result = 0 ;
  
  {
    try {
      result = (QuantLib::Canada *)new QuantLib::Canada();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_Canada(void * jarg1) {
  QuantLib::Canada *arg1 = (QuantLib::Canada *) 0 ;
  
  arg1 = (QuantLib::Canada *)jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_China() {
  void * jresult ;
  QuantLib::China *result = 0 ;
  
  {
    try {
      result = (QuantLib::China *)new QuantLib::China();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_China(void * jarg1) {
  QuantLib::China *arg1 = (QuantLib::China *) 0 ;
  
  arg1 = (QuantLib::China *)jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_CzechRepublic__SWIG_0(int jarg1) {
  void * jresult ;
  QuantLib::CzechRepublic::Market arg1 ;
  QuantLib::CzechRepublic *result = 0 ;
  
  arg1 = (QuantLib::CzechRepublic::Market)jarg1; 
  {
    try {
      result = (QuantLib::CzechRepublic *)new QuantLib::CzechRepublic(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_CzechRepublic__SWIG_1() {
  void * jresult ;
  QuantLib::CzechRepublic *result = 0 ;
  
  {
    try {
      result = (QuantLib::CzechRepublic *)new QuantLib::CzechRepublic();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_CzechRepublic(void * jarg1) {
  QuantLib::CzechRepublic *arg1 = (QuantLib::CzechRepublic *) 0 ;
  
  arg1 = (QuantLib::CzechRepublic *)jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_Denmark() {
  void * jresult ;
  QuantLib::Denmark *result = 0 ;
  
  {
    try {
      result = (QuantLib::Denmark *)new QuantLib::Denmark();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_Denmark(void * jarg1) {
  QuantLib::Denmark *arg1 = (QuantLib::Denmark *) 0 ;
  
  arg1 = (QuantLib::Denmark *)jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_Finland() {
  void * jresult ;
  QuantLib::Finland *result = 0 ;
  
  {
    try {
      result = (QuantLib::Finland *)new QuantLib::Finland();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_Finland(void * jarg1) {
  QuantLib::Finland *arg1 = (QuantLib::Finland *) 0 ;
  
  arg1 = (QuantLib::Finland *)jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_Germany__SWIG_0(int jarg1) {
  void * jresult ;
  QuantLib::Germany::Market arg1 ;
  QuantLib::Germany *result = 0 ;
  
  arg1 = (QuantLib::Germany::Market)jarg1; 
  {
    try {
      result = (QuantLib::Germany *)new QuantLib::Germany(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_Germany__SWIG_1() {
  void * jresult ;
  QuantLib::Germany *result = 0 ;
  
  {
    try {
      result = (QuantLib::Germany *)new QuantLib::Germany();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_Germany(void * jarg1) {
  QuantLib::Germany *arg1 = (QuantLib::Germany *) 0 ;
  
  arg1 = (QuantLib::Germany *)jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_HongKong__SWIG_0(int jarg1) {
  void * jresult ;
  QuantLib::HongKong::Market arg1 ;
  QuantLib::HongKong *result = 0 ;
  
  arg1 = (QuantLib::HongKong::Market)jarg1; 
  {
    try {
      result = (QuantLib::HongKong *)new QuantLib::HongKong(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_HongKong__SWIG_1() {
  void * jresult ;
  QuantLib::HongKong *result = 0 ;
  
  {
    try {
      result = (QuantLib::HongKong *)new QuantLib::HongKong();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_HongKong(void * jarg1) {
  QuantLib::HongKong *arg1 = (QuantLib::HongKong *) 0 ;
  
  arg1 = (QuantLib::HongKong *)jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_Hungary() {
  void * jresult ;
  QuantLib::Hungary *result = 0 ;
  
  {
    try {
      result = (QuantLib::Hungary *)new QuantLib::Hungary();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_Hungary(void * jarg1) {
  QuantLib::Hungary *arg1 = (QuantLib::Hungary *) 0 ;
  
  arg1 = (QuantLib::Hungary *)jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_Iceland__SWIG_0(int jarg1) {
  void * jresult ;
  QuantLib::Iceland::Market arg1 ;
  QuantLib::Iceland *result = 0 ;
  
  arg1 = (QuantLib::Iceland::Market)jarg1; 
  {
    try {
      result = (QuantLib::Iceland *)new QuantLib::Iceland(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_Iceland__SWIG_1() {
  void * jresult ;
  QuantLib::Iceland *result = 0 ;
  
  {
    try {
      result = (QuantLib::Iceland *)new QuantLib::Iceland();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_Iceland(void * jarg1) {
  QuantLib::Iceland *arg1 = (QuantLib::Iceland *) 0 ;
  
  arg1 = (QuantLib::Iceland *)jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_India__SWIG_0(int jarg1) {
  void * jresult ;
  QuantLib::India::Market arg1 ;
  QuantLib::India *result = 0 ;
  
  arg1 = (QuantLib::India::Market)jarg1; 
  {
    try {
      result = (QuantLib::India *)new QuantLib::India(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_India__SWIG_1() {
  void * jresult ;
  QuantLib::India *result = 0 ;
  
  {
    try {
      result = (QuantLib::India *)new QuantLib::India();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_India(void * jarg1) {
  QuantLib::India *arg1 = (QuantLib::India *) 0 ;
  
  arg1 = (QuantLib::India *)jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_Indonesia__SWIG_0(int jarg1) {
  void * jresult ;
  QuantLib::Indonesia::Market arg1 ;
  QuantLib::Indonesia *result = 0 ;
  
  arg1 = (QuantLib::Indonesia::Market)jarg1; 
  {
    try {
      result = (QuantLib::Indonesia *)new QuantLib::Indonesia(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_Indonesia__SWIG_1() {
  void * jresult ;
  QuantLib::Indonesia *result = 0 ;
  
  {
    try {
      result = (QuantLib::Indonesia *)new QuantLib::Indonesia();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_Indonesia(void * jarg1) {
  QuantLib::Indonesia *arg1 = (QuantLib::Indonesia *) 0 ;
  
  arg1 = (QuantLib::Indonesia *)jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_Italy__SWIG_0(int jarg1) {
  void * jresult ;
  QuantLib::Italy::Market arg1 ;
  QuantLib::Italy *result = 0 ;
  
  arg1 = (QuantLib::Italy::Market)jarg1; 
  {
    try {
      result = (QuantLib::Italy *)new QuantLib::Italy(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_Italy__SWIG_1() {
  void * jresult ;
  QuantLib::Italy *result = 0 ;
  
  {
    try {
      result = (QuantLib::Italy *)new QuantLib::Italy();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_Italy(void * jarg1) {
  QuantLib::Italy *arg1 = (QuantLib::Italy *) 0 ;
  
  arg1 = (QuantLib::Italy *)jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_Japan() {
  void * jresult ;
  QuantLib::Japan *result = 0 ;
  
  {
    try {
      result = (QuantLib::Japan *)new QuantLib::Japan();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_Japan(void * jarg1) {
  QuantLib::Japan *arg1 = (QuantLib::Japan *) 0 ;
  
  arg1 = (QuantLib::Japan *)jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_Mexico__SWIG_0(int jarg1) {
  void * jresult ;
  QuantLib::Mexico::Market arg1 ;
  QuantLib::Mexico *result = 0 ;
  
  arg1 = (QuantLib::Mexico::Market)jarg1; 
  {
    try {
      result = (QuantLib::Mexico *)new QuantLib::Mexico(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_Mexico__SWIG_1() {
  void * jresult ;
  QuantLib::Mexico *result = 0 ;
  
  {
    try {
      result = (QuantLib::Mexico *)new QuantLib::Mexico();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_Mexico(void * jarg1) {
  QuantLib::Mexico *arg1 = (QuantLib::Mexico *) 0 ;
  
  arg1 = (QuantLib::Mexico *)jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_NewZealand() {
  void * jresult ;
  QuantLib::NewZealand *result = 0 ;
  
  {
    try {
      result = (QuantLib::NewZealand *)new QuantLib::NewZealand();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_NewZealand(void * jarg1) {
  QuantLib::NewZealand *arg1 = (QuantLib::NewZealand *) 0 ;
  
  arg1 = (QuantLib::NewZealand *)jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_Norway() {
  void * jresult ;
  QuantLib::Norway *result = 0 ;
  
  {
    try {
      result = (QuantLib::Norway *)new QuantLib::Norway();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_Norway(void * jarg1) {
  QuantLib::Norway *arg1 = (QuantLib::Norway *) 0 ;
  
  arg1 = (QuantLib::Norway *)jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_Poland() {
  void * jresult ;
  QuantLib::Poland *result = 0 ;
  
  {
    try {
      result = (QuantLib::Poland *)new QuantLib::Poland();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_Poland(void * jarg1) {
  QuantLib::Poland *arg1 = (QuantLib::Poland *) 0 ;
  
  arg1 = (QuantLib::Poland *)jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_SaudiArabia() {
  void * jresult ;
  QuantLib::SaudiArabia *result = 0 ;
  
  {
    try {
      result = (QuantLib::SaudiArabia *)new QuantLib::SaudiArabia();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_SaudiArabia(void * jarg1) {
  QuantLib::SaudiArabia *arg1 = (QuantLib::SaudiArabia *) 0 ;
  
  arg1 = (QuantLib::SaudiArabia *)jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_Singapore__SWIG_0(int jarg1) {
  void * jresult ;
  QuantLib::Singapore::Market arg1 ;
  QuantLib::Singapore *result = 0 ;
  
  arg1 = (QuantLib::Singapore::Market)jarg1; 
  {
    try {
      result = (QuantLib::Singapore *)new QuantLib::Singapore(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_Singapore__SWIG_1() {
  void * jresult ;
  QuantLib::Singapore *result = 0 ;
  
  {
    try {
      result = (QuantLib::Singapore *)new QuantLib::Singapore();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_Singapore(void * jarg1) {
  QuantLib::Singapore *arg1 = (QuantLib::Singapore *) 0 ;
  
  arg1 = (QuantLib::Singapore *)jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_Slovakia__SWIG_0(int jarg1) {
  void * jresult ;
  QuantLib::Slovakia::Market arg1 ;
  QuantLib::Slovakia *result = 0 ;
  
  arg1 = (QuantLib::Slovakia::Market)jarg1; 
  {
    try {
      result = (QuantLib::Slovakia *)new QuantLib::Slovakia(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_Slovakia__SWIG_1() {
  void * jresult ;
  QuantLib::Slovakia *result = 0 ;
  
  {
    try {
      result = (QuantLib::Slovakia *)new QuantLib::Slovakia();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_Slovakia(void * jarg1) {
  QuantLib::Slovakia *arg1 = (QuantLib::Slovakia *) 0 ;
  
  arg1 = (QuantLib::Slovakia *)jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_SouthAfrica() {
  void * jresult ;
  QuantLib::SouthAfrica *result = 0 ;
  
  {
    try {
      result = (QuantLib::SouthAfrica *)new QuantLib::SouthAfrica();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_SouthAfrica(void * jarg1) {
  QuantLib::SouthAfrica *arg1 = (QuantLib::SouthAfrica *) 0 ;
  
  arg1 = (QuantLib::SouthAfrica *)jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_SouthKorea__SWIG_0(int jarg1) {
  void * jresult ;
  QuantLib::SouthKorea::Market arg1 ;
  QuantLib::SouthKorea *result = 0 ;
  
  arg1 = (QuantLib::SouthKorea::Market)jarg1; 
  {
    try {
      result = (QuantLib::SouthKorea *)new QuantLib::SouthKorea(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_SouthKorea__SWIG_1() {
  void * jresult ;
  QuantLib::SouthKorea *result = 0 ;
  
  {
    try {
      result = (QuantLib::SouthKorea *)new QuantLib::SouthKorea();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_SouthKorea(void * jarg1) {
  QuantLib::SouthKorea *arg1 = (QuantLib::SouthKorea *) 0 ;
  
  arg1 = (QuantLib::SouthKorea *)jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_Sweden() {
  void * jresult ;
  QuantLib::Sweden *result = 0 ;
  
  {
    try {
      result = (QuantLib::Sweden *)new QuantLib::Sweden();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_Sweden(void * jarg1) {
  QuantLib::Sweden *arg1 = (QuantLib::Sweden *) 0 ;
  
  arg1 = (QuantLib::Sweden *)jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_Switzerland() {
  void * jresult ;
  QuantLib::Switzerland *result = 0 ;
  
  {
    try {
      result = (QuantLib::Switzerland *)new QuantLib::Switzerland();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_Switzerland(void * jarg1) {
  QuantLib::Switzerland *arg1 = (QuantLib::Switzerland *) 0 ;
  
  arg1 = (QuantLib::Switzerland *)jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_Taiwan__SWIG_0(int jarg1) {
  void * jresult ;
  QuantLib::Taiwan::Market arg1 ;
  QuantLib::Taiwan *result = 0 ;
  
  arg1 = (QuantLib::Taiwan::Market)jarg1; 
  {
    try {
      result = (QuantLib::Taiwan *)new QuantLib::Taiwan(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_Taiwan__SWIG_1() {
  void * jresult ;
  QuantLib::Taiwan *result = 0 ;
  
  {
    try {
      result = (QuantLib::Taiwan *)new QuantLib::Taiwan();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_Taiwan(void * jarg1) {
  QuantLib::Taiwan *arg1 = (QuantLib::Taiwan *) 0 ;
  
  arg1 = (QuantLib::Taiwan *)jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_TARGET() {
  void * jresult ;
  QuantLib::TARGET *result = 0 ;
  
  {
    try {
      result = (QuantLib::TARGET *)new QuantLib::TARGET();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_TARGET(void * jarg1) {
  QuantLib::TARGET *arg1 = (QuantLib::TARGET *) 0 ;
  
  arg1 = (QuantLib::TARGET *)jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_Turkey() {
  void * jresult ;
  QuantLib::Turkey *result = 0 ;
  
  {
    try {
      result = (QuantLib::Turkey *)new QuantLib::Turkey();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_Turkey(void * jarg1) {
  QuantLib::Turkey *arg1 = (QuantLib::Turkey *) 0 ;
  
  arg1 = (QuantLib::Turkey *)jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_Ukraine__SWIG_0(int jarg1) {
  void * jresult ;
  QuantLib::Ukraine::Market arg1 ;
  QuantLib::Ukraine *result = 0 ;
  
  arg1 = (QuantLib::Ukraine::Market)jarg1; 
  {
    try {
      result = (QuantLib::Ukraine *)new QuantLib::Ukraine(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_Ukraine__SWIG_1() {
  void * jresult ;
  QuantLib::Ukraine *result = 0 ;
  
  {
    try {
      result = (QuantLib::Ukraine *)new QuantLib::Ukraine();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_Ukraine(void * jarg1) {
  QuantLib::Ukraine *arg1 = (QuantLib::Ukraine *) 0 ;
  
  arg1 = (QuantLib::Ukraine *)jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_UnitedKingdom__SWIG_0(int jarg1) {
  void * jresult ;
  QuantLib::UnitedKingdom::Market arg1 ;
  QuantLib::UnitedKingdom *result = 0 ;
  
  arg1 = (QuantLib::UnitedKingdom::Market)jarg1; 
  {
    try {
      result = (QuantLib::UnitedKingdom *)new QuantLib::UnitedKingdom(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_UnitedKingdom__SWIG_1() {
  void * jresult ;
  QuantLib::UnitedKingdom *result = 0 ;
  
  {
    try {
      result = (QuantLib::UnitedKingdom *)new QuantLib::UnitedKingdom();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_UnitedKingdom(void * jarg1) {
  QuantLib::UnitedKingdom *arg1 = (QuantLib::UnitedKingdom *) 0 ;
  
  arg1 = (QuantLib::UnitedKingdom *)jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_UnitedStates__SWIG_0(int jarg1) {
  void * jresult ;
  QuantLib::UnitedStates::Market arg1 ;
  QuantLib::UnitedStates *result = 0 ;
  
  arg1 = (QuantLib::UnitedStates::Market)jarg1; 
  {
    try {
      result = (QuantLib::UnitedStates *)new QuantLib::UnitedStates(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_UnitedStates__SWIG_1() {
  void * jresult ;
  QuantLib::UnitedStates *result = 0 ;
  
  {
    try {
      result = (QuantLib::UnitedStates *)new QuantLib::UnitedStates();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_UnitedStates(void * jarg1) {
  QuantLib::UnitedStates *arg1 = (QuantLib::UnitedStates *) 0 ;
  
  arg1 = (QuantLib::UnitedStates *)jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_NullCalendar() {
  void * jresult ;
  QuantLib::NullCalendar *result = 0 ;
  
  {
    try {
      result = (QuantLib::NullCalendar *)new QuantLib::NullCalendar();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_NullCalendar(void * jarg1) {
  QuantLib::NullCalendar *arg1 = (QuantLib::NullCalendar *) 0 ;
  
  arg1 = (QuantLib::NullCalendar *)jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_JointCalendar__SWIG_0(void * jarg1, void * jarg2, int jarg3) {
  void * jresult ;
  Calendar *arg1 = 0 ;
  Calendar *arg2 = 0 ;
  JointCalendarRule arg3 ;
  QuantLib::JointCalendar *result = 0 ;
  
  arg1 = (Calendar *)jarg1;
  if(!arg1) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Calendar const & type is null", 0);
    return 0;
  } 
  arg2 = (Calendar *)jarg2;
  if(!arg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Calendar const & type is null", 0);
    return 0;
  } 
  arg3 = (JointCalendarRule)jarg3; 
  {
    try {
      result = (QuantLib::JointCalendar *)new QuantLib::JointCalendar((Calendar const &)*arg1,(Calendar const &)*arg2,arg3);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_JointCalendar__SWIG_1(void * jarg1, void * jarg2) {
  void * jresult ;
  Calendar *arg1 = 0 ;
  Calendar *arg2 = 0 ;
  QuantLib::JointCalendar *result = 0 ;
  
  arg1 = (Calendar *)jarg1;
  if(!arg1) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Calendar const & type is null", 0);
    return 0;
  } 
  arg2 = (Calendar *)jarg2;
  if(!arg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Calendar const & type is null", 0);
    return 0;
  } 
  {
    try {
      result = (QuantLib::JointCalendar *)new QuantLib::JointCalendar((Calendar const &)*arg1,(Calendar const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_JointCalendar__SWIG_2(void * jarg1, void * jarg2, void * jarg3, int jarg4) {
  void * jresult ;
  Calendar *arg1 = 0 ;
  Calendar *arg2 = 0 ;
  Calendar *arg3 = 0 ;
  JointCalendarRule arg4 ;
  QuantLib::JointCalendar *result = 0 ;
  
  arg1 = (Calendar *)jarg1;
  if(!arg1) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Calendar const & type is null", 0);
    return 0;
  } 
  arg2 = (Calendar *)jarg2;
  if(!arg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Calendar const & type is null", 0);
    return 0;
  } 
  arg3 = (Calendar *)jarg3;
  if(!arg3) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Calendar const & type is null", 0);
    return 0;
  } 
  arg4 = (JointCalendarRule)jarg4; 
  {
    try {
      result = (QuantLib::JointCalendar *)new QuantLib::JointCalendar((Calendar const &)*arg1,(Calendar const &)*arg2,(Calendar const &)*arg3,arg4);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_JointCalendar__SWIG_3(void * jarg1, void * jarg2, void * jarg3) {
  void * jresult ;
  Calendar *arg1 = 0 ;
  Calendar *arg2 = 0 ;
  Calendar *arg3 = 0 ;
  QuantLib::JointCalendar *result = 0 ;
  
  arg1 = (Calendar *)jarg1;
  if(!arg1) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Calendar const & type is null", 0);
    return 0;
  } 
  arg2 = (Calendar *)jarg2;
  if(!arg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Calendar const & type is null", 0);
    return 0;
  } 
  arg3 = (Calendar *)jarg3;
  if(!arg3) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Calendar const & type is null", 0);
    return 0;
  } 
  {
    try {
      result = (QuantLib::JointCalendar *)new QuantLib::JointCalendar((Calendar const &)*arg1,(Calendar const &)*arg2,(Calendar const &)*arg3);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_JointCalendar__SWIG_4(void * jarg1, void * jarg2, void * jarg3, void * jarg4, int jarg5) {
  void * jresult ;
  Calendar *arg1 = 0 ;
  Calendar *arg2 = 0 ;
  Calendar *arg3 = 0 ;
  Calendar *arg4 = 0 ;
  JointCalendarRule arg5 ;
  QuantLib::JointCalendar *result = 0 ;
  
  arg1 = (Calendar *)jarg1;
  if(!arg1) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Calendar const & type is null", 0);
    return 0;
  } 
  arg2 = (Calendar *)jarg2;
  if(!arg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Calendar const & type is null", 0);
    return 0;
  } 
  arg3 = (Calendar *)jarg3;
  if(!arg3) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Calendar const & type is null", 0);
    return 0;
  } 
  arg4 = (Calendar *)jarg4;
  if(!arg4) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Calendar const & type is null", 0);
    return 0;
  } 
  arg5 = (JointCalendarRule)jarg5; 
  {
    try {
      result = (QuantLib::JointCalendar *)new QuantLib::JointCalendar((Calendar const &)*arg1,(Calendar const &)*arg2,(Calendar const &)*arg3,(Calendar const &)*arg4,arg5);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_JointCalendar__SWIG_5(void * jarg1, void * jarg2, void * jarg3, void * jarg4) {
  void * jresult ;
  Calendar *arg1 = 0 ;
  Calendar *arg2 = 0 ;
  Calendar *arg3 = 0 ;
  Calendar *arg4 = 0 ;
  QuantLib::JointCalendar *result = 0 ;
  
  arg1 = (Calendar *)jarg1;
  if(!arg1) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Calendar const & type is null", 0);
    return 0;
  } 
  arg2 = (Calendar *)jarg2;
  if(!arg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Calendar const & type is null", 0);
    return 0;
  } 
  arg3 = (Calendar *)jarg3;
  if(!arg3) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Calendar const & type is null", 0);
    return 0;
  } 
  arg4 = (Calendar *)jarg4;
  if(!arg4) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Calendar const & type is null", 0);
    return 0;
  } 
  {
    try {
      result = (QuantLib::JointCalendar *)new QuantLib::JointCalendar((Calendar const &)*arg1,(Calendar const &)*arg2,(Calendar const &)*arg3,(Calendar const &)*arg4);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_JointCalendar(void * jarg1) {
  QuantLib::JointCalendar *arg1 = (QuantLib::JointCalendar *) 0 ;
  
  arg1 = (QuantLib::JointCalendar *)jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_Rounding() {
  void * jresult ;
  Rounding *result = 0 ;
  
  {
    try {
      result = (Rounding *)new Rounding();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT double SWIGSTDCALL CSharp_Rounding_apply(void * jarg1, double jarg2) {
  double jresult ;
  Rounding *arg1 = (Rounding *) 0 ;
  Decimal arg2 ;
  Decimal result;
  
  arg1 = (Rounding *)jarg1; 
  arg2 = (Decimal)jarg2; 
  {
    try {
      result = (Decimal)((Rounding const *)arg1)->operator ()(arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_Rounding(void * jarg1) {
  Rounding *arg1 = (Rounding *) 0 ;
  
  arg1 = (Rounding *)jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_UpRounding__SWIG_0(int jarg1, int jarg2) {
  void * jresult ;
  Integer arg1 ;
  Integer arg2 ;
  UpRounding *result = 0 ;
  
  arg1 = (Integer)jarg1; 
  arg2 = (Integer)jarg2; 
  {
    try {
      result = (UpRounding *)new UpRounding(arg1,arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_UpRounding__SWIG_1(int jarg1) {
  void * jresult ;
  Integer arg1 ;
  UpRounding *result = 0 ;
  
  arg1 = (Integer)jarg1; 
  {
    try {
      result = (UpRounding *)new UpRounding(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_UpRounding(void * jarg1) {
  UpRounding *arg1 = (UpRounding *) 0 ;
  
  arg1 = (UpRounding *)jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_DownRounding__SWIG_0(int jarg1, int jarg2) {
  void * jresult ;
  Integer arg1 ;
  Integer arg2 ;
  DownRounding *result = 0 ;
  
  arg1 = (Integer)jarg1; 
  arg2 = (Integer)jarg2; 
  {
    try {
      result = (DownRounding *)new DownRounding(arg1,arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_DownRounding__SWIG_1(int jarg1) {
  void * jresult ;
  Integer arg1 ;
  DownRounding *result = 0 ;
  
  arg1 = (Integer)jarg1; 
  {
    try {
      result = (DownRounding *)new DownRounding(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_DownRounding(void * jarg1) {
  DownRounding *arg1 = (DownRounding *) 0 ;
  
  arg1 = (DownRounding *)jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_ClosestRounding__SWIG_0(int jarg1, int jarg2) {
  void * jresult ;
  Integer arg1 ;
  Integer arg2 ;
  ClosestRounding *result = 0 ;
  
  arg1 = (Integer)jarg1; 
  arg2 = (Integer)jarg2; 
  {
    try {
      result = (ClosestRounding *)new ClosestRounding(arg1,arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_ClosestRounding__SWIG_1(int jarg1) {
  void * jresult ;
  Integer arg1 ;
  ClosestRounding *result = 0 ;
  
  arg1 = (Integer)jarg1; 
  {
    try {
      result = (ClosestRounding *)new ClosestRounding(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_ClosestRounding(void * jarg1) {
  ClosestRounding *arg1 = (ClosestRounding *) 0 ;
  
  arg1 = (ClosestRounding *)jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_CeilingTruncation__SWIG_0(int jarg1, int jarg2) {
  void * jresult ;
  Integer arg1 ;
  Integer arg2 ;
  CeilingTruncation *result = 0 ;
  
  arg1 = (Integer)jarg1; 
  arg2 = (Integer)jarg2; 
  {
    try {
      result = (CeilingTruncation *)new CeilingTruncation(arg1,arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_CeilingTruncation__SWIG_1(int jarg1) {
  void * jresult ;
  Integer arg1 ;
  CeilingTruncation *result = 0 ;
  
  arg1 = (Integer)jarg1; 
  {
    try {
      result = (CeilingTruncation *)new CeilingTruncation(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_CeilingTruncation(void * jarg1) {
  CeilingTruncation *arg1 = (CeilingTruncation *) 0 ;
  
  arg1 = (CeilingTruncation *)jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_FloorTruncation__SWIG_0(int jarg1, int jarg2) {
  void * jresult ;
  Integer arg1 ;
  Integer arg2 ;
  FloorTruncation *result = 0 ;
  
  arg1 = (Integer)jarg1; 
  arg2 = (Integer)jarg2; 
  {
    try {
      result = (FloorTruncation *)new FloorTruncation(arg1,arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_FloorTruncation__SWIG_1(int jarg1) {
  void * jresult ;
  Integer arg1 ;
  FloorTruncation *result = 0 ;
  
  arg1 = (Integer)jarg1; 
  {
    try {
      result = (FloorTruncation *)new FloorTruncation(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_FloorTruncation(void * jarg1) {
  FloorTruncation *arg1 = (FloorTruncation *) 0 ;
  
  arg1 = (FloorTruncation *)jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT char * SWIGSTDCALL CSharp_Currency_name(void * jarg1) {
  char * jresult ;
  Currency *arg1 = (Currency *) 0 ;
  std::string *result = 0 ;
  
  arg1 = (Currency *)jarg1; 
  {
    try {
      {
        std::string const &_result_ref = ((Currency const *)arg1)->name();
        result = (std::string *) &_result_ref;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = SWIG_csharp_string_callback(result->c_str()); 
  return jresult;
}


SWIGEXPORT char * SWIGSTDCALL CSharp_Currency_code(void * jarg1) {
  char * jresult ;
  Currency *arg1 = (Currency *) 0 ;
  std::string *result = 0 ;
  
  arg1 = (Currency *)jarg1; 
  {
    try {
      {
        std::string const &_result_ref = ((Currency const *)arg1)->code();
        result = (std::string *) &_result_ref;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = SWIG_csharp_string_callback(result->c_str()); 
  return jresult;
}


SWIGEXPORT int SWIGSTDCALL CSharp_Currency_numericCode(void * jarg1) {
  int jresult ;
  Currency *arg1 = (Currency *) 0 ;
  Integer result;
  
  arg1 = (Currency *)jarg1; 
  {
    try {
      result = (Integer)((Currency const *)arg1)->numericCode();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT char * SWIGSTDCALL CSharp_Currency_symbol(void * jarg1) {
  char * jresult ;
  Currency *arg1 = (Currency *) 0 ;
  std::string *result = 0 ;
  
  arg1 = (Currency *)jarg1; 
  {
    try {
      {
        std::string const &_result_ref = ((Currency const *)arg1)->symbol();
        result = (std::string *) &_result_ref;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = SWIG_csharp_string_callback(result->c_str()); 
  return jresult;
}


SWIGEXPORT char * SWIGSTDCALL CSharp_Currency_fractionSymbol(void * jarg1) {
  char * jresult ;
  Currency *arg1 = (Currency *) 0 ;
  std::string *result = 0 ;
  
  arg1 = (Currency *)jarg1; 
  {
    try {
      {
        std::string const &_result_ref = ((Currency const *)arg1)->fractionSymbol();
        result = (std::string *) &_result_ref;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = SWIG_csharp_string_callback(result->c_str()); 
  return jresult;
}


SWIGEXPORT int SWIGSTDCALL CSharp_Currency_fractionsPerUnit(void * jarg1) {
  int jresult ;
  Currency *arg1 = (Currency *) 0 ;
  Integer result;
  
  arg1 = (Currency *)jarg1; 
  {
    try {
      result = (Integer)((Currency const *)arg1)->fractionsPerUnit();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_Currency_rounding(void * jarg1) {
  void * jresult ;
  Currency *arg1 = (Currency *) 0 ;
  Rounding *result = 0 ;
  
  arg1 = (Currency *)jarg1; 
  {
    try {
      {
        Rounding const &_result_ref = ((Currency const *)arg1)->rounding();
        result = (Rounding *) &_result_ref;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT unsigned int SWIGSTDCALL CSharp_Currency_isValid(void * jarg1) {
  unsigned int jresult ;
  Currency *arg1 = (Currency *) 0 ;
  bool result;
  
  arg1 = (Currency *)jarg1; 
  {
    try {
      result = (bool)((Currency const *)arg1)->isValid();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_Currency_triangulationCurrency(void * jarg1) {
  void * jresult ;
  Currency *arg1 = (Currency *) 0 ;
  Currency *result = 0 ;
  
  arg1 = (Currency *)jarg1; 
  {
    try {
      {
        Currency const &_result_ref = ((Currency const *)arg1)->triangulationCurrency();
        result = (Currency *) &_result_ref;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT char * SWIGSTDCALL CSharp_Currency___str__(void * jarg1) {
  char * jresult ;
  Currency *arg1 = (Currency *) 0 ;
  std::string result;
  
  arg1 = (Currency *)jarg1; 
  {
    try {
      result = Currency___str__(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = SWIG_csharp_string_callback((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_Currency() {
  void * jresult ;
  Currency *result = 0 ;
  
  {
    try {
      result = (Currency *)new Currency();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_Currency(void * jarg1) {
  Currency *arg1 = (Currency *) 0 ;
  
  arg1 = (Currency *)jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_ARSCurrency() {
  void * jresult ;
  QuantLib::ARSCurrency *result = 0 ;
  
  {
    try {
      result = (QuantLib::ARSCurrency *)new QuantLib::ARSCurrency();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_ARSCurrency(void * jarg1) {
  QuantLib::ARSCurrency *arg1 = (QuantLib::ARSCurrency *) 0 ;
  
  arg1 = (QuantLib::ARSCurrency *)jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_ATSCurrency() {
  void * jresult ;
  QuantLib::ATSCurrency *result = 0 ;
  
  {
    try {
      result = (QuantLib::ATSCurrency *)new QuantLib::ATSCurrency();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_ATSCurrency(void * jarg1) {
  QuantLib::ATSCurrency *arg1 = (QuantLib::ATSCurrency *) 0 ;
  
  arg1 = (QuantLib::ATSCurrency *)jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_AUDCurrency() {
  void * jresult ;
  QuantLib::AUDCurrency *result = 0 ;
  
  {
    try {
      result = (QuantLib::AUDCurrency *)new QuantLib::AUDCurrency();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_AUDCurrency(void * jarg1) {
  QuantLib::AUDCurrency *arg1 = (QuantLib::AUDCurrency *) 0 ;
  
  arg1 = (QuantLib::AUDCurrency *)jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_BDTCurrency() {
  void * jresult ;
  QuantLib::BDTCurrency *result = 0 ;
  
  {
    try {
      result = (QuantLib::BDTCurrency *)new QuantLib::BDTCurrency();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_BDTCurrency(void * jarg1) {
  QuantLib::BDTCurrency *arg1 = (QuantLib::BDTCurrency *) 0 ;
  
  arg1 = (QuantLib::BDTCurrency *)jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_BEFCurrency() {
  void * jresult ;
  QuantLib::BEFCurrency *result = 0 ;
  
  {
    try {
      result = (QuantLib::BEFCurrency *)new QuantLib::BEFCurrency();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_BEFCurrency(void * jarg1) {
  QuantLib::BEFCurrency *arg1 = (QuantLib::BEFCurrency *) 0 ;
  
  arg1 = (QuantLib::BEFCurrency *)jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_BGLCurrency() {
  void * jresult ;
  QuantLib::BGLCurrency *result = 0 ;
  
  {
    try {
      result = (QuantLib::BGLCurrency *)new QuantLib::BGLCurrency();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_BGLCurrency(void * jarg1) {
  QuantLib::BGLCurrency *arg1 = (QuantLib::BGLCurrency *) 0 ;
  
  arg1 = (QuantLib::BGLCurrency *)jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_BRLCurrency() {
  void * jresult ;
  QuantLib::BRLCurrency *result = 0 ;
  
  {
    try {
      result = (QuantLib::BRLCurrency *)new QuantLib::BRLCurrency();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_BRLCurrency(void * jarg1) {
  QuantLib::BRLCurrency *arg1 = (QuantLib::BRLCurrency *) 0 ;
  
  arg1 = (QuantLib::BRLCurrency *)jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_BYRCurrency() {
  void * jresult ;
  QuantLib::BYRCurrency *result = 0 ;
  
  {
    try {
      result = (QuantLib::BYRCurrency *)new QuantLib::BYRCurrency();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_BYRCurrency(void * jarg1) {
  QuantLib::BYRCurrency *arg1 = (QuantLib::BYRCurrency *) 0 ;
  
  arg1 = (QuantLib::BYRCurrency *)jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_CADCurrency() {
  void * jresult ;
  QuantLib::CADCurrency *result = 0 ;
  
  {
    try {
      result = (QuantLib::CADCurrency *)new QuantLib::CADCurrency();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_CADCurrency(void * jarg1) {
  QuantLib::CADCurrency *arg1 = (QuantLib::CADCurrency *) 0 ;
  
  arg1 = (QuantLib::CADCurrency *)jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_CHFCurrency() {
  void * jresult ;
  QuantLib::CHFCurrency *result = 0 ;
  
  {
    try {
      result = (QuantLib::CHFCurrency *)new QuantLib::CHFCurrency();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_CHFCurrency(void * jarg1) {
  QuantLib::CHFCurrency *arg1 = (QuantLib::CHFCurrency *) 0 ;
  
  arg1 = (QuantLib::CHFCurrency *)jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_CLPCurrency() {
  void * jresult ;
  QuantLib::CLPCurrency *result = 0 ;
  
  {
    try {
      result = (QuantLib::CLPCurrency *)new QuantLib::CLPCurrency();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_CLPCurrency(void * jarg1) {
  QuantLib::CLPCurrency *arg1 = (QuantLib::CLPCurrency *) 0 ;
  
  arg1 = (QuantLib::CLPCurrency *)jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_CNYCurrency() {
  void * jresult ;
  QuantLib::CNYCurrency *result = 0 ;
  
  {
    try {
      result = (QuantLib::CNYCurrency *)new QuantLib::CNYCurrency();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_CNYCurrency(void * jarg1) {
  QuantLib::CNYCurrency *arg1 = (QuantLib::CNYCurrency *) 0 ;
  
  arg1 = (QuantLib::CNYCurrency *)jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_COPCurrency() {
  void * jresult ;
  QuantLib::COPCurrency *result = 0 ;
  
  {
    try {
      result = (QuantLib::COPCurrency *)new QuantLib::COPCurrency();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_COPCurrency(void * jarg1) {
  QuantLib::COPCurrency *arg1 = (QuantLib::COPCurrency *) 0 ;
  
  arg1 = (QuantLib::COPCurrency *)jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_CYPCurrency() {
  void * jresult ;
  QuantLib::CYPCurrency *result = 0 ;
  
  {
    try {
      result = (QuantLib::CYPCurrency *)new QuantLib::CYPCurrency();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_CYPCurrency(void * jarg1) {
  QuantLib::CYPCurrency *arg1 = (QuantLib::CYPCurrency *) 0 ;
  
  arg1 = (QuantLib::CYPCurrency *)jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_CZKCurrency() {
  void * jresult ;
  QuantLib::CZKCurrency *result = 0 ;
  
  {
    try {
      result = (QuantLib::CZKCurrency *)new QuantLib::CZKCurrency();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_CZKCurrency(void * jarg1) {
  QuantLib::CZKCurrency *arg1 = (QuantLib::CZKCurrency *) 0 ;
  
  arg1 = (QuantLib::CZKCurrency *)jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_DEMCurrency() {
  void * jresult ;
  QuantLib::DEMCurrency *result = 0 ;
  
  {
    try {
      result = (QuantLib::DEMCurrency *)new QuantLib::DEMCurrency();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_DEMCurrency(void * jarg1) {
  QuantLib::DEMCurrency *arg1 = (QuantLib::DEMCurrency *) 0 ;
  
  arg1 = (QuantLib::DEMCurrency *)jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_DKKCurrency() {
  void * jresult ;
  QuantLib::DKKCurrency *result = 0 ;
  
  {
    try {
      result = (QuantLib::DKKCurrency *)new QuantLib::DKKCurrency();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_DKKCurrency(void * jarg1) {
  QuantLib::DKKCurrency *arg1 = (QuantLib::DKKCurrency *) 0 ;
  
  arg1 = (QuantLib::DKKCurrency *)jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_EEKCurrency() {
  void * jresult ;
  QuantLib::EEKCurrency *result = 0 ;
  
  {
    try {
      result = (QuantLib::EEKCurrency *)new QuantLib::EEKCurrency();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_EEKCurrency(void * jarg1) {
  QuantLib::EEKCurrency *arg1 = (QuantLib::EEKCurrency *) 0 ;
  
  arg1 = (QuantLib::EEKCurrency *)jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_ESPCurrency() {
  void * jresult ;
  QuantLib::ESPCurrency *result = 0 ;
  
  {
    try {
      result = (QuantLib::ESPCurrency *)new QuantLib::ESPCurrency();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_ESPCurrency(void * jarg1) {
  QuantLib::ESPCurrency *arg1 = (QuantLib::ESPCurrency *) 0 ;
  
  arg1 = (QuantLib::ESPCurrency *)jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_EURCurrency() {
  void * jresult ;
  QuantLib::EURCurrency *result = 0 ;
  
  {
    try {
      result = (QuantLib::EURCurrency *)new QuantLib::EURCurrency();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_EURCurrency(void * jarg1) {
  QuantLib::EURCurrency *arg1 = (QuantLib::EURCurrency *) 0 ;
  
  arg1 = (QuantLib::EURCurrency *)jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_FIMCurrency() {
  void * jresult ;
  QuantLib::FIMCurrency *result = 0 ;
  
  {
    try {
      result = (QuantLib::FIMCurrency *)new QuantLib::FIMCurrency();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_FIMCurrency(void * jarg1) {
  QuantLib::FIMCurrency *arg1 = (QuantLib::FIMCurrency *) 0 ;
  
  arg1 = (QuantLib::FIMCurrency *)jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_FRFCurrency() {
  void * jresult ;
  QuantLib::FRFCurrency *result = 0 ;
  
  {
    try {
      result = (QuantLib::FRFCurrency *)new QuantLib::FRFCurrency();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_FRFCurrency(void * jarg1) {
  QuantLib::FRFCurrency *arg1 = (QuantLib::FRFCurrency *) 0 ;
  
  arg1 = (QuantLib::FRFCurrency *)jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_GBPCurrency() {
  void * jresult ;
  QuantLib::GBPCurrency *result = 0 ;
  
  {
    try {
      result = (QuantLib::GBPCurrency *)new QuantLib::GBPCurrency();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_GBPCurrency(void * jarg1) {
  QuantLib::GBPCurrency *arg1 = (QuantLib::GBPCurrency *) 0 ;
  
  arg1 = (QuantLib::GBPCurrency *)jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_GRDCurrency() {
  void * jresult ;
  QuantLib::GRDCurrency *result = 0 ;
  
  {
    try {
      result = (QuantLib::GRDCurrency *)new QuantLib::GRDCurrency();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_GRDCurrency(void * jarg1) {
  QuantLib::GRDCurrency *arg1 = (QuantLib::GRDCurrency *) 0 ;
  
  arg1 = (QuantLib::GRDCurrency *)jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_HKDCurrency() {
  void * jresult ;
  QuantLib::HKDCurrency *result = 0 ;
  
  {
    try {
      result = (QuantLib::HKDCurrency *)new QuantLib::HKDCurrency();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_HKDCurrency(void * jarg1) {
  QuantLib::HKDCurrency *arg1 = (QuantLib::HKDCurrency *) 0 ;
  
  arg1 = (QuantLib::HKDCurrency *)jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_HUFCurrency() {
  void * jresult ;
  QuantLib::HUFCurrency *result = 0 ;
  
  {
    try {
      result = (QuantLib::HUFCurrency *)new QuantLib::HUFCurrency();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_HUFCurrency(void * jarg1) {
  QuantLib::HUFCurrency *arg1 = (QuantLib::HUFCurrency *) 0 ;
  
  arg1 = (QuantLib::HUFCurrency *)jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_IEPCurrency() {
  void * jresult ;
  QuantLib::IEPCurrency *result = 0 ;
  
  {
    try {
      result = (QuantLib::IEPCurrency *)new QuantLib::IEPCurrency();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_IEPCurrency(void * jarg1) {
  QuantLib::IEPCurrency *arg1 = (QuantLib::IEPCurrency *) 0 ;
  
  arg1 = (QuantLib::IEPCurrency *)jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_ILSCurrency() {
  void * jresult ;
  QuantLib::ILSCurrency *result = 0 ;
  
  {
    try {
      result = (QuantLib::ILSCurrency *)new QuantLib::ILSCurrency();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_ILSCurrency(void * jarg1) {
  QuantLib::ILSCurrency *arg1 = (QuantLib::ILSCurrency *) 0 ;
  
  arg1 = (QuantLib::ILSCurrency *)jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_INRCurrency() {
  void * jresult ;
  QuantLib::INRCurrency *result = 0 ;
  
  {
    try {
      result = (QuantLib::INRCurrency *)new QuantLib::INRCurrency();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_INRCurrency(void * jarg1) {
  QuantLib::INRCurrency *arg1 = (QuantLib::INRCurrency *) 0 ;
  
  arg1 = (QuantLib::INRCurrency *)jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_IQDCurrency() {
  void * jresult ;
  QuantLib::IQDCurrency *result = 0 ;
  
  {
    try {
      result = (QuantLib::IQDCurrency *)new QuantLib::IQDCurrency();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_IQDCurrency(void * jarg1) {
  QuantLib::IQDCurrency *arg1 = (QuantLib::IQDCurrency *) 0 ;
  
  arg1 = (QuantLib::IQDCurrency *)jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_IRRCurrency() {
  void * jresult ;
  QuantLib::IRRCurrency *result = 0 ;
  
  {
    try {
      result = (QuantLib::IRRCurrency *)new QuantLib::IRRCurrency();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_IRRCurrency(void * jarg1) {
  QuantLib::IRRCurrency *arg1 = (QuantLib::IRRCurrency *) 0 ;
  
  arg1 = (QuantLib::IRRCurrency *)jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_ISKCurrency() {
  void * jresult ;
  QuantLib::ISKCurrency *result = 0 ;
  
  {
    try {
      result = (QuantLib::ISKCurrency *)new QuantLib::ISKCurrency();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_ISKCurrency(void * jarg1) {
  QuantLib::ISKCurrency *arg1 = (QuantLib::ISKCurrency *) 0 ;
  
  arg1 = (QuantLib::ISKCurrency *)jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_ITLCurrency() {
  void * jresult ;
  QuantLib::ITLCurrency *result = 0 ;
  
  {
    try {
      result = (QuantLib::ITLCurrency *)new QuantLib::ITLCurrency();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_ITLCurrency(void * jarg1) {
  QuantLib::ITLCurrency *arg1 = (QuantLib::ITLCurrency *) 0 ;
  
  arg1 = (QuantLib::ITLCurrency *)jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_JPYCurrency() {
  void * jresult ;
  QuantLib::JPYCurrency *result = 0 ;
  
  {
    try {
      result = (QuantLib::JPYCurrency *)new QuantLib::JPYCurrency();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_JPYCurrency(void * jarg1) {
  QuantLib::JPYCurrency *arg1 = (QuantLib::JPYCurrency *) 0 ;
  
  arg1 = (QuantLib::JPYCurrency *)jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_KRWCurrency() {
  void * jresult ;
  QuantLib::KRWCurrency *result = 0 ;
  
  {
    try {
      result = (QuantLib::KRWCurrency *)new QuantLib::KRWCurrency();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_KRWCurrency(void * jarg1) {
  QuantLib::KRWCurrency *arg1 = (QuantLib::KRWCurrency *) 0 ;
  
  arg1 = (QuantLib::KRWCurrency *)jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_KWDCurrency() {
  void * jresult ;
  QuantLib::KWDCurrency *result = 0 ;
  
  {
    try {
      result = (QuantLib::KWDCurrency *)new QuantLib::KWDCurrency();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_KWDCurrency(void * jarg1) {
  QuantLib::KWDCurrency *arg1 = (QuantLib::KWDCurrency *) 0 ;
  
  arg1 = (QuantLib::KWDCurrency *)jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_LTLCurrency() {
  void * jresult ;
  QuantLib::LTLCurrency *result = 0 ;
  
  {
    try {
      result = (QuantLib::LTLCurrency *)new QuantLib::LTLCurrency();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_LTLCurrency(void * jarg1) {
  QuantLib::LTLCurrency *arg1 = (QuantLib::LTLCurrency *) 0 ;
  
  arg1 = (QuantLib::LTLCurrency *)jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_LUFCurrency() {
  void * jresult ;
  QuantLib::LUFCurrency *result = 0 ;
  
  {
    try {
      result = (QuantLib::LUFCurrency *)new QuantLib::LUFCurrency();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_LUFCurrency(void * jarg1) {
  QuantLib::LUFCurrency *arg1 = (QuantLib::LUFCurrency *) 0 ;
  
  arg1 = (QuantLib::LUFCurrency *)jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_LVLCurrency() {
  void * jresult ;
  QuantLib::LVLCurrency *result = 0 ;
  
  {
    try {
      result = (QuantLib::LVLCurrency *)new QuantLib::LVLCurrency();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_LVLCurrency(void * jarg1) {
  QuantLib::LVLCurrency *arg1 = (QuantLib::LVLCurrency *) 0 ;
  
  arg1 = (QuantLib::LVLCurrency *)jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_MTLCurrency() {
  void * jresult ;
  QuantLib::MTLCurrency *result = 0 ;
  
  {
    try {
      result = (QuantLib::MTLCurrency *)new QuantLib::MTLCurrency();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_MTLCurrency(void * jarg1) {
  QuantLib::MTLCurrency *arg1 = (QuantLib::MTLCurrency *) 0 ;
  
  arg1 = (QuantLib::MTLCurrency *)jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_MXNCurrency() {
  void * jresult ;
  QuantLib::MXNCurrency *result = 0 ;
  
  {
    try {
      result = (QuantLib::MXNCurrency *)new QuantLib::MXNCurrency();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_MXNCurrency(void * jarg1) {
  QuantLib::MXNCurrency *arg1 = (QuantLib::MXNCurrency *) 0 ;
  
  arg1 = (QuantLib::MXNCurrency *)jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_NLGCurrency() {
  void * jresult ;
  QuantLib::NLGCurrency *result = 0 ;
  
  {
    try {
      result = (QuantLib::NLGCurrency *)new QuantLib::NLGCurrency();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_NLGCurrency(void * jarg1) {
  QuantLib::NLGCurrency *arg1 = (QuantLib::NLGCurrency *) 0 ;
  
  arg1 = (QuantLib::NLGCurrency *)jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_NOKCurrency() {
  void * jresult ;
  QuantLib::NOKCurrency *result = 0 ;
  
  {
    try {
      result = (QuantLib::NOKCurrency *)new QuantLib::NOKCurrency();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_NOKCurrency(void * jarg1) {
  QuantLib::NOKCurrency *arg1 = (QuantLib::NOKCurrency *) 0 ;
  
  arg1 = (QuantLib::NOKCurrency *)jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_NPRCurrency() {
  void * jresult ;
  QuantLib::NPRCurrency *result = 0 ;
  
  {
    try {
      result = (QuantLib::NPRCurrency *)new QuantLib::NPRCurrency();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_NPRCurrency(void * jarg1) {
  QuantLib::NPRCurrency *arg1 = (QuantLib::NPRCurrency *) 0 ;
  
  arg1 = (QuantLib::NPRCurrency *)jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_NZDCurrency() {
  void * jresult ;
  QuantLib::NZDCurrency *result = 0 ;
  
  {
    try {
      result = (QuantLib::NZDCurrency *)new QuantLib::NZDCurrency();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_NZDCurrency(void * jarg1) {
  QuantLib::NZDCurrency *arg1 = (QuantLib::NZDCurrency *) 0 ;
  
  arg1 = (QuantLib::NZDCurrency *)jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_PKRCurrency() {
  void * jresult ;
  QuantLib::PKRCurrency *result = 0 ;
  
  {
    try {
      result = (QuantLib::PKRCurrency *)new QuantLib::PKRCurrency();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_PKRCurrency(void * jarg1) {
  QuantLib::PKRCurrency *arg1 = (QuantLib::PKRCurrency *) 0 ;
  
  arg1 = (QuantLib::PKRCurrency *)jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_PLNCurrency() {
  void * jresult ;
  QuantLib::PLNCurrency *result = 0 ;
  
  {
    try {
      result = (QuantLib::PLNCurrency *)new QuantLib::PLNCurrency();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_PLNCurrency(void * jarg1) {
  QuantLib::PLNCurrency *arg1 = (QuantLib::PLNCurrency *) 0 ;
  
  arg1 = (QuantLib::PLNCurrency *)jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_PTECurrency() {
  void * jresult ;
  QuantLib::PTECurrency *result = 0 ;
  
  {
    try {
      result = (QuantLib::PTECurrency *)new QuantLib::PTECurrency();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_PTECurrency(void * jarg1) {
  QuantLib::PTECurrency *arg1 = (QuantLib::PTECurrency *) 0 ;
  
  arg1 = (QuantLib::PTECurrency *)jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_ROLCurrency() {
  void * jresult ;
  QuantLib::ROLCurrency *result = 0 ;
  
  {
    try {
      result = (QuantLib::ROLCurrency *)new QuantLib::ROLCurrency();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_ROLCurrency(void * jarg1) {
  QuantLib::ROLCurrency *arg1 = (QuantLib::ROLCurrency *) 0 ;
  
  arg1 = (QuantLib::ROLCurrency *)jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_SARCurrency() {
  void * jresult ;
  QuantLib::SARCurrency *result = 0 ;
  
  {
    try {
      result = (QuantLib::SARCurrency *)new QuantLib::SARCurrency();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_SARCurrency(void * jarg1) {
  QuantLib::SARCurrency *arg1 = (QuantLib::SARCurrency *) 0 ;
  
  arg1 = (QuantLib::SARCurrency *)jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_SEKCurrency() {
  void * jresult ;
  QuantLib::SEKCurrency *result = 0 ;
  
  {
    try {
      result = (QuantLib::SEKCurrency *)new QuantLib::SEKCurrency();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_SEKCurrency(void * jarg1) {
  QuantLib::SEKCurrency *arg1 = (QuantLib::SEKCurrency *) 0 ;
  
  arg1 = (QuantLib::SEKCurrency *)jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_SGDCurrency() {
  void * jresult ;
  QuantLib::SGDCurrency *result = 0 ;
  
  {
    try {
      result = (QuantLib::SGDCurrency *)new QuantLib::SGDCurrency();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_SGDCurrency(void * jarg1) {
  QuantLib::SGDCurrency *arg1 = (QuantLib::SGDCurrency *) 0 ;
  
  arg1 = (QuantLib::SGDCurrency *)jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_SITCurrency() {
  void * jresult ;
  QuantLib::SITCurrency *result = 0 ;
  
  {
    try {
      result = (QuantLib::SITCurrency *)new QuantLib::SITCurrency();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_SITCurrency(void * jarg1) {
  QuantLib::SITCurrency *arg1 = (QuantLib::SITCurrency *) 0 ;
  
  arg1 = (QuantLib::SITCurrency *)jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_SKKCurrency() {
  void * jresult ;
  QuantLib::SKKCurrency *result = 0 ;
  
  {
    try {
      result = (QuantLib::SKKCurrency *)new QuantLib::SKKCurrency();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_SKKCurrency(void * jarg1) {
  QuantLib::SKKCurrency *arg1 = (QuantLib::SKKCurrency *) 0 ;
  
  arg1 = (QuantLib::SKKCurrency *)jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_THBCurrency() {
  void * jresult ;
  QuantLib::THBCurrency *result = 0 ;
  
  {
    try {
      result = (QuantLib::THBCurrency *)new QuantLib::THBCurrency();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_THBCurrency(void * jarg1) {
  QuantLib::THBCurrency *arg1 = (QuantLib::THBCurrency *) 0 ;
  
  arg1 = (QuantLib::THBCurrency *)jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_TRLCurrency() {
  void * jresult ;
  QuantLib::TRLCurrency *result = 0 ;
  
  {
    try {
      result = (QuantLib::TRLCurrency *)new QuantLib::TRLCurrency();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_TRLCurrency(void * jarg1) {
  QuantLib::TRLCurrency *arg1 = (QuantLib::TRLCurrency *) 0 ;
  
  arg1 = (QuantLib::TRLCurrency *)jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_TRYCurrency() {
  void * jresult ;
  QuantLib::TRYCurrency *result = 0 ;
  
  {
    try {
      result = (QuantLib::TRYCurrency *)new QuantLib::TRYCurrency();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_TRYCurrency(void * jarg1) {
  QuantLib::TRYCurrency *arg1 = (QuantLib::TRYCurrency *) 0 ;
  
  arg1 = (QuantLib::TRYCurrency *)jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_TTDCurrency() {
  void * jresult ;
  QuantLib::TTDCurrency *result = 0 ;
  
  {
    try {
      result = (QuantLib::TTDCurrency *)new QuantLib::TTDCurrency();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_TTDCurrency(void * jarg1) {
  QuantLib::TTDCurrency *arg1 = (QuantLib::TTDCurrency *) 0 ;
  
  arg1 = (QuantLib::TTDCurrency *)jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_TWDCurrency() {
  void * jresult ;
  QuantLib::TWDCurrency *result = 0 ;
  
  {
    try {
      result = (QuantLib::TWDCurrency *)new QuantLib::TWDCurrency();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_TWDCurrency(void * jarg1) {
  QuantLib::TWDCurrency *arg1 = (QuantLib::TWDCurrency *) 0 ;
  
  arg1 = (QuantLib::TWDCurrency *)jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_USDCurrency() {
  void * jresult ;
  QuantLib::USDCurrency *result = 0 ;
  
  {
    try {
      result = (QuantLib::USDCurrency *)new QuantLib::USDCurrency();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_USDCurrency(void * jarg1) {
  QuantLib::USDCurrency *arg1 = (QuantLib::USDCurrency *) 0 ;
  
  arg1 = (QuantLib::USDCurrency *)jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_VEBCurrency() {
  void * jresult ;
  QuantLib::VEBCurrency *result = 0 ;
  
  {
    try {
      result = (QuantLib::VEBCurrency *)new QuantLib::VEBCurrency();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_VEBCurrency(void * jarg1) {
  QuantLib::VEBCurrency *arg1 = (QuantLib::VEBCurrency *) 0 ;
  
  arg1 = (QuantLib::VEBCurrency *)jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_ZARCurrency() {
  void * jresult ;
  QuantLib::ZARCurrency *result = 0 ;
  
  {
    try {
      result = (QuantLib::ZARCurrency *)new QuantLib::ZARCurrency();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_ZARCurrency(void * jarg1) {
  QuantLib::ZARCurrency *arg1 = (QuantLib::ZARCurrency *) 0 ;
  
  arg1 = (QuantLib::ZARCurrency *)jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_LinearInterpolation(void * jarg1, void * jarg2) {
  void * jresult ;
  Array *arg1 = 0 ;
  Array *arg2 = 0 ;
  SafeLinearInterpolation *result = 0 ;
  
  arg1 = (Array *)jarg1;
  if(!arg1) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Array const & type is null", 0);
    return 0;
  } 
  arg2 = (Array *)jarg2;
  if(!arg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Array const & type is null", 0);
    return 0;
  } 
  {
    try {
      result = (SafeLinearInterpolation *)new SafeLinearInterpolation((Array const &)*arg1,(Array const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT double SWIGSTDCALL CSharp_LinearInterpolation_call__SWIG_0(void * jarg1, double jarg2, unsigned int jarg3) {
  double jresult ;
  SafeLinearInterpolation *arg1 = (SafeLinearInterpolation *) 0 ;
  Real arg2 ;
  bool arg3 ;
  Real result;
  
  arg1 = (SafeLinearInterpolation *)jarg1; 
  arg2 = (Real)jarg2; 
  arg3 = jarg3 ? true : false; 
  {
    try {
      result = (Real)(arg1)->operator ()(arg2,arg3);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT double SWIGSTDCALL CSharp_LinearInterpolation_call__SWIG_1(void * jarg1, double jarg2) {
  double jresult ;
  SafeLinearInterpolation *arg1 = (SafeLinearInterpolation *) 0 ;
  Real arg2 ;
  Real result;
  
  arg1 = (SafeLinearInterpolation *)jarg1; 
  arg2 = (Real)jarg2; 
  {
    try {
      result = (Real)(arg1)->operator ()(arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_LinearInterpolation(void * jarg1) {
  SafeLinearInterpolation *arg1 = (SafeLinearInterpolation *) 0 ;
  
  arg1 = (SafeLinearInterpolation *)jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_LogLinearInterpolation(void * jarg1, void * jarg2) {
  void * jresult ;
  Array *arg1 = 0 ;
  Array *arg2 = 0 ;
  SafeLogLinearInterpolation *result = 0 ;
  
  arg1 = (Array *)jarg1;
  if(!arg1) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Array const & type is null", 0);
    return 0;
  } 
  arg2 = (Array *)jarg2;
  if(!arg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Array const & type is null", 0);
    return 0;
  } 
  {
    try {
      result = (SafeLogLinearInterpolation *)new SafeLogLinearInterpolation((Array const &)*arg1,(Array const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT double SWIGSTDCALL CSharp_LogLinearInterpolation_call__SWIG_0(void * jarg1, double jarg2, unsigned int jarg3) {
  double jresult ;
  SafeLogLinearInterpolation *arg1 = (SafeLogLinearInterpolation *) 0 ;
  Real arg2 ;
  bool arg3 ;
  Real result;
  
  arg1 = (SafeLogLinearInterpolation *)jarg1; 
  arg2 = (Real)jarg2; 
  arg3 = jarg3 ? true : false; 
  {
    try {
      result = (Real)(arg1)->operator ()(arg2,arg3);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT double SWIGSTDCALL CSharp_LogLinearInterpolation_call__SWIG_1(void * jarg1, double jarg2) {
  double jresult ;
  SafeLogLinearInterpolation *arg1 = (SafeLogLinearInterpolation *) 0 ;
  Real arg2 ;
  Real result;
  
  arg1 = (SafeLogLinearInterpolation *)jarg1; 
  arg2 = (Real)jarg2; 
  {
    try {
      result = (Real)(arg1)->operator ()(arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_LogLinearInterpolation(void * jarg1) {
  SafeLogLinearInterpolation *arg1 = (SafeLogLinearInterpolation *) 0 ;
  
  arg1 = (SafeLogLinearInterpolation *)jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_BackwardFlatInterpolation(void * jarg1, void * jarg2) {
  void * jresult ;
  Array *arg1 = 0 ;
  Array *arg2 = 0 ;
  SafeBackwardFlatInterpolation *result = 0 ;
  
  arg1 = (Array *)jarg1;
  if(!arg1) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Array const & type is null", 0);
    return 0;
  } 
  arg2 = (Array *)jarg2;
  if(!arg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Array const & type is null", 0);
    return 0;
  } 
  {
    try {
      result = (SafeBackwardFlatInterpolation *)new SafeBackwardFlatInterpolation((Array const &)*arg1,(Array const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT double SWIGSTDCALL CSharp_BackwardFlatInterpolation_call__SWIG_0(void * jarg1, double jarg2, unsigned int jarg3) {
  double jresult ;
  SafeBackwardFlatInterpolation *arg1 = (SafeBackwardFlatInterpolation *) 0 ;
  Real arg2 ;
  bool arg3 ;
  Real result;
  
  arg1 = (SafeBackwardFlatInterpolation *)jarg1; 
  arg2 = (Real)jarg2; 
  arg3 = jarg3 ? true : false; 
  {
    try {
      result = (Real)(arg1)->operator ()(arg2,arg3);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT double SWIGSTDCALL CSharp_BackwardFlatInterpolation_call__SWIG_1(void * jarg1, double jarg2) {
  double jresult ;
  SafeBackwardFlatInterpolation *arg1 = (SafeBackwardFlatInterpolation *) 0 ;
  Real arg2 ;
  Real result;
  
  arg1 = (SafeBackwardFlatInterpolation *)jarg1; 
  arg2 = (Real)jarg2; 
  {
    try {
      result = (Real)(arg1)->operator ()(arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_BackwardFlatInterpolation(void * jarg1) {
  SafeBackwardFlatInterpolation *arg1 = (SafeBackwardFlatInterpolation *) 0 ;
  
  arg1 = (SafeBackwardFlatInterpolation *)jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_ForwardFlatInterpolation(void * jarg1, void * jarg2) {
  void * jresult ;
  Array *arg1 = 0 ;
  Array *arg2 = 0 ;
  SafeForwardFlatInterpolation *result = 0 ;
  
  arg1 = (Array *)jarg1;
  if(!arg1) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Array const & type is null", 0);
    return 0;
  } 
  arg2 = (Array *)jarg2;
  if(!arg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Array const & type is null", 0);
    return 0;
  } 
  {
    try {
      result = (SafeForwardFlatInterpolation *)new SafeForwardFlatInterpolation((Array const &)*arg1,(Array const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT double SWIGSTDCALL CSharp_ForwardFlatInterpolation_call__SWIG_0(void * jarg1, double jarg2, unsigned int jarg3) {
  double jresult ;
  SafeForwardFlatInterpolation *arg1 = (SafeForwardFlatInterpolation *) 0 ;
  Real arg2 ;
  bool arg3 ;
  Real result;
  
  arg1 = (SafeForwardFlatInterpolation *)jarg1; 
  arg2 = (Real)jarg2; 
  arg3 = jarg3 ? true : false; 
  {
    try {
      result = (Real)(arg1)->operator ()(arg2,arg3);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT double SWIGSTDCALL CSharp_ForwardFlatInterpolation_call__SWIG_1(void * jarg1, double jarg2) {
  double jresult ;
  SafeForwardFlatInterpolation *arg1 = (SafeForwardFlatInterpolation *) 0 ;
  Real arg2 ;
  Real result;
  
  arg1 = (SafeForwardFlatInterpolation *)jarg1; 
  arg2 = (Real)jarg2; 
  {
    try {
      result = (Real)(arg1)->operator ()(arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_ForwardFlatInterpolation(void * jarg1) {
  SafeForwardFlatInterpolation *arg1 = (SafeForwardFlatInterpolation *) 0 ;
  
  arg1 = (SafeForwardFlatInterpolation *)jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_CubicSpline(void * jarg1, void * jarg2) {
  void * jresult ;
  Array *arg1 = 0 ;
  Array *arg2 = 0 ;
  SafeNaturalCubicSpline *result = 0 ;
  
  arg1 = (Array *)jarg1;
  if(!arg1) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Array const & type is null", 0);
    return 0;
  } 
  arg2 = (Array *)jarg2;
  if(!arg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Array const & type is null", 0);
    return 0;
  } 
  {
    try {
      result = (SafeNaturalCubicSpline *)new SafeNaturalCubicSpline((Array const &)*arg1,(Array const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT double SWIGSTDCALL CSharp_CubicSpline_call__SWIG_0(void * jarg1, double jarg2, unsigned int jarg3) {
  double jresult ;
  SafeNaturalCubicSpline *arg1 = (SafeNaturalCubicSpline *) 0 ;
  Real arg2 ;
  bool arg3 ;
  Real result;
  
  arg1 = (SafeNaturalCubicSpline *)jarg1; 
  arg2 = (Real)jarg2; 
  arg3 = jarg3 ? true : false; 
  {
    try {
      result = (Real)(arg1)->operator ()(arg2,arg3);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT double SWIGSTDCALL CSharp_CubicSpline_call__SWIG_1(void * jarg1, double jarg2) {
  double jresult ;
  SafeNaturalCubicSpline *arg1 = (SafeNaturalCubicSpline *) 0 ;
  Real arg2 ;
  Real result;
  
  arg1 = (SafeNaturalCubicSpline *)jarg1; 
  arg2 = (Real)jarg2; 
  {
    try {
      result = (Real)(arg1)->operator ()(arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT double SWIGSTDCALL CSharp_CubicSpline_derivative__SWIG_0(void * jarg1, double jarg2, unsigned int jarg3) {
  double jresult ;
  SafeNaturalCubicSpline *arg1 = (SafeNaturalCubicSpline *) 0 ;
  Real arg2 ;
  bool arg3 ;
  Real result;
  
  arg1 = (SafeNaturalCubicSpline *)jarg1; 
  arg2 = (Real)jarg2; 
  arg3 = jarg3 ? true : false; 
  {
    try {
      result = (Real)SafeNaturalCubicSpline_derivative__SWIG_0(arg1,arg2,arg3);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT double SWIGSTDCALL CSharp_CubicSpline_derivative__SWIG_1(void * jarg1, double jarg2) {
  double jresult ;
  SafeNaturalCubicSpline *arg1 = (SafeNaturalCubicSpline *) 0 ;
  Real arg2 ;
  Real result;
  
  arg1 = (SafeNaturalCubicSpline *)jarg1; 
  arg2 = (Real)jarg2; 
  {
    try {
      result = (Real)SafeNaturalCubicSpline_derivative__SWIG_0(arg1,arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT double SWIGSTDCALL CSharp_CubicSpline_secondDerivative__SWIG_0(void * jarg1, double jarg2, unsigned int jarg3) {
  double jresult ;
  SafeNaturalCubicSpline *arg1 = (SafeNaturalCubicSpline *) 0 ;
  Real arg2 ;
  bool arg3 ;
  Real result;
  
  arg1 = (SafeNaturalCubicSpline *)jarg1; 
  arg2 = (Real)jarg2; 
  arg3 = jarg3 ? true : false; 
  {
    try {
      result = (Real)SafeNaturalCubicSpline_secondDerivative__SWIG_0(arg1,arg2,arg3);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT double SWIGSTDCALL CSharp_CubicSpline_secondDerivative__SWIG_1(void * jarg1, double jarg2) {
  double jresult ;
  SafeNaturalCubicSpline *arg1 = (SafeNaturalCubicSpline *) 0 ;
  Real arg2 ;
  Real result;
  
  arg1 = (SafeNaturalCubicSpline *)jarg1; 
  arg2 = (Real)jarg2; 
  {
    try {
      result = (Real)SafeNaturalCubicSpline_secondDerivative__SWIG_0(arg1,arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_CubicSpline(void * jarg1) {
  SafeNaturalCubicSpline *arg1 = (SafeNaturalCubicSpline *) 0 ;
  
  arg1 = (SafeNaturalCubicSpline *)jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_MonotonicCubicSpline(void * jarg1, void * jarg2) {
  void * jresult ;
  Array *arg1 = 0 ;
  Array *arg2 = 0 ;
  SafeNaturalMonotonicCubicSpline *result = 0 ;
  
  arg1 = (Array *)jarg1;
  if(!arg1) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Array const & type is null", 0);
    return 0;
  } 
  arg2 = (Array *)jarg2;
  if(!arg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Array const & type is null", 0);
    return 0;
  } 
  {
    try {
      result = (SafeNaturalMonotonicCubicSpline *)new SafeNaturalMonotonicCubicSpline((Array const &)*arg1,(Array const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT double SWIGSTDCALL CSharp_MonotonicCubicSpline_call__SWIG_0(void * jarg1, double jarg2, unsigned int jarg3) {
  double jresult ;
  SafeNaturalMonotonicCubicSpline *arg1 = (SafeNaturalMonotonicCubicSpline *) 0 ;
  Real arg2 ;
  bool arg3 ;
  Real result;
  
  arg1 = (SafeNaturalMonotonicCubicSpline *)jarg1; 
  arg2 = (Real)jarg2; 
  arg3 = jarg3 ? true : false; 
  {
    try {
      result = (Real)(arg1)->operator ()(arg2,arg3);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT double SWIGSTDCALL CSharp_MonotonicCubicSpline_call__SWIG_1(void * jarg1, double jarg2) {
  double jresult ;
  SafeNaturalMonotonicCubicSpline *arg1 = (SafeNaturalMonotonicCubicSpline *) 0 ;
  Real arg2 ;
  Real result;
  
  arg1 = (SafeNaturalMonotonicCubicSpline *)jarg1; 
  arg2 = (Real)jarg2; 
  {
    try {
      result = (Real)(arg1)->operator ()(arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT double SWIGSTDCALL CSharp_MonotonicCubicSpline_derivative__SWIG_0(void * jarg1, double jarg2, unsigned int jarg3) {
  double jresult ;
  SafeNaturalMonotonicCubicSpline *arg1 = (SafeNaturalMonotonicCubicSpline *) 0 ;
  Real arg2 ;
  bool arg3 ;
  Real result;
  
  arg1 = (SafeNaturalMonotonicCubicSpline *)jarg1; 
  arg2 = (Real)jarg2; 
  arg3 = jarg3 ? true : false; 
  {
    try {
      result = (Real)SafeNaturalMonotonicCubicSpline_derivative__SWIG_0(arg1,arg2,arg3);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT double SWIGSTDCALL CSharp_MonotonicCubicSpline_derivative__SWIG_1(void * jarg1, double jarg2) {
  double jresult ;
  SafeNaturalMonotonicCubicSpline *arg1 = (SafeNaturalMonotonicCubicSpline *) 0 ;
  Real arg2 ;
  Real result;
  
  arg1 = (SafeNaturalMonotonicCubicSpline *)jarg1; 
  arg2 = (Real)jarg2; 
  {
    try {
      result = (Real)SafeNaturalMonotonicCubicSpline_derivative__SWIG_0(arg1,arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT double SWIGSTDCALL CSharp_MonotonicCubicSpline_secondDerivative__SWIG_0(void * jarg1, double jarg2, unsigned int jarg3) {
  double jresult ;
  SafeNaturalMonotonicCubicSpline *arg1 = (SafeNaturalMonotonicCubicSpline *) 0 ;
  Real arg2 ;
  bool arg3 ;
  Real result;
  
  arg1 = (SafeNaturalMonotonicCubicSpline *)jarg1; 
  arg2 = (Real)jarg2; 
  arg3 = jarg3 ? true : false; 
  {
    try {
      result = (Real)SafeNaturalMonotonicCubicSpline_secondDerivative__SWIG_0(arg1,arg2,arg3);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT double SWIGSTDCALL CSharp_MonotonicCubicSpline_secondDerivative__SWIG_1(void * jarg1, double jarg2) {
  double jresult ;
  SafeNaturalMonotonicCubicSpline *arg1 = (SafeNaturalMonotonicCubicSpline *) 0 ;
  Real arg2 ;
  Real result;
  
  arg1 = (SafeNaturalMonotonicCubicSpline *)jarg1; 
  arg2 = (Real)jarg2; 
  {
    try {
      result = (Real)SafeNaturalMonotonicCubicSpline_secondDerivative__SWIG_0(arg1,arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_MonotonicCubicSpline(void * jarg1) {
  SafeNaturalMonotonicCubicSpline *arg1 = (SafeNaturalMonotonicCubicSpline *) 0 ;
  
  arg1 = (SafeNaturalMonotonicCubicSpline *)jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_BilinearInterpolation(void * jarg1, void * jarg2, void * jarg3) {
  void * jresult ;
  Array *arg1 = 0 ;
  Array *arg2 = 0 ;
  Matrix *arg3 = 0 ;
  SafeBilinearInterpolation *result = 0 ;
  
  arg1 = (Array *)jarg1;
  if(!arg1) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Array const & type is null", 0);
    return 0;
  } 
  arg2 = (Array *)jarg2;
  if(!arg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Array const & type is null", 0);
    return 0;
  } 
  arg3 = (Matrix *)jarg3;
  if(!arg3) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Matrix const & type is null", 0);
    return 0;
  } 
  {
    try {
      result = (SafeBilinearInterpolation *)new SafeBilinearInterpolation((Array const &)*arg1,(Array const &)*arg2,(Matrix const &)*arg3);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT double SWIGSTDCALL CSharp_BilinearInterpolation_call__SWIG_0(void * jarg1, double jarg2, double jarg3, unsigned int jarg4) {
  double jresult ;
  SafeBilinearInterpolation *arg1 = (SafeBilinearInterpolation *) 0 ;
  Real arg2 ;
  Real arg3 ;
  bool arg4 ;
  Real result;
  
  arg1 = (SafeBilinearInterpolation *)jarg1; 
  arg2 = (Real)jarg2; 
  arg3 = (Real)jarg3; 
  arg4 = jarg4 ? true : false; 
  {
    try {
      result = (Real)(arg1)->operator ()(arg2,arg3,arg4);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT double SWIGSTDCALL CSharp_BilinearInterpolation_call__SWIG_1(void * jarg1, double jarg2, double jarg3) {
  double jresult ;
  SafeBilinearInterpolation *arg1 = (SafeBilinearInterpolation *) 0 ;
  Real arg2 ;
  Real arg3 ;
  Real result;
  
  arg1 = (SafeBilinearInterpolation *)jarg1; 
  arg2 = (Real)jarg2; 
  arg3 = (Real)jarg3; 
  {
    try {
      result = (Real)(arg1)->operator ()(arg2,arg3);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_BilinearInterpolation(void * jarg1) {
  SafeBilinearInterpolation *arg1 = (SafeBilinearInterpolation *) 0 ;
  
  arg1 = (SafeBilinearInterpolation *)jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_BicubicSpline(void * jarg1, void * jarg2, void * jarg3) {
  void * jresult ;
  Array *arg1 = 0 ;
  Array *arg2 = 0 ;
  Matrix *arg3 = 0 ;
  SafeBicubicSpline *result = 0 ;
  
  arg1 = (Array *)jarg1;
  if(!arg1) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Array const & type is null", 0);
    return 0;
  } 
  arg2 = (Array *)jarg2;
  if(!arg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Array const & type is null", 0);
    return 0;
  } 
  arg3 = (Matrix *)jarg3;
  if(!arg3) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Matrix const & type is null", 0);
    return 0;
  } 
  {
    try {
      result = (SafeBicubicSpline *)new SafeBicubicSpline((Array const &)*arg1,(Array const &)*arg2,(Matrix const &)*arg3);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT double SWIGSTDCALL CSharp_BicubicSpline_call__SWIG_0(void * jarg1, double jarg2, double jarg3, unsigned int jarg4) {
  double jresult ;
  SafeBicubicSpline *arg1 = (SafeBicubicSpline *) 0 ;
  Real arg2 ;
  Real arg3 ;
  bool arg4 ;
  Real result;
  
  arg1 = (SafeBicubicSpline *)jarg1; 
  arg2 = (Real)jarg2; 
  arg3 = (Real)jarg3; 
  arg4 = jarg4 ? true : false; 
  {
    try {
      result = (Real)(arg1)->operator ()(arg2,arg3,arg4);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT double SWIGSTDCALL CSharp_BicubicSpline_call__SWIG_1(void * jarg1, double jarg2, double jarg3) {
  double jresult ;
  SafeBicubicSpline *arg1 = (SafeBicubicSpline *) 0 ;
  Real arg2 ;
  Real arg3 ;
  Real result;
  
  arg1 = (SafeBicubicSpline *)jarg1; 
  arg2 = (Real)jarg2; 
  arg3 = (Real)jarg3; 
  {
    try {
      result = (Real)(arg1)->operator ()(arg2,arg3);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_BicubicSpline(void * jarg1) {
  SafeBicubicSpline *arg1 = (SafeBicubicSpline *) 0 ;
  
  arg1 = (SafeBicubicSpline *)jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_BackwardFlat() {
  void * jresult ;
  BackwardFlat *result = 0 ;
  
  {
    try {
      result = (BackwardFlat *)new BackwardFlat();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_BackwardFlat(void * jarg1) {
  BackwardFlat *arg1 = (BackwardFlat *) 0 ;
  
  arg1 = (BackwardFlat *)jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_ForwardFlat() {
  void * jresult ;
  ForwardFlat *result = 0 ;
  
  {
    try {
      result = (ForwardFlat *)new ForwardFlat();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_ForwardFlat(void * jarg1) {
  ForwardFlat *arg1 = (ForwardFlat *) 0 ;
  
  arg1 = (ForwardFlat *)jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_Linear() {
  void * jresult ;
  Linear *result = 0 ;
  
  {
    try {
      result = (Linear *)new Linear();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_Linear(void * jarg1) {
  Linear *arg1 = (Linear *) 0 ;
  
  arg1 = (Linear *)jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_LogLinear() {
  void * jresult ;
  LogLinear *result = 0 ;
  
  {
    try {
      result = (LogLinear *)new LogLinear();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_LogLinear(void * jarg1) {
  LogLinear *arg1 = (LogLinear *) 0 ;
  
  arg1 = (LogLinear *)jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_Cubic() {
  void * jresult ;
  Cubic *result = 0 ;
  
  {
    try {
      result = (Cubic *)new Cubic();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_Cubic(void * jarg1) {
  Cubic *arg1 = (Cubic *) 0 ;
  
  arg1 = (Cubic *)jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_YieldTermStructure___deref__(void * jarg1) {
  void * jresult ;
  boost::shared_ptr<YieldTermStructure > *arg1 = (boost::shared_ptr<YieldTermStructure > *) 0 ;
  YieldTermStructure *result = 0 ;
  
  arg1 = (boost::shared_ptr<YieldTermStructure > *)jarg1; 
  {
    try {
      result = (YieldTermStructure *)(arg1)->operator ->();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT unsigned int SWIGSTDCALL CSharp_YieldTermStructure_isNull(void * jarg1) {
  unsigned int jresult ;
  boost::shared_ptr<YieldTermStructure > *arg1 = (boost::shared_ptr<YieldTermStructure > *) 0 ;
  bool result;
  
  arg1 = (boost::shared_ptr<YieldTermStructure > *)jarg1; 
  {
    try {
      result = (bool)boost_shared_ptr_Sl_YieldTermStructure_Sg__isNull(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_YieldTermStructure_asObservable(void * jarg1) {
  void * jresult ;
  boost::shared_ptr<YieldTermStructure > *arg1 = (boost::shared_ptr<YieldTermStructure > *) 0 ;
  boost::shared_ptr<Observable > result;
  
  arg1 = (boost::shared_ptr<YieldTermStructure > *)jarg1; 
  {
    try {
      result = boost_shared_ptr_Sl_YieldTermStructure_Sg__asObservable(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = new boost::shared_ptr<Observable >((boost::shared_ptr<Observable > &)result); 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_YieldTermStructure() {
  void * jresult ;
  boost::shared_ptr<YieldTermStructure > *result = 0 ;
  
  {
    try {
      result = (boost::shared_ptr<YieldTermStructure > *)new boost::shared_ptr<YieldTermStructure >();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_YieldTermStructure(void * jarg1) {
  boost::shared_ptr<YieldTermStructure > *arg1 = (boost::shared_ptr<YieldTermStructure > *) 0 ;
  
  arg1 = (boost::shared_ptr<YieldTermStructure > *)jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_YieldTermStructure_dayCounter(void * jarg1) {
  void * jresult ;
  boost::shared_ptr<YieldTermStructure > *arg1 = (boost::shared_ptr<YieldTermStructure > *) 0 ;
  SwigValueWrapper<DayCounter > result;
  
  arg1 = (boost::shared_ptr<YieldTermStructure > *)jarg1; 
  {
    try {
      result = (*arg1)->dayCounter();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = new DayCounter((DayCounter &)result); 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_YieldTermStructure_calendar(void * jarg1) {
  void * jresult ;
  boost::shared_ptr<YieldTermStructure > *arg1 = (boost::shared_ptr<YieldTermStructure > *) 0 ;
  SwigValueWrapper<Calendar > result;
  
  arg1 = (boost::shared_ptr<YieldTermStructure > *)jarg1; 
  {
    try {
      result = (*arg1)->calendar();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = new Calendar((Calendar &)result); 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_YieldTermStructure_referenceDate(void * jarg1) {
  void * jresult ;
  boost::shared_ptr<YieldTermStructure > *arg1 = (boost::shared_ptr<YieldTermStructure > *) 0 ;
  Date result;
  
  arg1 = (boost::shared_ptr<YieldTermStructure > *)jarg1; 
  {
    try {
      result = (*arg1)->referenceDate();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = new Date((Date &)result); 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_YieldTermStructure_maxDate(void * jarg1) {
  void * jresult ;
  boost::shared_ptr<YieldTermStructure > *arg1 = (boost::shared_ptr<YieldTermStructure > *) 0 ;
  Date result;
  
  arg1 = (boost::shared_ptr<YieldTermStructure > *)jarg1; 
  {
    try {
      result = (*arg1)->maxDate();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = new Date((Date &)result); 
  return jresult;
}


SWIGEXPORT double SWIGSTDCALL CSharp_YieldTermStructure_maxTime(void * jarg1) {
  double jresult ;
  boost::shared_ptr<YieldTermStructure > *arg1 = (boost::shared_ptr<YieldTermStructure > *) 0 ;
  Time result;
  
  arg1 = (boost::shared_ptr<YieldTermStructure > *)jarg1; 
  {
    try {
      result = (Time)(*arg1)->maxTime();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT double SWIGSTDCALL CSharp_YieldTermStructure_discount__SWIG_0(void * jarg1, void * jarg2, unsigned int jarg3) {
  double jresult ;
  boost::shared_ptr<YieldTermStructure > *arg1 = (boost::shared_ptr<YieldTermStructure > *) 0 ;
  Date *arg2 = 0 ;
  bool arg3 ;
  DiscountFactor result;
  
  arg1 = (boost::shared_ptr<YieldTermStructure > *)jarg1; 
  arg2 = (Date *)jarg2;
  if(!arg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
    return 0;
  } 
  arg3 = jarg3 ? true : false; 
  {
    try {
      result = (DiscountFactor)(*arg1)->discount((Date const &)*arg2,arg3);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT double SWIGSTDCALL CSharp_YieldTermStructure_discount__SWIG_1(void * jarg1, void * jarg2) {
  double jresult ;
  boost::shared_ptr<YieldTermStructure > *arg1 = (boost::shared_ptr<YieldTermStructure > *) 0 ;
  Date *arg2 = 0 ;
  DiscountFactor result;
  
  arg1 = (boost::shared_ptr<YieldTermStructure > *)jarg1; 
  arg2 = (Date *)jarg2;
  if(!arg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
    return 0;
  } 
  {
    try {
      result = (DiscountFactor)(*arg1)->discount((Date const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT double SWIGSTDCALL CSharp_YieldTermStructure_discount__SWIG_2(void * jarg1, double jarg2, unsigned int jarg3) {
  double jresult ;
  boost::shared_ptr<YieldTermStructure > *arg1 = (boost::shared_ptr<YieldTermStructure > *) 0 ;
  Time arg2 ;
  bool arg3 ;
  DiscountFactor result;
  
  arg1 = (boost::shared_ptr<YieldTermStructure > *)jarg1; 
  arg2 = (Time)jarg2; 
  arg3 = jarg3 ? true : false; 
  {
    try {
      result = (DiscountFactor)(*arg1)->discount(arg2,arg3);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT double SWIGSTDCALL CSharp_YieldTermStructure_discount__SWIG_3(void * jarg1, double jarg2) {
  double jresult ;
  boost::shared_ptr<YieldTermStructure > *arg1 = (boost::shared_ptr<YieldTermStructure > *) 0 ;
  Time arg2 ;
  DiscountFactor result;
  
  arg1 = (boost::shared_ptr<YieldTermStructure > *)jarg1; 
  arg2 = (Time)jarg2; 
  {
    try {
      result = (DiscountFactor)(*arg1)->discount(arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_YieldTermStructure_zeroRate__SWIG_0(void * jarg1, void * jarg2, void * jarg3, int jarg4, int jarg5, unsigned int jarg6) {
  void * jresult ;
  boost::shared_ptr<YieldTermStructure > *arg1 = (boost::shared_ptr<YieldTermStructure > *) 0 ;
  Date *arg2 = 0 ;
  DayCounter *arg3 = 0 ;
  Compounding arg4 ;
  Frequency arg5 ;
  bool arg6 ;
  InterestRate result;
  
  arg1 = (boost::shared_ptr<YieldTermStructure > *)jarg1; 
  arg2 = (Date *)jarg2;
  if(!arg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
    return 0;
  } 
  arg3 = (DayCounter *)jarg3;
  if(!arg3) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "DayCounter const & type is null", 0);
    return 0;
  } 
  arg4 = (Compounding)jarg4; 
  arg5 = (Frequency)jarg5; 
  arg6 = jarg6 ? true : false; 
  {
    try {
      result = (*arg1)->zeroRate((Date const &)*arg2,(DayCounter const &)*arg3,arg4,arg5,arg6);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = new InterestRate((InterestRate &)result); 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_YieldTermStructure_zeroRate__SWIG_1(void * jarg1, void * jarg2, void * jarg3, int jarg4, int jarg5) {
  void * jresult ;
  boost::shared_ptr<YieldTermStructure > *arg1 = (boost::shared_ptr<YieldTermStructure > *) 0 ;
  Date *arg2 = 0 ;
  DayCounter *arg3 = 0 ;
  Compounding arg4 ;
  Frequency arg5 ;
  InterestRate result;
  
  arg1 = (boost::shared_ptr<YieldTermStructure > *)jarg1; 
  arg2 = (Date *)jarg2;
  if(!arg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
    return 0;
  } 
  arg3 = (DayCounter *)jarg3;
  if(!arg3) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "DayCounter const & type is null", 0);
    return 0;
  } 
  arg4 = (Compounding)jarg4; 
  arg5 = (Frequency)jarg5; 
  {
    try {
      result = (*arg1)->zeroRate((Date const &)*arg2,(DayCounter const &)*arg3,arg4,arg5);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = new InterestRate((InterestRate &)result); 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_YieldTermStructure_zeroRate__SWIG_2(void * jarg1, void * jarg2, void * jarg3, int jarg4) {
  void * jresult ;
  boost::shared_ptr<YieldTermStructure > *arg1 = (boost::shared_ptr<YieldTermStructure > *) 0 ;
  Date *arg2 = 0 ;
  DayCounter *arg3 = 0 ;
  Compounding arg4 ;
  InterestRate result;
  
  arg1 = (boost::shared_ptr<YieldTermStructure > *)jarg1; 
  arg2 = (Date *)jarg2;
  if(!arg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
    return 0;
  } 
  arg3 = (DayCounter *)jarg3;
  if(!arg3) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "DayCounter const & type is null", 0);
    return 0;
  } 
  arg4 = (Compounding)jarg4; 
  {
    try {
      result = (*arg1)->zeroRate((Date const &)*arg2,(DayCounter const &)*arg3,arg4);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = new InterestRate((InterestRate &)result); 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_YieldTermStructure_zeroRate__SWIG_3(void * jarg1, double jarg2, int jarg3, int jarg4, unsigned int jarg5) {
  void * jresult ;
  boost::shared_ptr<YieldTermStructure > *arg1 = (boost::shared_ptr<YieldTermStructure > *) 0 ;
  Time arg2 ;
  Compounding arg3 ;
  Frequency arg4 ;
  bool arg5 ;
  InterestRate result;
  
  arg1 = (boost::shared_ptr<YieldTermStructure > *)jarg1; 
  arg2 = (Time)jarg2; 
  arg3 = (Compounding)jarg3; 
  arg4 = (Frequency)jarg4; 
  arg5 = jarg5 ? true : false; 
  {
    try {
      result = (*arg1)->zeroRate(arg2,arg3,arg4,arg5);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = new InterestRate((InterestRate &)result); 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_YieldTermStructure_zeroRate__SWIG_4(void * jarg1, double jarg2, int jarg3, int jarg4) {
  void * jresult ;
  boost::shared_ptr<YieldTermStructure > *arg1 = (boost::shared_ptr<YieldTermStructure > *) 0 ;
  Time arg2 ;
  Compounding arg3 ;
  Frequency arg4 ;
  InterestRate result;
  
  arg1 = (boost::shared_ptr<YieldTermStructure > *)jarg1; 
  arg2 = (Time)jarg2; 
  arg3 = (Compounding)jarg3; 
  arg4 = (Frequency)jarg4; 
  {
    try {
      result = (*arg1)->zeroRate(arg2,arg3,arg4);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = new InterestRate((InterestRate &)result); 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_YieldTermStructure_zeroRate__SWIG_5(void * jarg1, double jarg2, int jarg3) {
  void * jresult ;
  boost::shared_ptr<YieldTermStructure > *arg1 = (boost::shared_ptr<YieldTermStructure > *) 0 ;
  Time arg2 ;
  Compounding arg3 ;
  InterestRate result;
  
  arg1 = (boost::shared_ptr<YieldTermStructure > *)jarg1; 
  arg2 = (Time)jarg2; 
  arg3 = (Compounding)jarg3; 
  {
    try {
      result = (*arg1)->zeroRate(arg2,arg3);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = new InterestRate((InterestRate &)result); 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_YieldTermStructure_forwardRate__SWIG_0(void * jarg1, void * jarg2, void * jarg3, void * jarg4, int jarg5, int jarg6, unsigned int jarg7) {
  void * jresult ;
  boost::shared_ptr<YieldTermStructure > *arg1 = (boost::shared_ptr<YieldTermStructure > *) 0 ;
  Date *arg2 = 0 ;
  Date *arg3 = 0 ;
  DayCounter *arg4 = 0 ;
  Compounding arg5 ;
  Frequency arg6 ;
  bool arg7 ;
  InterestRate result;
  
  arg1 = (boost::shared_ptr<YieldTermStructure > *)jarg1; 
  arg2 = (Date *)jarg2;
  if(!arg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
    return 0;
  } 
  arg3 = (Date *)jarg3;
  if(!arg3) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
    return 0;
  } 
  arg4 = (DayCounter *)jarg4;
  if(!arg4) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "DayCounter const & type is null", 0);
    return 0;
  } 
  arg5 = (Compounding)jarg5; 
  arg6 = (Frequency)jarg6; 
  arg7 = jarg7 ? true : false; 
  {
    try {
      result = (*arg1)->forwardRate((Date const &)*arg2,(Date const &)*arg3,(DayCounter const &)*arg4,arg5,arg6,arg7);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = new InterestRate((InterestRate &)result); 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_YieldTermStructure_forwardRate__SWIG_1(void * jarg1, void * jarg2, void * jarg3, void * jarg4, int jarg5, int jarg6) {
  void * jresult ;
  boost::shared_ptr<YieldTermStructure > *arg1 = (boost::shared_ptr<YieldTermStructure > *) 0 ;
  Date *arg2 = 0 ;
  Date *arg3 = 0 ;
  DayCounter *arg4 = 0 ;
  Compounding arg5 ;
  Frequency arg6 ;
  InterestRate result;
  
  arg1 = (boost::shared_ptr<YieldTermStructure > *)jarg1; 
  arg2 = (Date *)jarg2;
  if(!arg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
    return 0;
  } 
  arg3 = (Date *)jarg3;
  if(!arg3) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
    return 0;
  } 
  arg4 = (DayCounter *)jarg4;
  if(!arg4) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "DayCounter const & type is null", 0);
    return 0;
  } 
  arg5 = (Compounding)jarg5; 
  arg6 = (Frequency)jarg6; 
  {
    try {
      result = (*arg1)->forwardRate((Date const &)*arg2,(Date const &)*arg3,(DayCounter const &)*arg4,arg5,arg6);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = new InterestRate((InterestRate &)result); 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_YieldTermStructure_forwardRate__SWIG_2(void * jarg1, void * jarg2, void * jarg3, void * jarg4, int jarg5) {
  void * jresult ;
  boost::shared_ptr<YieldTermStructure > *arg1 = (boost::shared_ptr<YieldTermStructure > *) 0 ;
  Date *arg2 = 0 ;
  Date *arg3 = 0 ;
  DayCounter *arg4 = 0 ;
  Compounding arg5 ;
  InterestRate result;
  
  arg1 = (boost::shared_ptr<YieldTermStructure > *)jarg1; 
  arg2 = (Date *)jarg2;
  if(!arg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
    return 0;
  } 
  arg3 = (Date *)jarg3;
  if(!arg3) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
    return 0;
  } 
  arg4 = (DayCounter *)jarg4;
  if(!arg4) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "DayCounter const & type is null", 0);
    return 0;
  } 
  arg5 = (Compounding)jarg5; 
  {
    try {
      result = (*arg1)->forwardRate((Date const &)*arg2,(Date const &)*arg3,(DayCounter const &)*arg4,arg5);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = new InterestRate((InterestRate &)result); 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_YieldTermStructure_forwardRate__SWIG_3(void * jarg1, double jarg2, double jarg3, int jarg4, int jarg5, unsigned int jarg6) {
  void * jresult ;
  boost::shared_ptr<YieldTermStructure > *arg1 = (boost::shared_ptr<YieldTermStructure > *) 0 ;
  Time arg2 ;
  Time arg3 ;
  Compounding arg4 ;
  Frequency arg5 ;
  bool arg6 ;
  InterestRate result;
  
  arg1 = (boost::shared_ptr<YieldTermStructure > *)jarg1; 
  arg2 = (Time)jarg2; 
  arg3 = (Time)jarg3; 
  arg4 = (Compounding)jarg4; 
  arg5 = (Frequency)jarg5; 
  arg6 = jarg6 ? true : false; 
  {
    try {
      result = (*arg1)->forwardRate(arg2,arg3,arg4,arg5,arg6);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = new InterestRate((InterestRate &)result); 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_YieldTermStructure_forwardRate__SWIG_4(void * jarg1, double jarg2, double jarg3, int jarg4, int jarg5) {
  void * jresult ;
  boost::shared_ptr<YieldTermStructure > *arg1 = (boost::shared_ptr<YieldTermStructure > *) 0 ;
  Time arg2 ;
  Time arg3 ;
  Compounding arg4 ;
  Frequency arg5 ;
  InterestRate result;
  
  arg1 = (boost::shared_ptr<YieldTermStructure > *)jarg1; 
  arg2 = (Time)jarg2; 
  arg3 = (Time)jarg3; 
  arg4 = (Compounding)jarg4; 
  arg5 = (Frequency)jarg5; 
  {
    try {
      result = (*arg1)->forwardRate(arg2,arg3,arg4,arg5);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = new InterestRate((InterestRate &)result); 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_YieldTermStructure_forwardRate__SWIG_5(void * jarg1, double jarg2, double jarg3, int jarg4) {
  void * jresult ;
  boost::shared_ptr<YieldTermStructure > *arg1 = (boost::shared_ptr<YieldTermStructure > *) 0 ;
  Time arg2 ;
  Time arg3 ;
  Compounding arg4 ;
  InterestRate result;
  
  arg1 = (boost::shared_ptr<YieldTermStructure > *)jarg1; 
  arg2 = (Time)jarg2; 
  arg3 = (Time)jarg3; 
  arg4 = (Compounding)jarg4; 
  {
    try {
      result = (*arg1)->forwardRate(arg2,arg3,arg4);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = new InterestRate((InterestRate &)result); 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_YieldTermStructure_enableExtrapolation(void * jarg1) {
  boost::shared_ptr<YieldTermStructure > *arg1 = (boost::shared_ptr<YieldTermStructure > *) 0 ;
  
  arg1 = (boost::shared_ptr<YieldTermStructure > *)jarg1; 
  {
    try {
      (*arg1)->enableExtrapolation();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_YieldTermStructure_disableExtrapolation(void * jarg1) {
  boost::shared_ptr<YieldTermStructure > *arg1 = (boost::shared_ptr<YieldTermStructure > *) 0 ;
  
  arg1 = (boost::shared_ptr<YieldTermStructure > *)jarg1; 
  {
    try {
      (*arg1)->disableExtrapolation();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT unsigned int SWIGSTDCALL CSharp_YieldTermStructure_allowsExtrapolation(void * jarg1) {
  unsigned int jresult ;
  boost::shared_ptr<YieldTermStructure > *arg1 = (boost::shared_ptr<YieldTermStructure > *) 0 ;
  bool result;
  
  arg1 = (boost::shared_ptr<YieldTermStructure > *)jarg1; 
  {
    try {
      result = (bool)(*arg1)->allowsExtrapolation();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_YieldTermStructureHandle__SWIG_0(void * jarg1) {
  void * jresult ;
  boost::shared_ptr<YieldTermStructure > *arg1 = 0 ;
  Handle<YieldTermStructure > *result = 0 ;
  
  arg1 = (boost::shared_ptr<YieldTermStructure > *)jarg1;
  if(!arg1) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "boost::shared_ptr<YieldTermStructure > const & type is null", 0);
    return 0;
  } 
  {
    try {
      result = (Handle<YieldTermStructure > *)new Handle<YieldTermStructure >((boost::shared_ptr<YieldTermStructure > const &)*arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_YieldTermStructureHandle__SWIG_1() {
  void * jresult ;
  Handle<YieldTermStructure > *result = 0 ;
  
  {
    try {
      result = (Handle<YieldTermStructure > *)new Handle<YieldTermStructure >();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_YieldTermStructureHandle___deref__(void * jarg1) {
  void * jresult ;
  Handle<YieldTermStructure > *arg1 = (Handle<YieldTermStructure > *) 0 ;
  boost::shared_ptr<YieldTermStructure > result;
  
  arg1 = (Handle<YieldTermStructure > *)jarg1; 
  {
    try {
      result = (arg1)->operator ->();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = new boost::shared_ptr<YieldTermStructure >((boost::shared_ptr<YieldTermStructure > &)result); 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_YieldTermStructureHandle_linkTo(void * jarg1, void * jarg2) {
  Handle<YieldTermStructure > *arg1 = (Handle<YieldTermStructure > *) 0 ;
  boost::shared_ptr<YieldTermStructure > *arg2 = 0 ;
  
  arg1 = (Handle<YieldTermStructure > *)jarg1; 
  arg2 = (boost::shared_ptr<YieldTermStructure > *)jarg2;
  if(!arg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "boost::shared_ptr<YieldTermStructure > const & type is null", 0);
    return ;
  } 
  {
    try {
      (arg1)->linkTo((boost::shared_ptr<YieldTermStructure > const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT unsigned int SWIGSTDCALL CSharp_YieldTermStructureHandle_empty(void * jarg1) {
  unsigned int jresult ;
  Handle<YieldTermStructure > *arg1 = (Handle<YieldTermStructure > *) 0 ;
  bool result;
  
  arg1 = (Handle<YieldTermStructure > *)jarg1; 
  {
    try {
      result = (bool)(arg1)->empty();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_YieldTermStructureHandle_asObservable(void * jarg1) {
  void * jresult ;
  Handle<YieldTermStructure > *arg1 = (Handle<YieldTermStructure > *) 0 ;
  boost::shared_ptr<Observable > result;
  
  arg1 = (Handle<YieldTermStructure > *)jarg1; 
  {
    try {
      result = Handle_Sl_YieldTermStructure_Sg__asObservable(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = new boost::shared_ptr<Observable >((boost::shared_ptr<Observable > &)result); 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_YieldTermStructureHandle(void * jarg1) {
  Handle<YieldTermStructure > *arg1 = (Handle<YieldTermStructure > *) 0 ;
  
  arg1 = (Handle<YieldTermStructure > *)jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_YieldTermStructureHandle_dayCounter(void * jarg1) {
  void * jresult ;
  Handle<YieldTermStructure > *arg1 = (Handle<YieldTermStructure > *) 0 ;
  SwigValueWrapper<DayCounter > result;
  
  arg1 = (Handle<YieldTermStructure > *)jarg1; 
  {
    try {
      result = (*arg1)->dayCounter();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = new DayCounter((DayCounter &)result); 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_YieldTermStructureHandle_calendar(void * jarg1) {
  void * jresult ;
  Handle<YieldTermStructure > *arg1 = (Handle<YieldTermStructure > *) 0 ;
  SwigValueWrapper<Calendar > result;
  
  arg1 = (Handle<YieldTermStructure > *)jarg1; 
  {
    try {
      result = (*arg1)->calendar();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = new Calendar((Calendar &)result); 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_YieldTermStructureHandle_referenceDate(void * jarg1) {
  void * jresult ;
  Handle<YieldTermStructure > *arg1 = (Handle<YieldTermStructure > *) 0 ;
  Date result;
  
  arg1 = (Handle<YieldTermStructure > *)jarg1; 
  {
    try {
      result = (*arg1)->referenceDate();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = new Date((Date &)result); 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_YieldTermStructureHandle_maxDate(void * jarg1) {
  void * jresult ;
  Handle<YieldTermStructure > *arg1 = (Handle<YieldTermStructure > *) 0 ;
  Date result;
  
  arg1 = (Handle<YieldTermStructure > *)jarg1; 
  {
    try {
      result = (*arg1)->maxDate();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = new Date((Date &)result); 
  return jresult;
}


SWIGEXPORT double SWIGSTDCALL CSharp_YieldTermStructureHandle_maxTime(void * jarg1) {
  double jresult ;
  Handle<YieldTermStructure > *arg1 = (Handle<YieldTermStructure > *) 0 ;
  Time result;
  
  arg1 = (Handle<YieldTermStructure > *)jarg1; 
  {
    try {
      result = (Time)(*arg1)->maxTime();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT double SWIGSTDCALL CSharp_YieldTermStructureHandle_discount__SWIG_0(void * jarg1, void * jarg2, unsigned int jarg3) {
  double jresult ;
  Handle<YieldTermStructure > *arg1 = (Handle<YieldTermStructure > *) 0 ;
  Date *arg2 = 0 ;
  bool arg3 ;
  DiscountFactor result;
  
  arg1 = (Handle<YieldTermStructure > *)jarg1; 
  arg2 = (Date *)jarg2;
  if(!arg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
    return 0;
  } 
  arg3 = jarg3 ? true : false; 
  {
    try {
      result = (DiscountFactor)(*arg1)->discount((Date const &)*arg2,arg3);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT double SWIGSTDCALL CSharp_YieldTermStructureHandle_discount__SWIG_1(void * jarg1, void * jarg2) {
  double jresult ;
  Handle<YieldTermStructure > *arg1 = (Handle<YieldTermStructure > *) 0 ;
  Date *arg2 = 0 ;
  DiscountFactor result;
  
  arg1 = (Handle<YieldTermStructure > *)jarg1; 
  arg2 = (Date *)jarg2;
  if(!arg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
    return 0;
  } 
  {
    try {
      result = (DiscountFactor)(*arg1)->discount((Date const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT double SWIGSTDCALL CSharp_YieldTermStructureHandle_discount__SWIG_2(void * jarg1, double jarg2, unsigned int jarg3) {
  double jresult ;
  Handle<YieldTermStructure > *arg1 = (Handle<YieldTermStructure > *) 0 ;
  Time arg2 ;
  bool arg3 ;
  DiscountFactor result;
  
  arg1 = (Handle<YieldTermStructure > *)jarg1; 
  arg2 = (Time)jarg2; 
  arg3 = jarg3 ? true : false; 
  {
    try {
      result = (DiscountFactor)(*arg1)->discount(arg2,arg3);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT double SWIGSTDCALL CSharp_YieldTermStructureHandle_discount__SWIG_3(void * jarg1, double jarg2) {
  double jresult ;
  Handle<YieldTermStructure > *arg1 = (Handle<YieldTermStructure > *) 0 ;
  Time arg2 ;
  DiscountFactor result;
  
  arg1 = (Handle<YieldTermStructure > *)jarg1; 
  arg2 = (Time)jarg2; 
  {
    try {
      result = (DiscountFactor)(*arg1)->discount(arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_YieldTermStructureHandle_zeroRate__SWIG_0(void * jarg1, void * jarg2, void * jarg3, int jarg4, int jarg5, unsigned int jarg6) {
  void * jresult ;
  Handle<YieldTermStructure > *arg1 = (Handle<YieldTermStructure > *) 0 ;
  Date *arg2 = 0 ;
  DayCounter *arg3 = 0 ;
  Compounding arg4 ;
  Frequency arg5 ;
  bool arg6 ;
  InterestRate result;
  
  arg1 = (Handle<YieldTermStructure > *)jarg1; 
  arg2 = (Date *)jarg2;
  if(!arg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
    return 0;
  } 
  arg3 = (DayCounter *)jarg3;
  if(!arg3) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "DayCounter const & type is null", 0);
    return 0;
  } 
  arg4 = (Compounding)jarg4; 
  arg5 = (Frequency)jarg5; 
  arg6 = jarg6 ? true : false; 
  {
    try {
      result = (*arg1)->zeroRate((Date const &)*arg2,(DayCounter const &)*arg3,arg4,arg5,arg6);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = new InterestRate((InterestRate &)result); 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_YieldTermStructureHandle_zeroRate__SWIG_1(void * jarg1, void * jarg2, void * jarg3, int jarg4, int jarg5) {
  void * jresult ;
  Handle<YieldTermStructure > *arg1 = (Handle<YieldTermStructure > *) 0 ;
  Date *arg2 = 0 ;
  DayCounter *arg3 = 0 ;
  Compounding arg4 ;
  Frequency arg5 ;
  InterestRate result;
  
  arg1 = (Handle<YieldTermStructure > *)jarg1; 
  arg2 = (Date *)jarg2;
  if(!arg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
    return 0;
  } 
  arg3 = (DayCounter *)jarg3;
  if(!arg3) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "DayCounter const & type is null", 0);
    return 0;
  } 
  arg4 = (Compounding)jarg4; 
  arg5 = (Frequency)jarg5; 
  {
    try {
      result = (*arg1)->zeroRate((Date const &)*arg2,(DayCounter const &)*arg3,arg4,arg5);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = new InterestRate((InterestRate &)result); 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_YieldTermStructureHandle_zeroRate__SWIG_2(void * jarg1, void * jarg2, void * jarg3, int jarg4) {
  void * jresult ;
  Handle<YieldTermStructure > *arg1 = (Handle<YieldTermStructure > *) 0 ;
  Date *arg2 = 0 ;
  DayCounter *arg3 = 0 ;
  Compounding arg4 ;
  InterestRate result;
  
  arg1 = (Handle<YieldTermStructure > *)jarg1; 
  arg2 = (Date *)jarg2;
  if(!arg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
    return 0;
  } 
  arg3 = (DayCounter *)jarg3;
  if(!arg3) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "DayCounter const & type is null", 0);
    return 0;
  } 
  arg4 = (Compounding)jarg4; 
  {
    try {
      result = (*arg1)->zeroRate((Date const &)*arg2,(DayCounter const &)*arg3,arg4);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = new InterestRate((InterestRate &)result); 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_YieldTermStructureHandle_zeroRate__SWIG_3(void * jarg1, double jarg2, int jarg3, int jarg4, unsigned int jarg5) {
  void * jresult ;
  Handle<YieldTermStructure > *arg1 = (Handle<YieldTermStructure > *) 0 ;
  Time arg2 ;
  Compounding arg3 ;
  Frequency arg4 ;
  bool arg5 ;
  InterestRate result;
  
  arg1 = (Handle<YieldTermStructure > *)jarg1; 
  arg2 = (Time)jarg2; 
  arg3 = (Compounding)jarg3; 
  arg4 = (Frequency)jarg4; 
  arg5 = jarg5 ? true : false; 
  {
    try {
      result = (*arg1)->zeroRate(arg2,arg3,arg4,arg5);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = new InterestRate((InterestRate &)result); 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_YieldTermStructureHandle_zeroRate__SWIG_4(void * jarg1, double jarg2, int jarg3, int jarg4) {
  void * jresult ;
  Handle<YieldTermStructure > *arg1 = (Handle<YieldTermStructure > *) 0 ;
  Time arg2 ;
  Compounding arg3 ;
  Frequency arg4 ;
  InterestRate result;
  
  arg1 = (Handle<YieldTermStructure > *)jarg1; 
  arg2 = (Time)jarg2; 
  arg3 = (Compounding)jarg3; 
  arg4 = (Frequency)jarg4; 
  {
    try {
      result = (*arg1)->zeroRate(arg2,arg3,arg4);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = new InterestRate((InterestRate &)result); 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_YieldTermStructureHandle_zeroRate__SWIG_5(void * jarg1, double jarg2, int jarg3) {
  void * jresult ;
  Handle<YieldTermStructure > *arg1 = (Handle<YieldTermStructure > *) 0 ;
  Time arg2 ;
  Compounding arg3 ;
  InterestRate result;
  
  arg1 = (Handle<YieldTermStructure > *)jarg1; 
  arg2 = (Time)jarg2; 
  arg3 = (Compounding)jarg3; 
  {
    try {
      result = (*arg1)->zeroRate(arg2,arg3);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = new InterestRate((InterestRate &)result); 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_YieldTermStructureHandle_forwardRate__SWIG_0(void * jarg1, void * jarg2, void * jarg3, void * jarg4, int jarg5, int jarg6, unsigned int jarg7) {
  void * jresult ;
  Handle<YieldTermStructure > *arg1 = (Handle<YieldTermStructure > *) 0 ;
  Date *arg2 = 0 ;
  Date *arg3 = 0 ;
  DayCounter *arg4 = 0 ;
  Compounding arg5 ;
  Frequency arg6 ;
  bool arg7 ;
  InterestRate result;
  
  arg1 = (Handle<YieldTermStructure > *)jarg1; 
  arg2 = (Date *)jarg2;
  if(!arg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
    return 0;
  } 
  arg3 = (Date *)jarg3;
  if(!arg3) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
    return 0;
  } 
  arg4 = (DayCounter *)jarg4;
  if(!arg4) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "DayCounter const & type is null", 0);
    return 0;
  } 
  arg5 = (Compounding)jarg5; 
  arg6 = (Frequency)jarg6; 
  arg7 = jarg7 ? true : false; 
  {
    try {
      result = (*arg1)->forwardRate((Date const &)*arg2,(Date const &)*arg3,(DayCounter const &)*arg4,arg5,arg6,arg7);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = new InterestRate((InterestRate &)result); 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_YieldTermStructureHandle_forwardRate__SWIG_1(void * jarg1, void * jarg2, void * jarg3, void * jarg4, int jarg5, int jarg6) {
  void * jresult ;
  Handle<YieldTermStructure > *arg1 = (Handle<YieldTermStructure > *) 0 ;
  Date *arg2 = 0 ;
  Date *arg3 = 0 ;
  DayCounter *arg4 = 0 ;
  Compounding arg5 ;
  Frequency arg6 ;
  InterestRate result;
  
  arg1 = (Handle<YieldTermStructure > *)jarg1; 
  arg2 = (Date *)jarg2;
  if(!arg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
    return 0;
  } 
  arg3 = (Date *)jarg3;
  if(!arg3) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
    return 0;
  } 
  arg4 = (DayCounter *)jarg4;
  if(!arg4) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "DayCounter const & type is null", 0);
    return 0;
  } 
  arg5 = (Compounding)jarg5; 
  arg6 = (Frequency)jarg6; 
  {
    try {
      result = (*arg1)->forwardRate((Date const &)*arg2,(Date const &)*arg3,(DayCounter const &)*arg4,arg5,arg6);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = new InterestRate((InterestRate &)result); 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_YieldTermStructureHandle_forwardRate__SWIG_2(void * jarg1, void * jarg2, void * jarg3, void * jarg4, int jarg5) {
  void * jresult ;
  Handle<YieldTermStructure > *arg1 = (Handle<YieldTermStructure > *) 0 ;
  Date *arg2 = 0 ;
  Date *arg3 = 0 ;
  DayCounter *arg4 = 0 ;
  Compounding arg5 ;
  InterestRate result;
  
  arg1 = (Handle<YieldTermStructure > *)jarg1; 
  arg2 = (Date *)jarg2;
  if(!arg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
    return 0;
  } 
  arg3 = (Date *)jarg3;
  if(!arg3) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
    return 0;
  } 
  arg4 = (DayCounter *)jarg4;
  if(!arg4) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "DayCounter const & type is null", 0);
    return 0;
  } 
  arg5 = (Compounding)jarg5; 
  {
    try {
      result = (*arg1)->forwardRate((Date const &)*arg2,(Date const &)*arg3,(DayCounter const &)*arg4,arg5);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = new InterestRate((InterestRate &)result); 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_YieldTermStructureHandle_forwardRate__SWIG_3(void * jarg1, double jarg2, double jarg3, int jarg4, int jarg5, unsigned int jarg6) {
  void * jresult ;
  Handle<YieldTermStructure > *arg1 = (Handle<YieldTermStructure > *) 0 ;
  Time arg2 ;
  Time arg3 ;
  Compounding arg4 ;
  Frequency arg5 ;
  bool arg6 ;
  InterestRate result;
  
  arg1 = (Handle<YieldTermStructure > *)jarg1; 
  arg2 = (Time)jarg2; 
  arg3 = (Time)jarg3; 
  arg4 = (Compounding)jarg4; 
  arg5 = (Frequency)jarg5; 
  arg6 = jarg6 ? true : false; 
  {
    try {
      result = (*arg1)->forwardRate(arg2,arg3,arg4,arg5,arg6);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = new InterestRate((InterestRate &)result); 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_YieldTermStructureHandle_forwardRate__SWIG_4(void * jarg1, double jarg2, double jarg3, int jarg4, int jarg5) {
  void * jresult ;
  Handle<YieldTermStructure > *arg1 = (Handle<YieldTermStructure > *) 0 ;
  Time arg2 ;
  Time arg3 ;
  Compounding arg4 ;
  Frequency arg5 ;
  InterestRate result;
  
  arg1 = (Handle<YieldTermStructure > *)jarg1; 
  arg2 = (Time)jarg2; 
  arg3 = (Time)jarg3; 
  arg4 = (Compounding)jarg4; 
  arg5 = (Frequency)jarg5; 
  {
    try {
      result = (*arg1)->forwardRate(arg2,arg3,arg4,arg5);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = new InterestRate((InterestRate &)result); 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_YieldTermStructureHandle_forwardRate__SWIG_5(void * jarg1, double jarg2, double jarg3, int jarg4) {
  void * jresult ;
  Handle<YieldTermStructure > *arg1 = (Handle<YieldTermStructure > *) 0 ;
  Time arg2 ;
  Time arg3 ;
  Compounding arg4 ;
  InterestRate result;
  
  arg1 = (Handle<YieldTermStructure > *)jarg1; 
  arg2 = (Time)jarg2; 
  arg3 = (Time)jarg3; 
  arg4 = (Compounding)jarg4; 
  {
    try {
      result = (*arg1)->forwardRate(arg2,arg3,arg4);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = new InterestRate((InterestRate &)result); 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_YieldTermStructureHandle_enableExtrapolation(void * jarg1) {
  Handle<YieldTermStructure > *arg1 = (Handle<YieldTermStructure > *) 0 ;
  
  arg1 = (Handle<YieldTermStructure > *)jarg1; 
  {
    try {
      (*arg1)->enableExtrapolation();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_YieldTermStructureHandle_disableExtrapolation(void * jarg1) {
  Handle<YieldTermStructure > *arg1 = (Handle<YieldTermStructure > *) 0 ;
  
  arg1 = (Handle<YieldTermStructure > *)jarg1; 
  {
    try {
      (*arg1)->disableExtrapolation();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT unsigned int SWIGSTDCALL CSharp_YieldTermStructureHandle_allowsExtrapolation(void * jarg1) {
  unsigned int jresult ;
  Handle<YieldTermStructure > *arg1 = (Handle<YieldTermStructure > *) 0 ;
  bool result;
  
  arg1 = (Handle<YieldTermStructure > *)jarg1; 
  {
    try {
      result = (bool)(*arg1)->allowsExtrapolation();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_ImpliedTermStructure(void * jarg1, void * jarg2) {
  void * jresult ;
  Handle<YieldTermStructure > *arg1 = 0 ;
  Date *arg2 = 0 ;
  ImpliedTermStructurePtr *result = 0 ;
  
  arg1 = (Handle<YieldTermStructure > *)jarg1;
  if(!arg1) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Handle<YieldTermStructure > const & type is null", 0);
    return 0;
  } 
  arg2 = (Date *)jarg2;
  if(!arg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
    return 0;
  } 
  {
    try {
      result = (ImpliedTermStructurePtr *)new_ImpliedTermStructurePtr((Handle<YieldTermStructure > const &)*arg1,(Date const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_ImpliedTermStructure(void * jarg1) {
  ImpliedTermStructurePtr *arg1 = (ImpliedTermStructurePtr *) 0 ;
  
  arg1 = (ImpliedTermStructurePtr *)jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_ZeroSpreadedTermStructure(void * jarg1, void * jarg2) {
  void * jresult ;
  Handle<YieldTermStructure > *arg1 = 0 ;
  Handle<Quote > *arg2 = 0 ;
  ZeroSpreadedTermStructurePtr *result = 0 ;
  
  arg1 = (Handle<YieldTermStructure > *)jarg1;
  if(!arg1) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Handle<YieldTermStructure > const & type is null", 0);
    return 0;
  } 
  arg2 = (Handle<Quote > *)jarg2;
  if(!arg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Handle<Quote > const & type is null", 0);
    return 0;
  } 
  {
    try {
      result = (ZeroSpreadedTermStructurePtr *)new_ZeroSpreadedTermStructurePtr((Handle<YieldTermStructure > const &)*arg1,(Handle<Quote > const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_ZeroSpreadedTermStructure(void * jarg1) {
  ZeroSpreadedTermStructurePtr *arg1 = (ZeroSpreadedTermStructurePtr *) 0 ;
  
  arg1 = (ZeroSpreadedTermStructurePtr *)jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_ForwardSpreadedTermStructure(void * jarg1, void * jarg2) {
  void * jresult ;
  Handle<YieldTermStructure > *arg1 = 0 ;
  Handle<Quote > *arg2 = 0 ;
  ForwardSpreadedTermStructurePtr *result = 0 ;
  
  arg1 = (Handle<YieldTermStructure > *)jarg1;
  if(!arg1) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Handle<YieldTermStructure > const & type is null", 0);
    return 0;
  } 
  arg2 = (Handle<Quote > *)jarg2;
  if(!arg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Handle<Quote > const & type is null", 0);
    return 0;
  } 
  {
    try {
      result = (ForwardSpreadedTermStructurePtr *)new_ForwardSpreadedTermStructurePtr((Handle<YieldTermStructure > const &)*arg1,(Handle<Quote > const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_ForwardSpreadedTermStructure(void * jarg1) {
  ForwardSpreadedTermStructurePtr *arg1 = (ForwardSpreadedTermStructurePtr *) 0 ;
  
  arg1 = (ForwardSpreadedTermStructurePtr *)jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_FlatForward__SWIG_0(void * jarg1, void * jarg2, void * jarg3, int jarg4, int jarg5) {
  void * jresult ;
  Date *arg1 = 0 ;
  Handle<Quote > *arg2 = 0 ;
  DayCounter *arg3 = 0 ;
  Compounding arg4 ;
  Frequency arg5 ;
  FlatForwardPtr *result = 0 ;
  
  arg1 = (Date *)jarg1;
  if(!arg1) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
    return 0;
  } 
  arg2 = (Handle<Quote > *)jarg2;
  if(!arg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Handle<Quote > const & type is null", 0);
    return 0;
  } 
  arg3 = (DayCounter *)jarg3;
  if(!arg3) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "DayCounter const & type is null", 0);
    return 0;
  } 
  arg4 = (Compounding)jarg4; 
  arg5 = (Frequency)jarg5; 
  {
    try {
      result = (FlatForwardPtr *)new_FlatForwardPtr__SWIG_0((Date const &)*arg1,(Handle<Quote > const &)*arg2,(DayCounter const &)*arg3,arg4,arg5);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_FlatForward__SWIG_1(void * jarg1, void * jarg2, void * jarg3, int jarg4) {
  void * jresult ;
  Date *arg1 = 0 ;
  Handle<Quote > *arg2 = 0 ;
  DayCounter *arg3 = 0 ;
  Compounding arg4 ;
  FlatForwardPtr *result = 0 ;
  
  arg1 = (Date *)jarg1;
  if(!arg1) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
    return 0;
  } 
  arg2 = (Handle<Quote > *)jarg2;
  if(!arg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Handle<Quote > const & type is null", 0);
    return 0;
  } 
  arg3 = (DayCounter *)jarg3;
  if(!arg3) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "DayCounter const & type is null", 0);
    return 0;
  } 
  arg4 = (Compounding)jarg4; 
  {
    try {
      result = (FlatForwardPtr *)new_FlatForwardPtr__SWIG_0((Date const &)*arg1,(Handle<Quote > const &)*arg2,(DayCounter const &)*arg3,arg4);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_FlatForward__SWIG_2(void * jarg1, void * jarg2, void * jarg3) {
  void * jresult ;
  Date *arg1 = 0 ;
  Handle<Quote > *arg2 = 0 ;
  DayCounter *arg3 = 0 ;
  FlatForwardPtr *result = 0 ;
  
  arg1 = (Date *)jarg1;
  if(!arg1) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
    return 0;
  } 
  arg2 = (Handle<Quote > *)jarg2;
  if(!arg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Handle<Quote > const & type is null", 0);
    return 0;
  } 
  arg3 = (DayCounter *)jarg3;
  if(!arg3) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "DayCounter const & type is null", 0);
    return 0;
  } 
  {
    try {
      result = (FlatForwardPtr *)new_FlatForwardPtr__SWIG_0((Date const &)*arg1,(Handle<Quote > const &)*arg2,(DayCounter const &)*arg3);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_FlatForward__SWIG_3(void * jarg1, double jarg2, void * jarg3, int jarg4, int jarg5) {
  void * jresult ;
  Date *arg1 = 0 ;
  Rate arg2 ;
  DayCounter *arg3 = 0 ;
  Compounding arg4 ;
  Frequency arg5 ;
  FlatForwardPtr *result = 0 ;
  
  arg1 = (Date *)jarg1;
  if(!arg1) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
    return 0;
  } 
  arg2 = (Rate)jarg2; 
  arg3 = (DayCounter *)jarg3;
  if(!arg3) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "DayCounter const & type is null", 0);
    return 0;
  } 
  arg4 = (Compounding)jarg4; 
  arg5 = (Frequency)jarg5; 
  {
    try {
      result = (FlatForwardPtr *)new_FlatForwardPtr__SWIG_3((Date const &)*arg1,arg2,(DayCounter const &)*arg3,arg4,arg5);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_FlatForward__SWIG_4(void * jarg1, double jarg2, void * jarg3, int jarg4) {
  void * jresult ;
  Date *arg1 = 0 ;
  Rate arg2 ;
  DayCounter *arg3 = 0 ;
  Compounding arg4 ;
  FlatForwardPtr *result = 0 ;
  
  arg1 = (Date *)jarg1;
  if(!arg1) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
    return 0;
  } 
  arg2 = (Rate)jarg2; 
  arg3 = (DayCounter *)jarg3;
  if(!arg3) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "DayCounter const & type is null", 0);
    return 0;
  } 
  arg4 = (Compounding)jarg4; 
  {
    try {
      result = (FlatForwardPtr *)new_FlatForwardPtr__SWIG_3((Date const &)*arg1,arg2,(DayCounter const &)*arg3,arg4);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_FlatForward__SWIG_5(void * jarg1, double jarg2, void * jarg3) {
  void * jresult ;
  Date *arg1 = 0 ;
  Rate arg2 ;
  DayCounter *arg3 = 0 ;
  FlatForwardPtr *result = 0 ;
  
  arg1 = (Date *)jarg1;
  if(!arg1) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
    return 0;
  } 
  arg2 = (Rate)jarg2; 
  arg3 = (DayCounter *)jarg3;
  if(!arg3) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "DayCounter const & type is null", 0);
    return 0;
  } 
  {
    try {
      result = (FlatForwardPtr *)new_FlatForwardPtr__SWIG_3((Date const &)*arg1,arg2,(DayCounter const &)*arg3);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_FlatForward__SWIG_6(int jarg1, void * jarg2, void * jarg3, void * jarg4, int jarg5, int jarg6) {
  void * jresult ;
  Integer arg1 ;
  Calendar *arg2 = 0 ;
  Handle<Quote > *arg3 = 0 ;
  DayCounter *arg4 = 0 ;
  Compounding arg5 ;
  Frequency arg6 ;
  FlatForwardPtr *result = 0 ;
  
  arg1 = (Integer)jarg1; 
  arg2 = (Calendar *)jarg2;
  if(!arg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Calendar const & type is null", 0);
    return 0;
  } 
  arg3 = (Handle<Quote > *)jarg3;
  if(!arg3) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Handle<Quote > const & type is null", 0);
    return 0;
  } 
  arg4 = (DayCounter *)jarg4;
  if(!arg4) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "DayCounter const & type is null", 0);
    return 0;
  } 
  arg5 = (Compounding)jarg5; 
  arg6 = (Frequency)jarg6; 
  {
    try {
      result = (FlatForwardPtr *)new_FlatForwardPtr__SWIG_6(arg1,(Calendar const &)*arg2,(Handle<Quote > const &)*arg3,(DayCounter const &)*arg4,arg5,arg6);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_FlatForward__SWIG_7(int jarg1, void * jarg2, void * jarg3, void * jarg4, int jarg5) {
  void * jresult ;
  Integer arg1 ;
  Calendar *arg2 = 0 ;
  Handle<Quote > *arg3 = 0 ;
  DayCounter *arg4 = 0 ;
  Compounding arg5 ;
  FlatForwardPtr *result = 0 ;
  
  arg1 = (Integer)jarg1; 
  arg2 = (Calendar *)jarg2;
  if(!arg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Calendar const & type is null", 0);
    return 0;
  } 
  arg3 = (Handle<Quote > *)jarg3;
  if(!arg3) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Handle<Quote > const & type is null", 0);
    return 0;
  } 
  arg4 = (DayCounter *)jarg4;
  if(!arg4) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "DayCounter const & type is null", 0);
    return 0;
  } 
  arg5 = (Compounding)jarg5; 
  {
    try {
      result = (FlatForwardPtr *)new_FlatForwardPtr__SWIG_6(arg1,(Calendar const &)*arg2,(Handle<Quote > const &)*arg3,(DayCounter const &)*arg4,arg5);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_FlatForward__SWIG_8(int jarg1, void * jarg2, void * jarg3, void * jarg4) {
  void * jresult ;
  Integer arg1 ;
  Calendar *arg2 = 0 ;
  Handle<Quote > *arg3 = 0 ;
  DayCounter *arg4 = 0 ;
  FlatForwardPtr *result = 0 ;
  
  arg1 = (Integer)jarg1; 
  arg2 = (Calendar *)jarg2;
  if(!arg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Calendar const & type is null", 0);
    return 0;
  } 
  arg3 = (Handle<Quote > *)jarg3;
  if(!arg3) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Handle<Quote > const & type is null", 0);
    return 0;
  } 
  arg4 = (DayCounter *)jarg4;
  if(!arg4) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "DayCounter const & type is null", 0);
    return 0;
  } 
  {
    try {
      result = (FlatForwardPtr *)new_FlatForwardPtr__SWIG_6(arg1,(Calendar const &)*arg2,(Handle<Quote > const &)*arg3,(DayCounter const &)*arg4);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_FlatForward__SWIG_9(int jarg1, void * jarg2, double jarg3, void * jarg4, int jarg5, int jarg6) {
  void * jresult ;
  Integer arg1 ;
  Calendar *arg2 = 0 ;
  Rate arg3 ;
  DayCounter *arg4 = 0 ;
  Compounding arg5 ;
  Frequency arg6 ;
  FlatForwardPtr *result = 0 ;
  
  arg1 = (Integer)jarg1; 
  arg2 = (Calendar *)jarg2;
  if(!arg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Calendar const & type is null", 0);
    return 0;
  } 
  arg3 = (Rate)jarg3; 
  arg4 = (DayCounter *)jarg4;
  if(!arg4) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "DayCounter const & type is null", 0);
    return 0;
  } 
  arg5 = (Compounding)jarg5; 
  arg6 = (Frequency)jarg6; 
  {
    try {
      result = (FlatForwardPtr *)new_FlatForwardPtr__SWIG_9(arg1,(Calendar const &)*arg2,arg3,(DayCounter const &)*arg4,arg5,arg6);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_FlatForward__SWIG_10(int jarg1, void * jarg2, double jarg3, void * jarg4, int jarg5) {
  void * jresult ;
  Integer arg1 ;
  Calendar *arg2 = 0 ;
  Rate arg3 ;
  DayCounter *arg4 = 0 ;
  Compounding arg5 ;
  FlatForwardPtr *result = 0 ;
  
  arg1 = (Integer)jarg1; 
  arg2 = (Calendar *)jarg2;
  if(!arg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Calendar const & type is null", 0);
    return 0;
  } 
  arg3 = (Rate)jarg3; 
  arg4 = (DayCounter *)jarg4;
  if(!arg4) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "DayCounter const & type is null", 0);
    return 0;
  } 
  arg5 = (Compounding)jarg5; 
  {
    try {
      result = (FlatForwardPtr *)new_FlatForwardPtr__SWIG_9(arg1,(Calendar const &)*arg2,arg3,(DayCounter const &)*arg4,arg5);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_FlatForward__SWIG_11(int jarg1, void * jarg2, double jarg3, void * jarg4) {
  void * jresult ;
  Integer arg1 ;
  Calendar *arg2 = 0 ;
  Rate arg3 ;
  DayCounter *arg4 = 0 ;
  FlatForwardPtr *result = 0 ;
  
  arg1 = (Integer)jarg1; 
  arg2 = (Calendar *)jarg2;
  if(!arg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Calendar const & type is null", 0);
    return 0;
  } 
  arg3 = (Rate)jarg3; 
  arg4 = (DayCounter *)jarg4;
  if(!arg4) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "DayCounter const & type is null", 0);
    return 0;
  } 
  {
    try {
      result = (FlatForwardPtr *)new_FlatForwardPtr__SWIG_9(arg1,(Calendar const &)*arg2,arg3,(DayCounter const &)*arg4);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_FlatForward(void * jarg1) {
  FlatForwardPtr *arg1 = (FlatForwardPtr *) 0 ;
  
  arg1 = (FlatForwardPtr *)jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_BlackModel___deref__(void * jarg1) {
  void * jresult ;
  boost::shared_ptr<BlackModel > *arg1 = (boost::shared_ptr<BlackModel > *) 0 ;
  BlackModel *result = 0 ;
  
  arg1 = (boost::shared_ptr<BlackModel > *)jarg1; 
  {
    try {
      result = (BlackModel *)(arg1)->operator ->();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT unsigned int SWIGSTDCALL CSharp_BlackModel_isNull(void * jarg1) {
  unsigned int jresult ;
  boost::shared_ptr<BlackModel > *arg1 = (boost::shared_ptr<BlackModel > *) 0 ;
  bool result;
  
  arg1 = (boost::shared_ptr<BlackModel > *)jarg1; 
  {
    try {
      result = (bool)boost_shared_ptr_Sl_BlackModel_Sg__isNull(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_BlackModel(void * jarg1, void * jarg2) {
  void * jresult ;
  Handle<Quote > *arg1 = 0 ;
  Handle<YieldTermStructure > *arg2 = 0 ;
  boost::shared_ptr<BlackModel > *result = 0 ;
  
  arg1 = (Handle<Quote > *)jarg1;
  if(!arg1) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Handle<Quote > const & type is null", 0);
    return 0;
  } 
  arg2 = (Handle<YieldTermStructure > *)jarg2;
  if(!arg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Handle<YieldTermStructure > const & type is null", 0);
    return 0;
  } 
  {
    try {
      result = (boost::shared_ptr<BlackModel > *)new_boost_shared_ptr_Sl_BlackModel_Sg_((Handle<Quote > const &)*arg1,(Handle<YieldTermStructure > const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_BlackModel(void * jarg1) {
  boost::shared_ptr<BlackModel > *arg1 = (boost::shared_ptr<BlackModel > *) 0 ;
  
  arg1 = (boost::shared_ptr<BlackModel > *)jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_PricingEngine___deref__(void * jarg1) {
  void * jresult ;
  boost::shared_ptr<PricingEngine > *arg1 = (boost::shared_ptr<PricingEngine > *) 0 ;
  PricingEngine *result = 0 ;
  
  arg1 = (boost::shared_ptr<PricingEngine > *)jarg1; 
  {
    try {
      result = (PricingEngine *)(arg1)->operator ->();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT unsigned int SWIGSTDCALL CSharp_PricingEngine_isNull(void * jarg1) {
  unsigned int jresult ;
  boost::shared_ptr<PricingEngine > *arg1 = (boost::shared_ptr<PricingEngine > *) 0 ;
  bool result;
  
  arg1 = (boost::shared_ptr<PricingEngine > *)jarg1; 
  {
    try {
      result = (bool)boost_shared_ptr_Sl_PricingEngine_Sg__isNull(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_PricingEngine() {
  void * jresult ;
  boost::shared_ptr<PricingEngine > *result = 0 ;
  
  {
    try {
      result = (boost::shared_ptr<PricingEngine > *)new boost::shared_ptr<PricingEngine >();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_PricingEngine(void * jarg1) {
  boost::shared_ptr<PricingEngine > *arg1 = (boost::shared_ptr<PricingEngine > *) 0 ;
  
  arg1 = (boost::shared_ptr<PricingEngine > *)jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_Instrument___deref__(void * jarg1) {
  void * jresult ;
  boost::shared_ptr<Instrument > *arg1 = (boost::shared_ptr<Instrument > *) 0 ;
  Instrument *result = 0 ;
  
  arg1 = (boost::shared_ptr<Instrument > *)jarg1; 
  {
    try {
      result = (Instrument *)(arg1)->operator ->();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT unsigned int SWIGSTDCALL CSharp_Instrument_isNull(void * jarg1) {
  unsigned int jresult ;
  boost::shared_ptr<Instrument > *arg1 = (boost::shared_ptr<Instrument > *) 0 ;
  bool result;
  
  arg1 = (boost::shared_ptr<Instrument > *)jarg1; 
  {
    try {
      result = (bool)boost_shared_ptr_Sl_Instrument_Sg__isNull(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_Instrument_asObservable(void * jarg1) {
  void * jresult ;
  boost::shared_ptr<Instrument > *arg1 = (boost::shared_ptr<Instrument > *) 0 ;
  boost::shared_ptr<Observable > result;
  
  arg1 = (boost::shared_ptr<Instrument > *)jarg1; 
  {
    try {
      result = boost_shared_ptr_Sl_Instrument_Sg__asObservable(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = new boost::shared_ptr<Observable >((boost::shared_ptr<Observable > &)result); 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_Instrument() {
  void * jresult ;
  boost::shared_ptr<Instrument > *result = 0 ;
  
  {
    try {
      result = (boost::shared_ptr<Instrument > *)new boost::shared_ptr<Instrument >();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_Instrument(void * jarg1) {
  boost::shared_ptr<Instrument > *arg1 = (boost::shared_ptr<Instrument > *) 0 ;
  
  arg1 = (boost::shared_ptr<Instrument > *)jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT double SWIGSTDCALL CSharp_Instrument_NPV(void * jarg1) {
  double jresult ;
  boost::shared_ptr<Instrument > *arg1 = (boost::shared_ptr<Instrument > *) 0 ;
  Real result;
  
  arg1 = (boost::shared_ptr<Instrument > *)jarg1; 
  {
    try {
      result = (Real)(*arg1)->NPV();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT double SWIGSTDCALL CSharp_Instrument_errorEstimate(void * jarg1) {
  double jresult ;
  boost::shared_ptr<Instrument > *arg1 = (boost::shared_ptr<Instrument > *) 0 ;
  Real result;
  
  arg1 = (boost::shared_ptr<Instrument > *)jarg1; 
  {
    try {
      result = (Real)(*arg1)->errorEstimate();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT unsigned int SWIGSTDCALL CSharp_Instrument_isExpired(void * jarg1) {
  unsigned int jresult ;
  boost::shared_ptr<Instrument > *arg1 = (boost::shared_ptr<Instrument > *) 0 ;
  bool result;
  
  arg1 = (boost::shared_ptr<Instrument > *)jarg1; 
  {
    try {
      result = (bool)(*arg1)->isExpired();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_Instrument_setPricingEngine(void * jarg1, void * jarg2) {
  boost::shared_ptr<Instrument > *arg1 = (boost::shared_ptr<Instrument > *) 0 ;
  boost::shared_ptr<PricingEngine > *arg2 = 0 ;
  
  arg1 = (boost::shared_ptr<Instrument > *)jarg1; 
  arg2 = (boost::shared_ptr<PricingEngine > *)jarg2;
  if(!arg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "boost::shared_ptr<PricingEngine > const & type is null", 0);
    return ;
  } 
  {
    try {
      (*arg1)->setPricingEngine((boost::shared_ptr<PricingEngine > const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_Instrument_recalculate(void * jarg1) {
  boost::shared_ptr<Instrument > *arg1 = (boost::shared_ptr<Instrument > *) 0 ;
  
  arg1 = (boost::shared_ptr<Instrument > *)jarg1; 
  {
    try {
      (*arg1)->recalculate();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_Instrument_freeze(void * jarg1) {
  boost::shared_ptr<Instrument > *arg1 = (boost::shared_ptr<Instrument > *) 0 ;
  
  arg1 = (boost::shared_ptr<Instrument > *)jarg1; 
  {
    try {
      (*arg1)->freeze();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_Instrument_unfreeze(void * jarg1) {
  boost::shared_ptr<Instrument > *arg1 = (boost::shared_ptr<Instrument > *) 0 ;
  
  arg1 = (boost::shared_ptr<Instrument > *)jarg1; 
  {
    try {
      (*arg1)->unfreeze();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_Stock(void * jarg1) {
  void * jresult ;
  Handle<Quote > *arg1 = 0 ;
  StockPtr *result = 0 ;
  
  arg1 = (Handle<Quote > *)jarg1;
  if(!arg1) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Handle<Quote > const & type is null", 0);
    return 0;
  } 
  {
    try {
      result = (StockPtr *)new_StockPtr((Handle<Quote > const &)*arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_Stock(void * jarg1) {
  StockPtr *arg1 = (StockPtr *) 0 ;
  
  arg1 = (StockPtr *)jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_IntVector_Clear(void * jarg1) {
  std::vector<int > *arg1 = (std::vector<int > *) 0 ;
  
  arg1 = (std::vector<int > *)jarg1; 
  {
    try {
      (arg1)->clear();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_IntVector_Add(void * jarg1, int jarg2) {
  std::vector<int > *arg1 = (std::vector<int > *) 0 ;
  std::vector<int >::value_type *arg2 = 0 ;
  std::vector<int >::value_type temp2 ;
  
  arg1 = (std::vector<int > *)jarg1; 
  temp2 = (std::vector<int >::value_type)jarg2; 
  arg2 = &temp2; 
  {
    try {
      (arg1)->push_back((std::vector<int >::value_type const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT unsigned long SWIGSTDCALL CSharp_IntVector_size(void * jarg1) {
  unsigned long jresult ;
  std::vector<int > *arg1 = (std::vector<int > *) 0 ;
  std::vector<int >::size_type result;
  
  arg1 = (std::vector<int > *)jarg1; 
  {
    try {
      result = ((std::vector<int > const *)arg1)->size();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT unsigned long SWIGSTDCALL CSharp_IntVector_capacity(void * jarg1) {
  unsigned long jresult ;
  std::vector<int > *arg1 = (std::vector<int > *) 0 ;
  std::vector<int >::size_type result;
  
  arg1 = (std::vector<int > *)jarg1; 
  {
    try {
      result = ((std::vector<int > const *)arg1)->capacity();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_IntVector_reserve(void * jarg1, unsigned long jarg2) {
  std::vector<int > *arg1 = (std::vector<int > *) 0 ;
  std::vector<int >::size_type arg2 ;
  
  arg1 = (std::vector<int > *)jarg1; 
  arg2 = (std::vector<int >::size_type)jarg2; 
  {
    try {
      (arg1)->reserve(arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_IntVector__SWIG_0() {
  void * jresult ;
  std::vector<int > *result = 0 ;
  
  {
    try {
      result = (std::vector<int > *)new std::vector<int >();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_IntVector__SWIG_1(int jarg1) {
  void * jresult ;
  int arg1 ;
  std::vector<int > *result = 0 ;
  
  arg1 = (int)jarg1; 
  {
    try {
      try {
        result = (std::vector<int > *)new_std_vector_Sl_int_Sg___SWIG_1(arg1);
      }
      catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return 0;
      }
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT int SWIGSTDCALL CSharp_IntVector_getitemcopy(void * jarg1, int jarg2) {
  int jresult ;
  std::vector<int > *arg1 = (std::vector<int > *) 0 ;
  int arg2 ;
  int result;
  
  arg1 = (std::vector<int > *)jarg1; 
  arg2 = (int)jarg2; 
  {
    try {
      try {
        result = (int)std_vector_Sl_int_Sg__getitemcopy(arg1,arg2);
      }
      catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return 0;
      }
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT int SWIGSTDCALL CSharp_IntVector_getitem(void * jarg1, int jarg2) {
  int jresult ;
  std::vector<int > *arg1 = (std::vector<int > *) 0 ;
  int arg2 ;
  std::vector<int >::value_type *result = 0 ;
  
  arg1 = (std::vector<int > *)jarg1; 
  arg2 = (int)jarg2; 
  {
    try {
      try {
        {
          std::vector<int >::const_reference _result_ref = std_vector_Sl_int_Sg__getitem(arg1,arg2);
          result = (std::vector<int >::value_type *) &_result_ref;
        }
      }
      catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return 0;
      }
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = *result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_IntVector_setitem(void * jarg1, int jarg2, int jarg3) {
  std::vector<int > *arg1 = (std::vector<int > *) 0 ;
  int arg2 ;
  std::vector<int >::value_type *arg3 = 0 ;
  std::vector<int >::value_type temp3 ;
  
  arg1 = (std::vector<int > *)jarg1; 
  arg2 = (int)jarg2; 
  temp3 = (std::vector<int >::value_type)jarg3; 
  arg3 = &temp3; 
  {
    try {
      try {
        std_vector_Sl_int_Sg__setitem(arg1,arg2,(int const &)*arg3);
      }
      catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return ;
      }
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_IntVector_AddRange(void * jarg1, void * jarg2) {
  std::vector<int > *arg1 = (std::vector<int > *) 0 ;
  std::vector<int > *arg2 = 0 ;
  
  arg1 = (std::vector<int > *)jarg1; 
  arg2 = (std::vector<int > *)jarg2;
  if(!arg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "std::vector<int > const & type is null", 0);
    return ;
  } 
  {
    try {
      std_vector_Sl_int_Sg__AddRange(arg1,(std::vector<int > const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_IntVector_GetRange(void * jarg1, int jarg2, int jarg3) {
  void * jresult ;
  std::vector<int > *arg1 = (std::vector<int > *) 0 ;
  int arg2 ;
  int arg3 ;
  std::vector<int > *result = 0 ;
  
  arg1 = (std::vector<int > *)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  {
    try {
      try {
        result = (std::vector<int > *)std_vector_Sl_int_Sg__GetRange(arg1,arg2,arg3);
      }
      catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return 0;
      }
      catch(std::invalid_argument &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentException, (&_e)->what(), "");
        return 0;
      }
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_IntVector_Insert(void * jarg1, int jarg2, int jarg3) {
  std::vector<int > *arg1 = (std::vector<int > *) 0 ;
  int arg2 ;
  std::vector<int >::value_type *arg3 = 0 ;
  std::vector<int >::value_type temp3 ;
  
  arg1 = (std::vector<int > *)jarg1; 
  arg2 = (int)jarg2; 
  temp3 = (std::vector<int >::value_type)jarg3; 
  arg3 = &temp3; 
  {
    try {
      try {
        std_vector_Sl_int_Sg__Insert(arg1,arg2,(int const &)*arg3);
      }
      catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return ;
      }
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_IntVector_InsertRange(void * jarg1, int jarg2, void * jarg3) {
  std::vector<int > *arg1 = (std::vector<int > *) 0 ;
  int arg2 ;
  std::vector<int > *arg3 = 0 ;
  
  arg1 = (std::vector<int > *)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (std::vector<int > *)jarg3;
  if(!arg3) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "std::vector<int > const & type is null", 0);
    return ;
  } 
  {
    try {
      try {
        std_vector_Sl_int_Sg__InsertRange(arg1,arg2,(std::vector<int > const &)*arg3);
      }
      catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return ;
      }
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_IntVector_RemoveAt(void * jarg1, int jarg2) {
  std::vector<int > *arg1 = (std::vector<int > *) 0 ;
  int arg2 ;
  
  arg1 = (std::vector<int > *)jarg1; 
  arg2 = (int)jarg2; 
  {
    try {
      try {
        std_vector_Sl_int_Sg__RemoveAt(arg1,arg2);
      }
      catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return ;
      }
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_IntVector_RemoveRange(void * jarg1, int jarg2, int jarg3) {
  std::vector<int > *arg1 = (std::vector<int > *) 0 ;
  int arg2 ;
  int arg3 ;
  
  arg1 = (std::vector<int > *)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  {
    try {
      try {
        std_vector_Sl_int_Sg__RemoveRange(arg1,arg2,arg3);
      }
      catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return ;
      }
      catch(std::invalid_argument &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentException, (&_e)->what(), "");
        return ;
      }
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_IntVector_Repeat(int jarg1, int jarg2) {
  void * jresult ;
  std::vector<int >::value_type *arg1 = 0 ;
  int arg2 ;
  std::vector<int > *result = 0 ;
  std::vector<int >::value_type temp1 ;
  
  temp1 = (std::vector<int >::value_type)jarg1; 
  arg1 = &temp1; 
  arg2 = (int)jarg2; 
  {
    try {
      try {
        result = (std::vector<int > *)std_vector_Sl_int_Sg__Repeat((int const &)*arg1,arg2);
      }
      catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return 0;
      }
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_IntVector_Reverse__SWIG_0(void * jarg1) {
  std::vector<int > *arg1 = (std::vector<int > *) 0 ;
  
  arg1 = (std::vector<int > *)jarg1; 
  {
    try {
      std_vector_Sl_int_Sg__Reverse__SWIG_0(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_IntVector_Reverse__SWIG_1(void * jarg1, int jarg2, int jarg3) {
  std::vector<int > *arg1 = (std::vector<int > *) 0 ;
  int arg2 ;
  int arg3 ;
  
  arg1 = (std::vector<int > *)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  {
    try {
      try {
        std_vector_Sl_int_Sg__Reverse__SWIG_1(arg1,arg2,arg3);
      }
      catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return ;
      }
      catch(std::invalid_argument &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentException, (&_e)->what(), "");
        return ;
      }
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_IntVector_SetRange(void * jarg1, int jarg2, void * jarg3) {
  std::vector<int > *arg1 = (std::vector<int > *) 0 ;
  int arg2 ;
  std::vector<int > *arg3 = 0 ;
  
  arg1 = (std::vector<int > *)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (std::vector<int > *)jarg3;
  if(!arg3) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "std::vector<int > const & type is null", 0);
    return ;
  } 
  {
    try {
      try {
        std_vector_Sl_int_Sg__SetRange(arg1,arg2,(std::vector<int > const &)*arg3);
      }
      catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return ;
      }
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT unsigned int SWIGSTDCALL CSharp_IntVector_Contains(void * jarg1, int jarg2) {
  unsigned int jresult ;
  std::vector<int > *arg1 = (std::vector<int > *) 0 ;
  std::vector<int >::value_type *arg2 = 0 ;
  bool result;
  std::vector<int >::value_type temp2 ;
  
  arg1 = (std::vector<int > *)jarg1; 
  temp2 = (std::vector<int >::value_type)jarg2; 
  arg2 = &temp2; 
  {
    try {
      result = (bool)std_vector_Sl_int_Sg__Contains(arg1,(int const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT int SWIGSTDCALL CSharp_IntVector_IndexOf(void * jarg1, int jarg2) {
  int jresult ;
  std::vector<int > *arg1 = (std::vector<int > *) 0 ;
  std::vector<int >::value_type *arg2 = 0 ;
  int result;
  std::vector<int >::value_type temp2 ;
  
  arg1 = (std::vector<int > *)jarg1; 
  temp2 = (std::vector<int >::value_type)jarg2; 
  arg2 = &temp2; 
  {
    try {
      result = (int)std_vector_Sl_int_Sg__IndexOf(arg1,(int const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT int SWIGSTDCALL CSharp_IntVector_LastIndexOf(void * jarg1, int jarg2) {
  int jresult ;
  std::vector<int > *arg1 = (std::vector<int > *) 0 ;
  std::vector<int >::value_type *arg2 = 0 ;
  int result;
  std::vector<int >::value_type temp2 ;
  
  arg1 = (std::vector<int > *)jarg1; 
  temp2 = (std::vector<int >::value_type)jarg2; 
  arg2 = &temp2; 
  {
    try {
      result = (int)std_vector_Sl_int_Sg__LastIndexOf(arg1,(int const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_IntVector_Remove(void * jarg1, int jarg2) {
  std::vector<int > *arg1 = (std::vector<int > *) 0 ;
  std::vector<int >::value_type *arg2 = 0 ;
  std::vector<int >::value_type temp2 ;
  
  arg1 = (std::vector<int > *)jarg1; 
  temp2 = (std::vector<int >::value_type)jarg2; 
  arg2 = &temp2; 
  {
    try {
      std_vector_Sl_int_Sg__Remove(arg1,(int const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_IntVector(void * jarg1) {
  std::vector<int > *arg1 = (std::vector<int > *) 0 ;
  
  arg1 = (std::vector<int > *)jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_DoubleVector_Clear(void * jarg1) {
  std::vector<double > *arg1 = (std::vector<double > *) 0 ;
  
  arg1 = (std::vector<double > *)jarg1; 
  {
    try {
      (arg1)->clear();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_DoubleVector_Add(void * jarg1, double jarg2) {
  std::vector<double > *arg1 = (std::vector<double > *) 0 ;
  std::vector<double >::value_type *arg2 = 0 ;
  std::vector<double >::value_type temp2 ;
  
  arg1 = (std::vector<double > *)jarg1; 
  temp2 = (std::vector<double >::value_type)jarg2; 
  arg2 = &temp2; 
  {
    try {
      (arg1)->push_back((std::vector<double >::value_type const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT unsigned long SWIGSTDCALL CSharp_DoubleVector_size(void * jarg1) {
  unsigned long jresult ;
  std::vector<double > *arg1 = (std::vector<double > *) 0 ;
  std::vector<double >::size_type result;
  
  arg1 = (std::vector<double > *)jarg1; 
  {
    try {
      result = ((std::vector<double > const *)arg1)->size();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT unsigned long SWIGSTDCALL CSharp_DoubleVector_capacity(void * jarg1) {
  unsigned long jresult ;
  std::vector<double > *arg1 = (std::vector<double > *) 0 ;
  std::vector<double >::size_type result;
  
  arg1 = (std::vector<double > *)jarg1; 
  {
    try {
      result = ((std::vector<double > const *)arg1)->capacity();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_DoubleVector_reserve(void * jarg1, unsigned long jarg2) {
  std::vector<double > *arg1 = (std::vector<double > *) 0 ;
  std::vector<double >::size_type arg2 ;
  
  arg1 = (std::vector<double > *)jarg1; 
  arg2 = (std::vector<double >::size_type)jarg2; 
  {
    try {
      (arg1)->reserve(arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_DoubleVector__SWIG_0() {
  void * jresult ;
  std::vector<double > *result = 0 ;
  
  {
    try {
      result = (std::vector<double > *)new std::vector<double >();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_DoubleVector__SWIG_1(int jarg1) {
  void * jresult ;
  int arg1 ;
  std::vector<double > *result = 0 ;
  
  arg1 = (int)jarg1; 
  {
    try {
      try {
        result = (std::vector<double > *)new_std_vector_Sl_double_Sg___SWIG_1(arg1);
      }
      catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return 0;
      }
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT double SWIGSTDCALL CSharp_DoubleVector_getitemcopy(void * jarg1, int jarg2) {
  double jresult ;
  std::vector<double > *arg1 = (std::vector<double > *) 0 ;
  int arg2 ;
  double result;
  
  arg1 = (std::vector<double > *)jarg1; 
  arg2 = (int)jarg2; 
  {
    try {
      try {
        result = (double)std_vector_Sl_double_Sg__getitemcopy(arg1,arg2);
      }
      catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return 0;
      }
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT double SWIGSTDCALL CSharp_DoubleVector_getitem(void * jarg1, int jarg2) {
  double jresult ;
  std::vector<double > *arg1 = (std::vector<double > *) 0 ;
  int arg2 ;
  std::vector<double >::value_type *result = 0 ;
  
  arg1 = (std::vector<double > *)jarg1; 
  arg2 = (int)jarg2; 
  {
    try {
      try {
        {
          std::vector<double >::const_reference _result_ref = std_vector_Sl_double_Sg__getitem(arg1,arg2);
          result = (std::vector<double >::value_type *) &_result_ref;
        }
      }
      catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return 0;
      }
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = *result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_DoubleVector_setitem(void * jarg1, int jarg2, double jarg3) {
  std::vector<double > *arg1 = (std::vector<double > *) 0 ;
  int arg2 ;
  std::vector<double >::value_type *arg3 = 0 ;
  std::vector<double >::value_type temp3 ;
  
  arg1 = (std::vector<double > *)jarg1; 
  arg2 = (int)jarg2; 
  temp3 = (std::vector<double >::value_type)jarg3; 
  arg3 = &temp3; 
  {
    try {
      try {
        std_vector_Sl_double_Sg__setitem(arg1,arg2,(double const &)*arg3);
      }
      catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return ;
      }
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_DoubleVector_AddRange(void * jarg1, void * jarg2) {
  std::vector<double > *arg1 = (std::vector<double > *) 0 ;
  std::vector<double > *arg2 = 0 ;
  
  arg1 = (std::vector<double > *)jarg1; 
  arg2 = (std::vector<double > *)jarg2;
  if(!arg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "std::vector<double > const & type is null", 0);
    return ;
  } 
  {
    try {
      std_vector_Sl_double_Sg__AddRange(arg1,(std::vector<double > const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_DoubleVector_GetRange(void * jarg1, int jarg2, int jarg3) {
  void * jresult ;
  std::vector<double > *arg1 = (std::vector<double > *) 0 ;
  int arg2 ;
  int arg3 ;
  std::vector<double > *result = 0 ;
  
  arg1 = (std::vector<double > *)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  {
    try {
      try {
        result = (std::vector<double > *)std_vector_Sl_double_Sg__GetRange(arg1,arg2,arg3);
      }
      catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return 0;
      }
      catch(std::invalid_argument &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentException, (&_e)->what(), "");
        return 0;
      }
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_DoubleVector_Insert(void * jarg1, int jarg2, double jarg3) {
  std::vector<double > *arg1 = (std::vector<double > *) 0 ;
  int arg2 ;
  std::vector<double >::value_type *arg3 = 0 ;
  std::vector<double >::value_type temp3 ;
  
  arg1 = (std::vector<double > *)jarg1; 
  arg2 = (int)jarg2; 
  temp3 = (std::vector<double >::value_type)jarg3; 
  arg3 = &temp3; 
  {
    try {
      try {
        std_vector_Sl_double_Sg__Insert(arg1,arg2,(double const &)*arg3);
      }
      catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return ;
      }
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_DoubleVector_InsertRange(void * jarg1, int jarg2, void * jarg3) {
  std::vector<double > *arg1 = (std::vector<double > *) 0 ;
  int arg2 ;
  std::vector<double > *arg3 = 0 ;
  
  arg1 = (std::vector<double > *)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (std::vector<double > *)jarg3;
  if(!arg3) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "std::vector<double > const & type is null", 0);
    return ;
  } 
  {
    try {
      try {
        std_vector_Sl_double_Sg__InsertRange(arg1,arg2,(std::vector<double > const &)*arg3);
      }
      catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return ;
      }
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_DoubleVector_RemoveAt(void * jarg1, int jarg2) {
  std::vector<double > *arg1 = (std::vector<double > *) 0 ;
  int arg2 ;
  
  arg1 = (std::vector<double > *)jarg1; 
  arg2 = (int)jarg2; 
  {
    try {
      try {
        std_vector_Sl_double_Sg__RemoveAt(arg1,arg2);
      }
      catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return ;
      }
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_DoubleVector_RemoveRange(void * jarg1, int jarg2, int jarg3) {
  std::vector<double > *arg1 = (std::vector<double > *) 0 ;
  int arg2 ;
  int arg3 ;
  
  arg1 = (std::vector<double > *)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  {
    try {
      try {
        std_vector_Sl_double_Sg__RemoveRange(arg1,arg2,arg3);
      }
      catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return ;
      }
      catch(std::invalid_argument &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentException, (&_e)->what(), "");
        return ;
      }
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_DoubleVector_Repeat(double jarg1, int jarg2) {
  void * jresult ;
  std::vector<double >::value_type *arg1 = 0 ;
  int arg2 ;
  std::vector<double > *result = 0 ;
  std::vector<double >::value_type temp1 ;
  
  temp1 = (std::vector<double >::value_type)jarg1; 
  arg1 = &temp1; 
  arg2 = (int)jarg2; 
  {
    try {
      try {
        result = (std::vector<double > *)std_vector_Sl_double_Sg__Repeat((double const &)*arg1,arg2);
      }
      catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return 0;
      }
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_DoubleVector_Reverse__SWIG_0(void * jarg1) {
  std::vector<double > *arg1 = (std::vector<double > *) 0 ;
  
  arg1 = (std::vector<double > *)jarg1; 
  {
    try {
      std_vector_Sl_double_Sg__Reverse__SWIG_0(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_DoubleVector_Reverse__SWIG_1(void * jarg1, int jarg2, int jarg3) {
  std::vector<double > *arg1 = (std::vector<double > *) 0 ;
  int arg2 ;
  int arg3 ;
  
  arg1 = (std::vector<double > *)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  {
    try {
      try {
        std_vector_Sl_double_Sg__Reverse__SWIG_1(arg1,arg2,arg3);
      }
      catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return ;
      }
      catch(std::invalid_argument &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentException, (&_e)->what(), "");
        return ;
      }
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_DoubleVector_SetRange(void * jarg1, int jarg2, void * jarg3) {
  std::vector<double > *arg1 = (std::vector<double > *) 0 ;
  int arg2 ;
  std::vector<double > *arg3 = 0 ;
  
  arg1 = (std::vector<double > *)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (std::vector<double > *)jarg3;
  if(!arg3) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "std::vector<double > const & type is null", 0);
    return ;
  } 
  {
    try {
      try {
        std_vector_Sl_double_Sg__SetRange(arg1,arg2,(std::vector<double > const &)*arg3);
      }
      catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return ;
      }
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT unsigned int SWIGSTDCALL CSharp_DoubleVector_Contains(void * jarg1, double jarg2) {
  unsigned int jresult ;
  std::vector<double > *arg1 = (std::vector<double > *) 0 ;
  std::vector<double >::value_type *arg2 = 0 ;
  bool result;
  std::vector<double >::value_type temp2 ;
  
  arg1 = (std::vector<double > *)jarg1; 
  temp2 = (std::vector<double >::value_type)jarg2; 
  arg2 = &temp2; 
  {
    try {
      result = (bool)std_vector_Sl_double_Sg__Contains(arg1,(double const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT int SWIGSTDCALL CSharp_DoubleVector_IndexOf(void * jarg1, double jarg2) {
  int jresult ;
  std::vector<double > *arg1 = (std::vector<double > *) 0 ;
  std::vector<double >::value_type *arg2 = 0 ;
  int result;
  std::vector<double >::value_type temp2 ;
  
  arg1 = (std::vector<double > *)jarg1; 
  temp2 = (std::vector<double >::value_type)jarg2; 
  arg2 = &temp2; 
  {
    try {
      result = (int)std_vector_Sl_double_Sg__IndexOf(arg1,(double const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT int SWIGSTDCALL CSharp_DoubleVector_LastIndexOf(void * jarg1, double jarg2) {
  int jresult ;
  std::vector<double > *arg1 = (std::vector<double > *) 0 ;
  std::vector<double >::value_type *arg2 = 0 ;
  int result;
  std::vector<double >::value_type temp2 ;
  
  arg1 = (std::vector<double > *)jarg1; 
  temp2 = (std::vector<double >::value_type)jarg2; 
  arg2 = &temp2; 
  {
    try {
      result = (int)std_vector_Sl_double_Sg__LastIndexOf(arg1,(double const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_DoubleVector_Remove(void * jarg1, double jarg2) {
  std::vector<double > *arg1 = (std::vector<double > *) 0 ;
  std::vector<double >::value_type *arg2 = 0 ;
  std::vector<double >::value_type temp2 ;
  
  arg1 = (std::vector<double > *)jarg1; 
  temp2 = (std::vector<double >::value_type)jarg2; 
  arg2 = &temp2; 
  {
    try {
      std_vector_Sl_double_Sg__Remove(arg1,(double const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_DoubleVector(void * jarg1) {
  std::vector<double > *arg1 = (std::vector<double > *) 0 ;
  
  arg1 = (std::vector<double > *)jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_StrVector_Clear(void * jarg1) {
  std::vector<std::string > *arg1 = (std::vector<std::string > *) 0 ;
  
  arg1 = (std::vector<std::string > *)jarg1; 
  {
    try {
      (arg1)->clear();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_StrVector_Add(void * jarg1, char * jarg2) {
  std::vector<std::string > *arg1 = (std::vector<std::string > *) 0 ;
  std::vector<std::string >::value_type *arg2 = 0 ;
  
  arg1 = (std::vector<std::string > *)jarg1; 
  if (!jarg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "null string", 0);
    return ;
  }
  std::string arg2_str(jarg2);
  arg2 = &arg2_str; 
  {
    try {
      (arg1)->push_back((std::vector<std::string >::value_type const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT unsigned long SWIGSTDCALL CSharp_StrVector_size(void * jarg1) {
  unsigned long jresult ;
  std::vector<std::string > *arg1 = (std::vector<std::string > *) 0 ;
  std::vector<std::string >::size_type result;
  
  arg1 = (std::vector<std::string > *)jarg1; 
  {
    try {
      result = ((std::vector<std::string > const *)arg1)->size();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT unsigned long SWIGSTDCALL CSharp_StrVector_capacity(void * jarg1) {
  unsigned long jresult ;
  std::vector<std::string > *arg1 = (std::vector<std::string > *) 0 ;
  std::vector<std::string >::size_type result;
  
  arg1 = (std::vector<std::string > *)jarg1; 
  {
    try {
      result = ((std::vector<std::string > const *)arg1)->capacity();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_StrVector_reserve(void * jarg1, unsigned long jarg2) {
  std::vector<std::string > *arg1 = (std::vector<std::string > *) 0 ;
  std::vector<std::string >::size_type arg2 ;
  
  arg1 = (std::vector<std::string > *)jarg1; 
  arg2 = (std::vector<std::string >::size_type)jarg2; 
  {
    try {
      (arg1)->reserve(arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_StrVector__SWIG_0() {
  void * jresult ;
  std::vector<std::string > *result = 0 ;
  
  {
    try {
      result = (std::vector<std::string > *)new std::vector<std::string >();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_StrVector__SWIG_1(int jarg1) {
  void * jresult ;
  int arg1 ;
  std::vector<std::string > *result = 0 ;
  
  arg1 = (int)jarg1; 
  {
    try {
      try {
        result = (std::vector<std::string > *)new_std_vector_Sl_std_string_Sg___SWIG_1(arg1);
      }
      catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return 0;
      }
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT char * SWIGSTDCALL CSharp_StrVector_getitemcopy(void * jarg1, int jarg2) {
  char * jresult ;
  std::vector<std::string > *arg1 = (std::vector<std::string > *) 0 ;
  int arg2 ;
  std::string result;
  
  arg1 = (std::vector<std::string > *)jarg1; 
  arg2 = (int)jarg2; 
  {
    try {
      try {
        result = std_vector_Sl_std_string_Sg__getitemcopy(arg1,arg2);
      }
      catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return 0;
      }
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = SWIG_csharp_string_callback((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT char * SWIGSTDCALL CSharp_StrVector_getitem(void * jarg1, int jarg2) {
  char * jresult ;
  std::vector<std::string > *arg1 = (std::vector<std::string > *) 0 ;
  int arg2 ;
  std::vector<std::string >::value_type *result = 0 ;
  
  arg1 = (std::vector<std::string > *)jarg1; 
  arg2 = (int)jarg2; 
  {
    try {
      try {
        {
          std::vector<std::string >::const_reference _result_ref = std_vector_Sl_std_string_Sg__getitem(arg1,arg2);
          result = (std::vector<std::string >::value_type *) &_result_ref;
        }
      }
      catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return 0;
      }
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = SWIG_csharp_string_callback(result->c_str()); 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_StrVector_setitem(void * jarg1, int jarg2, char * jarg3) {
  std::vector<std::string > *arg1 = (std::vector<std::string > *) 0 ;
  int arg2 ;
  std::vector<std::string >::value_type *arg3 = 0 ;
  
  arg1 = (std::vector<std::string > *)jarg1; 
  arg2 = (int)jarg2; 
  if (!jarg3) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "null string", 0);
    return ;
  }
  std::string arg3_str(jarg3);
  arg3 = &arg3_str; 
  {
    try {
      try {
        std_vector_Sl_std_string_Sg__setitem(arg1,arg2,(std::string const &)*arg3);
      }
      catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return ;
      }
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_StrVector_AddRange(void * jarg1, void * jarg2) {
  std::vector<std::string > *arg1 = (std::vector<std::string > *) 0 ;
  std::vector<std::string > *arg2 = 0 ;
  
  arg1 = (std::vector<std::string > *)jarg1; 
  arg2 = (std::vector<std::string > *)jarg2;
  if(!arg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "std::vector<std::string > const & type is null", 0);
    return ;
  } 
  {
    try {
      std_vector_Sl_std_string_Sg__AddRange(arg1,(std::vector<std::string > const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_StrVector_GetRange(void * jarg1, int jarg2, int jarg3) {
  void * jresult ;
  std::vector<std::string > *arg1 = (std::vector<std::string > *) 0 ;
  int arg2 ;
  int arg3 ;
  std::vector<std::string > *result = 0 ;
  
  arg1 = (std::vector<std::string > *)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  {
    try {
      try {
        result = (std::vector<std::string > *)std_vector_Sl_std_string_Sg__GetRange(arg1,arg2,arg3);
      }
      catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return 0;
      }
      catch(std::invalid_argument &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentException, (&_e)->what(), "");
        return 0;
      }
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_StrVector_Insert(void * jarg1, int jarg2, char * jarg3) {
  std::vector<std::string > *arg1 = (std::vector<std::string > *) 0 ;
  int arg2 ;
  std::vector<std::string >::value_type *arg3 = 0 ;
  
  arg1 = (std::vector<std::string > *)jarg1; 
  arg2 = (int)jarg2; 
  if (!jarg3) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "null string", 0);
    return ;
  }
  std::string arg3_str(jarg3);
  arg3 = &arg3_str; 
  {
    try {
      try {
        std_vector_Sl_std_string_Sg__Insert(arg1,arg2,(std::string const &)*arg3);
      }
      catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return ;
      }
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_StrVector_InsertRange(void * jarg1, int jarg2, void * jarg3) {
  std::vector<std::string > *arg1 = (std::vector<std::string > *) 0 ;
  int arg2 ;
  std::vector<std::string > *arg3 = 0 ;
  
  arg1 = (std::vector<std::string > *)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (std::vector<std::string > *)jarg3;
  if(!arg3) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "std::vector<std::string > const & type is null", 0);
    return ;
  } 
  {
    try {
      try {
        std_vector_Sl_std_string_Sg__InsertRange(arg1,arg2,(std::vector<std::string > const &)*arg3);
      }
      catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return ;
      }
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_StrVector_RemoveAt(void * jarg1, int jarg2) {
  std::vector<std::string > *arg1 = (std::vector<std::string > *) 0 ;
  int arg2 ;
  
  arg1 = (std::vector<std::string > *)jarg1; 
  arg2 = (int)jarg2; 
  {
    try {
      try {
        std_vector_Sl_std_string_Sg__RemoveAt(arg1,arg2);
      }
      catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return ;
      }
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_StrVector_RemoveRange(void * jarg1, int jarg2, int jarg3) {
  std::vector<std::string > *arg1 = (std::vector<std::string > *) 0 ;
  int arg2 ;
  int arg3 ;
  
  arg1 = (std::vector<std::string > *)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  {
    try {
      try {
        std_vector_Sl_std_string_Sg__RemoveRange(arg1,arg2,arg3);
      }
      catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return ;
      }
      catch(std::invalid_argument &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentException, (&_e)->what(), "");
        return ;
      }
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_StrVector_Repeat(char * jarg1, int jarg2) {
  void * jresult ;
  std::vector<std::string >::value_type *arg1 = 0 ;
  int arg2 ;
  std::vector<std::string > *result = 0 ;
  
  if (!jarg1) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "null string", 0);
    return 0;
  }
  std::string arg1_str(jarg1);
  arg1 = &arg1_str; 
  arg2 = (int)jarg2; 
  {
    try {
      try {
        result = (std::vector<std::string > *)std_vector_Sl_std_string_Sg__Repeat((std::string const &)*arg1,arg2);
      }
      catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return 0;
      }
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_StrVector_Reverse__SWIG_0(void * jarg1) {
  std::vector<std::string > *arg1 = (std::vector<std::string > *) 0 ;
  
  arg1 = (std::vector<std::string > *)jarg1; 
  {
    try {
      std_vector_Sl_std_string_Sg__Reverse__SWIG_0(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_StrVector_Reverse__SWIG_1(void * jarg1, int jarg2, int jarg3) {
  std::vector<std::string > *arg1 = (std::vector<std::string > *) 0 ;
  int arg2 ;
  int arg3 ;
  
  arg1 = (std::vector<std::string > *)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  {
    try {
      try {
        std_vector_Sl_std_string_Sg__Reverse__SWIG_1(arg1,arg2,arg3);
      }
      catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return ;
      }
      catch(std::invalid_argument &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentException, (&_e)->what(), "");
        return ;
      }
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_StrVector_SetRange(void * jarg1, int jarg2, void * jarg3) {
  std::vector<std::string > *arg1 = (std::vector<std::string > *) 0 ;
  int arg2 ;
  std::vector<std::string > *arg3 = 0 ;
  
  arg1 = (std::vector<std::string > *)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (std::vector<std::string > *)jarg3;
  if(!arg3) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "std::vector<std::string > const & type is null", 0);
    return ;
  } 
  {
    try {
      try {
        std_vector_Sl_std_string_Sg__SetRange(arg1,arg2,(std::vector<std::string > const &)*arg3);
      }
      catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return ;
      }
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT unsigned int SWIGSTDCALL CSharp_StrVector_Contains(void * jarg1, char * jarg2) {
  unsigned int jresult ;
  std::vector<std::string > *arg1 = (std::vector<std::string > *) 0 ;
  std::vector<std::string >::value_type *arg2 = 0 ;
  bool result;
  
  arg1 = (std::vector<std::string > *)jarg1; 
  if (!jarg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "null string", 0);
    return 0;
  }
  std::string arg2_str(jarg2);
  arg2 = &arg2_str; 
  {
    try {
      result = (bool)std_vector_Sl_std_string_Sg__Contains(arg1,(std::string const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT int SWIGSTDCALL CSharp_StrVector_IndexOf(void * jarg1, char * jarg2) {
  int jresult ;
  std::vector<std::string > *arg1 = (std::vector<std::string > *) 0 ;
  std::vector<std::string >::value_type *arg2 = 0 ;
  int result;
  
  arg1 = (std::vector<std::string > *)jarg1; 
  if (!jarg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "null string", 0);
    return 0;
  }
  std::string arg2_str(jarg2);
  arg2 = &arg2_str; 
  {
    try {
      result = (int)std_vector_Sl_std_string_Sg__IndexOf(arg1,(std::string const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT int SWIGSTDCALL CSharp_StrVector_LastIndexOf(void * jarg1, char * jarg2) {
  int jresult ;
  std::vector<std::string > *arg1 = (std::vector<std::string > *) 0 ;
  std::vector<std::string >::value_type *arg2 = 0 ;
  int result;
  
  arg1 = (std::vector<std::string > *)jarg1; 
  if (!jarg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "null string", 0);
    return 0;
  }
  std::string arg2_str(jarg2);
  arg2 = &arg2_str; 
  {
    try {
      result = (int)std_vector_Sl_std_string_Sg__LastIndexOf(arg1,(std::string const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_StrVector_Remove(void * jarg1, char * jarg2) {
  std::vector<std::string > *arg1 = (std::vector<std::string > *) 0 ;
  std::vector<std::string >::value_type *arg2 = 0 ;
  
  arg1 = (std::vector<std::string > *)jarg1; 
  if (!jarg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "null string", 0);
    return ;
  }
  std::string arg2_str(jarg2);
  arg2 = &arg2_str; 
  {
    try {
      std_vector_Sl_std_string_Sg__Remove(arg1,(std::string const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_StrVector(void * jarg1) {
  std::vector<std::string > *arg1 = (std::vector<std::string > *) 0 ;
  
  arg1 = (std::vector<std::string > *)jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_NodePair__SWIG_0() {
  void * jresult ;
  std::pair<Date,double > *result = 0 ;
  
  {
    try {
      result = (std::pair<Date,double > *)new std::pair<Date,double >();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_NodePair__SWIG_1(void * jarg1, double jarg2) {
  void * jresult ;
  Date arg1 ;
  double arg2 ;
  std::pair<Date,double > *result = 0 ;
  Date *argp1 ;
  
  argp1 = (Date *)jarg1; 
  if (!argp1) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Attempt to dereference null Date", 0);
    return 0;
  }
  arg1 = *argp1; 
  arg2 = (double)jarg2; 
  {
    try {
      result = (std::pair<Date,double > *)new std::pair<Date,double >(arg1,arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_NodePair__SWIG_2(void * jarg1) {
  void * jresult ;
  std::pair<Date,double > *arg1 = 0 ;
  std::pair<Date,double > *result = 0 ;
  
  arg1 = (std::pair<Date,double > *)jarg1;
  if(!arg1) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "std::pair<Date,double > const & type is null", 0);
    return 0;
  } 
  {
    try {
      result = (std::pair<Date,double > *)new std::pair<Date,double >((std::pair<Date,double > const &)*arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_NodePair_first_set(void * jarg1, void * jarg2) {
  std::pair<Date,double > *arg1 = (std::pair<Date,double > *) 0 ;
  Date *arg2 = (Date *) 0 ;
  
  arg1 = (std::pair<Date,double > *)jarg1; 
  arg2 = (Date *)jarg2; 
  if (arg1) (arg1)->first = *arg2;
  
}


SWIGEXPORT void * SWIGSTDCALL CSharp_NodePair_first_get(void * jarg1) {
  void * jresult ;
  std::pair<Date,double > *arg1 = (std::pair<Date,double > *) 0 ;
  Date *result = 0 ;
  
  arg1 = (std::pair<Date,double > *)jarg1; 
  result = (Date *)& ((arg1)->first);
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_NodePair_second_set(void * jarg1, double jarg2) {
  std::pair<Date,double > *arg1 = (std::pair<Date,double > *) 0 ;
  double arg2 ;
  
  arg1 = (std::pair<Date,double > *)jarg1; 
  arg2 = (double)jarg2; 
  if (arg1) (arg1)->second = arg2;
  
}


SWIGEXPORT double SWIGSTDCALL CSharp_NodePair_second_get(void * jarg1) {
  double jresult ;
  std::pair<Date,double > *arg1 = (std::pair<Date,double > *) 0 ;
  double result;
  
  arg1 = (std::pair<Date,double > *)jarg1; 
  result = (double) ((arg1)->second);
  jresult = result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_NodePair(void * jarg1) {
  std::pair<Date,double > *arg1 = (std::pair<Date,double > *) 0 ;
  
  arg1 = (std::pair<Date,double > *)jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_NodeVector_Clear(void * jarg1) {
  std::vector<std::pair<Date,double > > *arg1 = (std::vector<std::pair<Date,double > > *) 0 ;
  
  arg1 = (std::vector<std::pair<Date,double > > *)jarg1; 
  {
    try {
      (arg1)->clear();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_NodeVector_Add(void * jarg1, void * jarg2) {
  std::vector<std::pair<Date,double > > *arg1 = (std::vector<std::pair<Date,double > > *) 0 ;
  std::vector<std::pair<Date,double > >::value_type *arg2 = 0 ;
  
  arg1 = (std::vector<std::pair<Date,double > > *)jarg1; 
  arg2 = (std::vector<std::pair<Date,double > >::value_type *)jarg2;
  if(!arg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "std::vector<std::pair<Date,double > >::value_type const & type is null", 0);
    return ;
  } 
  {
    try {
      (arg1)->push_back((std::vector<std::pair<Date,double > >::value_type const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT unsigned long SWIGSTDCALL CSharp_NodeVector_size(void * jarg1) {
  unsigned long jresult ;
  std::vector<std::pair<Date,double > > *arg1 = (std::vector<std::pair<Date,double > > *) 0 ;
  std::vector<std::pair<Date,double > >::size_type result;
  
  arg1 = (std::vector<std::pair<Date,double > > *)jarg1; 
  {
    try {
      result = ((std::vector<std::pair<Date,double > > const *)arg1)->size();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT unsigned long SWIGSTDCALL CSharp_NodeVector_capacity(void * jarg1) {
  unsigned long jresult ;
  std::vector<std::pair<Date,double > > *arg1 = (std::vector<std::pair<Date,double > > *) 0 ;
  std::vector<std::pair<Date,double > >::size_type result;
  
  arg1 = (std::vector<std::pair<Date,double > > *)jarg1; 
  {
    try {
      result = ((std::vector<std::pair<Date,double > > const *)arg1)->capacity();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_NodeVector_reserve(void * jarg1, unsigned long jarg2) {
  std::vector<std::pair<Date,double > > *arg1 = (std::vector<std::pair<Date,double > > *) 0 ;
  std::vector<std::pair<Date,double > >::size_type arg2 ;
  
  arg1 = (std::vector<std::pair<Date,double > > *)jarg1; 
  arg2 = (std::vector<std::pair<Date,double > >::size_type)jarg2; 
  {
    try {
      (arg1)->reserve(arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_NodeVector__SWIG_0() {
  void * jresult ;
  std::vector<std::pair<Date,double > > *result = 0 ;
  
  {
    try {
      result = (std::vector<std::pair<Date,double > > *)new std::vector<std::pair<Date,double > >();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_NodeVector__SWIG_1(int jarg1) {
  void * jresult ;
  int arg1 ;
  std::vector<std::pair<Date,double > > *result = 0 ;
  
  arg1 = (int)jarg1; 
  {
    try {
      try {
        result = (std::vector<std::pair<Date,double > > *)new_std_vector_Sl_std_pair_Sl_Date_Sc_double_Sg__Sg___SWIG_1(arg1);
      }
      catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return 0;
      }
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_NodeVector_getitemcopy(void * jarg1, int jarg2) {
  void * jresult ;
  std::vector<std::pair<Date,double > > *arg1 = (std::vector<std::pair<Date,double > > *) 0 ;
  int arg2 ;
  std::pair<Date,double > result;
  
  arg1 = (std::vector<std::pair<Date,double > > *)jarg1; 
  arg2 = (int)jarg2; 
  {
    try {
      try {
        result = std_vector_Sl_std_pair_Sl_Date_Sc_double_Sg__Sg__getitemcopy(arg1,arg2);
      }
      catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return 0;
      }
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = new std::pair<Date,double >((std::pair<Date,double > &)result); 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_NodeVector_getitem(void * jarg1, int jarg2) {
  void * jresult ;
  std::vector<std::pair<Date,double > > *arg1 = (std::vector<std::pair<Date,double > > *) 0 ;
  int arg2 ;
  std::vector<std::pair<Date,double > >::value_type *result = 0 ;
  
  arg1 = (std::vector<std::pair<Date,double > > *)jarg1; 
  arg2 = (int)jarg2; 
  {
    try {
      try {
        {
          std::vector<std::pair<Date,double > >::const_reference _result_ref = std_vector_Sl_std_pair_Sl_Date_Sc_double_Sg__Sg__getitem(arg1,arg2);
          result = (std::vector<std::pair<Date,double > >::value_type *) &_result_ref;
        }
      }
      catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return 0;
      }
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_NodeVector_setitem(void * jarg1, int jarg2, void * jarg3) {
  std::vector<std::pair<Date,double > > *arg1 = (std::vector<std::pair<Date,double > > *) 0 ;
  int arg2 ;
  std::vector<std::pair<Date,double > >::value_type *arg3 = 0 ;
  
  arg1 = (std::vector<std::pair<Date,double > > *)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (std::vector<std::pair<Date,double > >::value_type *)jarg3;
  if(!arg3) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "std::vector<std::pair<Date,double > >::value_type const & type is null", 0);
    return ;
  } 
  {
    try {
      try {
        std_vector_Sl_std_pair_Sl_Date_Sc_double_Sg__Sg__setitem(arg1,arg2,(std::pair<Date,double > const &)*arg3);
      }
      catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return ;
      }
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_NodeVector_AddRange(void * jarg1, void * jarg2) {
  std::vector<std::pair<Date,double > > *arg1 = (std::vector<std::pair<Date,double > > *) 0 ;
  std::vector<std::pair<Date,double > > *arg2 = 0 ;
  
  arg1 = (std::vector<std::pair<Date,double > > *)jarg1; 
  arg2 = (std::vector<std::pair<Date,double > > *)jarg2;
  if(!arg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "std::vector<std::pair<Date,double > > const & type is null", 0);
    return ;
  } 
  {
    try {
      std_vector_Sl_std_pair_Sl_Date_Sc_double_Sg__Sg__AddRange(arg1,(std::vector<std::pair<Date,double > > const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_NodeVector_GetRange(void * jarg1, int jarg2, int jarg3) {
  void * jresult ;
  std::vector<std::pair<Date,double > > *arg1 = (std::vector<std::pair<Date,double > > *) 0 ;
  int arg2 ;
  int arg3 ;
  std::vector<std::pair<Date,double > > *result = 0 ;
  
  arg1 = (std::vector<std::pair<Date,double > > *)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  {
    try {
      try {
        result = (std::vector<std::pair<Date,double > > *)std_vector_Sl_std_pair_Sl_Date_Sc_double_Sg__Sg__GetRange(arg1,arg2,arg3);
      }
      catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return 0;
      }
      catch(std::invalid_argument &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentException, (&_e)->what(), "");
        return 0;
      }
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_NodeVector_Insert(void * jarg1, int jarg2, void * jarg3) {
  std::vector<std::pair<Date,double > > *arg1 = (std::vector<std::pair<Date,double > > *) 0 ;
  int arg2 ;
  std::vector<std::pair<Date,double > >::value_type *arg3 = 0 ;
  
  arg1 = (std::vector<std::pair<Date,double > > *)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (std::vector<std::pair<Date,double > >::value_type *)jarg3;
  if(!arg3) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "std::vector<std::pair<Date,double > >::value_type const & type is null", 0);
    return ;
  } 
  {
    try {
      try {
        std_vector_Sl_std_pair_Sl_Date_Sc_double_Sg__Sg__Insert(arg1,arg2,(std::pair<Date,double > const &)*arg3);
      }
      catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return ;
      }
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_NodeVector_InsertRange(void * jarg1, int jarg2, void * jarg3) {
  std::vector<std::pair<Date,double > > *arg1 = (std::vector<std::pair<Date,double > > *) 0 ;
  int arg2 ;
  std::vector<std::pair<Date,double > > *arg3 = 0 ;
  
  arg1 = (std::vector<std::pair<Date,double > > *)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (std::vector<std::pair<Date,double > > *)jarg3;
  if(!arg3) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "std::vector<std::pair<Date,double > > const & type is null", 0);
    return ;
  } 
  {
    try {
      try {
        std_vector_Sl_std_pair_Sl_Date_Sc_double_Sg__Sg__InsertRange(arg1,arg2,(std::vector<std::pair<Date,double > > const &)*arg3);
      }
      catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return ;
      }
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_NodeVector_RemoveAt(void * jarg1, int jarg2) {
  std::vector<std::pair<Date,double > > *arg1 = (std::vector<std::pair<Date,double > > *) 0 ;
  int arg2 ;
  
  arg1 = (std::vector<std::pair<Date,double > > *)jarg1; 
  arg2 = (int)jarg2; 
  {
    try {
      try {
        std_vector_Sl_std_pair_Sl_Date_Sc_double_Sg__Sg__RemoveAt(arg1,arg2);
      }
      catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return ;
      }
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_NodeVector_RemoveRange(void * jarg1, int jarg2, int jarg3) {
  std::vector<std::pair<Date,double > > *arg1 = (std::vector<std::pair<Date,double > > *) 0 ;
  int arg2 ;
  int arg3 ;
  
  arg1 = (std::vector<std::pair<Date,double > > *)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  {
    try {
      try {
        std_vector_Sl_std_pair_Sl_Date_Sc_double_Sg__Sg__RemoveRange(arg1,arg2,arg3);
      }
      catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return ;
      }
      catch(std::invalid_argument &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentException, (&_e)->what(), "");
        return ;
      }
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_NodeVector_Repeat(void * jarg1, int jarg2) {
  void * jresult ;
  std::vector<std::pair<Date,double > >::value_type *arg1 = 0 ;
  int arg2 ;
  std::vector<std::pair<Date,double > > *result = 0 ;
  
  arg1 = (std::vector<std::pair<Date,double > >::value_type *)jarg1;
  if(!arg1) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "std::vector<std::pair<Date,double > >::value_type const & type is null", 0);
    return 0;
  } 
  arg2 = (int)jarg2; 
  {
    try {
      try {
        result = (std::vector<std::pair<Date,double > > *)std_vector_Sl_std_pair_Sl_Date_Sc_double_Sg__Sg__Repeat((std::pair<Date,double > const &)*arg1,arg2);
      }
      catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return 0;
      }
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_NodeVector_Reverse__SWIG_0(void * jarg1) {
  std::vector<std::pair<Date,double > > *arg1 = (std::vector<std::pair<Date,double > > *) 0 ;
  
  arg1 = (std::vector<std::pair<Date,double > > *)jarg1; 
  {
    try {
      std_vector_Sl_std_pair_Sl_Date_Sc_double_Sg__Sg__Reverse__SWIG_0(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_NodeVector_Reverse__SWIG_1(void * jarg1, int jarg2, int jarg3) {
  std::vector<std::pair<Date,double > > *arg1 = (std::vector<std::pair<Date,double > > *) 0 ;
  int arg2 ;
  int arg3 ;
  
  arg1 = (std::vector<std::pair<Date,double > > *)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  {
    try {
      try {
        std_vector_Sl_std_pair_Sl_Date_Sc_double_Sg__Sg__Reverse__SWIG_1(arg1,arg2,arg3);
      }
      catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return ;
      }
      catch(std::invalid_argument &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentException, (&_e)->what(), "");
        return ;
      }
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_NodeVector_SetRange(void * jarg1, int jarg2, void * jarg3) {
  std::vector<std::pair<Date,double > > *arg1 = (std::vector<std::pair<Date,double > > *) 0 ;
  int arg2 ;
  std::vector<std::pair<Date,double > > *arg3 = 0 ;
  
  arg1 = (std::vector<std::pair<Date,double > > *)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (std::vector<std::pair<Date,double > > *)jarg3;
  if(!arg3) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "std::vector<std::pair<Date,double > > const & type is null", 0);
    return ;
  } 
  {
    try {
      try {
        std_vector_Sl_std_pair_Sl_Date_Sc_double_Sg__Sg__SetRange(arg1,arg2,(std::vector<std::pair<Date,double > > const &)*arg3);
      }
      catch(std::out_of_range &_e) {
        SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, 0, (&_e)->what());
        return ;
      }
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT unsigned int SWIGSTDCALL CSharp_NodeVector_Contains(void * jarg1, void * jarg2) {
  unsigned int jresult ;
  std::vector<std::pair<Date,double > > *arg1 = (std::vector<std::pair<Date,double > > *) 0 ;
  std::vector<std::pair<Date,double > >::value_type *arg2 = 0 ;
  bool result;
  
  arg1 = (std::vector<std::pair<Date,double > > *)jarg1; 
  arg2 = (std::vector<std::pair<Date,double > >::value_type *)jarg2;
  if(!arg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "std::vector<std::pair<Date,double > >::value_type const & type is null", 0);
    return 0;
  } 
  {
    try {
      result = (bool)std_vector_Sl_std_pair_Sl_Date_Sc_double_Sg__Sg__Contains(arg1,(std::pair<Date,double > const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT int SWIGSTDCALL CSharp_NodeVector_IndexOf(void * jarg1, void * jarg2) {
  int jresult ;
  std::vector<std::pair<Date,double > > *arg1 = (std::vector<std::pair<Date,double > > *) 0 ;
  std::vector<std::pair<Date,double > >::value_type *arg2 = 0 ;
  int result;
  
  arg1 = (std::vector<std::pair<Date,double > > *)jarg1; 
  arg2 = (std::vector<std::pair<Date,double > >::value_type *)jarg2;
  if(!arg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "std::vector<std::pair<Date,double > >::value_type const & type is null", 0);
    return 0;
  } 
  {
    try {
      result = (int)std_vector_Sl_std_pair_Sl_Date_Sc_double_Sg__Sg__IndexOf(arg1,(std::pair<Date,double > const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT int SWIGSTDCALL CSharp_NodeVector_LastIndexOf(void * jarg1, void * jarg2) {
  int jresult ;
  std::vector<std::pair<Date,double > > *arg1 = (std::vector<std::pair<Date,double > > *) 0 ;
  std::vector<std::pair<Date,double > >::value_type *arg2 = 0 ;
  int result;
  
  arg1 = (std::vector<std::pair<Date,double > > *)jarg1; 
  arg2 = (std::vector<std::pair<Date,double > >::value_type *)jarg2;
  if(!arg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "std::vector<std::pair<Date,double > >::value_type const & type is null", 0);
    return 0;
  } 
  {
    try {
      result = (int)std_vector_Sl_std_pair_Sl_Date_Sc_double_Sg__Sg__LastIndexOf(arg1,(std::pair<Date,double > const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_NodeVector_Remove(void * jarg1, void * jarg2) {
  std::vector<std::pair<Date,double > > *arg1 = (std::vector<std::pair<Date,double > > *) 0 ;
  std::vector<std::pair<Date,double > >::value_type *arg2 = 0 ;
  
  arg1 = (std::vector<std::pair<Date,double > > *)jarg1; 
  arg2 = (std::vector<std::pair<Date,double > >::value_type *)jarg2;
  if(!arg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "std::vector<std::pair<Date,double > >::value_type const & type is null", 0);
    return ;
  } 
  {
    try {
      std_vector_Sl_std_pair_Sl_Date_Sc_double_Sg__Sg__Remove(arg1,(std::pair<Date,double > const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_NodeVector(void * jarg1) {
  std::vector<std::pair<Date,double > > *arg1 = (std::vector<std::pair<Date,double > > *) 0 ;
  
  arg1 = (std::vector<std::pair<Date,double > > *)jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_HistoryEntry(void * jarg1) {
  HistoryEntry *arg1 = (HistoryEntry *) 0 ;
  
  arg1 = (HistoryEntry *)jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_History(void * jarg1, void * jarg2) {
  void * jresult ;
  std::vector<Date > *arg1 = 0 ;
  std::vector<Real > *arg2 = 0 ;
  History *result = 0 ;
  
  arg1 = (std::vector<Date > *)jarg1;
  if(!arg1) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "std::vector<Date > const & type is null", 0);
    return 0;
  } 
  arg2 = (std::vector<Real > *)jarg2;
  if(!arg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "std::vector<Real > const & type is null", 0);
    return 0;
  } 
  {
    try {
      result = (History *)new History((std::vector<Date > const &)*arg1,(std::vector<Real > const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_History_firstDate(void * jarg1) {
  void * jresult ;
  History *arg1 = (History *) 0 ;
  Date result;
  
  arg1 = (History *)jarg1; 
  {
    try {
      result = ((History const *)arg1)->firstDate();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = new Date((Date &)result); 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_History_lastDate(void * jarg1) {
  void * jresult ;
  History *arg1 = (History *) 0 ;
  Date result;
  
  arg1 = (History *)jarg1; 
  {
    try {
      result = ((History const *)arg1)->lastDate();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = new Date((Date &)result); 
  return jresult;
}


SWIGEXPORT unsigned long SWIGSTDCALL CSharp_History___len__(void * jarg1) {
  unsigned long jresult ;
  History *arg1 = (History *) 0 ;
  Size result;
  
  arg1 = (History *)jarg1; 
  {
    try {
      result = History___len__(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_History(void * jarg1) {
  History *arg1 = (History *) 0 ;
  
  arg1 = (History *)jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_IndexManager_instance() {
  void * jresult ;
  IndexManager *result = 0 ;
  
  {
    try {
      {
        IndexManager &_result_ref = IndexManager::instance();
        result = (IndexManager *) &_result_ref;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_IndexManager_setHistory(void * jarg1, char * jarg2, void * jarg3) {
  IndexManager *arg1 = (IndexManager *) 0 ;
  std::string *arg2 = 0 ;
  TimeSeries<Real > *arg3 = 0 ;
  
  arg1 = (IndexManager *)jarg1; 
  if (!jarg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "null string", 0);
    return ;
  }
  std::string arg2_str(jarg2);
  arg2 = &arg2_str; 
  arg3 = (TimeSeries<Real > *)jarg3;
  if(!arg3) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "TimeSeries<Real > const & type is null", 0);
    return ;
  } 
  {
    try {
      (arg1)->setHistory((std::string const &)*arg2,(TimeSeries<Real > const &)*arg3);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_IndexManager_getHistory(void * jarg1, char * jarg2) {
  void * jresult ;
  IndexManager *arg1 = (IndexManager *) 0 ;
  std::string *arg2 = 0 ;
  TimeSeries<Real > *result = 0 ;
  
  arg1 = (IndexManager *)jarg1; 
  if (!jarg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "null string", 0);
    return 0;
  }
  std::string arg2_str(jarg2);
  arg2 = &arg2_str; 
  {
    try {
      {
        TimeSeries<Real > const &_result_ref = ((IndexManager const *)arg1)->getHistory((std::string const &)*arg2);
        result = (TimeSeries<Real > *) &_result_ref;
      }
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT unsigned int SWIGSTDCALL CSharp_IndexManager_hasHistory(void * jarg1, char * jarg2) {
  unsigned int jresult ;
  IndexManager *arg1 = (IndexManager *) 0 ;
  std::string *arg2 = 0 ;
  bool result;
  
  arg1 = (IndexManager *)jarg1; 
  if (!jarg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "null string", 0);
    return 0;
  }
  std::string arg2_str(jarg2);
  arg2 = &arg2_str; 
  {
    try {
      result = (bool)((IndexManager const *)arg1)->hasHistory((std::string const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_IndexManager_histories(void * jarg1) {
  void * jresult ;
  IndexManager *arg1 = (IndexManager *) 0 ;
  std::vector<std::string > result;
  
  arg1 = (IndexManager *)jarg1; 
  {
    try {
      result = ((IndexManager const *)arg1)->histories();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = new std::vector<std::string >((std::vector<std::string > &)result); 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_IndexManager(void * jarg1) {
  IndexManager *arg1 = (IndexManager *) 0 ;
  
  arg1 = (IndexManager *)jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_Index___deref__(void * jarg1) {
  void * jresult ;
  boost::shared_ptr<Index > *arg1 = (boost::shared_ptr<Index > *) 0 ;
  Index *result = 0 ;
  
  arg1 = (boost::shared_ptr<Index > *)jarg1; 
  {
    try {
      result = (Index *)(arg1)->operator ->();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT unsigned int SWIGSTDCALL CSharp_Index_isNull(void * jarg1) {
  unsigned int jresult ;
  boost::shared_ptr<Index > *arg1 = (boost::shared_ptr<Index > *) 0 ;
  bool result;
  
  arg1 = (boost::shared_ptr<Index > *)jarg1; 
  {
    try {
      result = (bool)boost_shared_ptr_Sl_Index_Sg__isNull(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_Index_addFixings(void * jarg1, void * jarg2, void * jarg3) {
  boost::shared_ptr<Index > *arg1 = (boost::shared_ptr<Index > *) 0 ;
  std::vector<Date > *arg2 = 0 ;
  std::vector<Rate > *arg3 = 0 ;
  
  arg1 = (boost::shared_ptr<Index > *)jarg1; 
  arg2 = (std::vector<Date > *)jarg2;
  if(!arg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "std::vector<Date > const & type is null", 0);
    return ;
  } 
  arg3 = (std::vector<Rate > *)jarg3;
  if(!arg3) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "std::vector<Rate > const & type is null", 0);
    return ;
  } 
  {
    try {
      boost_shared_ptr_Sl_Index_Sg__addFixings(arg1,(std::vector<Date > const &)*arg2,(std::vector<double > const &)*arg3);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT char * SWIGSTDCALL CSharp_Index___str__(void * jarg1) {
  char * jresult ;
  boost::shared_ptr<Index > *arg1 = (boost::shared_ptr<Index > *) 0 ;
  std::string result;
  
  arg1 = (boost::shared_ptr<Index > *)jarg1; 
  {
    try {
      result = boost_shared_ptr_Sl_Index_Sg____str__(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = SWIG_csharp_string_callback((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_Index() {
  void * jresult ;
  boost::shared_ptr<Index > *result = 0 ;
  
  {
    try {
      result = (boost::shared_ptr<Index > *)new boost::shared_ptr<Index >();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_Index(void * jarg1) {
  boost::shared_ptr<Index > *arg1 = (boost::shared_ptr<Index > *) 0 ;
  
  arg1 = (boost::shared_ptr<Index > *)jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT double SWIGSTDCALL CSharp_Index_fixing(void * jarg1, void * jarg2) {
  double jresult ;
  boost::shared_ptr<Index > *arg1 = (boost::shared_ptr<Index > *) 0 ;
  Date *arg2 = 0 ;
  Rate result;
  
  arg1 = (boost::shared_ptr<Index > *)jarg1; 
  arg2 = (Date *)jarg2;
  if(!arg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
    return 0;
  } 
  {
    try {
      result = (Rate)(*arg1)->fixing((Date const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT char * SWIGSTDCALL CSharp_Index_name(void * jarg1) {
  char * jresult ;
  boost::shared_ptr<Index > *arg1 = (boost::shared_ptr<Index > *) 0 ;
  std::string result;
  
  arg1 = (boost::shared_ptr<Index > *)jarg1; 
  {
    try {
      result = (*arg1)->name();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = SWIG_csharp_string_callback((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_Index_addFixing(void * jarg1, void * jarg2, double jarg3) {
  boost::shared_ptr<Index > *arg1 = (boost::shared_ptr<Index > *) 0 ;
  Date *arg2 = 0 ;
  Rate arg3 ;
  
  arg1 = (boost::shared_ptr<Index > *)jarg1; 
  arg2 = (Date *)jarg2;
  if(!arg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
    return ;
  } 
  arg3 = (Rate)jarg3; 
  {
    try {
      (*arg1)->addFixing((Date const &)*arg2,arg3);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_Xibor(char * jarg1, int jarg2, int jarg3, int jarg4, void * jarg5, void * jarg6, int jarg7, void * jarg8, void * jarg9) {
  void * jresult ;
  std::string *arg1 = 0 ;
  Integer arg2 ;
  TimeUnit arg3 ;
  Integer arg4 ;
  Currency *arg5 = 0 ;
  Calendar *arg6 = 0 ;
  BusinessDayConvention arg7 ;
  DayCounter *arg8 = 0 ;
  Handle<YieldTermStructure > *arg9 = 0 ;
  XiborPtr *result = 0 ;
  
  if (!jarg1) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "null string", 0);
    return 0;
  }
  std::string arg1_str(jarg1);
  arg1 = &arg1_str; 
  arg2 = (Integer)jarg2; 
  arg3 = (TimeUnit)jarg3; 
  arg4 = (Integer)jarg4; 
  arg5 = (Currency *)jarg5;
  if(!arg5) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Currency const & type is null", 0);
    return 0;
  } 
  arg6 = (Calendar *)jarg6;
  if(!arg6) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Calendar const & type is null", 0);
    return 0;
  } 
  arg7 = (BusinessDayConvention)jarg7; 
  arg8 = (DayCounter *)jarg8;
  if(!arg8) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "DayCounter const & type is null", 0);
    return 0;
  } 
  arg9 = (Handle<YieldTermStructure > *)jarg9;
  if(!arg9) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Handle<YieldTermStructure > const & type is null", 0);
    return 0;
  } 
  {
    try {
      result = (XiborPtr *)new_XiborPtr((std::string const &)*arg1,arg2,arg3,arg4,(Currency const &)*arg5,(Calendar const &)*arg6,arg7,(DayCounter const &)*arg8,(Handle<YieldTermStructure > const &)*arg9);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_Xibor_tenor(void * jarg1) {
  void * jresult ;
  XiborPtr *arg1 = (XiborPtr *) 0 ;
  SwigValueWrapper<Period > result;
  
  arg1 = (XiborPtr *)jarg1; 
  {
    try {
      result = XiborPtr_tenor(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = new Period((Period &)result); 
  return jresult;
}


SWIGEXPORT int SWIGSTDCALL CSharp_Xibor_frequency(void * jarg1) {
  int jresult ;
  XiborPtr *arg1 = (XiborPtr *) 0 ;
  Frequency result;
  
  arg1 = (XiborPtr *)jarg1; 
  {
    try {
      result = (Frequency)XiborPtr_frequency(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_Xibor_currency(void * jarg1) {
  void * jresult ;
  XiborPtr *arg1 = (XiborPtr *) 0 ;
  Currency result;
  
  arg1 = (XiborPtr *)jarg1; 
  {
    try {
      result = XiborPtr_currency(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = new Currency((Currency &)result); 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_Xibor_calendar(void * jarg1) {
  void * jresult ;
  XiborPtr *arg1 = (XiborPtr *) 0 ;
  SwigValueWrapper<Calendar > result;
  
  arg1 = (XiborPtr *)jarg1; 
  {
    try {
      result = XiborPtr_calendar(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = new Calendar((Calendar &)result); 
  return jresult;
}


SWIGEXPORT unsigned int SWIGSTDCALL CSharp_Xibor_isAdjusted(void * jarg1) {
  unsigned int jresult ;
  XiborPtr *arg1 = (XiborPtr *) 0 ;
  bool result;
  
  arg1 = (XiborPtr *)jarg1; 
  {
    try {
      result = (bool)XiborPtr_isAdjusted(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT int SWIGSTDCALL CSharp_Xibor_businessDayConvention(void * jarg1) {
  int jresult ;
  XiborPtr *arg1 = (XiborPtr *) 0 ;
  BusinessDayConvention result;
  
  arg1 = (XiborPtr *)jarg1; 
  {
    try {
      result = (BusinessDayConvention)XiborPtr_businessDayConvention(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_Xibor_dayCounter(void * jarg1) {
  void * jresult ;
  XiborPtr *arg1 = (XiborPtr *) 0 ;
  SwigValueWrapper<DayCounter > result;
  
  arg1 = (XiborPtr *)jarg1; 
  {
    try {
      result = XiborPtr_dayCounter(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = new DayCounter((DayCounter &)result); 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_Xibor(void * jarg1) {
  XiborPtr *arg1 = (XiborPtr *) 0 ;
  
  arg1 = (XiborPtr *)jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_AUDLibor__SWIG_0(int jarg1, int jarg2, void * jarg3, void * jarg4) {
  void * jresult ;
  Integer arg1 ;
  TimeUnit arg2 ;
  Handle<YieldTermStructure > *arg3 = 0 ;
  DayCounter *arg4 = 0 ;
  AUDLiborPtr *result = 0 ;
  
  arg1 = (Integer)jarg1; 
  arg2 = (TimeUnit)jarg2; 
  arg3 = (Handle<YieldTermStructure > *)jarg3;
  if(!arg3) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Handle<YieldTermStructure > const & type is null", 0);
    return 0;
  } 
  arg4 = (DayCounter *)jarg4;
  if(!arg4) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "DayCounter const & type is null", 0);
    return 0;
  } 
  {
    try {
      result = (AUDLiborPtr *)new_AUDLiborPtr__SWIG_0(arg1,arg2,(Handle<YieldTermStructure > const &)*arg3,(DayCounter const &)*arg4);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_AUDLibor__SWIG_1(int jarg1, int jarg2, void * jarg3) {
  void * jresult ;
  Integer arg1 ;
  TimeUnit arg2 ;
  Handle<YieldTermStructure > *arg3 = 0 ;
  AUDLiborPtr *result = 0 ;
  
  arg1 = (Integer)jarg1; 
  arg2 = (TimeUnit)jarg2; 
  arg3 = (Handle<YieldTermStructure > *)jarg3;
  if(!arg3) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Handle<YieldTermStructure > const & type is null", 0);
    return 0;
  } 
  {
    try {
      result = (AUDLiborPtr *)new_AUDLiborPtr__SWIG_0(arg1,arg2,(Handle<YieldTermStructure > const &)*arg3);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_AUDLibor(void * jarg1) {
  AUDLiborPtr *arg1 = (AUDLiborPtr *) 0 ;
  
  arg1 = (AUDLiborPtr *)jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_CADLibor__SWIG_0(int jarg1, int jarg2, void * jarg3, void * jarg4) {
  void * jresult ;
  Integer arg1 ;
  TimeUnit arg2 ;
  Handle<YieldTermStructure > *arg3 = 0 ;
  DayCounter *arg4 = 0 ;
  CADLiborPtr *result = 0 ;
  
  arg1 = (Integer)jarg1; 
  arg2 = (TimeUnit)jarg2; 
  arg3 = (Handle<YieldTermStructure > *)jarg3;
  if(!arg3) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Handle<YieldTermStructure > const & type is null", 0);
    return 0;
  } 
  arg4 = (DayCounter *)jarg4;
  if(!arg4) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "DayCounter const & type is null", 0);
    return 0;
  } 
  {
    try {
      result = (CADLiborPtr *)new_CADLiborPtr__SWIG_0(arg1,arg2,(Handle<YieldTermStructure > const &)*arg3,(DayCounter const &)*arg4);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_CADLibor__SWIG_1(int jarg1, int jarg2, void * jarg3) {
  void * jresult ;
  Integer arg1 ;
  TimeUnit arg2 ;
  Handle<YieldTermStructure > *arg3 = 0 ;
  CADLiborPtr *result = 0 ;
  
  arg1 = (Integer)jarg1; 
  arg2 = (TimeUnit)jarg2; 
  arg3 = (Handle<YieldTermStructure > *)jarg3;
  if(!arg3) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Handle<YieldTermStructure > const & type is null", 0);
    return 0;
  } 
  {
    try {
      result = (CADLiborPtr *)new_CADLiborPtr__SWIG_0(arg1,arg2,(Handle<YieldTermStructure > const &)*arg3);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_CADLibor(void * jarg1) {
  CADLiborPtr *arg1 = (CADLiborPtr *) 0 ;
  
  arg1 = (CADLiborPtr *)jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_Cdor__SWIG_0(int jarg1, int jarg2, void * jarg3, void * jarg4) {
  void * jresult ;
  Integer arg1 ;
  TimeUnit arg2 ;
  Handle<YieldTermStructure > *arg3 = 0 ;
  DayCounter *arg4 = 0 ;
  CdorPtr *result = 0 ;
  
  arg1 = (Integer)jarg1; 
  arg2 = (TimeUnit)jarg2; 
  arg3 = (Handle<YieldTermStructure > *)jarg3;
  if(!arg3) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Handle<YieldTermStructure > const & type is null", 0);
    return 0;
  } 
  arg4 = (DayCounter *)jarg4;
  if(!arg4) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "DayCounter const & type is null", 0);
    return 0;
  } 
  {
    try {
      result = (CdorPtr *)new_CdorPtr__SWIG_0(arg1,arg2,(Handle<YieldTermStructure > const &)*arg3,(DayCounter const &)*arg4);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_Cdor__SWIG_1(int jarg1, int jarg2, void * jarg3) {
  void * jresult ;
  Integer arg1 ;
  TimeUnit arg2 ;
  Handle<YieldTermStructure > *arg3 = 0 ;
  CdorPtr *result = 0 ;
  
  arg1 = (Integer)jarg1; 
  arg2 = (TimeUnit)jarg2; 
  arg3 = (Handle<YieldTermStructure > *)jarg3;
  if(!arg3) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Handle<YieldTermStructure > const & type is null", 0);
    return 0;
  } 
  {
    try {
      result = (CdorPtr *)new_CdorPtr__SWIG_0(arg1,arg2,(Handle<YieldTermStructure > const &)*arg3);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_Cdor(void * jarg1) {
  CdorPtr *arg1 = (CdorPtr *) 0 ;
  
  arg1 = (CdorPtr *)jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_CHFLibor__SWIG_0(int jarg1, int jarg2, void * jarg3, void * jarg4) {
  void * jresult ;
  Integer arg1 ;
  TimeUnit arg2 ;
  Handle<YieldTermStructure > *arg3 = 0 ;
  DayCounter *arg4 = 0 ;
  CHFLiborPtr *result = 0 ;
  
  arg1 = (Integer)jarg1; 
  arg2 = (TimeUnit)jarg2; 
  arg3 = (Handle<YieldTermStructure > *)jarg3;
  if(!arg3) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Handle<YieldTermStructure > const & type is null", 0);
    return 0;
  } 
  arg4 = (DayCounter *)jarg4;
  if(!arg4) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "DayCounter const & type is null", 0);
    return 0;
  } 
  {
    try {
      result = (CHFLiborPtr *)new_CHFLiborPtr__SWIG_0(arg1,arg2,(Handle<YieldTermStructure > const &)*arg3,(DayCounter const &)*arg4);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_CHFLibor__SWIG_1(int jarg1, int jarg2, void * jarg3) {
  void * jresult ;
  Integer arg1 ;
  TimeUnit arg2 ;
  Handle<YieldTermStructure > *arg3 = 0 ;
  CHFLiborPtr *result = 0 ;
  
  arg1 = (Integer)jarg1; 
  arg2 = (TimeUnit)jarg2; 
  arg3 = (Handle<YieldTermStructure > *)jarg3;
  if(!arg3) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Handle<YieldTermStructure > const & type is null", 0);
    return 0;
  } 
  {
    try {
      result = (CHFLiborPtr *)new_CHFLiborPtr__SWIG_0(arg1,arg2,(Handle<YieldTermStructure > const &)*arg3);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_CHFLibor(void * jarg1) {
  CHFLiborPtr *arg1 = (CHFLiborPtr *) 0 ;
  
  arg1 = (CHFLiborPtr *)jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_Euribor__SWIG_0(int jarg1, int jarg2, void * jarg3, void * jarg4) {
  void * jresult ;
  Integer arg1 ;
  TimeUnit arg2 ;
  Handle<YieldTermStructure > *arg3 = 0 ;
  DayCounter *arg4 = 0 ;
  EuriborPtr *result = 0 ;
  
  arg1 = (Integer)jarg1; 
  arg2 = (TimeUnit)jarg2; 
  arg3 = (Handle<YieldTermStructure > *)jarg3;
  if(!arg3) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Handle<YieldTermStructure > const & type is null", 0);
    return 0;
  } 
  arg4 = (DayCounter *)jarg4;
  if(!arg4) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "DayCounter const & type is null", 0);
    return 0;
  } 
  {
    try {
      result = (EuriborPtr *)new_EuriborPtr__SWIG_0(arg1,arg2,(Handle<YieldTermStructure > const &)*arg3,(DayCounter const &)*arg4);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_Euribor__SWIG_1(int jarg1, int jarg2, void * jarg3) {
  void * jresult ;
  Integer arg1 ;
  TimeUnit arg2 ;
  Handle<YieldTermStructure > *arg3 = 0 ;
  EuriborPtr *result = 0 ;
  
  arg1 = (Integer)jarg1; 
  arg2 = (TimeUnit)jarg2; 
  arg3 = (Handle<YieldTermStructure > *)jarg3;
  if(!arg3) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Handle<YieldTermStructure > const & type is null", 0);
    return 0;
  } 
  {
    try {
      result = (EuriborPtr *)new_EuriborPtr__SWIG_0(arg1,arg2,(Handle<YieldTermStructure > const &)*arg3);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_Euribor(void * jarg1) {
  EuriborPtr *arg1 = (EuriborPtr *) 0 ;
  
  arg1 = (EuriborPtr *)jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_GBPLibor__SWIG_0(int jarg1, int jarg2, void * jarg3, void * jarg4) {
  void * jresult ;
  Integer arg1 ;
  TimeUnit arg2 ;
  Handle<YieldTermStructure > *arg3 = 0 ;
  DayCounter *arg4 = 0 ;
  GBPLiborPtr *result = 0 ;
  
  arg1 = (Integer)jarg1; 
  arg2 = (TimeUnit)jarg2; 
  arg3 = (Handle<YieldTermStructure > *)jarg3;
  if(!arg3) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Handle<YieldTermStructure > const & type is null", 0);
    return 0;
  } 
  arg4 = (DayCounter *)jarg4;
  if(!arg4) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "DayCounter const & type is null", 0);
    return 0;
  } 
  {
    try {
      result = (GBPLiborPtr *)new_GBPLiborPtr__SWIG_0(arg1,arg2,(Handle<YieldTermStructure > const &)*arg3,(DayCounter const &)*arg4);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_GBPLibor__SWIG_1(int jarg1, int jarg2, void * jarg3) {
  void * jresult ;
  Integer arg1 ;
  TimeUnit arg2 ;
  Handle<YieldTermStructure > *arg3 = 0 ;
  GBPLiborPtr *result = 0 ;
  
  arg1 = (Integer)jarg1; 
  arg2 = (TimeUnit)jarg2; 
  arg3 = (Handle<YieldTermStructure > *)jarg3;
  if(!arg3) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Handle<YieldTermStructure > const & type is null", 0);
    return 0;
  } 
  {
    try {
      result = (GBPLiborPtr *)new_GBPLiborPtr__SWIG_0(arg1,arg2,(Handle<YieldTermStructure > const &)*arg3);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_GBPLibor(void * jarg1) {
  GBPLiborPtr *arg1 = (GBPLiborPtr *) 0 ;
  
  arg1 = (GBPLiborPtr *)jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_Jibar__SWIG_0(int jarg1, int jarg2, void * jarg3, void * jarg4) {
  void * jresult ;
  Integer arg1 ;
  TimeUnit arg2 ;
  Handle<YieldTermStructure > *arg3 = 0 ;
  DayCounter *arg4 = 0 ;
  JibarPtr *result = 0 ;
  
  arg1 = (Integer)jarg1; 
  arg2 = (TimeUnit)jarg2; 
  arg3 = (Handle<YieldTermStructure > *)jarg3;
  if(!arg3) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Handle<YieldTermStructure > const & type is null", 0);
    return 0;
  } 
  arg4 = (DayCounter *)jarg4;
  if(!arg4) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "DayCounter const & type is null", 0);
    return 0;
  } 
  {
    try {
      result = (JibarPtr *)new_JibarPtr__SWIG_0(arg1,arg2,(Handle<YieldTermStructure > const &)*arg3,(DayCounter const &)*arg4);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_Jibar__SWIG_1(int jarg1, int jarg2, void * jarg3) {
  void * jresult ;
  Integer arg1 ;
  TimeUnit arg2 ;
  Handle<YieldTermStructure > *arg3 = 0 ;
  JibarPtr *result = 0 ;
  
  arg1 = (Integer)jarg1; 
  arg2 = (TimeUnit)jarg2; 
  arg3 = (Handle<YieldTermStructure > *)jarg3;
  if(!arg3) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Handle<YieldTermStructure > const & type is null", 0);
    return 0;
  } 
  {
    try {
      result = (JibarPtr *)new_JibarPtr__SWIG_0(arg1,arg2,(Handle<YieldTermStructure > const &)*arg3);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_Jibar(void * jarg1) {
  JibarPtr *arg1 = (JibarPtr *) 0 ;
  
  arg1 = (JibarPtr *)jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_JPYLibor__SWIG_0(int jarg1, int jarg2, void * jarg3, void * jarg4) {
  void * jresult ;
  Integer arg1 ;
  TimeUnit arg2 ;
  Handle<YieldTermStructure > *arg3 = 0 ;
  DayCounter *arg4 = 0 ;
  JPYLiborPtr *result = 0 ;
  
  arg1 = (Integer)jarg1; 
  arg2 = (TimeUnit)jarg2; 
  arg3 = (Handle<YieldTermStructure > *)jarg3;
  if(!arg3) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Handle<YieldTermStructure > const & type is null", 0);
    return 0;
  } 
  arg4 = (DayCounter *)jarg4;
  if(!arg4) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "DayCounter const & type is null", 0);
    return 0;
  } 
  {
    try {
      result = (JPYLiborPtr *)new_JPYLiborPtr__SWIG_0(arg1,arg2,(Handle<YieldTermStructure > const &)*arg3,(DayCounter const &)*arg4);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_JPYLibor__SWIG_1(int jarg1, int jarg2, void * jarg3) {
  void * jresult ;
  Integer arg1 ;
  TimeUnit arg2 ;
  Handle<YieldTermStructure > *arg3 = 0 ;
  JPYLiborPtr *result = 0 ;
  
  arg1 = (Integer)jarg1; 
  arg2 = (TimeUnit)jarg2; 
  arg3 = (Handle<YieldTermStructure > *)jarg3;
  if(!arg3) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Handle<YieldTermStructure > const & type is null", 0);
    return 0;
  } 
  {
    try {
      result = (JPYLiborPtr *)new_JPYLiborPtr__SWIG_0(arg1,arg2,(Handle<YieldTermStructure > const &)*arg3);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_JPYLibor(void * jarg1) {
  JPYLiborPtr *arg1 = (JPYLiborPtr *) 0 ;
  
  arg1 = (JPYLiborPtr *)jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_Tibor__SWIG_0(int jarg1, int jarg2, void * jarg3, void * jarg4) {
  void * jresult ;
  Integer arg1 ;
  TimeUnit arg2 ;
  Handle<YieldTermStructure > *arg3 = 0 ;
  DayCounter *arg4 = 0 ;
  TiborPtr *result = 0 ;
  
  arg1 = (Integer)jarg1; 
  arg2 = (TimeUnit)jarg2; 
  arg3 = (Handle<YieldTermStructure > *)jarg3;
  if(!arg3) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Handle<YieldTermStructure > const & type is null", 0);
    return 0;
  } 
  arg4 = (DayCounter *)jarg4;
  if(!arg4) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "DayCounter const & type is null", 0);
    return 0;
  } 
  {
    try {
      result = (TiborPtr *)new_TiborPtr__SWIG_0(arg1,arg2,(Handle<YieldTermStructure > const &)*arg3,(DayCounter const &)*arg4);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_Tibor__SWIG_1(int jarg1, int jarg2, void * jarg3) {
  void * jresult ;
  Integer arg1 ;
  TimeUnit arg2 ;
  Handle<YieldTermStructure > *arg3 = 0 ;
  TiborPtr *result = 0 ;
  
  arg1 = (Integer)jarg1; 
  arg2 = (TimeUnit)jarg2; 
  arg3 = (Handle<YieldTermStructure > *)jarg3;
  if(!arg3) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Handle<YieldTermStructure > const & type is null", 0);
    return 0;
  } 
  {
    try {
      result = (TiborPtr *)new_TiborPtr__SWIG_0(arg1,arg2,(Handle<YieldTermStructure > const &)*arg3);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_Tibor(void * jarg1) {
  TiborPtr *arg1 = (TiborPtr *) 0 ;
  
  arg1 = (TiborPtr *)jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_TRLibor__SWIG_0(int jarg1, int jarg2, void * jarg3, void * jarg4) {
  void * jresult ;
  Integer arg1 ;
  TimeUnit arg2 ;
  Handle<YieldTermStructure > *arg3 = 0 ;
  DayCounter *arg4 = 0 ;
  TRLiborPtr *result = 0 ;
  
  arg1 = (Integer)jarg1; 
  arg2 = (TimeUnit)jarg2; 
  arg3 = (Handle<YieldTermStructure > *)jarg3;
  if(!arg3) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Handle<YieldTermStructure > const & type is null", 0);
    return 0;
  } 
  arg4 = (DayCounter *)jarg4;
  if(!arg4) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "DayCounter const & type is null", 0);
    return 0;
  } 
  {
    try {
      result = (TRLiborPtr *)new_TRLiborPtr__SWIG_0(arg1,arg2,(Handle<YieldTermStructure > const &)*arg3,(DayCounter const &)*arg4);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_TRLibor__SWIG_1(int jarg1, int jarg2, void * jarg3) {
  void * jresult ;
  Integer arg1 ;
  TimeUnit arg2 ;
  Handle<YieldTermStructure > *arg3 = 0 ;
  TRLiborPtr *result = 0 ;
  
  arg1 = (Integer)jarg1; 
  arg2 = (TimeUnit)jarg2; 
  arg3 = (Handle<YieldTermStructure > *)jarg3;
  if(!arg3) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Handle<YieldTermStructure > const & type is null", 0);
    return 0;
  } 
  {
    try {
      result = (TRLiborPtr *)new_TRLiborPtr__SWIG_0(arg1,arg2,(Handle<YieldTermStructure > const &)*arg3);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_TRLibor(void * jarg1) {
  TRLiborPtr *arg1 = (TRLiborPtr *) 0 ;
  
  arg1 = (TRLiborPtr *)jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_USDLibor__SWIG_0(int jarg1, int jarg2, void * jarg3, void * jarg4) {
  void * jresult ;
  Integer arg1 ;
  TimeUnit arg2 ;
  Handle<YieldTermStructure > *arg3 = 0 ;
  DayCounter *arg4 = 0 ;
  USDLiborPtr *result = 0 ;
  
  arg1 = (Integer)jarg1; 
  arg2 = (TimeUnit)jarg2; 
  arg3 = (Handle<YieldTermStructure > *)jarg3;
  if(!arg3) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Handle<YieldTermStructure > const & type is null", 0);
    return 0;
  } 
  arg4 = (DayCounter *)jarg4;
  if(!arg4) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "DayCounter const & type is null", 0);
    return 0;
  } 
  {
    try {
      result = (USDLiborPtr *)new_USDLiborPtr__SWIG_0(arg1,arg2,(Handle<YieldTermStructure > const &)*arg3,(DayCounter const &)*arg4);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_USDLibor__SWIG_1(int jarg1, int jarg2, void * jarg3) {
  void * jresult ;
  Integer arg1 ;
  TimeUnit arg2 ;
  Handle<YieldTermStructure > *arg3 = 0 ;
  USDLiborPtr *result = 0 ;
  
  arg1 = (Integer)jarg1; 
  arg2 = (TimeUnit)jarg2; 
  arg3 = (Handle<YieldTermStructure > *)jarg3;
  if(!arg3) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Handle<YieldTermStructure > const & type is null", 0);
    return 0;
  } 
  {
    try {
      result = (USDLiborPtr *)new_USDLiborPtr__SWIG_0(arg1,arg2,(Handle<YieldTermStructure > const &)*arg3);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_USDLibor(void * jarg1) {
  USDLiborPtr *arg1 = (USDLiborPtr *) 0 ;
  
  arg1 = (USDLiborPtr *)jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_Zibor__SWIG_0(int jarg1, int jarg2, void * jarg3, void * jarg4) {
  void * jresult ;
  Integer arg1 ;
  TimeUnit arg2 ;
  Handle<YieldTermStructure > *arg3 = 0 ;
  DayCounter *arg4 = 0 ;
  ZiborPtr *result = 0 ;
  
  arg1 = (Integer)jarg1; 
  arg2 = (TimeUnit)jarg2; 
  arg3 = (Handle<YieldTermStructure > *)jarg3;
  if(!arg3) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Handle<YieldTermStructure > const & type is null", 0);
    return 0;
  } 
  arg4 = (DayCounter *)jarg4;
  if(!arg4) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "DayCounter const & type is null", 0);
    return 0;
  } 
  {
    try {
      result = (ZiborPtr *)new_ZiborPtr__SWIG_0(arg1,arg2,(Handle<YieldTermStructure > const &)*arg3,(DayCounter const &)*arg4);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_Zibor__SWIG_1(int jarg1, int jarg2, void * jarg3) {
  void * jresult ;
  Integer arg1 ;
  TimeUnit arg2 ;
  Handle<YieldTermStructure > *arg3 = 0 ;
  ZiborPtr *result = 0 ;
  
  arg1 = (Integer)jarg1; 
  arg2 = (TimeUnit)jarg2; 
  arg3 = (Handle<YieldTermStructure > *)jarg3;
  if(!arg3) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Handle<YieldTermStructure > const & type is null", 0);
    return 0;
  } 
  {
    try {
      result = (ZiborPtr *)new_ZiborPtr__SWIG_0(arg1,arg2,(Handle<YieldTermStructure > const &)*arg3);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_Zibor(void * jarg1) {
  ZiborPtr *arg1 = (ZiborPtr *) 0 ;
  
  arg1 = (ZiborPtr *)jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_Schedule__SWIG_0(void * jarg1, void * jarg2, void * jarg3, int jarg4, int jarg5, void * jarg6, unsigned int jarg7, unsigned int jarg8) {
  void * jresult ;
  Calendar *arg1 = 0 ;
  Date *arg2 = 0 ;
  Date *arg3 = 0 ;
  Frequency arg4 ;
  BusinessDayConvention arg5 ;
  Date *arg6 = 0 ;
  bool arg7 ;
  bool arg8 ;
  Schedule *result = 0 ;
  
  arg1 = (Calendar *)jarg1;
  if(!arg1) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Calendar const & type is null", 0);
    return 0;
  } 
  arg2 = (Date *)jarg2;
  if(!arg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
    return 0;
  } 
  arg3 = (Date *)jarg3;
  if(!arg3) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
    return 0;
  } 
  arg4 = (Frequency)jarg4; 
  arg5 = (BusinessDayConvention)jarg5; 
  arg6 = (Date *)jarg6;
  if(!arg6) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
    return 0;
  } 
  arg7 = jarg7 ? true : false; 
  arg8 = jarg8 ? true : false; 
  {
    try {
      result = (Schedule *)new Schedule((Calendar const &)*arg1,(Date const &)*arg2,(Date const &)*arg3,arg4,arg5,(Date const &)*arg6,arg7,arg8);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_Schedule__SWIG_1(void * jarg1, void * jarg2, void * jarg3, int jarg4, int jarg5, void * jarg6, unsigned int jarg7) {
  void * jresult ;
  Calendar *arg1 = 0 ;
  Date *arg2 = 0 ;
  Date *arg3 = 0 ;
  Frequency arg4 ;
  BusinessDayConvention arg5 ;
  Date *arg6 = 0 ;
  bool arg7 ;
  Schedule *result = 0 ;
  
  arg1 = (Calendar *)jarg1;
  if(!arg1) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Calendar const & type is null", 0);
    return 0;
  } 
  arg2 = (Date *)jarg2;
  if(!arg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
    return 0;
  } 
  arg3 = (Date *)jarg3;
  if(!arg3) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
    return 0;
  } 
  arg4 = (Frequency)jarg4; 
  arg5 = (BusinessDayConvention)jarg5; 
  arg6 = (Date *)jarg6;
  if(!arg6) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
    return 0;
  } 
  arg7 = jarg7 ? true : false; 
  {
    try {
      result = (Schedule *)new Schedule((Calendar const &)*arg1,(Date const &)*arg2,(Date const &)*arg3,arg4,arg5,(Date const &)*arg6,arg7);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_Schedule__SWIG_2(void * jarg1, void * jarg2, void * jarg3, int jarg4, int jarg5, void * jarg6) {
  void * jresult ;
  Calendar *arg1 = 0 ;
  Date *arg2 = 0 ;
  Date *arg3 = 0 ;
  Frequency arg4 ;
  BusinessDayConvention arg5 ;
  Date *arg6 = 0 ;
  Schedule *result = 0 ;
  
  arg1 = (Calendar *)jarg1;
  if(!arg1) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Calendar const & type is null", 0);
    return 0;
  } 
  arg2 = (Date *)jarg2;
  if(!arg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
    return 0;
  } 
  arg3 = (Date *)jarg3;
  if(!arg3) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
    return 0;
  } 
  arg4 = (Frequency)jarg4; 
  arg5 = (BusinessDayConvention)jarg5; 
  arg6 = (Date *)jarg6;
  if(!arg6) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
    return 0;
  } 
  {
    try {
      result = (Schedule *)new Schedule((Calendar const &)*arg1,(Date const &)*arg2,(Date const &)*arg3,arg4,arg5,(Date const &)*arg6);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_Schedule__SWIG_3(void * jarg1, void * jarg2, void * jarg3, int jarg4, int jarg5) {
  void * jresult ;
  Calendar *arg1 = 0 ;
  Date *arg2 = 0 ;
  Date *arg3 = 0 ;
  Frequency arg4 ;
  BusinessDayConvention arg5 ;
  Schedule *result = 0 ;
  
  arg1 = (Calendar *)jarg1;
  if(!arg1) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Calendar const & type is null", 0);
    return 0;
  } 
  arg2 = (Date *)jarg2;
  if(!arg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
    return 0;
  } 
  arg3 = (Date *)jarg3;
  if(!arg3) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
    return 0;
  } 
  arg4 = (Frequency)jarg4; 
  arg5 = (BusinessDayConvention)jarg5; 
  {
    try {
      result = (Schedule *)new Schedule((Calendar const &)*arg1,(Date const &)*arg2,(Date const &)*arg3,arg4,arg5);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_Schedule__SWIG_4(void * jarg1, void * jarg2, int jarg3) {
  void * jresult ;
  std::vector<Date > *arg1 = 0 ;
  Calendar *arg2 = 0 ;
  BusinessDayConvention arg3 ;
  Schedule *result = 0 ;
  
  arg1 = (std::vector<Date > *)jarg1;
  if(!arg1) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "std::vector<Date > const & type is null", 0);
    return 0;
  } 
  arg2 = (Calendar *)jarg2;
  if(!arg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Calendar const & type is null", 0);
    return 0;
  } 
  arg3 = (BusinessDayConvention)jarg3; 
  {
    try {
      result = (Schedule *)new Schedule((std::vector<Date > const &)*arg1,(Calendar const &)*arg2,arg3);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT unsigned long SWIGSTDCALL CSharp_Schedule_size(void * jarg1) {
  unsigned long jresult ;
  Schedule *arg1 = (Schedule *) 0 ;
  Size result;
  
  arg1 = (Schedule *)jarg1; 
  {
    try {
      result = ((Schedule const *)arg1)->size();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_Schedule_date(void * jarg1, unsigned long jarg2) {
  void * jresult ;
  Schedule *arg1 = (Schedule *) 0 ;
  Size arg2 ;
  Date result;
  
  arg1 = (Schedule *)jarg1; 
  arg2 = (Size)jarg2; 
  {
    try {
      result = ((Schedule const *)arg1)->date(arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = new Date((Date &)result); 
  return jresult;
}


SWIGEXPORT unsigned int SWIGSTDCALL CSharp_Schedule_isRegular(void * jarg1, unsigned long jarg2) {
  unsigned int jresult ;
  Schedule *arg1 = (Schedule *) 0 ;
  Size arg2 ;
  bool result;
  
  arg1 = (Schedule *)jarg1; 
  arg2 = (Size)jarg2; 
  {
    try {
      result = (bool)((Schedule const *)arg1)->isRegular(arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_Schedule(void * jarg1) {
  Schedule *arg1 = (Schedule *) 0 ;
  
  arg1 = (Schedule *)jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_BlackVolTermStructure___deref__(void * jarg1) {
  void * jresult ;
  boost::shared_ptr<BlackVolTermStructure > *arg1 = (boost::shared_ptr<BlackVolTermStructure > *) 0 ;
  BlackVolTermStructure *result = 0 ;
  
  arg1 = (boost::shared_ptr<BlackVolTermStructure > *)jarg1; 
  {
    try {
      result = (BlackVolTermStructure *)(arg1)->operator ->();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT unsigned int SWIGSTDCALL CSharp_BlackVolTermStructure_isNull(void * jarg1) {
  unsigned int jresult ;
  boost::shared_ptr<BlackVolTermStructure > *arg1 = (boost::shared_ptr<BlackVolTermStructure > *) 0 ;
  bool result;
  
  arg1 = (boost::shared_ptr<BlackVolTermStructure > *)jarg1; 
  {
    try {
      result = (bool)boost_shared_ptr_Sl_BlackVolTermStructure_Sg__isNull(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_BlackVolTermStructure_asObservable(void * jarg1) {
  void * jresult ;
  boost::shared_ptr<BlackVolTermStructure > *arg1 = (boost::shared_ptr<BlackVolTermStructure > *) 0 ;
  boost::shared_ptr<Observable > result;
  
  arg1 = (boost::shared_ptr<BlackVolTermStructure > *)jarg1; 
  {
    try {
      result = boost_shared_ptr_Sl_BlackVolTermStructure_Sg__asObservable(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = new boost::shared_ptr<Observable >((boost::shared_ptr<Observable > &)result); 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_BlackVolTermStructure() {
  void * jresult ;
  boost::shared_ptr<BlackVolTermStructure > *result = 0 ;
  
  {
    try {
      result = (boost::shared_ptr<BlackVolTermStructure > *)new boost::shared_ptr<BlackVolTermStructure >();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_BlackVolTermStructure(void * jarg1) {
  boost::shared_ptr<BlackVolTermStructure > *arg1 = (boost::shared_ptr<BlackVolTermStructure > *) 0 ;
  
  arg1 = (boost::shared_ptr<BlackVolTermStructure > *)jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_BlackVolTermStructure_referenceDate(void * jarg1) {
  void * jresult ;
  boost::shared_ptr<BlackVolTermStructure > *arg1 = (boost::shared_ptr<BlackVolTermStructure > *) 0 ;
  Date result;
  
  arg1 = (boost::shared_ptr<BlackVolTermStructure > *)jarg1; 
  {
    try {
      result = (*arg1)->referenceDate();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = new Date((Date &)result); 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_BlackVolTermStructure_dayCounter(void * jarg1) {
  void * jresult ;
  boost::shared_ptr<BlackVolTermStructure > *arg1 = (boost::shared_ptr<BlackVolTermStructure > *) 0 ;
  SwigValueWrapper<DayCounter > result;
  
  arg1 = (boost::shared_ptr<BlackVolTermStructure > *)jarg1; 
  {
    try {
      result = (*arg1)->dayCounter();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = new DayCounter((DayCounter &)result); 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_BlackVolTermStructure_calendar(void * jarg1) {
  void * jresult ;
  boost::shared_ptr<BlackVolTermStructure > *arg1 = (boost::shared_ptr<BlackVolTermStructure > *) 0 ;
  SwigValueWrapper<Calendar > result;
  
  arg1 = (boost::shared_ptr<BlackVolTermStructure > *)jarg1; 
  {
    try {
      result = (*arg1)->calendar();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = new Calendar((Calendar &)result); 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_BlackVolTermStructure_maxDate(void * jarg1) {
  void * jresult ;
  boost::shared_ptr<BlackVolTermStructure > *arg1 = (boost::shared_ptr<BlackVolTermStructure > *) 0 ;
  Date result;
  
  arg1 = (boost::shared_ptr<BlackVolTermStructure > *)jarg1; 
  {
    try {
      result = (*arg1)->maxDate();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = new Date((Date &)result); 
  return jresult;
}


SWIGEXPORT double SWIGSTDCALL CSharp_BlackVolTermStructure_maxTime(void * jarg1) {
  double jresult ;
  boost::shared_ptr<BlackVolTermStructure > *arg1 = (boost::shared_ptr<BlackVolTermStructure > *) 0 ;
  Time result;
  
  arg1 = (boost::shared_ptr<BlackVolTermStructure > *)jarg1; 
  {
    try {
      result = (Time)(*arg1)->maxTime();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT double SWIGSTDCALL CSharp_BlackVolTermStructure_minStrike(void * jarg1) {
  double jresult ;
  boost::shared_ptr<BlackVolTermStructure > *arg1 = (boost::shared_ptr<BlackVolTermStructure > *) 0 ;
  Real result;
  
  arg1 = (boost::shared_ptr<BlackVolTermStructure > *)jarg1; 
  {
    try {
      result = (Real)(*arg1)->minStrike();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT double SWIGSTDCALL CSharp_BlackVolTermStructure_maxStrike(void * jarg1) {
  double jresult ;
  boost::shared_ptr<BlackVolTermStructure > *arg1 = (boost::shared_ptr<BlackVolTermStructure > *) 0 ;
  Real result;
  
  arg1 = (boost::shared_ptr<BlackVolTermStructure > *)jarg1; 
  {
    try {
      result = (Real)(*arg1)->maxStrike();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT double SWIGSTDCALL CSharp_BlackVolTermStructure_blackVol__SWIG_0(void * jarg1, void * jarg2, double jarg3, unsigned int jarg4) {
  double jresult ;
  boost::shared_ptr<BlackVolTermStructure > *arg1 = (boost::shared_ptr<BlackVolTermStructure > *) 0 ;
  Date *arg2 = 0 ;
  Real arg3 ;
  bool arg4 ;
  Volatility result;
  
  arg1 = (boost::shared_ptr<BlackVolTermStructure > *)jarg1; 
  arg2 = (Date *)jarg2;
  if(!arg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
    return 0;
  } 
  arg3 = (Real)jarg3; 
  arg4 = jarg4 ? true : false; 
  {
    try {
      result = (Volatility)(*arg1)->blackVol((Date const &)*arg2,arg3,arg4);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT double SWIGSTDCALL CSharp_BlackVolTermStructure_blackVol__SWIG_1(void * jarg1, void * jarg2, double jarg3) {
  double jresult ;
  boost::shared_ptr<BlackVolTermStructure > *arg1 = (boost::shared_ptr<BlackVolTermStructure > *) 0 ;
  Date *arg2 = 0 ;
  Real arg3 ;
  Volatility result;
  
  arg1 = (boost::shared_ptr<BlackVolTermStructure > *)jarg1; 
  arg2 = (Date *)jarg2;
  if(!arg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
    return 0;
  } 
  arg3 = (Real)jarg3; 
  {
    try {
      result = (Volatility)(*arg1)->blackVol((Date const &)*arg2,arg3);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT double SWIGSTDCALL CSharp_BlackVolTermStructure_blackVol__SWIG_2(void * jarg1, double jarg2, double jarg3, unsigned int jarg4) {
  double jresult ;
  boost::shared_ptr<BlackVolTermStructure > *arg1 = (boost::shared_ptr<BlackVolTermStructure > *) 0 ;
  Time arg2 ;
  Real arg3 ;
  bool arg4 ;
  Volatility result;
  
  arg1 = (boost::shared_ptr<BlackVolTermStructure > *)jarg1; 
  arg2 = (Time)jarg2; 
  arg3 = (Real)jarg3; 
  arg4 = jarg4 ? true : false; 
  {
    try {
      result = (Volatility)(*arg1)->blackVol(arg2,arg3,arg4);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT double SWIGSTDCALL CSharp_BlackVolTermStructure_blackVol__SWIG_3(void * jarg1, double jarg2, double jarg3) {
  double jresult ;
  boost::shared_ptr<BlackVolTermStructure > *arg1 = (boost::shared_ptr<BlackVolTermStructure > *) 0 ;
  Time arg2 ;
  Real arg3 ;
  Volatility result;
  
  arg1 = (boost::shared_ptr<BlackVolTermStructure > *)jarg1; 
  arg2 = (Time)jarg2; 
  arg3 = (Real)jarg3; 
  {
    try {
      result = (Volatility)(*arg1)->blackVol(arg2,arg3);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT double SWIGSTDCALL CSharp_BlackVolTermStructure_blackVariance__SWIG_0(void * jarg1, void * jarg2, double jarg3, unsigned int jarg4) {
  double jresult ;
  boost::shared_ptr<BlackVolTermStructure > *arg1 = (boost::shared_ptr<BlackVolTermStructure > *) 0 ;
  Date *arg2 = 0 ;
  Real arg3 ;
  bool arg4 ;
  Real result;
  
  arg1 = (boost::shared_ptr<BlackVolTermStructure > *)jarg1; 
  arg2 = (Date *)jarg2;
  if(!arg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
    return 0;
  } 
  arg3 = (Real)jarg3; 
  arg4 = jarg4 ? true : false; 
  {
    try {
      result = (Real)(*arg1)->blackVariance((Date const &)*arg2,arg3,arg4);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT double SWIGSTDCALL CSharp_BlackVolTermStructure_blackVariance__SWIG_1(void * jarg1, void * jarg2, double jarg3) {
  double jresult ;
  boost::shared_ptr<BlackVolTermStructure > *arg1 = (boost::shared_ptr<BlackVolTermStructure > *) 0 ;
  Date *arg2 = 0 ;
  Real arg3 ;
  Real result;
  
  arg1 = (boost::shared_ptr<BlackVolTermStructure > *)jarg1; 
  arg2 = (Date *)jarg2;
  if(!arg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
    return 0;
  } 
  arg3 = (Real)jarg3; 
  {
    try {
      result = (Real)(*arg1)->blackVariance((Date const &)*arg2,arg3);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT double SWIGSTDCALL CSharp_BlackVolTermStructure_blackVariance__SWIG_2(void * jarg1, double jarg2, double jarg3, unsigned int jarg4) {
  double jresult ;
  boost::shared_ptr<BlackVolTermStructure > *arg1 = (boost::shared_ptr<BlackVolTermStructure > *) 0 ;
  Time arg2 ;
  Real arg3 ;
  bool arg4 ;
  Real result;
  
  arg1 = (boost::shared_ptr<BlackVolTermStructure > *)jarg1; 
  arg2 = (Time)jarg2; 
  arg3 = (Real)jarg3; 
  arg4 = jarg4 ? true : false; 
  {
    try {
      result = (Real)(*arg1)->blackVariance(arg2,arg3,arg4);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT double SWIGSTDCALL CSharp_BlackVolTermStructure_blackVariance__SWIG_3(void * jarg1, double jarg2, double jarg3) {
  double jresult ;
  boost::shared_ptr<BlackVolTermStructure > *arg1 = (boost::shared_ptr<BlackVolTermStructure > *) 0 ;
  Time arg2 ;
  Real arg3 ;
  Real result;
  
  arg1 = (boost::shared_ptr<BlackVolTermStructure > *)jarg1; 
  arg2 = (Time)jarg2; 
  arg3 = (Real)jarg3; 
  {
    try {
      result = (Real)(*arg1)->blackVariance(arg2,arg3);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT double SWIGSTDCALL CSharp_BlackVolTermStructure_blackForwardVol__SWIG_0(void * jarg1, void * jarg2, void * jarg3, double jarg4, unsigned int jarg5) {
  double jresult ;
  boost::shared_ptr<BlackVolTermStructure > *arg1 = (boost::shared_ptr<BlackVolTermStructure > *) 0 ;
  Date *arg2 = 0 ;
  Date *arg3 = 0 ;
  Real arg4 ;
  bool arg5 ;
  Volatility result;
  
  arg1 = (boost::shared_ptr<BlackVolTermStructure > *)jarg1; 
  arg2 = (Date *)jarg2;
  if(!arg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
    return 0;
  } 
  arg3 = (Date *)jarg3;
  if(!arg3) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
    return 0;
  } 
  arg4 = (Real)jarg4; 
  arg5 = jarg5 ? true : false; 
  {
    try {
      result = (Volatility)(*arg1)->blackForwardVol((Date const &)*arg2,(Date const &)*arg3,arg4,arg5);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT double SWIGSTDCALL CSharp_BlackVolTermStructure_blackForwardVol__SWIG_1(void * jarg1, void * jarg2, void * jarg3, double jarg4) {
  double jresult ;
  boost::shared_ptr<BlackVolTermStructure > *arg1 = (boost::shared_ptr<BlackVolTermStructure > *) 0 ;
  Date *arg2 = 0 ;
  Date *arg3 = 0 ;
  Real arg4 ;
  Volatility result;
  
  arg1 = (boost::shared_ptr<BlackVolTermStructure > *)jarg1; 
  arg2 = (Date *)jarg2;
  if(!arg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
    return 0;
  } 
  arg3 = (Date *)jarg3;
  if(!arg3) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
    return 0;
  } 
  arg4 = (Real)jarg4; 
  {
    try {
      result = (Volatility)(*arg1)->blackForwardVol((Date const &)*arg2,(Date const &)*arg3,arg4);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT double SWIGSTDCALL CSharp_BlackVolTermStructure_blackForwardVol__SWIG_2(void * jarg1, double jarg2, double jarg3, double jarg4, unsigned int jarg5) {
  double jresult ;
  boost::shared_ptr<BlackVolTermStructure > *arg1 = (boost::shared_ptr<BlackVolTermStructure > *) 0 ;
  Time arg2 ;
  Time arg3 ;
  Real arg4 ;
  bool arg5 ;
  Volatility result;
  
  arg1 = (boost::shared_ptr<BlackVolTermStructure > *)jarg1; 
  arg2 = (Time)jarg2; 
  arg3 = (Time)jarg3; 
  arg4 = (Real)jarg4; 
  arg5 = jarg5 ? true : false; 
  {
    try {
      result = (Volatility)(*arg1)->blackForwardVol(arg2,arg3,arg4,arg5);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT double SWIGSTDCALL CSharp_BlackVolTermStructure_blackForwardVol__SWIG_3(void * jarg1, double jarg2, double jarg3, double jarg4) {
  double jresult ;
  boost::shared_ptr<BlackVolTermStructure > *arg1 = (boost::shared_ptr<BlackVolTermStructure > *) 0 ;
  Time arg2 ;
  Time arg3 ;
  Real arg4 ;
  Volatility result;
  
  arg1 = (boost::shared_ptr<BlackVolTermStructure > *)jarg1; 
  arg2 = (Time)jarg2; 
  arg3 = (Time)jarg3; 
  arg4 = (Real)jarg4; 
  {
    try {
      result = (Volatility)(*arg1)->blackForwardVol(arg2,arg3,arg4);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT double SWIGSTDCALL CSharp_BlackVolTermStructure_blackForwardVariance__SWIG_0(void * jarg1, void * jarg2, void * jarg3, double jarg4, unsigned int jarg5) {
  double jresult ;
  boost::shared_ptr<BlackVolTermStructure > *arg1 = (boost::shared_ptr<BlackVolTermStructure > *) 0 ;
  Date *arg2 = 0 ;
  Date *arg3 = 0 ;
  Real arg4 ;
  bool arg5 ;
  Real result;
  
  arg1 = (boost::shared_ptr<BlackVolTermStructure > *)jarg1; 
  arg2 = (Date *)jarg2;
  if(!arg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
    return 0;
  } 
  arg3 = (Date *)jarg3;
  if(!arg3) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
    return 0;
  } 
  arg4 = (Real)jarg4; 
  arg5 = jarg5 ? true : false; 
  {
    try {
      result = (Real)(*arg1)->blackForwardVariance((Date const &)*arg2,(Date const &)*arg3,arg4,arg5);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT double SWIGSTDCALL CSharp_BlackVolTermStructure_blackForwardVariance__SWIG_1(void * jarg1, void * jarg2, void * jarg3, double jarg4) {
  double jresult ;
  boost::shared_ptr<BlackVolTermStructure > *arg1 = (boost::shared_ptr<BlackVolTermStructure > *) 0 ;
  Date *arg2 = 0 ;
  Date *arg3 = 0 ;
  Real arg4 ;
  Real result;
  
  arg1 = (boost::shared_ptr<BlackVolTermStructure > *)jarg1; 
  arg2 = (Date *)jarg2;
  if(!arg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
    return 0;
  } 
  arg3 = (Date *)jarg3;
  if(!arg3) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
    return 0;
  } 
  arg4 = (Real)jarg4; 
  {
    try {
      result = (Real)(*arg1)->blackForwardVariance((Date const &)*arg2,(Date const &)*arg3,arg4);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT double SWIGSTDCALL CSharp_BlackVolTermStructure_blackForwardVariance__SWIG_2(void * jarg1, double jarg2, double jarg3, double jarg4, unsigned int jarg5) {
  double jresult ;
  boost::shared_ptr<BlackVolTermStructure > *arg1 = (boost::shared_ptr<BlackVolTermStructure > *) 0 ;
  Time arg2 ;
  Time arg3 ;
  Real arg4 ;
  bool arg5 ;
  Real result;
  
  arg1 = (boost::shared_ptr<BlackVolTermStructure > *)jarg1; 
  arg2 = (Time)jarg2; 
  arg3 = (Time)jarg3; 
  arg4 = (Real)jarg4; 
  arg5 = jarg5 ? true : false; 
  {
    try {
      result = (Real)(*arg1)->blackForwardVariance(arg2,arg3,arg4,arg5);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT double SWIGSTDCALL CSharp_BlackVolTermStructure_blackForwardVariance__SWIG_3(void * jarg1, double jarg2, double jarg3, double jarg4) {
  double jresult ;
  boost::shared_ptr<BlackVolTermStructure > *arg1 = (boost::shared_ptr<BlackVolTermStructure > *) 0 ;
  Time arg2 ;
  Time arg3 ;
  Real arg4 ;
  Real result;
  
  arg1 = (boost::shared_ptr<BlackVolTermStructure > *)jarg1; 
  arg2 = (Time)jarg2; 
  arg3 = (Time)jarg3; 
  arg4 = (Real)jarg4; 
  {
    try {
      result = (Real)(*arg1)->blackForwardVariance(arg2,arg3,arg4);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_BlackVolTermStructure_enableExtrapolation(void * jarg1) {
  boost::shared_ptr<BlackVolTermStructure > *arg1 = (boost::shared_ptr<BlackVolTermStructure > *) 0 ;
  
  arg1 = (boost::shared_ptr<BlackVolTermStructure > *)jarg1; 
  {
    try {
      (*arg1)->enableExtrapolation();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_BlackVolTermStructure_disableExtrapolation(void * jarg1) {
  boost::shared_ptr<BlackVolTermStructure > *arg1 = (boost::shared_ptr<BlackVolTermStructure > *) 0 ;
  
  arg1 = (boost::shared_ptr<BlackVolTermStructure > *)jarg1; 
  {
    try {
      (*arg1)->disableExtrapolation();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT unsigned int SWIGSTDCALL CSharp_BlackVolTermStructure_allowsExtrapolation(void * jarg1) {
  unsigned int jresult ;
  boost::shared_ptr<BlackVolTermStructure > *arg1 = (boost::shared_ptr<BlackVolTermStructure > *) 0 ;
  bool result;
  
  arg1 = (boost::shared_ptr<BlackVolTermStructure > *)jarg1; 
  {
    try {
      result = (bool)(*arg1)->allowsExtrapolation();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_BlackVolTermStructureHandle__SWIG_0(void * jarg1) {
  void * jresult ;
  boost::shared_ptr<BlackVolTermStructure > *arg1 = 0 ;
  Handle<BlackVolTermStructure > *result = 0 ;
  
  arg1 = (boost::shared_ptr<BlackVolTermStructure > *)jarg1;
  if(!arg1) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "boost::shared_ptr<BlackVolTermStructure > const & type is null", 0);
    return 0;
  } 
  {
    try {
      result = (Handle<BlackVolTermStructure > *)new Handle<BlackVolTermStructure >((boost::shared_ptr<BlackVolTermStructure > const &)*arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_BlackVolTermStructureHandle__SWIG_1() {
  void * jresult ;
  Handle<BlackVolTermStructure > *result = 0 ;
  
  {
    try {
      result = (Handle<BlackVolTermStructure > *)new Handle<BlackVolTermStructure >();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_BlackVolTermStructureHandle___deref__(void * jarg1) {
  void * jresult ;
  Handle<BlackVolTermStructure > *arg1 = (Handle<BlackVolTermStructure > *) 0 ;
  boost::shared_ptr<BlackVolTermStructure > result;
  
  arg1 = (Handle<BlackVolTermStructure > *)jarg1; 
  {
    try {
      result = (arg1)->operator ->();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = new boost::shared_ptr<BlackVolTermStructure >((boost::shared_ptr<BlackVolTermStructure > &)result); 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_BlackVolTermStructureHandle_linkTo(void * jarg1, void * jarg2) {
  Handle<BlackVolTermStructure > *arg1 = (Handle<BlackVolTermStructure > *) 0 ;
  boost::shared_ptr<BlackVolTermStructure > *arg2 = 0 ;
  
  arg1 = (Handle<BlackVolTermStructure > *)jarg1; 
  arg2 = (boost::shared_ptr<BlackVolTermStructure > *)jarg2;
  if(!arg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "boost::shared_ptr<BlackVolTermStructure > const & type is null", 0);
    return ;
  } 
  {
    try {
      (arg1)->linkTo((boost::shared_ptr<BlackVolTermStructure > const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT unsigned int SWIGSTDCALL CSharp_BlackVolTermStructureHandle_empty(void * jarg1) {
  unsigned int jresult ;
  Handle<BlackVolTermStructure > *arg1 = (Handle<BlackVolTermStructure > *) 0 ;
  bool result;
  
  arg1 = (Handle<BlackVolTermStructure > *)jarg1; 
  {
    try {
      result = (bool)(arg1)->empty();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_BlackVolTermStructureHandle_asObservable(void * jarg1) {
  void * jresult ;
  Handle<BlackVolTermStructure > *arg1 = (Handle<BlackVolTermStructure > *) 0 ;
  boost::shared_ptr<Observable > result;
  
  arg1 = (Handle<BlackVolTermStructure > *)jarg1; 
  {
    try {
      result = Handle_Sl_BlackVolTermStructure_Sg__asObservable(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = new boost::shared_ptr<Observable >((boost::shared_ptr<Observable > &)result); 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_BlackVolTermStructureHandle(void * jarg1) {
  Handle<BlackVolTermStructure > *arg1 = (Handle<BlackVolTermStructure > *) 0 ;
  
  arg1 = (Handle<BlackVolTermStructure > *)jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_BlackVolTermStructureHandle_referenceDate(void * jarg1) {
  void * jresult ;
  Handle<BlackVolTermStructure > *arg1 = (Handle<BlackVolTermStructure > *) 0 ;
  Date result;
  
  arg1 = (Handle<BlackVolTermStructure > *)jarg1; 
  {
    try {
      result = (*arg1)->referenceDate();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = new Date((Date &)result); 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_BlackVolTermStructureHandle_dayCounter(void * jarg1) {
  void * jresult ;
  Handle<BlackVolTermStructure > *arg1 = (Handle<BlackVolTermStructure > *) 0 ;
  SwigValueWrapper<DayCounter > result;
  
  arg1 = (Handle<BlackVolTermStructure > *)jarg1; 
  {
    try {
      result = (*arg1)->dayCounter();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = new DayCounter((DayCounter &)result); 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_BlackVolTermStructureHandle_calendar(void * jarg1) {
  void * jresult ;
  Handle<BlackVolTermStructure > *arg1 = (Handle<BlackVolTermStructure > *) 0 ;
  SwigValueWrapper<Calendar > result;
  
  arg1 = (Handle<BlackVolTermStructure > *)jarg1; 
  {
    try {
      result = (*arg1)->calendar();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = new Calendar((Calendar &)result); 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_BlackVolTermStructureHandle_maxDate(void * jarg1) {
  void * jresult ;
  Handle<BlackVolTermStructure > *arg1 = (Handle<BlackVolTermStructure > *) 0 ;
  Date result;
  
  arg1 = (Handle<BlackVolTermStructure > *)jarg1; 
  {
    try {
      result = (*arg1)->maxDate();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = new Date((Date &)result); 
  return jresult;
}


SWIGEXPORT double SWIGSTDCALL CSharp_BlackVolTermStructureHandle_maxTime(void * jarg1) {
  double jresult ;
  Handle<BlackVolTermStructure > *arg1 = (Handle<BlackVolTermStructure > *) 0 ;
  Time result;
  
  arg1 = (Handle<BlackVolTermStructure > *)jarg1; 
  {
    try {
      result = (Time)(*arg1)->maxTime();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT double SWIGSTDCALL CSharp_BlackVolTermStructureHandle_minStrike(void * jarg1) {
  double jresult ;
  Handle<BlackVolTermStructure > *arg1 = (Handle<BlackVolTermStructure > *) 0 ;
  Real result;
  
  arg1 = (Handle<BlackVolTermStructure > *)jarg1; 
  {
    try {
      result = (Real)(*arg1)->minStrike();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT double SWIGSTDCALL CSharp_BlackVolTermStructureHandle_maxStrike(void * jarg1) {
  double jresult ;
  Handle<BlackVolTermStructure > *arg1 = (Handle<BlackVolTermStructure > *) 0 ;
  Real result;
  
  arg1 = (Handle<BlackVolTermStructure > *)jarg1; 
  {
    try {
      result = (Real)(*arg1)->maxStrike();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT double SWIGSTDCALL CSharp_BlackVolTermStructureHandle_blackVol__SWIG_0(void * jarg1, void * jarg2, double jarg3, unsigned int jarg4) {
  double jresult ;
  Handle<BlackVolTermStructure > *arg1 = (Handle<BlackVolTermStructure > *) 0 ;
  Date *arg2 = 0 ;
  Real arg3 ;
  bool arg4 ;
  Volatility result;
  
  arg1 = (Handle<BlackVolTermStructure > *)jarg1; 
  arg2 = (Date *)jarg2;
  if(!arg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
    return 0;
  } 
  arg3 = (Real)jarg3; 
  arg4 = jarg4 ? true : false; 
  {
    try {
      result = (Volatility)(*arg1)->blackVol((Date const &)*arg2,arg3,arg4);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT double SWIGSTDCALL CSharp_BlackVolTermStructureHandle_blackVol__SWIG_1(void * jarg1, void * jarg2, double jarg3) {
  double jresult ;
  Handle<BlackVolTermStructure > *arg1 = (Handle<BlackVolTermStructure > *) 0 ;
  Date *arg2 = 0 ;
  Real arg3 ;
  Volatility result;
  
  arg1 = (Handle<BlackVolTermStructure > *)jarg1; 
  arg2 = (Date *)jarg2;
  if(!arg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
    return 0;
  } 
  arg3 = (Real)jarg3; 
  {
    try {
      result = (Volatility)(*arg1)->blackVol((Date const &)*arg2,arg3);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT double SWIGSTDCALL CSharp_BlackVolTermStructureHandle_blackVol__SWIG_2(void * jarg1, double jarg2, double jarg3, unsigned int jarg4) {
  double jresult ;
  Handle<BlackVolTermStructure > *arg1 = (Handle<BlackVolTermStructure > *) 0 ;
  Time arg2 ;
  Real arg3 ;
  bool arg4 ;
  Volatility result;
  
  arg1 = (Handle<BlackVolTermStructure > *)jarg1; 
  arg2 = (Time)jarg2; 
  arg3 = (Real)jarg3; 
  arg4 = jarg4 ? true : false; 
  {
    try {
      result = (Volatility)(*arg1)->blackVol(arg2,arg3,arg4);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT double SWIGSTDCALL CSharp_BlackVolTermStructureHandle_blackVol__SWIG_3(void * jarg1, double jarg2, double jarg3) {
  double jresult ;
  Handle<BlackVolTermStructure > *arg1 = (Handle<BlackVolTermStructure > *) 0 ;
  Time arg2 ;
  Real arg3 ;
  Volatility result;
  
  arg1 = (Handle<BlackVolTermStructure > *)jarg1; 
  arg2 = (Time)jarg2; 
  arg3 = (Real)jarg3; 
  {
    try {
      result = (Volatility)(*arg1)->blackVol(arg2,arg3);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT double SWIGSTDCALL CSharp_BlackVolTermStructureHandle_blackVariance__SWIG_0(void * jarg1, void * jarg2, double jarg3, unsigned int jarg4) {
  double jresult ;
  Handle<BlackVolTermStructure > *arg1 = (Handle<BlackVolTermStructure > *) 0 ;
  Date *arg2 = 0 ;
  Real arg3 ;
  bool arg4 ;
  Real result;
  
  arg1 = (Handle<BlackVolTermStructure > *)jarg1; 
  arg2 = (Date *)jarg2;
  if(!arg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
    return 0;
  } 
  arg3 = (Real)jarg3; 
  arg4 = jarg4 ? true : false; 
  {
    try {
      result = (Real)(*arg1)->blackVariance((Date const &)*arg2,arg3,arg4);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT double SWIGSTDCALL CSharp_BlackVolTermStructureHandle_blackVariance__SWIG_1(void * jarg1, void * jarg2, double jarg3) {
  double jresult ;
  Handle<BlackVolTermStructure > *arg1 = (Handle<BlackVolTermStructure > *) 0 ;
  Date *arg2 = 0 ;
  Real arg3 ;
  Real result;
  
  arg1 = (Handle<BlackVolTermStructure > *)jarg1; 
  arg2 = (Date *)jarg2;
  if(!arg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
    return 0;
  } 
  arg3 = (Real)jarg3; 
  {
    try {
      result = (Real)(*arg1)->blackVariance((Date const &)*arg2,arg3);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT double SWIGSTDCALL CSharp_BlackVolTermStructureHandle_blackVariance__SWIG_2(void * jarg1, double jarg2, double jarg3, unsigned int jarg4) {
  double jresult ;
  Handle<BlackVolTermStructure > *arg1 = (Handle<BlackVolTermStructure > *) 0 ;
  Time arg2 ;
  Real arg3 ;
  bool arg4 ;
  Real result;
  
  arg1 = (Handle<BlackVolTermStructure > *)jarg1; 
  arg2 = (Time)jarg2; 
  arg3 = (Real)jarg3; 
  arg4 = jarg4 ? true : false; 
  {
    try {
      result = (Real)(*arg1)->blackVariance(arg2,arg3,arg4);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT double SWIGSTDCALL CSharp_BlackVolTermStructureHandle_blackVariance__SWIG_3(void * jarg1, double jarg2, double jarg3) {
  double jresult ;
  Handle<BlackVolTermStructure > *arg1 = (Handle<BlackVolTermStructure > *) 0 ;
  Time arg2 ;
  Real arg3 ;
  Real result;
  
  arg1 = (Handle<BlackVolTermStructure > *)jarg1; 
  arg2 = (Time)jarg2; 
  arg3 = (Real)jarg3; 
  {
    try {
      result = (Real)(*arg1)->blackVariance(arg2,arg3);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT double SWIGSTDCALL CSharp_BlackVolTermStructureHandle_blackForwardVol__SWIG_0(void * jarg1, void * jarg2, void * jarg3, double jarg4, unsigned int jarg5) {
  double jresult ;
  Handle<BlackVolTermStructure > *arg1 = (Handle<BlackVolTermStructure > *) 0 ;
  Date *arg2 = 0 ;
  Date *arg3 = 0 ;
  Real arg4 ;
  bool arg5 ;
  Volatility result;
  
  arg1 = (Handle<BlackVolTermStructure > *)jarg1; 
  arg2 = (Date *)jarg2;
  if(!arg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
    return 0;
  } 
  arg3 = (Date *)jarg3;
  if(!arg3) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
    return 0;
  } 
  arg4 = (Real)jarg4; 
  arg5 = jarg5 ? true : false; 
  {
    try {
      result = (Volatility)(*arg1)->blackForwardVol((Date const &)*arg2,(Date const &)*arg3,arg4,arg5);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT double SWIGSTDCALL CSharp_BlackVolTermStructureHandle_blackForwardVol__SWIG_1(void * jarg1, void * jarg2, void * jarg3, double jarg4) {
  double jresult ;
  Handle<BlackVolTermStructure > *arg1 = (Handle<BlackVolTermStructure > *) 0 ;
  Date *arg2 = 0 ;
  Date *arg3 = 0 ;
  Real arg4 ;
  Volatility result;
  
  arg1 = (Handle<BlackVolTermStructure > *)jarg1; 
  arg2 = (Date *)jarg2;
  if(!arg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
    return 0;
  } 
  arg3 = (Date *)jarg3;
  if(!arg3) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
    return 0;
  } 
  arg4 = (Real)jarg4; 
  {
    try {
      result = (Volatility)(*arg1)->blackForwardVol((Date const &)*arg2,(Date const &)*arg3,arg4);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT double SWIGSTDCALL CSharp_BlackVolTermStructureHandle_blackForwardVol__SWIG_2(void * jarg1, double jarg2, double jarg3, double jarg4, unsigned int jarg5) {
  double jresult ;
  Handle<BlackVolTermStructure > *arg1 = (Handle<BlackVolTermStructure > *) 0 ;
  Time arg2 ;
  Time arg3 ;
  Real arg4 ;
  bool arg5 ;
  Volatility result;
  
  arg1 = (Handle<BlackVolTermStructure > *)jarg1; 
  arg2 = (Time)jarg2; 
  arg3 = (Time)jarg3; 
  arg4 = (Real)jarg4; 
  arg5 = jarg5 ? true : false; 
  {
    try {
      result = (Volatility)(*arg1)->blackForwardVol(arg2,arg3,arg4,arg5);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT double SWIGSTDCALL CSharp_BlackVolTermStructureHandle_blackForwardVol__SWIG_3(void * jarg1, double jarg2, double jarg3, double jarg4) {
  double jresult ;
  Handle<BlackVolTermStructure > *arg1 = (Handle<BlackVolTermStructure > *) 0 ;
  Time arg2 ;
  Time arg3 ;
  Real arg4 ;
  Volatility result;
  
  arg1 = (Handle<BlackVolTermStructure > *)jarg1; 
  arg2 = (Time)jarg2; 
  arg3 = (Time)jarg3; 
  arg4 = (Real)jarg4; 
  {
    try {
      result = (Volatility)(*arg1)->blackForwardVol(arg2,arg3,arg4);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT double SWIGSTDCALL CSharp_BlackVolTermStructureHandle_blackForwardVariance__SWIG_0(void * jarg1, void * jarg2, void * jarg3, double jarg4, unsigned int jarg5) {
  double jresult ;
  Handle<BlackVolTermStructure > *arg1 = (Handle<BlackVolTermStructure > *) 0 ;
  Date *arg2 = 0 ;
  Date *arg3 = 0 ;
  Real arg4 ;
  bool arg5 ;
  Real result;
  
  arg1 = (Handle<BlackVolTermStructure > *)jarg1; 
  arg2 = (Date *)jarg2;
  if(!arg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
    return 0;
  } 
  arg3 = (Date *)jarg3;
  if(!arg3) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
    return 0;
  } 
  arg4 = (Real)jarg4; 
  arg5 = jarg5 ? true : false; 
  {
    try {
      result = (Real)(*arg1)->blackForwardVariance((Date const &)*arg2,(Date const &)*arg3,arg4,arg5);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT double SWIGSTDCALL CSharp_BlackVolTermStructureHandle_blackForwardVariance__SWIG_1(void * jarg1, void * jarg2, void * jarg3, double jarg4) {
  double jresult ;
  Handle<BlackVolTermStructure > *arg1 = (Handle<BlackVolTermStructure > *) 0 ;
  Date *arg2 = 0 ;
  Date *arg3 = 0 ;
  Real arg4 ;
  Real result;
  
  arg1 = (Handle<BlackVolTermStructure > *)jarg1; 
  arg2 = (Date *)jarg2;
  if(!arg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
    return 0;
  } 
  arg3 = (Date *)jarg3;
  if(!arg3) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
    return 0;
  } 
  arg4 = (Real)jarg4; 
  {
    try {
      result = (Real)(*arg1)->blackForwardVariance((Date const &)*arg2,(Date const &)*arg3,arg4);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT double SWIGSTDCALL CSharp_BlackVolTermStructureHandle_blackForwardVariance__SWIG_2(void * jarg1, double jarg2, double jarg3, double jarg4, unsigned int jarg5) {
  double jresult ;
  Handle<BlackVolTermStructure > *arg1 = (Handle<BlackVolTermStructure > *) 0 ;
  Time arg2 ;
  Time arg3 ;
  Real arg4 ;
  bool arg5 ;
  Real result;
  
  arg1 = (Handle<BlackVolTermStructure > *)jarg1; 
  arg2 = (Time)jarg2; 
  arg3 = (Time)jarg3; 
  arg4 = (Real)jarg4; 
  arg5 = jarg5 ? true : false; 
  {
    try {
      result = (Real)(*arg1)->blackForwardVariance(arg2,arg3,arg4,arg5);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT double SWIGSTDCALL CSharp_BlackVolTermStructureHandle_blackForwardVariance__SWIG_3(void * jarg1, double jarg2, double jarg3, double jarg4) {
  double jresult ;
  Handle<BlackVolTermStructure > *arg1 = (Handle<BlackVolTermStructure > *) 0 ;
  Time arg2 ;
  Time arg3 ;
  Real arg4 ;
  Real result;
  
  arg1 = (Handle<BlackVolTermStructure > *)jarg1; 
  arg2 = (Time)jarg2; 
  arg3 = (Time)jarg3; 
  arg4 = (Real)jarg4; 
  {
    try {
      result = (Real)(*arg1)->blackForwardVariance(arg2,arg3,arg4);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_BlackVolTermStructureHandle_enableExtrapolation(void * jarg1) {
  Handle<BlackVolTermStructure > *arg1 = (Handle<BlackVolTermStructure > *) 0 ;
  
  arg1 = (Handle<BlackVolTermStructure > *)jarg1; 
  {
    try {
      (*arg1)->enableExtrapolation();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_BlackVolTermStructureHandle_disableExtrapolation(void * jarg1) {
  Handle<BlackVolTermStructure > *arg1 = (Handle<BlackVolTermStructure > *) 0 ;
  
  arg1 = (Handle<BlackVolTermStructure > *)jarg1; 
  {
    try {
      (*arg1)->disableExtrapolation();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT unsigned int SWIGSTDCALL CSharp_BlackVolTermStructureHandle_allowsExtrapolation(void * jarg1) {
  unsigned int jresult ;
  Handle<BlackVolTermStructure > *arg1 = (Handle<BlackVolTermStructure > *) 0 ;
  bool result;
  
  arg1 = (Handle<BlackVolTermStructure > *)jarg1; 
  {
    try {
      result = (bool)(*arg1)->allowsExtrapolation();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_LocalVolTermStructure___deref__(void * jarg1) {
  void * jresult ;
  boost::shared_ptr<LocalVolTermStructure > *arg1 = (boost::shared_ptr<LocalVolTermStructure > *) 0 ;
  LocalVolTermStructure *result = 0 ;
  
  arg1 = (boost::shared_ptr<LocalVolTermStructure > *)jarg1; 
  {
    try {
      result = (LocalVolTermStructure *)(arg1)->operator ->();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT unsigned int SWIGSTDCALL CSharp_LocalVolTermStructure_isNull(void * jarg1) {
  unsigned int jresult ;
  boost::shared_ptr<LocalVolTermStructure > *arg1 = (boost::shared_ptr<LocalVolTermStructure > *) 0 ;
  bool result;
  
  arg1 = (boost::shared_ptr<LocalVolTermStructure > *)jarg1; 
  {
    try {
      result = (bool)boost_shared_ptr_Sl_LocalVolTermStructure_Sg__isNull(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_LocalVolTermStructure_asObservable(void * jarg1) {
  void * jresult ;
  boost::shared_ptr<LocalVolTermStructure > *arg1 = (boost::shared_ptr<LocalVolTermStructure > *) 0 ;
  boost::shared_ptr<Observable > result;
  
  arg1 = (boost::shared_ptr<LocalVolTermStructure > *)jarg1; 
  {
    try {
      result = boost_shared_ptr_Sl_LocalVolTermStructure_Sg__asObservable(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = new boost::shared_ptr<Observable >((boost::shared_ptr<Observable > &)result); 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_LocalVolTermStructure() {
  void * jresult ;
  boost::shared_ptr<LocalVolTermStructure > *result = 0 ;
  
  {
    try {
      result = (boost::shared_ptr<LocalVolTermStructure > *)new boost::shared_ptr<LocalVolTermStructure >();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_LocalVolTermStructure(void * jarg1) {
  boost::shared_ptr<LocalVolTermStructure > *arg1 = (boost::shared_ptr<LocalVolTermStructure > *) 0 ;
  
  arg1 = (boost::shared_ptr<LocalVolTermStructure > *)jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_LocalVolTermStructure_referenceDate(void * jarg1) {
  void * jresult ;
  boost::shared_ptr<LocalVolTermStructure > *arg1 = (boost::shared_ptr<LocalVolTermStructure > *) 0 ;
  Date result;
  
  arg1 = (boost::shared_ptr<LocalVolTermStructure > *)jarg1; 
  {
    try {
      result = (*arg1)->referenceDate();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = new Date((Date &)result); 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_LocalVolTermStructure_dayCounter(void * jarg1) {
  void * jresult ;
  boost::shared_ptr<LocalVolTermStructure > *arg1 = (boost::shared_ptr<LocalVolTermStructure > *) 0 ;
  SwigValueWrapper<DayCounter > result;
  
  arg1 = (boost::shared_ptr<LocalVolTermStructure > *)jarg1; 
  {
    try {
      result = (*arg1)->dayCounter();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = new DayCounter((DayCounter &)result); 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_LocalVolTermStructure_calendar(void * jarg1) {
  void * jresult ;
  boost::shared_ptr<LocalVolTermStructure > *arg1 = (boost::shared_ptr<LocalVolTermStructure > *) 0 ;
  SwigValueWrapper<Calendar > result;
  
  arg1 = (boost::shared_ptr<LocalVolTermStructure > *)jarg1; 
  {
    try {
      result = (*arg1)->calendar();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = new Calendar((Calendar &)result); 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_LocalVolTermStructure_maxDate(void * jarg1) {
  void * jresult ;
  boost::shared_ptr<LocalVolTermStructure > *arg1 = (boost::shared_ptr<LocalVolTermStructure > *) 0 ;
  Date result;
  
  arg1 = (boost::shared_ptr<LocalVolTermStructure > *)jarg1; 
  {
    try {
      result = (*arg1)->maxDate();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = new Date((Date &)result); 
  return jresult;
}


SWIGEXPORT double SWIGSTDCALL CSharp_LocalVolTermStructure_maxTime(void * jarg1) {
  double jresult ;
  boost::shared_ptr<LocalVolTermStructure > *arg1 = (boost::shared_ptr<LocalVolTermStructure > *) 0 ;
  Time result;
  
  arg1 = (boost::shared_ptr<LocalVolTermStructure > *)jarg1; 
  {
    try {
      result = (Time)(*arg1)->maxTime();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT double SWIGSTDCALL CSharp_LocalVolTermStructure_minStrike(void * jarg1) {
  double jresult ;
  boost::shared_ptr<LocalVolTermStructure > *arg1 = (boost::shared_ptr<LocalVolTermStructure > *) 0 ;
  Real result;
  
  arg1 = (boost::shared_ptr<LocalVolTermStructure > *)jarg1; 
  {
    try {
      result = (Real)(*arg1)->minStrike();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT double SWIGSTDCALL CSharp_LocalVolTermStructure_maxStrike(void * jarg1) {
  double jresult ;
  boost::shared_ptr<LocalVolTermStructure > *arg1 = (boost::shared_ptr<LocalVolTermStructure > *) 0 ;
  Real result;
  
  arg1 = (boost::shared_ptr<LocalVolTermStructure > *)jarg1; 
  {
    try {
      result = (Real)(*arg1)->maxStrike();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT double SWIGSTDCALL CSharp_LocalVolTermStructure_localVol__SWIG_0(void * jarg1, void * jarg2, double jarg3, unsigned int jarg4) {
  double jresult ;
  boost::shared_ptr<LocalVolTermStructure > *arg1 = (boost::shared_ptr<LocalVolTermStructure > *) 0 ;
  Date *arg2 = 0 ;
  Real arg3 ;
  bool arg4 ;
  Volatility result;
  
  arg1 = (boost::shared_ptr<LocalVolTermStructure > *)jarg1; 
  arg2 = (Date *)jarg2;
  if(!arg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
    return 0;
  } 
  arg3 = (Real)jarg3; 
  arg4 = jarg4 ? true : false; 
  {
    try {
      result = (Volatility)(*arg1)->localVol((Date const &)*arg2,arg3,arg4);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT double SWIGSTDCALL CSharp_LocalVolTermStructure_localVol__SWIG_1(void * jarg1, void * jarg2, double jarg3) {
  double jresult ;
  boost::shared_ptr<LocalVolTermStructure > *arg1 = (boost::shared_ptr<LocalVolTermStructure > *) 0 ;
  Date *arg2 = 0 ;
  Real arg3 ;
  Volatility result;
  
  arg1 = (boost::shared_ptr<LocalVolTermStructure > *)jarg1; 
  arg2 = (Date *)jarg2;
  if(!arg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
    return 0;
  } 
  arg3 = (Real)jarg3; 
  {
    try {
      result = (Volatility)(*arg1)->localVol((Date const &)*arg2,arg3);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT double SWIGSTDCALL CSharp_LocalVolTermStructure_localVol__SWIG_2(void * jarg1, double jarg2, double jarg3, unsigned int jarg4) {
  double jresult ;
  boost::shared_ptr<LocalVolTermStructure > *arg1 = (boost::shared_ptr<LocalVolTermStructure > *) 0 ;
  Time arg2 ;
  Real arg3 ;
  bool arg4 ;
  Volatility result;
  
  arg1 = (boost::shared_ptr<LocalVolTermStructure > *)jarg1; 
  arg2 = (Time)jarg2; 
  arg3 = (Real)jarg3; 
  arg4 = jarg4 ? true : false; 
  {
    try {
      result = (Volatility)(*arg1)->localVol(arg2,arg3,arg4);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT double SWIGSTDCALL CSharp_LocalVolTermStructure_localVol__SWIG_3(void * jarg1, double jarg2, double jarg3) {
  double jresult ;
  boost::shared_ptr<LocalVolTermStructure > *arg1 = (boost::shared_ptr<LocalVolTermStructure > *) 0 ;
  Time arg2 ;
  Real arg3 ;
  Volatility result;
  
  arg1 = (boost::shared_ptr<LocalVolTermStructure > *)jarg1; 
  arg2 = (Time)jarg2; 
  arg3 = (Real)jarg3; 
  {
    try {
      result = (Volatility)(*arg1)->localVol(arg2,arg3);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_LocalVolTermStructure_enableExtrapolation(void * jarg1) {
  boost::shared_ptr<LocalVolTermStructure > *arg1 = (boost::shared_ptr<LocalVolTermStructure > *) 0 ;
  
  arg1 = (boost::shared_ptr<LocalVolTermStructure > *)jarg1; 
  {
    try {
      (*arg1)->enableExtrapolation();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_LocalVolTermStructure_disableExtrapolation(void * jarg1) {
  boost::shared_ptr<LocalVolTermStructure > *arg1 = (boost::shared_ptr<LocalVolTermStructure > *) 0 ;
  
  arg1 = (boost::shared_ptr<LocalVolTermStructure > *)jarg1; 
  {
    try {
      (*arg1)->disableExtrapolation();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT unsigned int SWIGSTDCALL CSharp_LocalVolTermStructure_allowsExtrapolation(void * jarg1) {
  unsigned int jresult ;
  boost::shared_ptr<LocalVolTermStructure > *arg1 = (boost::shared_ptr<LocalVolTermStructure > *) 0 ;
  bool result;
  
  arg1 = (boost::shared_ptr<LocalVolTermStructure > *)jarg1; 
  {
    try {
      result = (bool)(*arg1)->allowsExtrapolation();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_LocalVolTermStructureHandle__SWIG_0(void * jarg1) {
  void * jresult ;
  boost::shared_ptr<LocalVolTermStructure > *arg1 = 0 ;
  Handle<LocalVolTermStructure > *result = 0 ;
  
  arg1 = (boost::shared_ptr<LocalVolTermStructure > *)jarg1;
  if(!arg1) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "boost::shared_ptr<LocalVolTermStructure > const & type is null", 0);
    return 0;
  } 
  {
    try {
      result = (Handle<LocalVolTermStructure > *)new Handle<LocalVolTermStructure >((boost::shared_ptr<LocalVolTermStructure > const &)*arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_LocalVolTermStructureHandle__SWIG_1() {
  void * jresult ;
  Handle<LocalVolTermStructure > *result = 0 ;
  
  {
    try {
      result = (Handle<LocalVolTermStructure > *)new Handle<LocalVolTermStructure >();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_LocalVolTermStructureHandle___deref__(void * jarg1) {
  void * jresult ;
  Handle<LocalVolTermStructure > *arg1 = (Handle<LocalVolTermStructure > *) 0 ;
  boost::shared_ptr<LocalVolTermStructure > result;
  
  arg1 = (Handle<LocalVolTermStructure > *)jarg1; 
  {
    try {
      result = (arg1)->operator ->();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = new boost::shared_ptr<LocalVolTermStructure >((boost::shared_ptr<LocalVolTermStructure > &)result); 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_LocalVolTermStructureHandle_linkTo(void * jarg1, void * jarg2) {
  Handle<LocalVolTermStructure > *arg1 = (Handle<LocalVolTermStructure > *) 0 ;
  boost::shared_ptr<LocalVolTermStructure > *arg2 = 0 ;
  
  arg1 = (Handle<LocalVolTermStructure > *)jarg1; 
  arg2 = (boost::shared_ptr<LocalVolTermStructure > *)jarg2;
  if(!arg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "boost::shared_ptr<LocalVolTermStructure > const & type is null", 0);
    return ;
  } 
  {
    try {
      (arg1)->linkTo((boost::shared_ptr<LocalVolTermStructure > const &)*arg2);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT unsigned int SWIGSTDCALL CSharp_LocalVolTermStructureHandle_empty(void * jarg1) {
  unsigned int jresult ;
  Handle<LocalVolTermStructure > *arg1 = (Handle<LocalVolTermStructure > *) 0 ;
  bool result;
  
  arg1 = (Handle<LocalVolTermStructure > *)jarg1; 
  {
    try {
      result = (bool)(arg1)->empty();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_LocalVolTermStructureHandle_asObservable(void * jarg1) {
  void * jresult ;
  Handle<LocalVolTermStructure > *arg1 = (Handle<LocalVolTermStructure > *) 0 ;
  boost::shared_ptr<Observable > result;
  
  arg1 = (Handle<LocalVolTermStructure > *)jarg1; 
  {
    try {
      result = Handle_Sl_LocalVolTermStructure_Sg__asObservable(arg1);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = new boost::shared_ptr<Observable >((boost::shared_ptr<Observable > &)result); 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_LocalVolTermStructureHandle(void * jarg1) {
  Handle<LocalVolTermStructure > *arg1 = (Handle<LocalVolTermStructure > *) 0 ;
  
  arg1 = (Handle<LocalVolTermStructure > *)jarg1; 
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return ; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return ; 
      };
    }
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_LocalVolTermStructureHandle_referenceDate(void * jarg1) {
  void * jresult ;
  Handle<LocalVolTermStructure > *arg1 = (Handle<LocalVolTermStructure > *) 0 ;
  Date result;
  
  arg1 = (Handle<LocalVolTermStructure > *)jarg1; 
  {
    try {
      result = (*arg1)->referenceDate();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = new Date((Date &)result); 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_LocalVolTermStructureHandle_dayCounter(void * jarg1) {
  void * jresult ;
  Handle<LocalVolTermStructure > *arg1 = (Handle<LocalVolTermStructure > *) 0 ;
  SwigValueWrapper<DayCounter > result;
  
  arg1 = (Handle<LocalVolTermStructure > *)jarg1; 
  {
    try {
      result = (*arg1)->dayCounter();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = new DayCounter((DayCounter &)result); 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_LocalVolTermStructureHandle_calendar(void * jarg1) {
  void * jresult ;
  Handle<LocalVolTermStructure > *arg1 = (Handle<LocalVolTermStructure > *) 0 ;
  SwigValueWrapper<Calendar > result;
  
  arg1 = (Handle<LocalVolTermStructure > *)jarg1; 
  {
    try {
      result = (*arg1)->calendar();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = new Calendar((Calendar &)result); 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_LocalVolTermStructureHandle_maxDate(void * jarg1) {
  void * jresult ;
  Handle<LocalVolTermStructure > *arg1 = (Handle<LocalVolTermStructure > *) 0 ;
  Date result;
  
  arg1 = (Handle<LocalVolTermStructure > *)jarg1; 
  {
    try {
      result = (*arg1)->maxDate();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = new Date((Date &)result); 
  return jresult;
}


SWIGEXPORT double SWIGSTDCALL CSharp_LocalVolTermStructureHandle_maxTime(void * jarg1) {
  double jresult ;
  Handle<LocalVolTermStructure > *arg1 = (Handle<LocalVolTermStructure > *) 0 ;
  Time result;
  
  arg1 = (Handle<LocalVolTermStructure > *)jarg1; 
  {
    try {
      result = (Time)(*arg1)->maxTime();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT double SWIGSTDCALL CSharp_LocalVolTermStructureHandle_minStrike(void * jarg1) {
  double jresult ;
  Handle<LocalVolTermStructure > *arg1 = (Handle<LocalVolTermStructure > *) 0 ;
  Real result;
  
  arg1 = (Handle<LocalVolTermStructure > *)jarg1; 
  {
    try {
      result = (Real)(*arg1)->minStrike();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT double SWIGSTDCALL CSharp_LocalVolTermStructureHandle_maxStrike(void * jarg1) {
  double jresult ;
  Handle<LocalVolTermStructure > *arg1 = (Handle<LocalVolTermStructure > *) 0 ;
  Real result;
  
  arg1 = (Handle<LocalVolTermStructure > *)jarg1; 
  {
    try {
      result = (Real)(*arg1)->maxStrike();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT double SWIGSTDCALL CSharp_LocalVolTermStructureHandle_localVol__SWIG_0(void * jarg1, void * jarg2, double jarg3, unsigned int jarg4) {
  double jresult ;
  Handle<LocalVolTermStructure > *arg1 = (Handle<LocalVolTermStructure > *) 0 ;
  Date *arg2 = 0 ;
  Real arg3 ;
  bool arg4 ;
  Volatility result;
  
  arg1 = (Handle<LocalVolTermStructure > *)jarg1; 
  arg2 = (Date *)jarg2;
  if(!arg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
    return 0;
  } 
  arg3 = (Real)jarg3; 
  arg4 = jarg4 ? true : false; 
  {
    try {
      result = (Volatility)(*arg1)->localVol((Date const &)*arg2,arg3,arg4);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT double SWIGSTDCALL CSharp_LocalVolTermStructureHandle_localVol__SWIG_1(void * jarg1, void * jarg2, double jarg3) {
  double jresult ;
  Handle<LocalVolTermStructure > *arg1 = (Handle<LocalVolTermStructure > *) 0 ;
  Date *arg2 = 0 ;
  Real arg3 ;
  Volatility result;
  
  arg1 = (Handle<LocalVolTermStructure > *)jarg1; 
  arg2 = (Date *)jarg2;
  if(!arg2) {
    SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentNullException, "Date const & type is null", 0);
    return 0;
  } 
  arg3 = (Real)jarg3; 
  {
    try {
      result = (Volatility)(*arg1)->localVol((Date const &)*arg2,arg3);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT double SWIGSTDCALL CSharp_LocalVolTermStructureHandle_localVol__SWIG_2(void * jarg1, double jarg2, double jarg3, unsigned int jarg4) {
  double jresult ;
  Handle<LocalVolTermStructure > *arg1 = (Handle<LocalVolTermStructure > *) 0 ;
  Time arg2 ;
  Real arg3 ;
  bool arg4 ;
  Volatility result;
  
  arg1 = (Handle<LocalVolTermStructure > *)jarg1; 
  arg2 = (Time)jarg2; 
  arg3 = (Real)jarg3; 
  arg4 = jarg4 ? true : false; 
  {
    try {
      result = (Volatility)(*arg1)->localVol(arg2,arg3,arg4);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT double SWIGSTDCALL CSharp_LocalVolTermStructureHandle_localVol__SWIG_3(void * jarg1, double jarg2, double jarg3) {
  double jresult ;
  Handle<LocalVolTermStructure > *arg1 = (Handle<LocalVolTermStructure > *) 0 ;
  Time arg2 ;
  Real arg3 ;
  Volatility result;
  
  arg1 = (Handle<LocalVolTermStructure > *)jarg1; 
  arg2 = (Time)jarg2; 
  arg3 = (Real)jarg3; 
  {
    try {
      result = (Volatility)(*arg1)->localVol(arg2,arg3);
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (std::exception& e) {
      {
        SWIG_CSharpException(SWIG_RuntimeError, const_cast<char*>(e.what())); return 0; 
      };
    } catch (...) {
      {
        SWIG_CSharpException(SWIG_UnknownError, "unknown error"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_LocalVolTermStructureHandle_enableExtrapolation(void * jarg1) {
  Handle<LocalVolTermStructure > *arg1 = (Handle<LocalVolTermStructure > *) 0 ;
  
  arg1 = (Handle<LocalVolTermStructure > *)jarg1; 
  {
    try {
      (*arg1)->enableExtrapolation();
    } catch (std::out_of_range& e) {
      {
        SWIG_CSharpException(SWIG_IndexError, const_cast<char*>(e.what())); return ; 
      };
    } catch (std::exception& e) {
      {
    