/***************************************************************************
                          doublearray2d.h  -  description
                             -------------------
    begin                : Thu Dec 12 2002
    copyright            : (C) 2002 by Michael Herder
    email                : crapsite@gmx.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef DOUBLEARRAY2D_H
#define DOUBLEARRAY2D_H

#include <qarray.h>

/**
  *@author Michael Herder
  */

class DoubleArray2D
{
public: 
  DoubleArray2D(int dimx,int dimy);
  DoubleArray2D();
  ~DoubleArray2D();
  void resize(int dimx, int dimy);
  double at(int x, int y);
  void set(int x, int y, double val);
  void add(int x, int y, double val);
  void sub(int x, int y, double val);
  void multiply(int x, int y, double val);
  DoubleArray2D operator =(DoubleArray2D a);
  int cols();
  int rows();
  int x();
  int y();
  /** No descriptions */
  void detach();
  /** No descriptions */
  QArray <double> array();
private:
  int mDimX;
  int mDimY;
  QArray <double> mArray;
};

#endif
