@rem Build the jit package under Windows
@rem The "if errorlevel 1" tests against any err level greater than or equal to 1

@rem Don't forget to change version number both in the DESCRIPTION and below
@set JITVERSION=0.0-8
@set RAPATH=\a\r\ra
@set RAPATH1=/a/r/ra
@set RPATH=\PROGRA~1\R\R-2.7.1

@rem R needs a slightly different path to my standard path
@set | egrep -i "path=[^;]*Rtools" >NUL && goto :done @rem only do it if needed
@echo modifying path
@set path=c:\Rtools\bin;c:\Rtools\MinGW\bin;%PATH%
:done

@rem ===clean===
@rem @\rtools\mingw\bin\make.exe -f Makefile.win clean

@echo ===install to Ra===
@cd %RAPATH%\bin
           @if errorlevel 1 goto error 
%RAPATH%\bin\rcmd.exe INSTALL %RAPATH1%/src/library/jit
           @if errorlevel 1 goto error 

@echo ===convert jit.html etc. to web publishable form and copy to homepage===
@sed "s#Rchm.css#R.css#" /a/r/ra/library/jit/html/jit.html >xtmp1
                     @if errorlevel 1 goto error 
@sed "s#../../base/html/#http://cged.genes.nig.ac.jp/RGM2/R_current/library/base/html/#g" xtmp1 >xtmp2
                     @if errorlevel 1 goto error 
@sed "s#00Index.html#index.html#" xtmp2 > xtmp3
                     @if errorlevel 1 goto error 
@sed "s#<body>#<body bgcolor=\"\#e0e0e0\"><a><img src=\"ra.png\" alt=\"ra.png\" border=\"0\" align=\"right\"></a>#" xtmp3 > xtmp4
                     @if errorlevel 1 goto error 
@sed "s#<td align=\"right\">R Documentation</td>##" xtmp4 > xtmp5
                     @if errorlevel 1 goto error 
@dos2unix xtmp5
                     @if errorlevel 1 goto error 
@copy xtmp5 \a\homepage\ra\jit.html
                     @if errorlevel 1 goto error 
@rm -f xtmp1 xtmp2 xtmp3 xtmp4 xtmp5

@rem nojit.html
@sed "s#Rchm.css#R.css#" /a/r/ra/library/jit/html/nojit.html >xtmp1
                     @if errorlevel 1 goto error 
@sed "s#../../base/html/#http://cged.genes.nig.ac.jp/RGM2/R_current/library/base/html/#g" xtmp1 >xtmp2
                     @if errorlevel 1 goto error 
@sed "s#00Index.html#index.html#" xtmp2 > xtmp3
                     @if errorlevel 1 goto error 
@sed "s#<body>#<body bgcolor=\"\#e0e0e0\"><a><img src=\"ra.png\" alt=\"ra.png\" border=\"0\" align=\"right\"></a>#" xtmp3 > xtmp4
                     @if errorlevel 1 goto error 
@sed "s#<td align=\"right\">R Documentation</td>##" xtmp4 > xtmp5
                     @if errorlevel 1 goto error 
@dos2unix xtmp5
                     @if errorlevel 1 goto error 
@copy xtmp5 \a\homepage\ra\nojit.html
                     @if errorlevel 1 goto error 
@rm -f xtmp1 xtmp2 xtmp3 xtmp4 xtmp5

@rem isra.html
@sed "s#Rchm.css#R.css#" /a/r/ra/library/jit/html/is.ra.html >xtmp1
                     @if errorlevel 1 goto error 
@sed "s#../../base/html/#http://cged.genes.nig.ac.jp/RGM2/R_current/library/base/html/#g" xtmp1 >xtmp2
                     @if errorlevel 1 goto error 
@sed "s#00Index.html#index.html#" xtmp2 > xtmp3
                     @if errorlevel 1 goto error 
@sed "s#<body>#<body bgcolor=\"\#e0e0e0\"><a><img src=\"ra.png\" alt=\"ra.png\" border=\"0\" align=\"right\"></a>#" xtmp3 > xtmp4
                     @if errorlevel 1 goto error 
@sed "s#<td align=\"right\">R Documentation</td>##" xtmp4 > xtmp5
                     @if errorlevel 1 goto error 
@dos2unix xtmp5
                     @if errorlevel 1 goto error 
@copy xtmp5 \a\homepage\ra\is.ra.html
                     @if errorlevel 1 goto error 
@rm -f xtmp1 xtmp2 xtmp3 xtmp4 xtmp5

@rem @echo ===remove from Ra===
@rem @rm -rf %RAPATH1%/library/ra

@echo ===copy to standard installed R===
@mcp -r %RAPATH1%/library/jit %RPATH%/library

@echo ===build for gzip file release, also copy zip file to homepage===
@rm -rf %RAPATH%\library\jit
                @if errorlevel 1 goto error 
"%RAPATH%\bin\rcmd" BUILD --no-vignettes %RAPATH1%/src/library/jit
                @if errorlevel 1 goto error 
@cp ./jit_*.tar.gz /a/homepage/ra/tar
                @if errorlevel 1 goto error 
@mv ./jit_*.tar.gz %RAPATH1%/library
                @if errorlevel 1 goto error 
@ls -l %RAPATH1%/library/jit_*.tar.gz

@echo ===install from release to ra===
@rem you should build the release gzip file above before doing this
@cd %RAPATH%\bin
                @if errorlevel 1 goto error 
@rm -rf %RAPATH1%/library/jit
                @if errorlevel 1 goto error 
%RAPATH%\bin\rcmd.exe INSTALL ../library/jit_%JITVERSION%.tar.gz
                @if errorlevel 1 goto error 

@rem @echo ===check release with ra===
@rem @rem you should build the gzip file above and install before doing this
@rem @rem note that R_CHECK_SUBDIRS_NOCASE is 0 because it seems to cause false positives
@rem @rem results go into %RAPATH1%/bin/jit.Rcheck
@rem @cd %RAPATH%\bin
@rem                 @if errorlevel 1 goto error 
@rem @set _R_CHECK_USE_CODETOOLS_=1
@rem                 @if errorlevel 1 goto error 
@rem @set _R_CHECK_ALL_NON_ISO_C_=1
@rem                 @if errorlevel 1 goto error 
@rem @set _R_CHECK_RD_STYLE_=1
@rem                 @if errorlevel 1 goto error 
@rem @set _R_CHECK_SUBDIRS_NOCASE_=0
@rem                 @if errorlevel 1 goto error 
@rem %RAPATH%\bin\rcmd.exe check %RAPATH%/library/jit_%JITVERSION%.tar.gz
@rem                 @if errorlevel 1 goto error 

@echo ===install from release to installed R===
@rem you should build the release gzip file above before doing this
cd %RPATH%\bin
                @if errorlevel 1 goto error 
rm -rf %RPATH1%/library/jit
                @if errorlevel 1 goto error 
%RPATH%\bin\rcmd.exe INSTALL %RAPATH%/library/jit_%JITVERSION%.tar.gz
                @if errorlevel 1 goto error 

@echo ===check release with installed R===
@rem you should build the gzip file above and install before doing this
@rem note that R_CHECK_SUBDIRS_NOCASE is 0 because it seems to cause false positives
@rem results go into %RAPATH1%/bin/jit.Rcheck
cd %RPATH%\bin
                @if errorlevel 1 goto error 
@set _R_CHECK_USE_CODETOOLS_=1
                @if errorlevel 1 goto error 
@set _R_CHECK_ALL_NON_ISO_C_=1
                @if errorlevel 1 goto error 
@set _R_CHECK_RD_STYLE_=1
                @if errorlevel 1 goto error 
@set _R_CHECK_SUBDIRS_NOCASE_=0
                @if errorlevel 1 goto error 
%RPATH%\bin\rcmd.exe check %RAPATH%/library/jit_%JITVERSION%.tar.gz
                @if errorlevel 1 goto error 

@goto done
:error
@echo ====ERROR====
:done
cd %RAPATH%\src\library\jit\.#
