% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_qvalue.R
\name{write.qvalue}
\alias{write.qvalue}
\title{Write results to file}
\usage{
write.qvalue(x, file = NULL, sep = " ", eol = "\\n", na = "NA",
  row.names = FALSE, col.names = TRUE)
}
\arguments{
\item{x}{A q-value object.}

\item{file}{Output filename (optional).}

\item{sep}{Separation between columns.}

\item{eol}{Character to print at the end of each line.}

\item{na}{String to use when there are missing values.}

\item{row.names}{logical. Specify whether row names are to be printed.}

\item{col.names}{logical. Specify whether column names are to be printed.}
}
\value{
Nothing of interest.
}
\description{
Write the results of the q-value object to a file.
}
\details{
The output file includes: (i) p-values, (ii)
q-values (iii) local FDR values, and (iv) the estimate of \eqn{\pi_0}{pi_0},
one per line. If an FDR significance
level was specified in the call to \code{\link{qvalue}}, the significance
level is printed and an indicator of significance is included.
}
\examples{
# import data
data(hedenfalk)
p <- hedenfalk$p

# write q-value object
qobj <- qvalue(p)
write.qvalue(qobj, file="myresults.txt")
}
\author{
John D. Storey, Andrew J. Bass
}
\seealso{
\code{\link{qvalue}}, \code{\link{plot.qvalue}},
  \code{\link{summary.qvalue}}
}
\keyword{write.qvalue}

