% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R, R/methods_row.R
\name{colWeightedMeans,xgCMatrix-method}
\alias{colWeightedMeans,xgCMatrix-method}
\alias{rowWeightedMeans,xgCMatrix-method}
\title{Calculates the weighted mean for each row (column) of a matrix-like object}
\usage{
\S4method{colWeightedMeans}{xgCMatrix}(x, w = NULL, rows = NULL, cols = NULL, na.rm = FALSE)

\S4method{rowWeightedMeans}{xgCMatrix}(x, w = NULL, rows = NULL, cols = NULL, na.rm = FALSE)
}
\arguments{
\item{x}{An NxK matrix-like object.}

\item{w}{A \code{\link{numeric}} vector of length K (N) that specifies by
how much each element is weighted.}

\item{rows}{A \code{\link{vector}} indicating the subset of rows
(and/or columns) to operate over. If \code{\link{NULL}}, no subsetting is
done.}

\item{cols}{A \code{\link{vector}} indicating the subset of rows
(and/or columns) to operate over. If \code{\link{NULL}}, no subsetting is
done.}

\item{na.rm}{If \code{\link[base:logical]{TRUE}}, \code{\link{NA}}s
are excluded first, otherwise not.}
}
\value{
Returns a \code{\link{numeric}} \code{\link{vector}} of length N (K).
}
\description{
Calculates the weighted  mean for each row (column) of a matrix-like object.
}
\details{
The S4 methods for \code{x} of type \code{\link{matrix}},
\code{\link{array}}, or \code{\link{numeric}} call
\code{matrixStats::rowWeightedMeans}
/ \code{matrixStats::colWeightedMeans}.
}
\examples{
mat <- matrix(rnorm(15), nrow = 5, ncol = 3)
  mat[2, 1] <- NA
  mat[3, 3] <- Inf
  mat[4, 1] <- 0
  
  print(mat)
  w <- rnorm(n = 5, mean = 3)
  rowWeightedMeans(mat, w = w[1:3])
  colWeightedMeans(mat, w = w)
}
\seealso{
\itemize{
\item \code{matrixStats::\link[matrixStats]{rowWeightedMeans}()} and
\code{matrixStats::\link[matrixStats:rowWeightedMeans]{colWeightedMeans}()}
which are used when the input is a \code{matrix} or \code{numeric} vector.
\item See also \link[MatrixGenerics]{rowMeans2} for the corresponding unweighted function.
}
}
