% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rcmd-process.R
\name{rcmd_process}
\alias{rcmd_process}
\title{External R CMD Process}
\description{
An \code{R CMD *} command that runs in the background. This is an R6 class
that extends the \link{process} class.
}
\section{Usage}{
\preformatted{rp <- rcmd_process$new(options)
}
}

\section{Arguments}{

\itemize{
\item \code{options} A list of options created via \code{\link[=rcmd_process_options]{rcmd_process_options()}}.
}
}

\section{Details}{

\code{rcmd_process$new} creates a new instance. Its \code{options} argument is
best created by the \code{\link[=rcmd_process_options]{rcmd_process_options()}} function.
}

\examples{
\dontrun{
options <- rcmd_process_options(cmd = "config", cmdargs = "CC")
rp <- rcmd_process$new(options)
rp$wait()
rp$read_output_lines()
}
}
