% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/schema.R
\name{in_schema}
\alias{in_schema}
\title{Refer to a table in a schema}
\usage{
in_schema(schema, table)
}
\arguments{
\item{schema, table}{Names of schema and table.}
}
\description{
Refer to a table in a schema
}
\examples{
in_schema("my_schema", "my_table")

# Example using schemas with SQLite
con <- DBI::dbConnect(RSQLite::SQLite(), ":memory:")
src <- src_dbi(con, auto_disconnect = TRUE)

# Add auxilary schema
tmp <- tempfile()
DBI::dbExecute(con, paste0("ATTACH '", tmp, "' AS aux"))

library(dplyr, warn.conflicts = FALSE)
copy_to(con, iris, "df", temporary = FALSE)
copy_to(con, mtcars, in_schema("aux", "df"), temporary = FALSE)

con \%>\% tbl("df")
con \%>\% tbl(in_schema("aux", "df"))
}
