% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oauth-app.r
\name{oauth_app}
\alias{oauth_app}
\title{Create an OAuth application.}
\usage{
oauth_app(appname, key, secret = NULL)
}
\arguments{
\item{appname}{name of the application.  This is not used for OAuth, but
is used to make it easier to identify different applications and
provide a consistent way of storing secrets in environment variables.}

\item{key}{consumer key (equivalent to a user name)}

\item{secret}{consumer secret. This is not equivalent to a password, and
  is not really a secret. If you are writing an API wrapper package, it
  is fine to include this secret in your package code.

  Use \code{NULL} to not store a secret: this is useful if you're relying on
  cached OAuth tokens.}
}
\description{
The OAuth framework doesn't match perfectly to use from R. Each user of the
package for a particular OAuth enabled site must create their own
application. See the demos for instructions on how to do this for
linkedin, twitter, vimeo, facebook, github and google.
}
\examples{
\dontrun{
# These work on my computer because I have the right envvars set up
linkedin_app <- oauth_app("linkedin", key = "outmkw3859gy")
github_app <- oauth_app("github", "56b637a5baffac62cad9")
}

# If you're relying on caching, supply an explicit NULL to
# suppress the warning message
oauth_app("my_app", "mykey")
oauth_app("my_app", "mykey", NULL)
}
\seealso{
Other OAuth: \code{\link{oauth1.0_token}},
  \code{\link{oauth2.0_token}},
  \code{\link{oauth_endpoint}},
  \code{\link{oauth_service_token}}
}

