% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_FastRatio.R
\name{calc_FastRatio}
\alias{calc_FastRatio}
\title{Calculate the Fast Ratio for CW-OSL curves}
\usage{
calc_FastRatio(object, stimulation.power = 30.6, wavelength = 470,
  sigmaF = 2.6e-17, sigmaM = 4.28e-18, Ch_L1 = 1, x = 1, x2 = 0.1,
  dead.channels = c(0, 0), fitCW.sigma = FALSE, fitCW.curve = FALSE,
  plot = TRUE, ...)
}
\arguments{
\item{object}{\code{\linkS4class{RLum.Analysis}}, 
\code{\linkS4class{RLum.Data.Curve}} or \code{\link{data.frame}} 
(\bold{required}): x, y data of measured values (time and counts).}

\item{stimulation.power}{\code{\link{numeric}} (with default): Stimulation power in mW/cm^2}

\item{wavelength}{\code{\link{numeric}} (with default): Stimulation wavelength in nm}

\item{sigmaF}{\code{\link{numeric}} (with default): Photoionisation cross-section (cm^2) of the
fast component. Default value after Durcan & Duller (2011).}

\item{sigmaM}{\code{\link{numeric}} (with default): Photoionisation cross-section (cm^2) of the
medium component. Default value after Durcan & Duller (2011).}

\item{Ch_L1}{\code{\link{numeric}} (with default): An integer specifying the channel for L1.}

\item{x}{\code{\link{numeric}} (with default): \% of signal remaining from the fast component.
Used to define the location of L2 and L3 (start).}

\item{x2}{\code{\link{numeric}} (with default): \% of signal remaining from the medium component.
Used to define the location of L3 (end).}

\item{dead.channels}{\code{\link{numeric}} (with default): Vector of length 2 in the form of
\code{c(x, y)}. Channels that do not contain OSL data, i.e. at the start or end of
measurement.}

\item{fitCW.sigma}{\code{\link{logical}} (optional): fit CW-OSL curve using \code{\link{fit_CWCurve}}
to calculate \code{sigmaF} and \code{sigmaM} (experimental).}

\item{fitCW.curve}{\code{\link{logical}} (optional): fit CW-OSL curve using \code{\link{fit_CWCurve}}
and derive the counts of L2 and L3 from the fitted OSL curve (experimental).}

\item{plot}{\code{\link{logical}} (with default): plot output (\code{TRUE}/\code{FALSE})}

\item{...}{available options: \code{verbose} (\code{\link{logical}}). Further
arguments passed to \code{\link{fit_CWCurve}}.}
}
\value{
Returns a plot (optional) and an S4 object of type \code{\linkS4class{RLum.Results}}. 
The slot \code{data} contains a \code{\link{list}} with the following elements:\cr

\item{summary}{\code{\link{data.frame}} summary of all relevant results}
\item{data}{the original input data}
\item{fit}{\code{\linkS4class{RLum.Results}} object if either \code{fitCW.sigma} or \code{fitCW.curve} is \code{TRUE}}
\item{args}{\code{\link{list}} of used arguments}
\item{call}{\code{\link{call}} the function call}
}
\description{
Function to calculate the fast ratio of quartz CW-OSL single grain or single 
aliquot curves after Durcan & Duller (2011).
}
\details{
This function follows the equations of Durcan & Duller (2011). The energy
required to reduce the fast and medium quartz OSL components to \code{x} and
\code{x2} \% respectively using eq. 3 to determine channels L2 and L3 (start 
and end). The fast ratio is then calculated from: \eqn{(L1-L3)/(L2-L3)}.
}
\section{Function version}{
 0.1.0 (2016-05-02 09:36:06)
}
\examples{
# load example CW-OSL curve
data("ExampleData.CW_OSL_Curve")

# calculate the fast ratio w/o further adjustments
res <- calc_FastRatio(ExampleData.CW_OSL_Curve)

# show the summary table
get_RLum(res)

}
\author{
Georgina King, University of Cologne (Germany) \cr
Julie A. Durcan, University of Oxford (United Kingdom) \cr
Christoph Burow, University of Cologne (Germany) \cr
\cr R Luminescence Package Team}
\references{
Durcan, J.A. & Duller, G.A.T., 2011. The fast ratio: A rapid measure for testing
the dominance of the fast component in the initial OSL signal from quartz.
Radiation Measurements 46, 1065-1072. \cr\cr

Madsen, A.T., Duller, G.A.T., Donnelly, J.P., Roberts, H.M. & Wintle, A.G., 2009.
A chronology of hurricane landfalls at Little Sippewissett Marsh, Massachusetts, USA,
using optical dating. Geomorphology 109, 36-45. \cr\cr

\bold{Further reading} \cr\cr

Steffen, D., Preusser, F. & Schlunegger, 2009. OSL quartz age underestimation 
due to unstable signal components. Quaternary Geochronology 4, 353-362.
}
\seealso{
\code{\link{fit_CWCurve}}, \code{\link{get_RLum}}, \code{\linkS4class{RLum.Analysis}},
\code{\linkS4class{RLum.Results}}, \code{\linkS4class{RLum.Data.Curve}}
}

