% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search_any_match_paged.R
\name{search_any_match_paged}
\alias{search_any_match_paged}
\title{Search for any matched page}
\usage{
search_any_match_paged(x, pagesize = NULL, pagenum = NULL, ascend = NULL,
  wt = "json", raw = FALSE, ...)
}
\arguments{
\item{x}{text or taxonomic serial number (TSN) (character or numeric)}

\item{pagesize}{An integer containing the page size (numeric)}

\item{pagenum}{An integer containing the page number (numeric)}

\item{ascend}{A boolean containing true for ascending sort order or false
for descending (logical)}

\item{wt}{(character) One of "json" or "xml". Required.}

\item{raw}{(logical) Return raw JSON or XML as character string. Required.
Default: \code{FALSE}}

\item{...}{Curl options passed on to \code{\link[httr]{GET}}}
}
\value{
a data.frame

a data.frame
}
\description{
Search for any matched page
}
\examples{
\dontrun{
search_any_match_paged(x=202385, pagesize=100, pagenum=1, ascend=FALSE)
search_any_match_paged(x="Zy", pagesize=100, pagenum=1, ascend=FALSE)
}
}
\seealso{
\code{\link{search_anymatch}}
}

