/*
 * This Game is distributed under the GNU GENERAL PUBLIC LICENSE
 * version 2. See COPYING for details.
 *
 * Copyright (C) 1999, 2000, 2001 Harry Storbacka <harrysto@nic.fi>
 * 
 * Race homepage: http://race.sourceforge.net 
*/

#include <ClanLib/core.h>
#include <ClanLib/display.h>

#include "../tile_enums.h"
#include "../graphics.h"
#include "../rect.h"
#include "../texture.h"
#include "../object_3d.h"
#include "../height_map.h"

#include "house.h"


std::vector<Object3D*> House::house_1x1;
std::vector<Object3D*> House::house_2x2;
std::vector<Object3D*> House::house_5x3;
std::vector<Object3D*> House::house_3x5;
std::vector<Object3D*> House::house_5x5;

std::vector<Texture> House::house_1x1_tex;
std::vector<Texture> House::house_2x2_tex;
std::vector<Texture> House::house_5x3_tex;
std::vector<Texture> House::house_3x5_tex;
std::vector<Texture> House::house_5x5_tex;

void House::draw( int x, int y, float z, int item )
{	
	if( HeightMap::under_water(x,y,z) )
		return;

	int item_num = Items(item);
	if(!((item_num >= 30 && item_num <= 39)
	   || (item_num >= 200 && item_num <= 239)))
	{
		return;
	}
	
	glPushMatrix();
	glTranslatef(x,y,z);
	
	// 1x1
	if( item >= Items( HOUSE_SMALL_1 )
	   && (unsigned)item < (Items(HOUSE_SMALL_1) + house_1x1.size()))
	{
		house_1x1_tex[item_num-HOUSE_SMALL_1].bind();
		house_1x1[item_num-HOUSE_SMALL_1]->draw();
	}

	// 2x2
	if( item >= Items( HOUSE_1 )
	   && (unsigned)item < (Items(HOUSE_1) + house_2x2.size()))
	{
		house_2x2_tex[item_num-HOUSE_1].bind();
		house_2x2[item_num-HOUSE_1]->draw();
	}

	// 5x3
	if( item >= Items( HOUSE_BIG_H_1 )
	   && (unsigned)item < (Items(HOUSE_BIG_H_1) + house_5x3.size()))
	{
		house_5x3_tex[item_num-HOUSE_BIG_H_1].bind();
		house_5x3[item_num-HOUSE_BIG_H_1]->draw();
	}

	// 3x5
	if( item >= Items( HOUSE_BIG_V_1 )
	   && (unsigned)item < (Items(HOUSE_BIG_V_1) + house_3x5.size()))
	{
		// todo: delete this and add a rotation value to everything
	}

	// 5x5
	if( item >= Items( HOUSE_BIG_HV_1 )
	   && (unsigned)item < (Items(HOUSE_BIG_HV_1) + house_5x5.size()))
	{
		house_5x5_tex[item_num-HOUSE_BIG_HV_1].bind();
		house_5x5[item_num-HOUSE_BIG_HV_1]->draw();
	}
	
	glPopMatrix();
}







void House::load( CL_ResourceManager &res )
{
//	unload();

	load_1x1( res );
	load_2x2( res );
	load_3x5( res );
	load_5x3( res );
	load_5x5( res );
}



void House::unload()
{
/*	house_1x1_tex.clear();
	house_2x2_tex.clear();
	house_5x3_tex.clear();
	house_3x5_tex.clear();
	house_5x5_tex.clear();
*/	
	house_1x1.clear();
	house_2x2.clear();
	house_5x3.clear();
	house_3x5.clear();
	house_5x5.clear();
}


void House::load_1x1( CL_ResourceManager &res )
{
	// todo load_1x1
}


void House::load_2x2( CL_ResourceManager &res )
{
	int i, num_items = CL_Integer( "houses/2x2/num_items", &res );
	CL_String res_base_name = "houses/2x2/house_";
	
	for( i=0; i < num_items; i++ )
	{
		// set resource name.
		CL_String res_name = res_base_name;
		res_name += i;
		
		// load model.
		house_2x2.push_back( Object3D::load(res_name, &res) );
		
		// texture
		res_name += "_tex";
		house_2x2_tex.push_back( Texture( CL_Surface::load( res_name, &res) ));
	}
}


void House::load_5x3( CL_ResourceManager &res )
{
	int i, num_items = CL_Integer( "houses/5x3/num_items", &res );
	CL_String res_base_name = "houses/5x3/house_";
	
	for( i=0; i < num_items; i++ )
	{
		// set resource name.
		CL_String res_name = res_base_name;
		res_name += i;
		
		// load model.
		house_5x3.push_back( Object3D::load(res_name, &res) );
		
		// texture
		res_name += "_tex";
		house_5x3_tex.push_back( Texture( CL_Surface::load( res_name, &res) ));
	}
}

void House::load_3x5( CL_ResourceManager &res )
{
	// delete
}

void House::load_5x5( CL_ResourceManager &res )
{
	//
}



void House::modify_base( float x, float y, int item, float r, CL_Canvas *canvas )
{
	if( item >= HOUSE_1 && item <= HOUSE_10
		&& (unsigned)item < (Items(HOUSE_1) + house_2x2.size()))
		canvas->fill_rect( x*12.5f-12.5f, y*12.5f-12.5f, (x*12.5f)+37.5f, (y*12.5f)+37.5f, r, r, r );
	
	if( item >= HOUSE_BIG_H_1 && item <= HOUSE_BIG_H_10
		&& (unsigned)item < (Items(HOUSE_BIG_H_1) + house_5x3.size()))
		canvas->fill_rect( x*12.5f-12.5f, y*12.5f-12.5f, (x*12.5f)+(5*12.5f), (y*12.5f)+(4*12.5f), r, r, r );
			
	if( item >= HOUSE_BIG_V_1 && item <= HOUSE_BIG_V_10
		&& (unsigned)item < (Items(HOUSE_BIG_V_1) + house_3x5.size()))
		canvas->fill_rect( x*12.5f, y*12.5f, (x*12.5f)+(3*12.5f), (y*12.5f)+(5*12.5f), r, r, r );
	
	if( item >= HOUSE_BIG_HV_1 && item <= HOUSE_BIG_HV_10
		&& (unsigned)item < (Items(HOUSE_BIG_HV_1) + house_5x5.size()))
		canvas->fill_rect( x*12.5f, y*12.5f, (x*12.5f)+(5*12.5f), (y*12.5f)+(5*12.5f), r, r, r );
}
