#include "allegro.h"
#include "rgbhandle.h"
#include "defs.h"

RGBHandle::RGBHandle() {
	rwant = rnd( 255 );
	gwant = rnd( 255 );
	bwant = rnd( 255 );

	mine.r = rwant;
	mine.g = gwant;
	mine.b = bwant;

}


void RGBHandle::update( int max, int min ) {

	unsigned char * want[ 3 ];
	want[0] = &rwant;
	want[1] = &gwant;
	want[2] = &bwant;

	if ( changecol( mine.r, rwant ) ) {
		if ( rnd( RGB_GO_BLACK ) == rnd( RGB_GO_BLACK ) )
			rwant = 0;
		else    rwant = rnd(max-min)+min;
	}

	if ( changecol( mine.g, gwant ) ) {
		if ( rnd( RGB_GO_BLACK ) == rnd( RGB_GO_BLACK ) )
			gwant = 0;
		else    gwant = rnd(max-min)+min;
	}

	if ( changecol( mine.b, bwant ) ) {
		if ( rnd( RGB_GO_BLACK ) == rnd( RGB_GO_BLACK ) )
			bwant = 0;
		else    bwant = rnd(max-min)+min;
	}

	bool cy = false;
	for ( int q = 0; q < 3; q++ )
		cy = cy || (*(want[q]) >= min && *(want[q]) <= max);
	if ( !cy ) *(want[rnd(3)]) = rnd(max-min)+min;
	cy = true;
	for ( int q = 0; q < 3; q++ )
		cy = cy && *(want[q]) == 0;
	if ( cy ) *(want[rnd(3)]) = rnd(max-min)+min;

}


int RGBHandle::Get( ) {
	return makecol( mine.r, mine.g, mine.b );
}


bool RGBHandle::changecol( unsigned char & c, unsigned char & dir ) {

	for ( int q = 0; q < 2; q++ ) {
		if ( c > dir ) c--;
		if ( c < dir ) c++;
	}

	return c == dir;

}
