/*
 * @LANG: c++
 * Convert an string to an integer.
 */

#include <iostream>
#include <stdlib.h>
#include <stdio.h>

using namespace std;

struct AtoI
{
	bool neg;
	int val;
	int cs;

	// Initialize the machine. Invokes any init statement blocks. Returns 0
	// if the machine begins in a non-accepting state and 1 if the machine
	// begins in an accepting state.
	void init( );

	// Execute the machine on a block of data. Returns -1 if after processing
	// the data, the machine is in the error state and can never accept, 0 if
	// the machine is in a non-accepting state and 1 if the machine is in an
	// accepting state.
	void execute( const char *data, int len );

	// Indicate that there is no more data. Returns -1 if the machine finishes
	// in the error state and does not accept, 0 if the machine finishes
	// in any other non-accepting state and 1 if the machine finishes in an
	// accepting state.
	int finish( );
};

%%{
	machine AtoI;

	action begin {
		neg = false;
		val = 0;
	}

	action see_neg {
		neg = true;
	}

	action add_digit { 
		val = val * 10 + (fc - '0');
	}

	action finish {
		if ( neg )
			val = -1 * val;
	}

	atoi = (
		('-'@see_neg | '+')? (digit @add_digit)+
	) >begin %finish;

	main := atoi '\n';
}%%

%% write data;

void AtoI::init( )
{
	%% write init;
}

void AtoI::execute( const char *data, int len )
{
	const char *p = data;
	const char *pe = data+len;

	%% write exec;
}

int AtoI::finish( )
{
	%% write eof;
	if ( cs == AtoI_error )
		return -1;
	if ( cs >= AtoI_first_final )
		return 1;
	return 0;
}

void run_test( char *buf )
{
	AtoI atoi;
	atoi.init();
	atoi.execute( buf, strlen(buf) );
	if ( atoi.finish() > 0 )
		cout << atoi.val << endl;
	else
		cout << "FAIL" << endl;
}

int main()
{
	run_test( "1\n" );
	run_test( "12\n" );
	run_test( "222222\n" );
	run_test( "+2123\n" );
	run_test( "213 3213\n" );
	run_test( "-12321\n" );
	run_test( "--123\n" );
	run_test( "-99\n" );
	run_test( " -3000\n" );
	return 0;
}

#ifdef _____OUTPUT_____
1
12
222222
2123
FAIL
-12321
FAIL
-99
FAIL
#endif
