/*
 * @LANG: c++
 * @ALLOW_GENFLAGS: -T0 -T1 -F0 -F1 -G0 -G1 -G2 -P
 */

/*
 * Test error actions.
 */

#include <iostream>
#include <stdio.h>
#include <string.h>
#include "eofact.h"

using namespace std;

%%{
	machine eofact;

	action a1 { /* a1 */ }

	main := (
		'hello' %/ a1 '\n'? |
		'there' %/ a1
	);

	access fsm->;
}%%

%% write data;

void test( char *data )
{
	struct eofact fsm_inst;
	struct eofact *fsm = &fsm_inst;
	char *p = data;
	char *pe = data + strlen(data);

	%% write init;
	%% write exec;
	%% write eof;

	if ( fsm->cs >= eofact_first_final )
		cout << "ACCEPT" << endl;
	else
		cout << "FAIL" << endl;
}

#define BUFSIZE 1024


int main()
{
	test( "hello" );
	test( "there" );
	test( "friend" );
	return 0;
}

#ifdef _____OUTPUT_____
ACCEPT
ACCEPT
FAIL
#endif
