/*
 * @LANG: c
 */

/*
 * Test in and out state actions.
 */

#include <stdio.h>
#include <string.h>

struct state_act 
{
	int cs;
};

%%{
	machine state_act;
	variable curstate fsm->cs;

	action a1 { printf( "a1\n"); }
	action a2 { printf( "a2\n"); }
	action b1 { printf( "b1\n"); }
	action b2 { printf( "b2\n"); }
	action c1 { printf( "c1\n"); }
	action c2 { printf( "c2\n"); }

	hi = 'hi';
	main := ( again: hi >~b1 >*b2 '\n' >~c1 >*c2 @{fnext again;} )* >~a1 >*a2;
}%%

%% write data;

void state_act_init( struct state_act *fsm )
{
	%% write init;
}

void state_act_execute( struct state_act *fsm, const char *_data, int _len )
{
	const char *p = _data;
	const char *pe = _data+_len;

	%% write exec;
}

int state_act_finish( struct state_act *fsm )
{
	%% write eof;

	if ( fsm->cs == state_act_error )
		return -1;
	if ( fsm->cs >= state_act_first_final )
		return 1;
	return 0;
}

struct state_act sa;

void test( char *buf )
{
	int len = strlen( buf );
	state_act_init( &sa );
	state_act_execute( &sa, buf, len );
	state_act_finish( &sa );
}

int main()
{
	test(
		"hi\n"
		"hi\n"
	);

	return 0;
}

#ifdef _____OUTPUT_____
a2
b2
c1
c2
b1
b2
c1
c2
b1
#endif
