/*

  rawtran -  test suite
  Copyright (C) 2016  Filip Hroch, Masaryk University, Brno, CZ

  Rawtran is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  Rawtran is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with Rawtran.  If not, see <http://www.gnu.org/licenses/>.

*/

#include <fitsio.h>
#include <string.h>


#define FILENAME "IMG_5952.fits"

int main(int argc, char *argv[])
{

  fitsfile *f;
  int status, bitpix, naxis, nullval=0, fpixel=1, n, i;
  long naxes[3];
  char line[FLEN_CARD];
  int *pic;

  pic = NULL;
  status = 0;
  fits_open_image(&f,FILENAME, READONLY, &status);
  if( status != 0 ) goto crash;

  fits_get_img_type(f,&bitpix,&status);
  if( status != 0 || bitpix != 16 ) goto crash;

  fits_get_img_dim(f,&naxis,&status);
  if( status != 0 || naxis != 3 ) goto crash;

  fits_read_key(f,TSTRING,"CSPACE",line,NULL,&status);
  if( status != 0 || strstr(line,"XYZ") == NULL ) goto crash;

  fits_get_img_size(f,3,naxes,&status);
  if( status != 0 || naxes[0] != 3522 || naxes[1] != 2348 || naxes[2] != 3 ) goto crash;

  n = 1; for( i = 0; i < naxis; i++) n = n*naxes[i];
  pic = malloc(n*sizeof(int));
  if( pic == NULL ) goto crash;

  fits_read_img(f,TINT,fpixel,n,&nullval,pic,&i,&status);
  if( status != 0 || pic[1759*naxes[0]+1471] != 11220  ) goto crash;
  free(pic);

  fits_close_file(f, &status);
  if( status != 0 ) goto crash;

  return 0;

 crash:

  fits_close_file(f, &status);
  free(pic);

  return 1;
}
