#include "rcui.h"

#include <engine/engine.h>
#include "engine/engine-private.h"

extern RcEngine *RC_engine;

char *
save_file (const char * title, const char *okstock, GtkWidget * parent)
{
	GtkWidget *dialog;
	char *filename = NULL;

	dialog = gtk_file_chooser_dialog_new (title,
										  GTK_WINDOW (parent),
										  GTK_FILE_CHOOSER_ACTION_SAVE,
										  GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL,
										  okstock, GTK_RESPONSE_ACCEPT,
										  NULL);

	if (gtk_dialog_run (GTK_DIALOG (dialog)) == GTK_RESPONSE_ACCEPT)
		{
			
			filename = gtk_file_chooser_get_filename (GTK_FILE_CHOOSER (dialog));
		}
	
	gtk_widget_destroy (dialog);

	return filename;
}

void
on_new1_activate                       (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  RCUI_clean_state (ui_stores.mainw_store);
}


void
on_open1_activate                      (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  GtkWidget *dialog;
  GtkWidget *parent = GTK_WIDGET(user_data);

  dialog = gtk_file_chooser_dialog_new ("Ouvrir un fichier",
				      GTK_WINDOW (parent),
				      GTK_FILE_CHOOSER_ACTION_OPEN,
				      GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL,
				      GTK_STOCK_OPEN, GTK_RESPONSE_ACCEPT,
				      NULL);

  if (gtk_dialog_run (GTK_DIALOG (dialog)) == GTK_RESPONSE_ACCEPT)
  {
    char *filename;

    filename = gtk_file_chooser_get_filename (GTK_FILE_CHOOSER (dialog));

    if (!RCUI_load_state_from_file (ui_stores.mainw_store, filename))
      g_print(_("Error: file %s could not be recognized as a rcalc file\n"), filename);
      
    g_free (filename);
  }

  gtk_widget_destroy (dialog);  
}


void
on_save1_activate                      (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  if (ui_params.saveas)
    RCUI_save_state_to_file (ui_stores.mainw_store, ui_params.saveas);
  
  else
    on_save_as1_activate(menuitem, user_data);
}


void
on_save_as1_activate                   (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  char * filename;
  GtkWidget *parent = GTK_WIDGET(user_data);

	filename = save_file (_("Save as..."), GTK_STOCK_SAVE, parent);

  if (filename) {
    if (ui_params.saveas) 
      g_free(ui_params.saveas);
    ui_params.saveas = g_strdup (filename);
    RCUI_save_state_to_file (ui_stores.mainw_store, filename);
   
    g_free (filename);
  }
}


void
on_quit1_activate                      (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  gtk_main_quit();
}


void
on_preferences1_activate               (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_about1_activate                     (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  GtkWidget* aboutd = create_about_dialog();
  gtk_widget_show (aboutd);
}


void
on_variables1_activate                 (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  GtkWidget* varw = create_var_window(GTK_WINDOW(user_data));
  gtk_widget_show (varw);
}


void
on_toolbar_cleanb_clicked              (GtkToolButton   *toolbutton,
                                        gpointer         user_data)
{
  RCUI_remove_undefined(ui_stores.mainw_store);
}

void
on_toolbar_newb_clicked                (GtkToolButton   *toolbutton,
                                        gpointer         user_data)
{
  RCUI_clean_state (ui_stores.mainw_store);
}


void
on_toolbar_openb_clicked               (GtkToolButton   *toolbutton,
                                        gpointer         user_data)
{
  on_open1_activate (NULL, user_data);
}


void
on_toolbar_saveb_clicked               (GtkToolButton   *toolbutton,
                                        gpointer         user_data)
{
  on_save1_activate (NULL, user_data);

}


void
on_degrees1_activate                   (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  if (ui_params.angle_unit != RC_ANGLE_DEGREES)
  {
    ui_params.angle_unit = RC_ANGLE_DEGREES;
    rc_engine_set_angleunit( RC_engine, RC_ANGLE_DEGREES );
    RCUI_update_state_all(ui_stores.mainw_store);
  }
}


void
on_radians1_activate                   (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  if (ui_params.angle_unit != RC_ANGLE_RADIANS)
  {
    ui_params.angle_unit = RC_ANGLE_RADIANS;
    rc_engine_set_angleunit( RC_engine, RC_ANGLE_RADIANS );
    RCUI_update_state_all(ui_stores.mainw_store);
  }
}
