(*pp ocamlrun ../common/version_filter -pp "camlp4o -impl" *)
(************************************************************
 *
 * A part of Regexp/OCaml module.
 * 
 * (c) 2002-2003 Yutaka Oiwa. All Rights Reserved.
 *
 * This file is distributed under the terms of the Q Public
 * License version 1.0.
 *
 ************************************************************)
(* $Id: pa_pragma.ml 118 2005-01-23 12:04:31Z yutaka $ *)

(* provides camlp4 "pragma": allow specifying user-defined camlp4 *)
(* option in program: *)

open Printf
open Pcaml

#load "pa_extend.cmo";;
#load "q_MLast.cmo";;

#if 3.06 | 3.07pre | 3.07 | 3.07_5 | 3.07_19
#define _loc loc
#endif

let rec find_action s = function
    [] -> raise Not_found
  | (n,a,_)::tl -> if n = s then a else find_action s tl

let do_pragma name arg loc = 
  let ext_spec_list = List.rev (Pcaml.arg_spec_list ()) in
  let spec = 
    try find_action ("-" ^ name) ext_spec_list 
    with Not_found -> failwith ("unknown option \"" ^ name ^ "\"")
  in
  match spec, arg with
    Arg.Unit f, None -> f ()
  | Arg.Set r, None -> r := true
  | Arg.Clear r, None -> r := false
  | Arg.Rest f, _ -> failwith ("option \"" ^ name ^ "\" is not supported by pragma")
  | Arg.String f, Some (<:expr< $str:s$ >>, argloc) ->
#if 3.06 | 3.07pre | 3.07
      f (Token.eval_string s)
#else
      f (Token.eval_string argloc s)
#endif
  | Arg.Int f, Some (<:expr< $int:s$ >>, _) ->
      f (int_of_string s)
  | Arg.Float f, Some ((<:expr< $int:s$ >> | <:expr< $flo:s$ >>), _) ->
      f (float_of_string s)
  | _ -> failwith ("invalid type of argument for option \"" ^ name ^ "\"")

let _ = EXTEND
    implem: FIRST
    [ [
      "#"; LIDENT "pragma" ; name = [ n = LIDENT -> n | n = STRING -> n ];
	arg = OPT [ "="; e = expr LEVEL "simple" -> e, _loc]; ";;" ->
	  (* (sil, stopped) = SELF -> *)
	  do_pragma name arg _loc;
	  ([ <:str_item< declare end >>, _loc ], true)
    ] ];
    interf: FIRST
    [ [
      "#"; LIDENT "pragma" ; name = [ n = LIDENT -> n | n = STRING -> n ];
	arg = OPT [ "="; e = expr LEVEL "simple" -> e, _loc]; ";;" ->
	  (* (sil, stopped) = SELF -> *)
	  do_pragma name arg _loc;
	  ([ <:sig_item< declare end >>, _loc ], true)
    ] ];
  use_file: FIRST
    [ [
      "#"; LIDENT "pragma" ; name = [ n = LIDENT -> n | n = STRING -> n ];
      arg = OPT [ "="; e = expr LEVEL "simple" -> e, _loc]; ";;" ->
	  (* (sil, stopped) = SELF -> *)
	do_pragma name arg _loc;
	([ <:str_item< declare end >> ], true)
    ] ];
  top_phrase: FIRST
    [ [
      "#"; LIDENT "pragma" ; name = [ n = LIDENT -> n | n = STRING -> n ];
	arg = OPT [ "="; e = expr LEVEL "simple" -> e, _loc]; ";;" ->
	  (* (sil, stopped) = SELF -> *)
	  do_pragma name arg _loc;
	  Some <:str_item< declare end >>
    ] ];
  END

(* TODO: TEST interf, use_file *)
