/*************************************************************************/
/*                                                                       */
/*  Regexx - Regular Expressions C++ solution.                           */
/*                                                                       */
/*  http://projects.nn.com.br/                                           */
/*                                                                       */
/*  Copyright (C) 2000 Gustavo Niemeyer <gustavo@nn.com.br>              */
/*                                                                       */
/*  This library is free software; you can redistribute it and/or        */
/*  modify it under the terms of the GNU Library General Public          */
/*  License as published by the Free Software Foundation; either         */
/*  version 2 of the License, or (at your option) any later version.     */
/*                                                                       */
/*  This library is distributed in the hope that it will be useful,      */
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of       */
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU    */
/*  Library General Public License for more details.                     */
/*                                                                       */
/*  You should have received a copy of the GNU Library General Public    */
/*  License along with this library; if not, write to the                */
/*  Free Software Foundation, Inc., 59 Temple Place - Suite 330,         */
/*  Boston, MA  02111-1307, USA.                                         */
/*                                                                       */
/*************************************************************************/

// $Revision: 1.6 $
// $Date: 2001/03/13 14:42:21 $

#include <iostream>
#include <regexx.hh>

using namespace regexx;

//
// This is the function to pass to replace() in
// example 6. It must accept a RegexxMatch as the
// only parameter and return the string to replace.
//
std::string invert(const RegexxMatch& _match)
{
  if(_match == "free")
    return "expensive";
  else
    return "free";
}

int main()
{
  Regexx rxx;

  try {

    // 1 - Replacing strings with atom substitution:
    
    cout << "1: ";
    cout << rxx.replace("I love expensive software!","expensive (soft[a-z]*)",
			"free %0");
    cout << endl;


    // 2 - Atom retrieving:

    cout << "2: ";
    rxx.exec("http://distro.conectiva.com/projetos/32/","http://([-1-9a-zA-Z\\.]*)/");
    if(rxx.match.size() > 0 && rxx.match[0].atom.size() > 0)
      cout << "Regexx's host is " << rxx.match[0].atom[0] << "." << endl;
    else
      cout << "Oops, no hosts found!" << endl;


    // 3 - Patern matching:

    cout << "3: ";
    if(rxx.exec("gnu@gnu.org",".+@gnu\\.org$"))
      cout << "Yeah! It's from gnu.org!" << endl;
    else
      cout << "No, it's not from gnu.org." << endl;


    // 4 - Counting occurrences:

    cout << "4: ";
    cout << "There are "
	 << rxx.exec("There are n 'a's in this phrase.",
		     "a",Regexx::global|Regexx::nomatch)
	 << " 'a's in this phrase." << endl;


    // 5 - Removing HTML tags:

    cout << "5: ";
    cout << rxx.replace("<B>Please, <STRIKE>no</STRIKE> tags.</B>",
			"</?[a-z]+( [^>]*)*>", "",
			Regexx::global|Regexx::nocase|Regexx::study);
    cout << endl;


    // 6 - Customizing replaces

    cout << "6: ";
    cout << rxx.replacef("Turn your free software into expensive software.",
			 "free|expensive", invert, Regexx::global);
    cout << endl;


    // 7 - One-line regular expressions using constructors

    cout << "7: ";
    if(Regexx("Using constructor!","constructor"))
      cout << "I've found the 'constructor' word!" << endl;
    else
      cout << "I haven't found the 'constructor' word!" << endl;

  }
  catch(Regexx::CompileException &e) {
    cerr << e.message() << endl;
  }
  return 0;
}
