collapseConstructors <-
function(k = getConstructors(defs),  defs, filter = NULL)
{
  funcNames = character()
  
  if(!is.null(filter))
    k <- k[grep(filter, k)]

   # Get all the constructors of the form *_new_*
   # i.e. that have additional arguments.
   # note that this catches gtk_sheet_new_browser()
   # which has no extra arguments, but which doesn't have a class either!
  dups <- grep("_new_", k)

   # list of the new constructor functions we will create that combine
   # 2 (or more) constructor functions into a single argument.
  v <- list()

   # Which ones we will drop.
  drop <- integer(0)
  for(i in dups) {
       # Get the short form of the name, removing any of the words after the _new.
     short <- gsub("_new_.*", "_new", k[i])
     dup <- grep(short, k)
     drop <- c(drop, dup)     
     tmp  <- k[dup]

     num <- sort(sapply(defs$functions[tmp], function(x) length(x$parameters)))

       # If this is a widget class (i.e. descendant from GtkWidget), then we need the
       # show and .flush arguments.
     useShow = isWidgetClass(mapToClassName(k[[i]], defs$classes, FALSE), defs$classes)
     if(useShow) {
        widgetArgs = c("show" = " = TRUE", ".flush" = " = TRUE")       
     } else
        widgetArgs = character(0)

     
     if(length(tmp) == 2 && (num[1] == 0 || any(num == 1))) {
       defaultArgs <- lapply(defs$functions[names(num)], function(x) getDefaultSArgs(x$parameters, defs))

       allArgs <- list()
       for(j in defaultArgs) {
            # potential problem of matching arguments across methods!
            # unlist(defaultArgs) appends the names of the method to the names
            # of the functions
          if(length(j))
             allArgs[names(j)] <- j
       }

       if(useShow) {
         allArgs = c(allArgs, widgetArgs)
         defaultArgs = lapply(defaultArgs, function(x) c(x, widgetArgs))
       }


       id <- (1:length(num))[num != 0]
       missingArg <- names(defaultArgs[[id[1] ]])[1]

       funName = paste(changeCapitalization(mapToClassName(k[[i]], defs$classes, FALSE), FALSE))
       funcNames = c(funcNames, funName)

         # Define the function body
       code <- c(paste(funName, "<-"),
                 paste("function(", paste(names(allArgs), allArgs, collapse=", ", sep=""), ")"),
                 "{",
                 paste("  if(missing(", missingArg, "))"),
                 paste("    ", mapToClassName(names(num)[1], defs$classes, capitalize = TRUE),
                         "(", paste(names(defaultArgs[[1]]), collapse=", ", sep=""),")"),
                 "  else",
                 paste("    ", mapToClassName(names(num)[2], defs$classes, capitalize = TRUE),
                         "(",paste(names(defaultArgs[[2]]), collapse=", ", sep=""), ")"),
                 "}\n")

       v[[k[i]]] <- paste(code, collapse="\n", sep="")
     } else
         warning(paste("Skipping", k[i]))
  }

  copies <- character(0)

  for(i in (1:length(k))[-c(drop)]) {
     copies[k[i]] <- changeCapitalization(mapToClassName(k[i], defs$classes, FALSE), FALSE)
  }

  invisible(list(defs = v, copies = copies, funcNames = funcNames))
}
