//  mkgeo_grid -e 20 -a -2 -b 2  > line2.geo
//  ./convect-P2 line2 P1 1e-2 100 > line2-P1.branch
//  ./convect-P2 line2 P2 1e-2 100 > line2-P2.branch
//  ./convect_error < line2-P1.branch > line2-P1-cmp.branch
//  ./convect_error < line2-P2.branch > line2-P2-cmp.branch
#include "rheolef.h"
using namespace rheolef;
using namespace std;
#include "rotating-hill.h"
int main (int argc, char **argv) {
  environment rheolef (argc,argv);
  geo omega (argv[1]);
  string approx = (argc > 2) ? argv[2] : "P1";
  Float  nu     = (argc > 3) ? atof(argv[3]) : 1e-2;
  size_t n_max  = (argc > 4) ? atoi(argv[4]) : 50;
  size_t d = omega.dimension();
  Float delta_t = 2*acos(-1.)/n_max;
  space Vh (omega, approx, "vector");
  field uh = interpolate (Vh, u(d));
  space Xh (omega, approx);
  Xh.block ("boundary");
  field phi_h = interpolate (Xh, phi(d,nu,0));
  characteristic X (-delta_t*uh);
  quadrature_option_type qopt;
  qopt.set_family(quadrature_option_type::gauss_lobatto);
  qopt.set_order(Xh.degree());
  form m (Xh, Xh, "mass", qopt);
  form a (Xh, Xh, "grad_grad");
  branch event ("t","phi");
  dout << catchmark("nu") << nu << endl
       << event (0, phi_h);
  for (size_t n = 1; n <= n_max; n++) {
    Float t = n*delta_t;
    field lh = riesz(Xh, compose(phi_h, X), qopt);
    form c = (1 + delta_t*phi::sigma(d,nu,t))*m + delta_t*nu*a;
    solver sc (c.uu());
    phi_h.set_u() = sc.solve (lh.u() - c.ub()*phi_h.b());
    dout << event (t, phi_h);
  }
}
