#include "rheolef.h"
#include "rheolef/uzawa_abtb.h"
#include "old-cavity.h"
using namespace rheolef;
using namespace std;
int main(int argc, char**argv) {
  geo  omega_h (argv[1]);
  space Vh = cavity_space (omega_h, "P2");
  space Qh (omega_h, "P1");
  field uh = cavity_field (Vh, 1);
  field ph (Qh, 0.);
  form a (Vh, Vh, "2D_D");
  form b (Vh, Qh, "div"); b = -b;
  int   max_iter = 50;
  Float tol      = 1e-12;
  Float r        = 1e+7;
  form ar = a + r*trans(b)*b;
  ssk<Float> fact = ldlt(ar.uu);
  uzawa_abtb (ar.uu, fact, b.uu, uh.u, ph.u, -(ar.ub*uh.b), -(b.ub*uh.b), r, max_iter, tol);
  cout << catchmark("u")  << uh
       << catchmark("p")  << ph;
  return 0;
}
