///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2018 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
/// 
/// =========================================================================
//! @examplefile combustion_post.cc The combustion problem -- post-treatment
#include "rheolef.h"
using namespace rheolef;
using namespace std;
#include "combustion.h"
int main(int argc, char**argv) {
  environment rheolef (argc,argv);
  field uh;
  dout << setprecision(numeric_limits<Float>::digits10)
       << "# lambda det_mantissa det_exp det_base" << endl;
  combustion F;
  while (F.get(din,uh)) {
    F.reset (uh.get_geo(), uh.get_approx());
    problem::determinant_type det = F.update_derivative(uh);
    dout << F.parameter() << " " << det.mantissa << " "
         << det.exponant << " " << det.base << endl;
  }
}
