/* This is the source code for RIG, a program to generate fake identities.
 * Copyright (c) 1999 Ian Turner
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
 * USA. */

#include <iostream>
#include <fstream>
#include <vector>
#include <stdlib.h>
#include <string>

using namespace std;

template <class T>
T getrandint(T max)
{
  static ifstream randev("/dev/urandom");
  T rval;
  if (randev) {
    randev.read(&rval, sizeof(rval));
  }
  if (max == 0)
    return max;
  else
    return rval % max;
}

template <class T>
typename T::value_type getrandpart(T& a)
{
  return a[getrandint(a.size() - 1)];
}

struct place {
  string city, state;
  int ZIP;
  short int areacode;
};

ostream& operator<< (ostream& out, const place& a)
{
  out << a.city << ", " << a.state << "  " << a.ZIP << endl
      << "(" << a.areacode << ") xxx-xxxx";
  return out;
}

istream& operator>> (istream& in, place& a)
{
  in >> a.city >> a.state >> a.areacode >> a.ZIP;
  return in;
}

struct wholeline {
  string name;
};

ostream& operator<< (ostream& out, const wholeline& a)
{
  out << a.name;
  return out;
}

istream& operator>> (istream& in, wholeline& a)
{
  char temp = 'a';
  for (;;) {
    temp = in.get();
    if (temp == '\n' || temp == '\r' || temp == '0' || !in)
      break;
    a.name += temp;
  }
  return in;
}

/* Returns number of records gotten. */
template <class T>
int readfile(T& dest, const char * origin)
{
  int counter = 0;
  ifstream filetoread(origin);
  while (filetoread) {
    typename T::value_type temp;
    filetoread >> temp;
    dest.push_back(temp);
    counter++;
  }
  return counter;
}

void printusage()
{
  cerr << "USAGE: rig [datadir]" << endl
       << "       datadir - Directory where data files can be found." << endl
       << "       If datadir is not specified, " DATADIR " is used as the" << endl
       << "       default directory." << endl;
  cerr << endl;
  exit(-1);
}

int printfileerror(string filename)
{
  cerr << "Unable to read file " << filename << endl;
  printusage();
  exit(-2);
}

int main(int argc, char *argv[])
{
  string locdataidx, streetidx, mnamesidx, fnamesidx, lnamesidx;
  if (argc == 1)
    locdataidx = DATADIR;
  else if (argc == 2)
    locdataidx = argv[1];
  else
    printusage();

  streetidx = locdataidx + "/street.idx";
  mnamesidx = locdataidx + "/mnames.idx";
  fnamesidx = locdataidx + "/fnames.idx";
  lnamesidx = locdataidx + "/lnames.idx";
  locdataidx += "/locdata.idx";
    
  vector<string> firstname, lastname;
  vector<wholeline> street;
  vector<place> location;
  if (readfile(location, locdataidx.c_str()) == 0)
    printfileerror(locdataidx);
  if (readfile(street, streetidx.c_str()) == 0)
    printfileerror(streetidx);
  if (readfile(firstname, mnamesidx.c_str()) == 0) {
    if (readfile(firstname, fnamesidx.c_str()) == 0)
      printfileerror(mnamesidx + "and" + fnamesidx);
  } else
      readfile(firstname, fnamesidx.c_str());
  if (readfile(lastname, lnamesidx.c_str()) == 0)
    printfileerror(lnamesidx);
  
  cout << getrandpart(firstname) << " " << getrandpart(lastname) << endl
       << getrandint(999u) + 1 << " " << getrandpart(street) << endl
       << getrandpart(location) << endl;
}





