#ifndef GNOMETEXT_H
#define GNOMETEXT_H

#include <gnome.h>
#include <gtk/gtk.h>
#include <zvt/zvtterm.h>

#include "../../module.h"
#include "../../root-portal.h"

class GnomeText : public Module
{
public:
        GnomeText();
        ~GnomeText();
/*  	void service(); */
        
        friend gint windowmove_(GtkWidget* widget, GdkEventConfigure* event, GnomeText* data);
	friend gint windowclick_(GtkWidget* widget,GdkEventButton* event,GnomeText* data);
	friend gint act_on_pattern_(GtkWidget* widget,GdkEventButton* event,GnomeText* data);

        virtual string getName() {
                return "Gnometext";
        }

        virtual const DataSetMap& get_module_info() {
                return get_module_info_instance();
        }
        static const DataSetMap &get_module_info_instance();

        static void destroy_module_info() {
                if (moduleInfo)
                        delete moduleInfo;
                moduleInfo = 0;
        }                
private:
        static DataSetMap* moduleInfo;
                        
protected:
        void updated(const string& keyName, const DataSet& data);
        void postStartup();

private:
        const string& getcolour(const string& colourStr) const;
        void display();
        void windowMove(GdkEventConfigure* event);
 	void windowClick(GdkEventButton* event);
	void actOnPattern(GdkEventButton* event);
        void reSync();

	void add_submenu_item(GtkWidget* menu,const char* aName,GtkWidget* aMenu);
	void add_menu_item(GtkWidget* menu,const char* aName,const void* aFunction);
        void buildSmallMenu();
	void buildFullMenu();
       
        string colour;
        string oldTextLine;

	GtkWidget* window;
        GtkWidget* term;
        GtkWidget* scrollbar;
        GtkWidget* hbox;
	GtkWidget* smallmenu;
	GtkWidget* fullmenu;

        /* disallow assignment */
        GnomeText& operator=(const GnomeText& other) {};

        /* disallow copy */
        GnomeText(const GnomeText& other) {};
};

#endif
