#ifndef PATH_H
#define PATH_H

#include <vector>
#include <string>
using namespace std;

class Path
{
public:
        int first() const {
                assert(storage.size() > 0);
                return storage[0];
        }

        int last() const {
                assert(storage.size() > 0);
                return storage[storage.size() - 1];
        }
        
        void remove_first() {
                assert(storage.size() > 0);
                storage.erase(storage.begin());
        }
        
        Path remove_first() const {
                assert(storage.size() > 0);
                Path p(*this);
                p.remove_first();
                return p;
        }               
                        
        void remove_last() {
                storage.erase(storage.end() - 1);
        }

        Path remove_last() const {
                assert(storage.size() > 0);
                Path p(*this);
                p.remove_last();
                return p;
        }
        
        void add_last(int l) {
                storage.push_back(l);
        }

        void add_start(int l) {
                storage.insert(storage.begin(), l);
        }
        
        bool operator==(const Path& other) const {
                return storage == other.storage;
        }

        int length() const {
                return storage.size();
        }               
        
        string to_string() const;
private:
        vector<int> storage;
};

#endif
