#include "tree_builder_xml.h"
#include "module_tree.h"
#include "module_registry.h"

#include <gnome-xml/parser.h>
#include <string>
using namespace std;

TreeBuilderXml *TreeBuilderXml::instance_ = 0;

static void load_module(const Path& path, xmlDoc* document, xmlNode* cur)
{
        // setup parameters for current module
        xmlAttr* attr = cur->properties;
        while (attr) {
                string name = reinterpret_cast<const char*> (attr->name);
                char *value = reinterpret_cast<char*> (xmlNodeListGetString(document, attr->val, 1));
                if (value != NULL) {
                        try {
                                ModuleTree::instance()->set_value(path, name, value);
                        } catch (ModuleError ex) {
                                cerr << "Module exception: " << ex.description << endl;
                        }
                        free(value);
                }
                attr = attr->next;
        }

        // create children
        cur = cur->childs;
        int child_num = 0;
        while (cur != NULL) {
                string nname = reinterpret_cast<const char*> (cur->name);
                if (ModuleRegistry::instance()->valid_module_name(nname)) {
                        try {
                                ModuleTree::instance()->create_child(path, nname);
                                
                                Path npath = path;
                                npath.add_last(child_num);
                                // call ourselves recursively
                                load_module(npath, document, cur);
                                child_num++;
                                
                                ModuleTree::instance()->overlay_defaults(npath);
                        } catch (ModuleError ex) {
                                cerr << "Module exception: " << ex.description << endl;
                        }
                } else {
                        cerr << "unknown module type \"" << nname << "\"" << endl;
                }
                cur = cur->next;
        }
}

void TreeBuilderXml::load_file(const string& filename)
{
	xmlNode* cur;
        xmlDoc* doc = xmlParseFile(filename.c_str());
	if (doc == NULL) {
	    	cerr << "Error in Config File" << endl;
                return;
	}

	cur = doc->root;
	if (cur == NULL) {
	    	cerr << "Config File Empty" << endl;
                return;
	}

	if (reinterpret_cast<const char*> (cur->name) != string("Configuration")) {
	    	cerr << "Configuration Module needs to be root in config file (as opposed to "
                     << cur->name << ")" << endl;
                return;
	}

	load_module(Path(), doc, cur);
        xmlFreeDoc(doc);

        ModuleTree::instance()->post_startup_recursive(Path());
}

