#define _XOPEN_SOURCE 500

#include "utils.h"

#include <fcntl.h>
#include <unistd.h>
#include <stdio.h>
#include <errno.h>

void set_blocking(int fd, bool block_state)
{
        int flags = fcntl(fd, F_GETFL);
        if (block_state)
                flags &= ~O_NONBLOCK;
        else
                flags |= O_NONBLOCK;
        fcntl(fd, F_SETFL, flags);
}

string int_to_string(int a)
{
        char buf[20];
        sprintf(buf, "%d", a);
        return buf;
}

string double_to_string(double a)
{
        char buf[20];
        sprintf(buf, "%f", a);
        return buf;
}

string read_line(int fd, bool nonblocking) throw (FileException)
{
        if (nonblocking)
                set_blocking(fd, false);
        string result;
        char ch;
        do {
                int rd = read(fd, &ch, 1);
                if (rd == -1) {
                        if (errno == EAGAIN) {
                                break;
                        } else if (errno == EINTR) {
                        } else {
                                throw FileException();
                        }
                } else if (rd == 0) {
                        throw FileException();
                } else {
                        if (ch != '\n')
                                result += ch;
                }
        } while (ch != '\n');
        if (nonblocking)
                set_blocking(fd, true);
        return result;
}

// gets the full path for an executable (pid).  returns "" on failure (ie if the process doesn't exist)
string get_exe(int pid)
{
        string prname = "/proc/" + int_to_string(pid) + "/exe";
        char* buf = new char[1024];
        buf[0] = 0;
        int retcode = readlink(prname.c_str(), buf, 1024);
        string result;
        if (retcode == -1) {
                result = "";
        } else {
                buf[retcode] = 0;
                result = buf;
        }
        delete[] buf;
        return result;
}

